<?php /* Template Name: Portfolio Modern*/
sh_custom_header();
global $posts ; 
$Settings = get_option( 'wp_dictate') ;
$page_settings  = get_post_meta(get_the_ID(), '_page_settings', true);
$paged = get_query_var('paged');
$span_array = array( '2column'=>'span6', '3column'=>'span4', '4column'=>'span3');
$columns = sh_set($_GET, 'portfolio_cols') ? sh_set($_GET, 'portfolio_cols') : sh_set( $Settings, 'columns', '3column');
$span_class = sh_set( $span_array, $columns );
$args = array('post_type'=>'dict_portfolio' , 'posts_per_page'=> 9999999) ;
$posts = get_posts($args);
$terms = get_terms( 'portfolio_category', array( 'hide_empty'=>0));//printr($terms);
?>
<section>
	<?php if(sh_set($page_settings , 'header') == 'enable'): 
		$bg_img = sh_set($page_settings , 'header_bg') ? 'background:url('.sh_set($page_settings , 'header_bg') .')': '' ;?>
		<div class="full-page-head" style=" <?php echo $bg_img ; ?>">
			<div class="full-page-title">
				<h1><?php echo sh_set($page_settings , 'header_title') ; ?><span class="slogan"><?php echo sh_set($page_settings , 'sub_title') ; ?></span></h1>
				<p><?php  echo sh_set($page_settings , 'header_content') ; ?></p>
			</div>        
		</div><!-- Full Width Page Title -->
    <?php endif ; ?>
	<div class="container">
		<div class="controls">	
			<ul>
				<li class="filter" data-filter="all">All</li>
                <?php foreach($terms as $term): ?>
				<li class="filter" data-filter="category_<?php echo sh_set($term , 'term_id'); ?>"><?php echo sh_set($term , 'name'); ?></li>
				<?php endforeach; ?>
			</ul>
		</div>
        
		<div id="grid" class="row">
            	<?php foreach($posts as $post_chunk) : 
					$post_term = get_the_terms( $post_chunk , 'portfolio_category' ) ; //printr(current($post_term)) ;		?>
                <div class="<?php echo $span_class; ?> mix category_<?php echo sh_set(current($post_term) , 'term_id') ; ?>" data-cat="<?php echo sh_set(current($post_term) , 'term_id') ; ?>">
                    <div class="portfolio-style-img">
                        <?php echo get_the_post_thumbnail(sh_set($post_chunk , 'ID') , '' ) ; ?>
                        <span><?php echo get_the_title(sh_set($post_chunk , 'ID')); ?></span>
                        <a href="<?php echo get_permalink(sh_set($post_chunk , 'ID')) ; ?> " title="<?php echo get_the_title(sh_set($post_chunk , 'ID')); ?>">
                        	<i class="fa fa-link"></i><?php _e('Detail' , 'wp_dictate' ) ; ?>
                        </a>
                    </div>
                </div>
                <?php endforeach ; ?>
		</div>
	
	</div>
</section>
<script type="text/javascript">
	jQuery(function(){
		jQuery('#grid').mixitup();
	});
</script>
<?php
wp_reset_query() ; 
 get_footer(); ?>
