<?php
/* Template Name: Portfolio Descriptive */
sh_custom_header();
global $posts;
$Settings = get_option('wp_dictate');
$page_settings = get_post_meta(get_the_ID(), '_page_settings', true);
$paged = get_query_var('paged');
$span_array = array('2column' => 'span6', '3column' => 'span4', '4column' => 'span3');
$columns = sh_set($_GET, 'portfolio_cols') ? sh_set($_GET, 'portfolio_cols') : sh_set($Settings, 'columns', '3column');
$span_class = sh_set($span_array, $columns);
//$args = array('post_type'=>'dict_portfolio', 'posts_per_page'=>99999999) ;
//$posts = get_posts($args);
$terms = get_terms('portfolio_category', array('hide_empty' => 0)); //printr($terms);
?>
<section>
    <?php if (sh_set($page_settings, 'header') == 'enable'):
        $bg_img = sh_set($page_settings, 'header_bg') ? 'background-image:' . sh_set($page_settings, 'header_bg') : '';
        ?>
        <div class="full-page-head" style=" <?php echo $bg_img; ?>">
            <div class="full-page-title">
                <h1><?php echo sh_set($page_settings, 'header_title'); ?><span class="slogan"><?php echo sh_set($page_settings, 'sub_title'); ?></span></h1>
                <p><?php echo sh_set($page_settings, 'header_content'); ?></p>
            </div>        
        </div><!-- Full Width Page Title -->
<?php endif; ?>
    <div class="container">
        <div class="controls">	
            <ul>
                <li class="filter" data-filter="all">All</li>
                <?php foreach ($terms as $term): ?>
                    <li class="filter" data-filter="category_<?php echo sh_set($term, 'term_id'); ?>"><?php echo sh_set($term, 'name'); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>

        <div id="grid" class="portfolio-cols">
            <div class="row">
                <?php
                foreach ($terms as $term):
                    $args = array('post_type' => 'dict_portfolio', 'posts_per_page' => -1);
                    if (sh_set($term, 'term_id') != '')
                        $args['tax_query'] = array(array('taxonomy' => 'portfolio_category', 'field' => 'id', 'terms' => (int) sh_set($term, 'term_id')));
                    $query = new WP_Query($args);
                    while ($query->have_posts()): $query->the_post();
                        ?>
                        <div class="<?php echo $span_class; ?> mix category_<?php echo sh_set($term, 'term_id'); ?>" data-cat="<?php echo sh_set(current($post_term), 'term_id'); ?>">
                            <div class="portfolio-style">
                                <div class="portfolio-style-img">
                                    <?php echo get_the_post_thumbnail(get_the_ID(), ''); ?>
                                    <a href="<?php echo get_permalink(get_the_ID()); ?> " title="<?php echo get_the_title(); ?>">
                                        <i class="fa fa-link"></i><?php _e('Detail', 'wp_dictate'); ?>
                                    </a>
                                </div>
                                <i><?php echo get_the_date('d M Y'); ?></i>
                                <h3><a href="<?php echo get_permalink(); ?> " title="<?php echo get_the_title(); ?>"><?php echo get_the_title(); ?></a></h3>
                                <p><?php echo substr(strip_tags(apply_filters('the_content', sh_set(get_the_content(), 'post_content'))), 0, 150); ?>..</p>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_query(); ?>
                <?php endforeach; ?>
            </div>
        </div>

    </div>
</section>
<script type="text/javascript">
    jQuery(function () {
        jQuery('#grid').mixitup();
    });
</script>
<?php
wp_reset_query();
get_footer();
?>
