<?php // Template Name: Our News
sh_custom_header();
$settings  = get_post_meta(get_the_ID(), '_page_settings', true);
$paged = get_query_var('paged');?>
<section id="inner-page">
    <div class="container">
        <div class="left-side-content span8">
            <div class="main-title sec">
                <h1><?php the_title(); ?></h1>
                <span class="short-desc"><?php echo sh_set( $settings, 'sub_title'); ?></span> 
            </div>
            <!-- Page Title -->
            <?php $query = new WP_Query( array('post_type'=>'dict_our_news', 'paged'=>$paged, 'showposts'=>get_option('posts_per_page'), )); //printr($query);						
			 ?>					
            <?php while( $query->have_posts() ): $query->the_post(); ?>
                <div class="recent-event row-fluid">
                    <?php $event_setting = get_post_meta( get_the_id(), '_dict_news_settings', true ); //printr($event_setting);?>
                    <div class="recent-event-img span6"> 
                        <?php the_post_thumbnail('770x385'); ?>
                        <div class="recent-event-links">
                            <?php $large = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'large'); ?>
                            <a rel="prettyPhoto" title="<?php the_title(); ?>" data-group="event" class="html5lightbox" href="<?php echo sh_set($large, '0'); ?>"><i class="fa fa-search"></i></a> 
                        </div>
                    </div>
                    <div class="recent-event-desc span6">
                        <h2><a title="" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                        <p><?php echo substr(strip_tags(get_the_excerpt()) , 0 , 350) ; ?></p>
                        <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>" class="continue"><?php _e('Continue Reading', 'wp_dictate'); ?></a> 
					  </div>
                </div>
            <?php endwhile;
			wp_reset_query();
			 ?>
            <?php _the_pagination(array('total'=>$query->max_num_pages)); ?>
            <!-- Pagination --><!-- Pagination--> 
        </div>
        <aside class="span4">
        	<?php dynamic_sidebar( sh_set( $settings, 'sidebar' ) ); ?>
        </aside>
        <?php echo do_shortcode('[sh_recent_posts]'); ?>
    </div>
</section>
<?php get_footer(); ?>