<?php /* Template Name: Events */
sh_custom_header();
$settings  = get_post_meta(get_the_ID(), '_page_settings', true);
$paged = get_query_var('paged');?>
<section id="inner-page">
    <div class="container">
        <div class="left-side-content span8">
            <div class="main-title sec">
                <h1><?php the_title(); ?></h1>
                <span class="short-desc"><?php echo sh_set( $settings, 'sub_title'); ?></span> 
            </div>
            <!-- Page Title -->
            <?php $query = new WP_Query( array('post_type'=>'dict_event', 'paged'=>$paged, 'showposts'=>get_option('posts_per_page'), 'meta_key' =>'_dict_event_date', 'meta_query' => array(array('key' => '_dict_event_date', 'value' => date('Y-m-d h:i:s'), 'type' => 'date', 'compare' => '>='	)), 'orderby'=>'meta_value', 'order'=>'ASC' )); //printr($query);						
			 ?>					
            <?php while( $query->have_posts() ): $query->the_post(); ?>
                <div class="recent-event row-fluid">
                    <?php $event_setting = get_post_meta( get_the_id(), '_dict_event_settings', true ); //printr($event_setting);?>
                    <div class="recent-event-img span6"> 
                        <?php the_post_thumbnail('770x385'); ?>
                        <div class="recent-event-links">
                            <?php $large = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'large'); ?>
                            <a rel="prettyPhoto" title="<?php the_title(); ?>" data-group="event" class="html5lightbox" href="<?php echo sh_set($large, '0'); ?>"><i class="fa fa-search"></i></a> 
                        </div>
                    </div>
                    <div class="recent-event-desc span6">
                        <h2><a title="" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                        <div class="recent-event-meta">
                            <ul>
                                <?php $start_date = (sh_set($event_setting, 'start_date')) ? date(get_option('date_format'), strtotime(sh_set($event_setting, 'start_date'))) : ''; 
								$end_date = (sh_set($event_setting, 'end_date')) ? date(get_option('date_format'), strtotime(sh_set($event_setting, 'end_date'))) : ''; ?>
                                <?php if(sh_set($event_setting, 'start_date')):?><li><span><?php _e('Start Date', 'wp_dictate'); ?></span> <i><?php echo $start_date; ?></i></li><?php endif; ?>
                                <?php if(sh_set($event_setting, 'end_date')):?><li><span><?php _e(' End Date', 'wp_dictate'); ?></span> <i><?php echo $end_date;?></i></li><?php endif; ?>
                                <?php if(sh_set($event_setting, 'location')):?><li><span><?php _e(' Event Location', 'wp_dictate'); ?></span> <i><?php echo sh_set($event_setting, 'location');?></i></li><?php endif; ?>
                            </ul>
                        </div>
						
                        <p><?php echo substr(strip_tags(get_the_excerpt()) , 0 , 100) ; ?></p>
    
                        <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>" class="continue"><?php _e('Continue Reading', 'wp_dictate'); ?></a> 
             
                        
					  </div>
                        
                </div>
            <?php endwhile;
			wp_reset_query();
			 ?>
            <?php _the_pagination(array('total'=>$query->max_num_pages)); ?>
            <!-- Pagination --><!-- Pagination--> 
            
        </div>
		<?php if(sh_set( $settings, 'sidebar' )): ?>
        <aside class="span4">
        	<?php dynamic_sidebar( sh_set( $settings, 'sidebar' ) ); ?>
        </aside>
		<?php endif; ?>
        
        <?php echo do_shortcode('[sh_recent_posts]'); ?>
    </div>
</section>
<?php get_footer(); ?>