<?php
/* Template Name: Contact Page */
sh_custom_header();
$theme_optinons = get_option('wp_dictate'); //printr($theme_optinons);
$settings = get_post_meta(get_the_ID(), '_page_settings', true); //printr($settings);
$sidebar = sh_set($settings, 'sidebar');

$paged = get_query_var('paged');
?>
<section>
<?php if (sh_set($settings, 'header') == 'enable' && sh_set($settings, 'home_page') == "header"):
    $bg_img = sh_set($settings, 'header_bg') ? 'background-image:url(' . sh_set($settings, 'header_bg') . ');' : '';
    ?>
        <div class="full-page-head " style=" <?php echo $bg_img; ?>">
            <div class="full-page-title">
                <h1><?php echo sh_set($settings, 'header_title'); ?><span class="slogan"><?php echo sh_set($settings, 'sub_title'); ?></span></h1>
                <p><?php echo sh_set($settings, 'header_content'); ?></p>
            </div>      
        </div>
<?php endif; ?>
    <div class="contact-box">
        <div class="container">
            <div class="row-fluid">
            <?php echo (is_active_sidebar($sidebar)) ? '<div class="span8">' : '<div class="span12">';?>
            <div class="message">
                <div class="main-title sec">
                    <h1><?php _e('Send Us A Message!', 'wp_dictate'); ?></h1>
                </div>
                <p><?php _e('Your email address will not be published. Required fields are marked', 'wp_dictate'); ?>. <span class="star">*</span></p>

                <form class="" id="dict_contact_form1" name="contact_form" action="<?php echo admin_url('admin-ajax.php?action=dictate_ajax_callback&subaction=sh_contact_form_submit'); ?>" >
                    <div class="msgs"></div>
                    <div class="row-fluid">
                        <div class="span4">
                            <label class="control-label"><?php _e('Complete Name', 'wp_dictate'); ?><span class="star"> *</span></label>
                            <input type="text" class="input-block-level" name="contact_name">
                        </div>
                        <div class="span4">
                            <label class="control-label"><?php _e('Email Address', 'wp_dictate'); ?><span class="star"> *</span></label>
                            <input type="text" class="input-block-level" name="contact_email">
                        </div>
                        <div class="span4">
                            <label class="control-label"><?php _e('Website', 'wp_dictate'); ?></label>
                            <input type="text" class="input-block-level" name="contact_website">
                        </div>
                        <div class="span12">
                            <label class="control-label"><?php _e('Message', 'wp_dictate'); ?><span class="star"> *</span></label>
                            <textarea rows="10" class="input-block-level" name="contact_message"></textarea>
                        </div>
                        <?php
                        if (sh_set($theme_optinons, 'captcha_status') == 'true'):
                            echo '<div class="span12">';
                            echo '<script type="text/javascript">
										 var RecaptchaOptions = {
											theme : "clean"
										 };
									  </script>';
                            include_once( SH_FRW_DIR . 'modules/recaptchalib.php');
                            echo recaptcha_get_html(sh_set($theme_optinons, 'captcha_api'));
                            echo '</div>';
                        endif;
                        ?>
                    </div>
                    <button type="submit" class="submit-btn" type="button"><?php _e('Submit Message', 'wp_dictate'); ?></button>
                </form>
            </div>
            <!-- Message Box -->
            </div>
            <?php if(is_active_sidebar($sidebar)):?>
                <div class="span4">
                    <?php dynamic_sidebar(sh_set($settings, 'sidebar')); ?>
                </div>
            <?php endif;?>
        </div>
        </div>
    </div>
    <div class="map">
        <div class="container">
<?php $theme_options = get_option('wp_dictate'); ?>                    
<?php echo stripslashes(sh_set($theme_options, 'google_map_code')); ?>
        </div>
    </div>
</div>
</section>
<?php get_footer(); ?>
