<?php global $post_type;
sh_custom_header();
$settings = get_post_meta( get_the_ID(), '_'.sh_set($post, 'post_type').'_settings', true); 
$attachments = get_posts(array('post_type'=>'attachment', 'post_parent'=>get_the_ID() , 'showposts' => -1) );
//printr($attachments);
$days = array( 'timetable', 'monday', 'tuesday', 'wednesday','thursday', 'friday', 'saturday');
$time_table = array();
foreach( $days as $d ) $time_table = array_merge( (array)$time_table, (array)sh_set(get_option('sh_'.$d), 'field') );
//$time_table = get_option('sh_timetable') ; //printr($time_table);
$doctor_place = '';
$doct_start_time ='';
$doct_end_time = '';
//printr(sh_set($time_table, 'field' ));
foreach( $time_table as $t )
{
	if( get_the_ID() == sh_set( $t, 'member' ) ) 
	{
		$doctor_place = sh_set( $t, 'duty_place' );
		$doct_start_time = date('h:i a', strtotime(sh_set( $t , 'start_time'))) ;
		$doct_end_time = date('h:i a', strtotime(sh_set( $t , 'end_time'))); 
		break;
	}
}
?>
<?php
/**
 * Get an attachment ID given a URL.
 *
 * @param string $url
 *
 * @return int Attachment ID on success, 0 on failure
 */
function get_attachment_id( $url ) {
	$attachment_id = 0;
	$dir = wp_upload_dir();
	if ( false !== strpos( $url, $dir['baseurl'] . '/' ) ) { // Is URL in uploads directory?
		$file = basename( $url );
		$query_args = array(
			'post_type'   => 'attachment',
			'post_status' => 'inherit',
			'fields'      => 'ids',
			'meta_query'  => array(
				array(
					'value'   => $file,
					'compare' => 'LIKE',
					'key'     => '_wp_attachment_metadata',
				),
			)
		);
		$query = new WP_Query( $query_args );
		if ( $query->have_posts() ) {
			foreach ( $query->posts as $post_id ) {
				$meta = wp_get_attachment_metadata( $post_id );
				$original_file       = basename( $meta['file'] );
				$cropped_image_files = wp_list_pluck( $meta['sizes'], 'file' );
				if ( $original_file === $file || in_array( $file, $cropped_image_files ) ) {
					$attachment_id = $post_id;
					break;
				}
			}
		}
	}
	return $attachment_id;
}
?>
<section id="inner-page">
    
    <div class="container">
        
        <div id="post-<?php the_ID(); ?>" <?php post_class('doctors-into'); ?>>
            <?php while( have_posts() ): the_post(); ?>
            <div class="row">
                <?php wp_enqueue_script('jquery_camera_min'); ?>
                <script>
				/*** Document Ready Function ***/
				jQuery(document).ready(function($){
					if (jQuery('#camera_wrap_2').length !== 0){
					jQuery('#camera_wrap_2').camera({
						height: '334px',
						thumbnails: true,
						time: 12000,
						transPeriod: 1000
					});
					}
				});
				</script>
                <div class="slider-area span8">
                    <div class="camera_wrap camera_azure_skin" id="camera_wrap_2">
                        <?php
                            $atc_id = array_unique(explode(',',$settings['gallery']));
                                foreach ($atc_id as $atcs_id){
                         ?>
			        <div data-thumb="<?php echo sh_set(wp_get_attachment_image_src($atcs_id , '103x103') , 0); ?>" data-src="<?php echo wp_get_attachment_url($atcs_id); ?>"> </div>
		                <?php } ?>
                    </div>
                </div>
                <div class="span4">
                    <h1><i class="fa fa-user"></i>
                        <?php the_title(); ?>
                    </h1>
                    <ul>
                        <?php if(sh_set( $settings, 'designation' )){ ?>
						<li> <span>
                            <?php _e('Speciality:', 'wp_dictate');?>
                            </span> <i><?php echo  sh_set( $settings, 'designation' ) ; ?></i> </li> 
							<?php } ?>
							 <?php if(sh_set( $settings, 'experience' )){ ?>
                        <li> <span>
                            <?php _e('Experience:', 'wp_dictate');?>
                            </span> <i><?php echo  sh_set( $settings, 'experience' ) ; ?></i> </li>
                        <?php } ?>
                        <li>
						 <?php if(sh_set( $settings, 'skill_1_percent' )){ ?>
                            <div class="progress indivisual">
                                <div style="width: <?php echo  sh_set( $settings, 'skill_1_percent' ) ; ?>%;" class="bar"></div>
                                <span><?php echo  sh_set( $settings, 'skill_1_name' ) ; ?></span><i><?php echo  sh_set( $settings, 'skill_1_percent' ) ; ?>%</i> </div>
						 <?php } ?>
						 <?php if(sh_set( $settings, 'skill_2_percent' )){ ?>
                            <div class="progress indivisual">
                                <div style="width: <?php echo  sh_set( $settings, 'skill_2_percent' ) ; ?>%;" class="bar"></div>
                                <span><?php echo  sh_set( $settings, 'skill_2_name' ) ; ?></span><i><?php echo  sh_set( $settings, 'skill_2_percent' ) ; ?>%</i> </div>
						<?php } ?>
						 <?php if(sh_set( $settings, 'skill_3_percent' )){ ?>
							<div class="progress indivisual">
                                <div style="width: <?php echo  sh_set( $settings, 'skill_3_percent' ) ; ?>%;" class="bar"></div>
                                <span><?php echo  sh_set( $settings, 'skill_3_name' ) ; ?></span><i><?php echo  sh_set( $settings, 'skill_3_percent' ) ; ?>%</i> </div>
								
						<?php } ?>
						 <?php if(sh_set( $settings, 'skill_4_percent' )){ ?>
							<div class="progress indivisual">
                                <div style="width: <?php echo  sh_set( $settings, 'skill_4_percent' ) ; ?>%;" class="bar"></div>
                                <span><?php echo  sh_set( $settings, 'skill_4_name' ) ; ?></span><i><?php echo  sh_set( $settings, 'skill_4_percent' ) ; ?>%</i> </div>
						<?php } ?>
                        </li>
                        <li> 
						<?php if(sh_set( $settings, 'skype' ) || sh_set( $settings, 'twitter' ) || sh_set( $settings, 'facebook' ) || sh_set( $settings, 'linkedin' )) : ?>
						<span>
                            <?php _e('Contact:', 'wp_dictate');?>
                            </span> 
						<?php endif; ?>
							<?php if(sh_set( $settings, 'skype' )) : ?><a href="<?php echo  sh_set( $settings, 'skype' ) ; ?>" class="skype" title=""><i class="fa fa-skype"></i></a> <?php endif; ?>
							<?php if(sh_set( $settings, 'twitter' )): ?><a href="<?php echo  sh_set( $settings, 'twitter' ) ; ?>" class="twitter" title=""><i class="fa fa-twitter"></i></a>  <?php endif; ?>
							<?php if(sh_set( $settings, 'facebook' )): ?><a href="<?php echo  sh_set( $settings, 'facebook' ) ; ?>" class="facebook" title=""><i class="fa fa-facebook"></i></a> <?php endif; ?>
							<?php if(sh_set( $settings, 'linkedin' )): ?><a href="<?php echo  sh_set( $settings, 'linkedin' ) ; ?>" class="linkedin" title=""><i class="fa fa-linkedin"></i></a> <?php endif; ?>
							</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="single-post-desc">
            <?php the_content(); ?>
        </div>
        
		<?php //wp_link_pages(); ?>
        <?php if( is_single() && comments_open() ) comments_template(); ?>
        <?php endwhile; ?>
        
    	<?php echo do_shortcode('[sh_recent_posts]'); ?>
        
    </div>
    
    
</section>
<?php get_footer(); ?>
