<?php
sh_custom_header();
$settings = get_post_meta(get_the_ID(), '_dict_gallery_settings', true); 
$sidebar = sh_set($settings, 'sidebar', 'default-sidebar');
$sidebar_position = sh_set($settings, 'sidebar_position', 'full');
$span = ($sidebar_position == 'full') ? 'span12' : 'span8';
$span_array = array('1col'=>'span12','2col'=>'span6','3col'=>'span4','4col'=>'span3');
$columns = sh_set( $_GET, 'column') ? sh_set( $_GET, 'column') : sh_set( $settings, 'column', 2);
$cols = array(2=>'two-wos', 3 => 'three', 4 => 'four');
$ids = array_filter(explode(',',sh_set($settings, 'gallery')));?>
<section id="inner-page">
	
    <div class="container">
    	
        <div class="main-title first">
            <h1><?php the_title(); ?></h1>
            <span class="short-desc"><?php echo sh_set($settings, 'sub_title'); ?></span>
        </div>
		
        <div class="row-fluid">
            
            <?php if( $sidebar_position == 'left' ): ?>
                <aside class="span4"><?php dynamic_sidebar($sidebar); ?></aside>
            <?php endif; ?>
            
            <div class="<?php echo $span; ?>">
                
                <div class="tabbable gallery-tabs">
                   
					<div class="tab-content ">
                    
                        <div id="gallery" class="tab-pane fade active in row-fluid">
                            <?php 
							if($ids && is_array( $ids )) :
							$new_att = get_posts(array('post_type'=>'attachment', 'post__in'=>$ids, 'posts_per_page'=>-1 ) ); ?>
                            
                            <?php foreach( (array)$new_att as $new_a ): ?>
                                <div class="<?php echo sh_set($span_array, $columns); ?>">
                                   <div class="gallery-column"> 
                                        <?php echo wp_get_attachment_image( $new_a->ID, '570x422' ); ?>
                                        
                                        <div class="img-title"><?php echo $new_a->post_title; ?></div>
                                        
                                        <div class="onhover">
                                            <p><?php echo get_the_title( $new_a->post_parent ); ?> / <?php echo get_the_title( $new_a->ID ); ?></p>
                                            
                                            <a class="img-magnify" rel="prettyPhoto" data-group="all" href="<?php echo sh_set(wp_get_attachment_image_src( $new_a->ID, 'large' ), '0'); ?>" title="" >
                                                <img src="<?php echo get_template_directory_uri(); ?>/img/magnify.png" alt="" />
                                            </a>
                                        </div>
                                    </div> 
                                    
                                   
                                </div>
                            <?php 
							endforeach; 
							endif;?>
                            
                            <?php $new_att = get_posts(array('post_type'=>'attachment', 'post__in'=>$ids) ); ?>
                            <?php $opt = sh_set($settings, 'videos'); //printr($opt); ?>
                            <?php if( $opt && is_array( $opt ) && sh_set($opt , 0)): 
                                foreach( (array)sh_set($settings, 'videos') as $new_a ): ?>
                                    
                                    <div class="<?php echo sh_set($span_array, $columns); ?>">
                                        <div class="gallery-column">
											<?php $video_data = sh_grab_video( $new_a, $opt );?>
                                            <img src="<?php echo sh_set( $video_data, 'thumb'); ?>" alt="<?php echo sh_set( $video_data, 'title' ); ?>" />
                                           
                                            <div class="img-title"><?php echo sh_set( $video_data, 'title' ); ?></div>
                                            <div class="onhover">
                                                <p><?php echo get_the_title(get_the_ID()); ?> / <?php echo sh_set( $video_data, 'title' ); ?></p>
                                                
                                                <a class="img-magnify" rel="prettyPhoto" data-group="all" href="<?php echo $new_a; ?>" title="" >
                                                    <img src="<?php echo get_template_directory_uri(); ?>/img/magnify.png" alt="" />
                                                </a>
                                            </div>
                                        </div>
                                        
                                    </div>
                                    
                                <?php endforeach; 
                           endif;?>
                            
                        </div>
                        
                    </div>
 
                    <div class="clearfix"></div>
                    
                </div>
                
            </div>
            
                                    
			<?php if( $sidebar_position == 'right' ): ?>
                <aside class="span4"><?php dynamic_sidebar($sidebar); ?></aside>
            <?php endif; ?>     
            
        </div>
        
        <div style="margin-top:40px;">
			<?php echo do_shortcode('[sh_recent_posts]'); ?>
        </div>
	</div>
</section>
<?php get_footer(); ?>
