<?php
sh_custom_header();?>
<section id="inner-page">
    <div class="container">
    	<div id="post-<?php the_ID(); ?>" <?php post_class('left-side-content span8'); ?>>
        	
            <?php while( have_posts() ): the_post(); ?>
            
			<?php $settings = get_post_meta( get_the_ID(), '_dict_event_settings', true ); ?>
			<?php if( has_post_thumbnail() ): ?>
                <div class="post-image">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_post_thumbnail('770x385'); ?></a>
                </div>
            <?php endif; ?>
            
            <div class="post-intro">
                <div class="single-post-date">
                	<?php echo get_the_date('d'); ?> <span><?php echo get_the_date('M Y'); ?></span> 
                </div><!-- Date -->
                <h1><?php the_title(); ?></h1>
            </div>
            
            <div class="event-mgt">
                <ul>
                	<?php if( sh_set( $settings, 'start_time') || sh_set( $settings, 'start_date') ):?>
                    <li>
                        <?php if( sh_set( $settings, 'start_time') ):?><span><strong><?php _e('Time', 'wp_dictate'); ?>:</strong> <i><?php echo date('h:i a', strtotime( sh_set( $settings, 'start_time') ) ); ?>	 <?php _e('to ', 'wp_dictate'); ?><?php echo date('h:i a', strtotime( sh_set( $settings, 'end_time') ) ); ?></i></span><?php endif; ?>
    					 <?php if( sh_set( $settings, 'start_date') ):?><span><strong><?php _e('Start Date', 'wp_dictate'); ?>:</strong> <i><?php echo date(get_option('date_format'), strtotime( sh_set( $settings, 'start_date') ) ); ?></i></span><?php endif; ?>                     
                    </li>
                    <?php endif; ?>
                    <?php if( sh_set( $settings, 'end_date') || sh_set( $settings, 'location') ):?>
                    <li>
                    <?php if( sh_set( $settings, 'end_date') ):?><span><strong><?php _e('End Date', 'wp_dictate'); ?>:</strong> <i><?php echo date(get_option('date_format'), strtotime( sh_set( $settings, 'end_date') ) ); ?></i></span><?php endif; ?>
                        <?php if( sh_set( $settings, 'location') ):?><span><strong><?php _e('Location', 'wp_dictate'); ?>:</strong> <i><?php echo sh_set( $settings, 'location'); ?></i></span><?php endif; ?>                       
                    </li>
                    <?php endif; ?>
                </ul>
			</div>
            <?php if( sh_set( $settings, 'organizer') || sh_set( $settings, 'address') || sh_set( $settings, 'contact') || sh_set( $settings, 'email') || sh_set( $settings, 'website') ):?>
            <div class="event-heading"><h2><?php _e('Organizers', 'wp_dictate'); ?></h2></div>
            <div class="event-mgt">
                <ul>
                	<?php if( sh_set( $settings, 'organizer') || sh_set( $settings, 'address') ):?>
                    <li>
                        <?php if( sh_set( $settings, 'organizer') ):?><span><strong><?php _e('Organized by', 'wp_dictate'); ?>:</strong> <i><?php echo sh_set( $settings, 'organizer' ); ?></i></span><?php endif; ?>
    
                        <?php if( sh_set( $settings, 'address') ):?><span><strong><?php _e('Address', 'wp_dictate'); ?> :</strong> <i><?php echo sh_set( $settings, 'address' ); ?></i></span><?php endif; ?>
                    </li>
                    <?php endif; ?>
                    <?php if( sh_set( $settings, 'contact') || sh_set( $settings, 'email') ):?>
                    <li>
                        <?php if( sh_set( $settings, 'contact') ):?><span><strong><?php _e('Mobile', 'wp_dictate'); ?> :</strong> <i><?php echo sh_set( $settings, 'contact' ); ?></i></span><?php endif; ?>                        
                        <?php if( sh_set( $settings, 'email') ):?><span><strong><?php _e('Email', 'wp_dictate'); ?> :</strong> <i><a title="" href="mailto: <?php echo sh_set( $settings, 'email' ); ?>"><?php echo sh_set( $settings, 'email' ); ?></a></i></span><?php endif; ?>
                    </li>
                    <?php endif; ?>
                    <?php if( sh_set( $settings, 'website')):?>
                    <li>
                    	<span><strong><?php _e('Website', 'wp_dictate'); ?> :</strong> <i><a title="" href="<?php echo esc_url(sh_set( $settings, 'website' )); ?>"><?php echo sh_set( $settings, 'website' ); ?></a></i></span>
                    </li>
                    <?php endif; ?>
                </ul>
			</div>
            <?php endif; ?>
            <div class="event-heading" style="margin-bottom:30px;"><h2><?php _e('Description', 'wp_dictate'); ?></h2></div>
            <div class="single-post-desc"><?php the_content(); ?></div>
            
            <div class="tag-clouds">
            	<?php the_tags('<h4>'.__('Tags', 'wp_dictate').' ;</h4>', ''); ?>
            </div>
            
            <?php if( is_singular() && comments_open() ) comments_template(); ?>
            
            <?php endwhile; ?>
            
		</div>
           
		<aside class="span4"><?php dynamic_sidebar('default-sidebar'); ?></aside>
		<?php echo do_shortcode('[sh_recent_posts]'); ?>
	</div>
</section> 
<?php get_footer(); ?>
