<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<?php
    $settings = get_option('wp_dictate' );
    $res_settings = sh_header_settings($settings);
    echo ( !empty( $settings['site_favicon'] ) ) ? '<link rel="icon" type="image/png" href="'.$settings['site_favicon'].'">': '';?>
    <meta charset="utf-8">
    <title><?php wp_title(); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    
    <!--[if lt IE 9]>
    <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/ie.css" />
    <script type="text/javascript" language="javascript" src="<?php echo get_template_directory_uri(); ?>/js/html5shiv.js"></script>
    <![endif]-->
	<?php wp_head(); ?>
</head>
<!-- Head Ends -->
<body  <?php body_class(sh_set( $res_settings, 'pattern')); ?> style=" <?php echo sh_set($res_settings, 'pattern_image'); ?>">
<?php get_template_part( 'framework/modules/header_donate_us' ); 
$custom_sticky_header_class = (sh_set($settings , 'sh_custom_stickey_menu') == 'true') ? 'sticky' : '' ; 
?>
<div class="theme-layout <?php echo sh_set($res_settings, 'boxed'); ?>" style=" <?php echo sh_set($res_settings, 'width'); ?> ">
<!--################################SLIDER AREA################################-->
<header class="below <?php echo $custom_sticky_header_class; ?>">
  <div class="container">
    <div class="logo">
      <?php
	  if( isset( $settings['logo_text_status'] ) && $settings['logo_text_status'] === 'true' )
	  {
		  $LogoStyle = sh_get_font_settings( array( 'logo_text_font_size' => 'font-size', 'logo_text_font_family' => 'font-family', 'logo_text_font_style' => 'font-style', 'logo_text_color' => 'color' ), ' style="', '"' );
		  $Logo = $settings['logo_text'];
	  }
	  else
	  {
		  $LogoStyle = '';
		  $LogoImageStyle = ( sh_set( $settings, 'logo_width' ) || sh_set( $settings, 'logo_height' ) ) ? ' style="': '';
		  $LogoImageStyle .= ( sh_set( $settings, 'logo_width' ) ) ? ' width:'.sh_set( $settings, 'logo_width' ).'px;': '';
		  $LogoImageStyle .= ( sh_set( $settings, 'logo_height' ) ) ? ' height:'.sh_set( $settings, 'logo_height' ).'px;': '';
		  $LogoImageStyle .= ( sh_set( $settings, 'logo_width' ) || sh_set( $settings, 'logo_height' ) ) ? '"': '';
		  $Logo = '<img src="'.$settings['logo_image'].'" alt=""'.$LogoImageStyle.' />';
	  }
	  ?>
      <a href="<?php echo home_url(); ?>" title="<?php bloginfo('name'); ?>"<?php echo $LogoStyle;?>><?php echo $Logo;?></a>
      <?php
	  if( sh_set( $settings, 'logo_text_status' ) === 'true' && sh_set( $settings, 'site_salogan' ) )
	  {
		  $SaloganStyle = sh_get_font_settings( array( 'salogan_font_size' => 'font-size', 'salogan_font_family' => 'font-family', 'salogan_font_style' => 'font-style' ), ' style="', '"' );
		  echo '<p'.$SaloganStyle.'>'.$settings['site_salogan'].'</p>';
	  }
	  ?>
    </div>
    
    <!-- Logo -->
    
    <div id="menu">
    	<ul id="menu-primary-menu" class="menu">
      		<?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container'=>'', 'items_wrap'=>'%3$s'  ) ); ?>
       </ul>
    </div>
   <!-- Menu -->
<?php
    sh_responsive_menu();	
?>
<!-- Select Navigation On Responsive Version --> 
  </div>
</header>
