<?php
define('DOMAIN', 'wp_dictate');
define('SH_VERSION', 'v1.0');
define('SH_ROOT', get_template_directory() . '/');
define('SH_URL', get_template_directory_uri() . '/');
get_template_part('framework/loader');
add_action('after_setup_theme', 'sh_theme_setup');
add_filter('deprecated_constructor_trigger_error', '__return_false');
include SH_ROOT . '/importer/importer.php';
include SH_ROOT . '/framework/helpers/import_export.php';
function sh_theme_setup() {
    global $wp_version;
    load_theme_textdomain('wp_dictate', get_template_directory() . '/languages');
    add_editor_style();

    sh_create_donation_table();
    //ADD THUMBNAIL SUPPORT
    add_theme_support('post-thumbnails');
    add_theme_support('menus'); //Add menu support
    add_theme_support('automatic-feed-links'); //Enables post and comment RSS feed links to head.
    add_theme_support('widgets'); //Add widgets and sidebar support
    add_theme_support('woocommerce');
    add_theme_support('custom-header');
    add_theme_support('custom-background');
    /** Register wp_nav_menus */
    if (function_exists('register_nav_menu')) {
        register_nav_menus(
                array(
                    /** Register Main Menu location header */
                    'main_menu' => __('Main Menu', 'wp_dictate'),
                    'footer_menu' => __('Footer Menu', 'wp_dictate'),
                )
        );
    }

    if (!isset($content_width))
        $content_width = 960;

    add_image_size('770x385', 770, 385, true);
    add_image_size('770x578', 770, 578, true);
    add_image_size('400x240', 400, 240, true);
    add_image_size('470x522', 470, 522, true);
    add_image_size('570x194', 570, 194, true);
    add_image_size('670x465', 670, 465, true);
    add_image_size('103x103', 103, 103, true);
    add_image_size('370x152', 370, 152, true);
    add_image_size('370x370', 370, 370, true);
    add_image_size('140x140', 140, 140, true);
}

function sh_theme_activation_hook($oldname, $oldtheme = false) {
    $options = get_option('wp_dictate');
    if (!$options) {
        $content = '';
        ob_start();

        include('framework/backup/theme_options/default_settings');
        $content = ob_get_contents();
        $content = unserialize(base64_decode($content));

        ob_end_clean();
        if ($content)
            update_option('wp_dictate', $content);
    }
}

add_action("after_switch_theme", "sh_theme_activation_hook", 10, 2);

require_once( get_template_directory() . '/envato_setup/envato_setup.php' );
add_filter('sh_theme_setup_wizard_username', 'sh_set_theme_setup_wizard_username', 10);
if( ! function_exists('sh_set_theme_setup_wizard_username') ){
	function sh_set_theme_setup_wizard_username($username){
		return 'webinane';
	}
}

add_filter('sh_theme_setup_wizard_oauth_script', 'sh_set_theme_setup_wizard_oauth_script', 10);
if( ! function_exists('sh_set_theme_setup_wizard_oauth_script') ){
	function sh_set_theme_setup_wizard_oauth_script($oauth_url){
		return 'http://api.webinane.com/envato/api/server-script.php';
	}
}

function sh_widget_init() {
    global $wp_registered_sidebars;
    register_widget("SH_Our_Location");
    register_widget("SH_Contact_Us");
    register_widget("SH_Flickr");
    register_widget("SH_Tabber");
    register_widget("SH_Social_Networks");
    register_widget("SH_Galleries");
    register_widget("SH_Popular_Video");
    register_widget("SH_show_pages");
    register_widget("SH_appointment_sidebox");

    register_sidebar(array(
        'name' => __('Default Sidebar', 'wp_dictate'),
        'id' => 'default-sidebar',
        'description' => __('Widgets in this area will be shown on the right-hand side.', 'wp_dictate'),
        'class' => '',
        'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-widget-title"><h4>',
        'after_title' => '</h4></div>'
    ));

    register_sidebar(array(
        'name' => __('Product Sidebar', 'wp_dictate'),
        'id' => 'product-sidebar',
        'description' => __('Widgets in this will be shown on woocommerce pages.', 'wp_dictate'),
        'class' => '',
        'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-widget-title"><h4>',
        'after_title' => '</h4></div>'
    ));

    register_sidebar(array(
        'name' => __('Blog Listing', 'wp_dictate'),
        'id' => 'blog-sidebar',
        'description' => __('Widgets in this area will be shown on the right-hand side.', 'wp_dictate'),
        'class' => '',
        'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-widget-title"><h4>',
        'after_title' => '</h4></div>'
    ));

    register_sidebar(array(
        'name' => __('Footer Sidebar', 'wp_dictate'),
        'id' => 'footer-sidebar',
        'description' => __('Widgets in this area will be shown on the right-hand side.', 'wp_dictate'),
        'class' => 'quick-menu',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="footer-title">',
        'after_title' => '</h3>'
    ));

    $sidebars = sh_set(get_option('wp_dictate'), 'dynamic_sidebars'); //printr($sidebars);
    foreach (array_filter((array) $sidebars) as $sidebar) {
        register_sidebar(array(
            'name' => $sidebar,
            'id' => bistro_slug($sidebar),
            'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
            'after_widget' => "</div>",
            'before_title' => '<div class="sidebar-widget-title"><h4>',
            'after_title' => '</h4></div>',
        ));
    }
    update_option('wp_registered_sidebars', $wp_registered_sidebars);
}

add_action('widgets_init', 'sh_widget_init');

function sh_theme_init() {
    if (function_exists('vc_map')) {
        include( SH_FRW_DIR . 'vc_map.php' );
    }
}

add_action('init', 'sh_theme_init');

function new_excerpt_more($more) {
    return ' <a class="read-more" href="' . get_permalink(get_the_ID()) . '">' . __('Read More', 'wp_dictate') . '</a>';
}

add_filter('excerpt_more', 'new_excerpt_more');

//responsive menu
function sh_responsive_menu() {
    $output = '';
    $MenuName = 'main_menu';
    if (( $locations = get_nav_menu_locations() ) && has_nav_menu($MenuName) && isset($locations['main_menu'])) {
        $menu = wp_get_nav_menu_object($locations['main_menu']);
        $menu_items = wp_get_nav_menu_items($menu->term_id);
        $output = "<select class='ipadMenu'>";
        $output .= "<option value='' selected='selected'>" . __('Go to...', 'wp_dictate') . "</option>";
        foreach ((array) $menu_items as $key => $menu_item) {
            $title = $menu_item->title;
            $url = $menu_item->url;

            if ($menu_item->menu_item_parent) {
                $title = ' - ' . $title;
            }
            $output .= "<option value='" . $url . "'>" . $title . '</option>';
        }
        $output .= '</select>';
    }
    echo $output;
}

add_filter('get_header', 'sh_under_construction');

function sh_under_construction() {
    if (!is_admin() && !is_user_logged_in()) {
        $settings = get_option('wp_dictate');
        if (sh_set($settings, 'coming_soon_status') == 'true') {
            get_template_part('comming', 'soon');
            exit;
        }
    }
}

function sh_woo_pages($page_id) {
    $pages = array(
        get_option('woocommerce_shop_page_id'),
        get_option('woocommerce_cart_page_id'),
        get_option('woocommerce_checkout_page_id'),
        get_option('woocommerce_pay_page_id'),
        get_option('woocommerce_thanks_page_id'),
        get_option('woocommerce_myaccount_page_id'),
        get_option('woocommerce_edit_address_page_id'),
        get_option('woocommerce_view_order_page_id'),
        get_option('woocommerce_terms_page_id')
    );
    return ( in_array($page_id, $pages) ) ? 'true' : 'false';
}

function sh_get_cat_limit($limit, $sep = '') {
    $categories = get_the_category();
    $separator = $sep;
    $output = '';
    $counter = 0;
    if ($categories) {
        foreach ($categories as $category) {
            if ($counter == $limit)
                break;
            $output .= '<li><a href="' . get_category_link($category->term_id) . '" title="' . esc_attr(sprintf(__("View all posts in %s", 'wp_dictate'), $category->name)) . '">' . $category->cat_name . '</a></li>';
            $counter++;
        }
        echo trim($output, $separator);
    }
}

function sh_get_term($limit, $sep = '', $taxonomy, $id) {
    $counter = 0;
    $terms = get_the_terms($id, $taxonomy);
    if ($terms && !is_wp_error($terms)) :
        $term_slugs_arr = array();
        foreach ($terms as $term) {
            if ($counter == $limit)
                break;
            $term_slugs_arr[] = $term->slug;
        }
        $terms_slug_str = join($sep, $term_slugs_arr);
    endif;
    echo $terms_slug_str;
}

function sh_cus_excerpt($limit) {
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if (count($excerpt) >= $limit) {
        array_pop($excerpt);
        $excerpt = implode(" ", $excerpt) . '...';
    } else {
        $excerpt = implode(" ", $excerpt);
    }
    $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
    return $excerpt;
}

add_action('wp_ajax_theme-install-demo-data', 'theme_ajax_install_dummy_data');

function theme_ajax_install_dummy_data() {
    
    require_once('framework/helpers/importer.php');
    sh_xml_importer();
    die();
}
if ( !function_exists( 'web_dictateImporterScript' ) ) {
    function web_dictateImporterScript() {
       
        _load_class( 'import_export', 'helpers', false );
        $importer = new SH_import_export();
        $importer->import();
    }
}
add_filter('wp_title', 'sh_filter_wp_title');

/**
 * Filters the page title appropriately depending on the current page
 *
 * This function is attached to the 'wp_title' fiilter hook.
 *
 * @uses	get_bloginfo()
 * @uses	is_home()
 * @uses	is_front_page()
 */
function sh_filter_wp_title($title) {
    global $page, $paged;
    if (is_feed())
        return $title;

    $site_description = get_bloginfo('description');

    $filtered_title = $title . get_bloginfo('name');
    $filtered_title .= (!empty($site_description) && ( is_home() || is_front_page() ) ) ? ' | ' . $site_description : '';
    $filtered_title .= ( 2 <= $paged || 2 <= $page ) ? ' | ' . sprintf(__('Page %s', 'wp_dictate'), max($paged, $page)) : '';

    return $filtered_title;
}
	function add_datepicker_in_footer(){ ?>
	<script type="text/javascript">
        jQuery(document).ready(function(){
            jQuery('#date').datepicker({
                dateFormat: 'dd-mm-yy'
            });
        });
	</script>
	<?php
} // close add_datepicker_in_footer() here
//add an action to call add_datepicker_in_footer function
add_action('wp_footer','add_datepicker_in_footer',10);

if ( function_exists( 'vc_map' ) ) {
	function sh_vc_disable_update() {
		if ( function_exists( 'vc_license' ) && function_exists( 'vc_updater' )
		     && ! vc_license()->isActivated()
		) {

			remove_filter( 'upgrader_pre_download',
				[ vc_updater(), 'preUpgradeFilter' ], 10 );
			remove_filter( 'pre_set_site_transient_update_plugins', [
				vc_updater()->updateManager(),
				'check_update'
			] );

		}
	}

	add_action( 'admin_init', 'sh_vc_disable_update', 9 );
}
if( function_exists( 'layerslider_set_as_theme' ) ) {
	layerslider_set_as_theme();
}
// Remove LayerSlider's update notifications
function filter_plugin_updates( $value ) {
	unset( $value->response['LayerSlider/layerslider.php'] );
	return $value;
}
add_filter( 'site_transient_update_plugins', 'filter_plugin_updates' );