<?php

$vc_array[] = array(
    "name" => __("Services With Custom Link", 'wp_dictate'),
    "base" => "sh_services_custom",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Select Post", 'wp_dictate'),
            "param_name" => "select_post",
            "value" => sh_posts_list(),
            "description" => __("Select the require post.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Link", 'wp_dictate'),
            "param_name" => "s1_link",
            //"value" => array(3 => 3 , 4 => 4),
            "description" => __("Enter custom link of services to show you have the custom post.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("FAQs", 'wp_dictate'),
    "base" => "sh_faqs",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'faqs',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter title for posts", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort FAQS BY", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array('date' => 'Date', 'title' => 'Title'),
            "description" => __("Select FAQs sorting option", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Skills", 'wp_dictate'),
    "base" => "sh_skills",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'skillbar',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Skill Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter The Name of The Skill Here", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Percentage of Skill", 'wp_dictate'),
            "param_name" => "skill",
            "value" => '',
            "description" => __("Enter The Percentage Here Like 12 or 70 (Out Of 100) Donot Enter The % Sign", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Class", 'wp_dictate'),
            "param_name" => "class",
            "value" => array('Rounded' => 'Rounded', 'Simple' => 'Simple'),
            "description" => __("Select Rounded or Simple Corner's Design Here", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Toggle", 'wp_dictate'),
    "base" => "sh_toggle",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'toggle-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title Here.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Font Awesome Icon", 'wp_dictate'),
            "param_name" => "icon",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select The Font Awesome Icon To Show With The Toggle Title", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("First Toggle", 'wp_dictate'),
            "param_name" => "first",
            "value" => array('true' => 'True', 'false' => 'False'),
            "description" => __("Keep this option open in any Toggle which you want to keep open Onload", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Last", 'wp_dictate'),
            "param_name" => "last",
            "value" => array_flip(array('true' => 'True', 'false' => 'False')),
            "description" => __("Keep this option true for all the toggles.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Accordion Style", 'wp_dictate'),
            "param_name" => "acc_style",
            "value" => array_flip(array('simple' => 'Simple', 'colored' => 'Colored')),
            "description" => ''
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Content", 'wp_dictate'),
            "param_name" => "content",
            "value" => '',
            "description" => __("Enter the content here to show in the Toggle under the title.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Price Table With Picture", 'wp_dictate'),
    "base" => "sh_price_table",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'price-table',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title of your price table like (Gold Package).", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sub Title", 'wp_dictate'),
            "param_name" => "sub_title",
            "value" => '',
            "description" => __("Enter sub title here like (The Most Used Package), it is just like a description of the title.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Currency", 'wp_dictate'),
            "param_name" => "currency",
            "value" => '',
            "description" => __("Enter currency symbol here like ($ etc).", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Price", 'wp_dictate'),
            "param_name" => "price",
            "value" => '',
            "description" => __("Enter price of the package here.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Duration", 'wp_dictate'),
            "param_name" => "duration",
            "value" => '',
            "description" => __("Enter duration of the package like (Per 30 Days).", 'wp_dictate')
        ),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Image", 'wp_dictate'),
            "param_name" => "image",
            "value" => '',
            "description" => __("Upload image here, Width is auto adjusted.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Option 1", 'wp_dictate'),
            "param_name" => "option1",
            "value" => '',
            "description" => __("Enter the package feature 1 like (20MB Storage).", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Option 2", 'wp_dictate'),
            "param_name" => "option2",
            "value" => '',
            "description" => __("Enter the package feature 2 like (50 Email Accounts).", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Option 3", 'wp_dictate'),
            "param_name" => "option3",
            "value" => '',
            "description" => __("Enter the package feature 3 like (Unlimited Addon Domains).", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Option 4", 'wp_dictate'),
            "param_name" => "option4",
            "value" => '',
            "description" => __("Enter the package feature 3 like (Free Support).", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Link", 'wp_dictate'),
            "param_name" => "link",
            "value" => '',
            "description" => __("Enter subscribtion page link here.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Alert Box", 'wp_dictate'),
    "base" => "sh_alert_box",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'alert-box',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for the Alert Box here.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Type", 'wp_dictate'),
            "param_name" => "type",
            "value" => array_flip(array('success' => 'Success', 'attention' => 'Attention', 'error' => 'Error', 'didyouknow' => 'Did You Know')),
            "description" => __("Enter the type of the box (every type has different icon and color).", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Message", 'wp_dictate'),
            "param_name" => "message",
            "value" => '',
            "description" => __("Enter the detailed massege to show in the Alert Box", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Button Styles", 'wp_dictate'),
    "base" => "sh_button",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'icon-button',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Text", 'wp_dictate'),
            "param_name" => "text",
            "value" => '',
            "description" => __("Enter text to show on the button.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Size", 'wp_dictate'),
            "param_name" => "size",
            "value" => array_flip(array('large' => 'Large', 'medium' => 'Medium', 'small' => 'Small')),
            "description" => __("Select the size of the button, Large, Medium or Small.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Color", 'wp_dictate'),
            "param_name" => "color",
            "value" => array_flip(array('cyan' => 'Cyan', 'green' => 'Green', 'lightblue' => 'Light Blue', 'darkblue' => 'Dark Blue', 'orange' => 'Orange', 'silver' => 'Silver')),
            "description" => __("Select the Botton Color to Apply on Button.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Shadow", 'wp_dictate'),
            "param_name" => "shadow",
            "value" => array_flip(array('none' => 'None', 'shadow1' => 'Shadow 1', 'shadow2' => 'Shadow 2')),
            "description" => __("Select on of the three given shadow styles.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Link", 'wp_dictate'),
            "param_name" => "link",
            "value" => '',
            "description" => __("Enter URL for the button.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Recent Posts Carousel", 'wp_dictate'),
    "base" => "sh_recent_posts",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'recent-posts',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter the number of posts to show.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "category",
            "value" => sh_get_categories(),
            "description" => __("Enter posts category.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Appointment Box (Click to Open) ", 'wp_dictate'),
    "base" => "sh_appointment_dropdown",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'appointment-downs',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter The Title.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Descriptive Portfolio or Blog", 'wp_dictate'),
    "base" => "sh_descriptive_portfolio",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'appointment-downs',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts to show.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Columns", 'wp_dictate'),
            "param_name" => "cols",
            "value" => array_flip(array('span6' => '2 Columns', 'span4' => '3 Columns', 'span3' => '4 Columns')),
            "description" => __("Choose number of colums you show the posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Post Type", 'wp_dictate'),
            "param_name" => "post_type",
            "value" => array_flip(array('post' => 'Blog', 'dict_portfolio' => 'Portfolio', 'dict_gallery' => 'Gallery')),
            "description" => __("Choose Post type to select Posts From.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Portfolio with Filters", 'wp_dictate'),
    "base" => "sh_portfolio_with_filters",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'appointment-downs',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts to show.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Columns", 'wp_dictate'),
            "param_name" => "cols",
            "value" => array_flip(array('span6' => '2 Columns', 'span4' => '3 Columns', 'span3' => '4 Columns')),
            "description" => __("Choose number of colums you show the posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Portfoliyo Description", 'wp_dictate'),
            "param_name" => "portfolio_desc",
            "value" => array_flip(array(true => 'True', false => 'False')),
            "description" => __("Choose Post type to select Posts From.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Appointment Box Colored Title", 'wp_dictate'),
    "base" => "sh_appointment_sidebox",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'appointment-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter name.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title 2", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter .", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Text", 'wp_dictate'),
            "param_name" => "text",
            "value" => '',
            "description" => __("Enter text.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Appointment Box (Gray or Simple Title)", 'wp_dictate'),
    "base" => "sh_appointment_sidebox_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'appointment-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title here.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title Style", 'wp_dictate'),
            "param_name" => "title_style",
            "value" => array_flip(array('simple' => 'Simple Title', 'grey_title' => 'Grey Title')),
            "description" => __("Enter Title Style (Choose from simple title style of title with gray background).", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Tag Line", 'wp_dictate'),
            "param_name" => "tag_line",
            "value" => '',
            "description" => __("Enter Tag Line if you Choosed the Grey Title (Option remains invalid if you choose simple title style above).", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Text", 'wp_dictate'),
            "param_name" => "text",
            "value" => '',
            "description" => __("Enter text.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Time Table (Full Page)", 'wp_dictate'),
    "base" => "sh_time_table",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'timetable',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter name.", 'wp_dictate')
        ),
        array(
            "type" => "checkbox",
            "holder" => "div",
            "class" => "",
            "heading" => __("Days", 'wp_dictate'),
            "param_name" => "tt_days",
            "value" => array_flip(array("sh_timetable" => __("Sunday", 'wp_dictate'), "sh_monday" => __("Monday", 'wp_dictate'), "sh_tuesday" => __("Tuesday", 'wp_dictate'), "sh_wednesday" => __("Wednesday", 'wp_dictate'), "sh_thursday" => __("Thursday", 'wp_dictate'), "sh_friday" => __("Friday", 'wp_dictate'), "sh_saturday" => __("Saturday", 'wp_dictate'))),
            "description" => __("Choose Days which you want to show on the Time Table.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Time Table (Half Page with Tabs)", 'wp_dictate'),
    "base" => "sh_time_table_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'timetable',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter the title here.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slogan", 'wp_dictate'),
            "param_name" => "slogan",
            "value" => '',
            "description" => __("Enter the subtitle here.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("View All URL", 'wp_dictate'),
            "param_name" => "view_all_link",
            "value" => '',
            "description" => __("Enter the URL to link the View All button to redirect the visitor to the timetable detail page.", 'wp_dictate')
        ),
        array(
            "type" => "checkbox",
            "holder" => "div",
            "class" => "",
            "heading" => __("Days", 'wp_dictate'),
            "param_name" => "tt_days",
            "value" => array_flip(array("sh_timetable" => __("Sunday", 'wp_dictate'), "sh_monday" => __("Monday", 'wp_dictate'), "sh_tuesday" => __("Tuesday", 'wp_dictate'), "sh_wednesday" => __("Wednesday", 'wp_dictate'), "sh_thursday" => __("Thursday", 'wp_dictate'), "sh_friday" => __("Friday", 'wp_dictate'), "sh_saturday" => __("Saturday", 'wp_dictate'))),
            "description" => __("Choose Days which you want to show on the Time Table.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Services Simple Style 1 ", 'wp_dictate'),
    "base" => "sh_services_1",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "s1_number",
            "value" => array(3 => 3, 4 => 4),
            "description" => __("Enter number of services to show you have the option to select 3 or 4 services to show from the above given dropdown menu.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => false))),
            "description" => __("Enter the category of services from which you want to show the services. You can make these category in the Services post.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("Select how to sort it.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Linked to Detailed Page ?", 'wp_dictate'),
            "param_name" => "linked",
            "value" => array_flip(array('yes' => 'Yes', 'no' => 'No')),
            "description" => __("Select how to sort it.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Services with Icon on Top 2", 'wp_dictate'),
    "base" => "sh_services_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => false))),
            "description" => __("Enter department or category from which the services are to be displayed in the services area on the front page.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("Select how to sort the services.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Linked to Detailed Page ?", 'wp_dictate'),
            "param_name" => "linked",
            "value" => array_flip(array('yes' => 'Yes', 'no' => 'No')),
            "description" => __("Select how to sort it.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Services Widescreen 3", 'wp_dictate'),
    "base" => "sh_services_3",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title of the section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Subtitle", 'wp_dictate'),
            "param_name" => "subtitle",
            "value" => '',
            "description" => __("Enter sub title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => false))),
            "description" => __("Enter services category to show the the items.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("Select how to sort out the services.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Linked to Detailed Page ?", 'wp_dictate'),
            "param_name" => "linked",
            "value" => array_flip(array('yes' => 'Yes', 'no' => 'No')),
            "description" => __("Select how to sort it.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Services With Picture 4", 'wp_dictate'),
    "base" => "sh_services_4",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title of the section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Subtitle", 'wp_dictate'),
            "param_name" => "subtitle",
            "value" => '',
            "description" => __("Enter slogan of the section", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => false))),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Image", 'wp_dictate'),
            "param_name" => "img",
            "value" => '',
            "description" => __("Upload Background Image for this section.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Linked to Detailed Page ?", 'wp_dictate'),
            "param_name" => "linked",
            "value" => array_flip(array('yes' => 'Yes', 'no' => 'No')),
            "description" => __("Select how to sort it.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Services with FA Icons 5", 'wp_dictate'),
    "base" => "sh_services_5",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter the number of posts to show.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => false))),
            "description" => __("Select posts category from which the post needs to be shown. You select this category from Our Services single post.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("Select the sort option.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Linked to Detailed Page ?", 'wp_dictate'),
            "param_name" => "linked",
            "value" => array_flip(array('yes' => 'Yes', 'no' => 'No')),
            "description" => __("Select how to sort it.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Services Parallax Style 6", 'wp_dictate'),
    "base" => "sh_services_6",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => false))),
            "description" => __("Select service category.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Image", 'wp_dictate'),
            "param_name" => "bg",
            "value" => '',
            "description" => __("Upload background image.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Linked to Detailed Page ?", 'wp_dictate'),
            "param_name" => "linked",
            "value" => array_flip(array('yes' => 'Yes', 'no' => 'No')),
            "description" => __("Select how to sort it.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Our Team Carousel", 'wp_dictate'),
    "base" => "sh_our_staff_slider",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'our-staff',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Select the number of members to show in the carousel slider.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter the title here.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'department'))),
            "description" => __("Select the category from which the memebers are to be displayed.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Our Team Carousel 2", 'wp_dictate'),
    "base" => "sh_our_staff_slider_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'our-staff',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Select the number of members to show in the carousel slider.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter the title here.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'department'))),
            "description" => __("Select the category from which the memebers are to be displayed.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Recent Events Full Page", 'wp_dictate'),
    "base" => "sh_recent_events",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'recent-events',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter the title of this section here.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => array_flip(array(3 => 3, 4 => 4)),
            "description" => __("Enter number of events to show.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Recent Events Tabs", 'wp_dictate'),
    "base" => "sh_recent_events_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'recent-events',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter Title of this section.", 'wp_dictate')
        ),
        array(
            "type" => "autocomplete",
            "heading" => __("Select Events", 'wp_dictate'),
            "param_name" => "post_ids",
             'settings' => array(
                'multiple' => true,
                'sortable' => true,
                'min_length' => 1,
                'no_hide' => true, // In UI after select doesn't hide an select list
                'groups' => false, // In UI show results grouped by groups
                'unique_values' => true, // In UI show results except selected. NB! You should manually check values in backend
                'display_inline' => true, // In UI show results inline view
                "values" => sh_get_posts_array('dict_event', true),
            ),
            
            "description" => __("Slect the category from which you want to show the images.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slogan", 'wp_dictate'),
            "param_name" => "slogan",
            "description" => __("Enter Slogan.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Title Style", 'wp_dictate'),
            "param_name" => "title_style",
            "value" => array_flip(array('simple' => 'Simple Title', 'red_title' => 'Red Title')),
            "description" => __("Select the title style of this section, Red Background Title or Simple Text Title.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Our Affiliation", 'wp_dictate'),
    "base" => "sh_our_affiliation",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'our-affiliation',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title for this Section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of affiliated companies to show.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Testimonial Vertical Style", 'wp_dictate'),
    "base" => "sh_testimonial",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'testimonials',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter the title of the section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slogan", 'wp_dictate'),
            "param_name" => "slogan",
            "value" => '',
            "description" => __("Enter the slogan of the section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Testimonial Horizontal Style 2", 'wp_dictate'),
    "base" => "sh_testimonial_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'testimonials',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of testimonials to show.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Testimonial with Image on Top", 'wp_dictate'),
    "base" => "sh_testimonial_3",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'testimonials',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title for the Section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of testimonials to show.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Portfolio Modern Style", 'wp_dictate'),
    "base" => "sh_portfolio",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'portfolio',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of portfolios to show.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("About", 'wp_dictate'),
    "base" => "sh_about",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'about',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Text", 'wp_dictate'),
            "param_name" => "text",
            "value" => '',
            "description" => __("Enter text.", 'wp_dictate')
        ),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Image", 'wp_dictate'),
            "param_name" => "bg",
            "value" => '',
            "description" => __("Insert the background image URL.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Team Carousel Vertical Pics", 'wp_dictate'),
    "base" => "sh_team_1",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'team',
    "params" => array(
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Image", 'wp_dictate'),
            "param_name" => "img",
            "value" => '',
            "description" => __("Upload the background image.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slogan", 'wp_dictate'),
            "param_name" => "slogan",
            "value" => '',
            "description" => __("Enter slogan.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'department'))),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Team Carousel Horizontal Pics", 'wp_dictate'),
    "base" => "sh_team_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'team',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'department'))),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Team 3", 'wp_dictate'),
    "base" => "sh_team_3",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'team',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'department'))),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Employee", 'wp_dictate'),
    "base" => "sh_employee",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'team',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'department'))),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Company Progress", 'wp_dictate'),
    "base" => "sh_company_progress",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'company-progress',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("From Last Year", 'wp_dictate'),
            "param_name" => "from_last_year",
            "value" => '',
            "description" => __("Enter progress from last year", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Gross Revenue", 'wp_dictate'),
            "param_name" => "gross_revenue",
            "value" => '',
            "description" => __("Enter gross revenue.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Net Revenue", 'wp_dictate'),
            "param_name" => "net_revenue",
            "value" => '',
            "description" => __("Enter net revenue.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Text", 'wp_dictate'),
            "param_name" => "text",
            "value" => '',
            "description" => __("Enter detail contents.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("January", 'wp_dictate'),
            "param_name" => "jan",
            "value" => '',
            "description" => __("Enter Progress percentage for January.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("February", 'wp_dictate'),
            "param_name" => "feb",
            "value" => '',
            "description" => __("Enter Progress percentage for February.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("March", 'wp_dictate'),
            "param_name" => "mar",
            "value" => '',
            "description" => __("Enter Progress percentage for March.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("April", 'wp_dictate'),
            "param_name" => "apr",
            "value" => '',
            "description" => __("Enter Progress percentage for April.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("May", 'wp_dictate'),
            "param_name" => "may",
            "value" => '',
            "description" => __("Enter Progress percentage for May.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("June", 'wp_dictate'),
            "param_name" => "jun",
            "value" => '',
            "description" => __("Enter Progress percentage for June.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("July", 'wp_dictate'),
            "param_name" => "jul",
            "value" => '',
            "description" => __("Enter Progress percentage for July.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("August", 'wp_dictate'),
            "param_name" => "aug",
            "value" => '',
            "description" => __("Enter Progress percentage for August.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("September", 'wp_dictate'),
            "param_name" => "sep",
            "value" => '',
            "description" => __("Enter Progress percentage for September.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Octuber", 'wp_dictate'),
            "param_name" => "oct",
            "value" => '',
            "description" => __("Enter Progress percentage for Octuber.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("November", 'wp_dictate'),
            "param_name" => "nov",
            "value" => '',
            "description" => __("Enter Progress percentage for November.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("December", 'wp_dictate'),
            "param_name" => "dec",
            "value" => '',
            "description" => __("Enter Progress percentage for December.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Camera Slider", 'wp_dictate'),
    "base" => "sh_camera_slider",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'camera-slider',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of slides", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Parallex Slider", 'wp_dictate'),
    "base" => "sh_parallex_slider",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'slicebox-slider',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of slides", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random'),
            "description" => __("Enter posts category.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Slice Box Slider", 'wp_dictate'),
    "base" => "sh_slice_box_slider",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'slicebox-slider',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of slides", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("About Us With video", 'wp_dictate'),
    "base" => "sh_aboutus_video",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'slicebox-slider',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title for the Section", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Text", 'wp_dictate'),
            "param_name" => "text",
            "value" => '',
            "description" => __("Enter Text for the Section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Video Link", 'wp_dictate'),
            "param_name" => "mp4_vid",
            "value" => '',
            "description" => __("Enter Link to your MP4 Video To display in This Section", 'wp_dictate')
        ),
        array(
            "type" => "attach_images",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Image", 'wp_dictate'),
            "param_name" => "bg",
            "value" => '',
            "description" => __("Upload Image to Show as Background of this Section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 1 Title", 'wp_dictate'),
            "param_name" => "s1_name",
            "value" => '',
            "description" => __("Enter Title for Service 1.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 1 Icon", 'wp_dictate'),
            "param_name" => "s1_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Service 1.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 2 Title", 'wp_dictate'),
            "param_name" => "s2_name",
            "value" => '',
            "description" => __("Enter Title for Service 2.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 2 Icon", 'wp_dictate'),
            "param_name" => "s2_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Service 2.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 3 Title", 'wp_dictate'),
            "param_name" => "s3_name",
            "value" => '',
            "description" => __("Enter Title for Service 3.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 3 Icon", 'wp_dictate'),
            "param_name" => "s3_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Service 3.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Services with Video BG", 'wp_dictate'),
    "base" => "sh_services_bg_video",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'slicebox-slider',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title for the Section", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Text", 'wp_dictate'),
            "param_name" => "text",
            "value" => '',
            "description" => __("Enter Text for the Section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Video Link", 'wp_dictate'),
            "param_name" => "mp4_vid",
            "value" => '',
            "description" => __("Enter Link to your MP4 Video To display in This Section", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Option", 'wp_dictate'),
            "param_name" => "bg_op",
            "value" => array_flip(array('image' => 'Image', 'vid' => 'Video')),
            "description" => __("Select the font awesome icon for Service 1.", 'wp_dictate')
        ),
        array(
            "type" => "attach_images",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Image", 'wp_dictate'),
            "param_name" => "bg",
            "value" => '',
            "description" => __("Upload Image to Show as Background of this Section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 1 Title", 'wp_dictate'),
            "param_name" => "s1_name",
            "value" => '',
            "description" => __("Enter Title for Service 1.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 1 Icon", 'wp_dictate'),
            "param_name" => "s1_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Service 1.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 2 Title", 'wp_dictate'),
            "param_name" => "s2_name",
            "value" => '',
            "description" => __("Enter Title for Service 2.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 2 Icon", 'wp_dictate'),
            "param_name" => "s2_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Service 2.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 3 Title", 'wp_dictate'),
            "param_name" => "s3_name",
            "value" => '',
            "description" => __("Enter Title for Service 3.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 3 Icon", 'wp_dictate'),
            "param_name" => "s3_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Service 3.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 4 Title", 'wp_dictate'),
            "param_name" => "s4_name",
            "value" => '',
            "description" => __("Enter Title for Service 4.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service 4 Icon", 'wp_dictate'),
            "param_name" => "s4_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Service 4.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Recent Blog Posts", 'wp_dictate'),
    "base" => "sh_blog_posts",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'recent-posts',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number of Posts", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter the number of posts", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories()),
            "description" => __("Enter text for Heading", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("select the sorting order", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Price Table 2", 'wp_dictate'),
    "base" => "sh_price_table_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'recent-posts',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter the Title for Price Table", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Currency", 'wp_dictate'),
            "param_name" => "currency",
            "value" => '',
            "description" => __("Enter the Currency Symbol Like $.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Price Before Decimal", 'wp_dictate'),
            "param_name" => "price_before_decimal",
            "value" => '',
            "description" => __("Enter the Price Before Decimal.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Price after Decimal", 'wp_dictate'),
            "param_name" => "price_after_decimal",
            "value" => '',
            "description" => __("Enter the Price After Decimal.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Service Duration", 'wp_dictate'),
            "param_name" => "duration",
            "value" => '',
            "description" => __("Enter the Duration of Your service as Per Month or Year.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 1", 'wp_dictate'),
            "param_name" => "s1_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 1 Icon", 'wp_dictate'),
            "param_name" => "sp1_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 2", 'wp_dictate'),
            "param_name" => "s2_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 2 Icon", 'wp_dictate'),
            "param_name" => "sp2_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 3", 'wp_dictate'),
            "param_name" => "s3_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 3 Icon", 'wp_dictate'),
            "param_name" => "sp3_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 4", 'wp_dictate'),
            "param_name" => "s4_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 4 Icon", 'wp_dictate'),
            "param_name" => "sp4_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 5", 'wp_dictate'),
            "param_name" => "s5_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 5 Icon", 'wp_dictate'),
            "param_name" => "sp5_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 6", 'wp_dictate'),
            "param_name" => "s6_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 6 Icon", 'wp_dictate'),
            "param_name" => "sp6_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 7", 'wp_dictate'),
            "param_name" => "s7_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 7 Icon", 'wp_dictate'),
            "param_name" => "sp7_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 8", 'wp_dictate'),
            "param_name" => "s8_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 8 Icon", 'wp_dictate'),
            "param_name" => "sp8_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 9", 'wp_dictate'),
            "param_name" => "s9_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 9 Icon", 'wp_dictate'),
            "param_name" => "sp9_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 10", 'wp_dictate'),
            "param_name" => "s10_name",
            "value" => '',
            "description" => __("Enter the Specification of Your Service/Product/Packages.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Specs 10 Icon", 'wp_dictate'),
            "param_name" => "sp10_fa",
            "value" => array_flip(sh_font_awesome()),
            "description" => __("Select the font awesome icon for Specification.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("News", 'wp_dictate'),
    "base" => "sh_news",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'timetable',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter name.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter Number of News to show.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("select the sorting order", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Column Size", 'wp_dictate'),
            "param_name" => "column_size",
            "value" => array_flip(array('span12' => '1 Clomn', 'span6' => '2 Column', 'span4' => '3 Column', 'span3' => '4 Column')),
            "description" => __("Choose the column size in which you are putting This Section.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("News 2", 'wp_dictate'),
    "base" => "sh_news_2",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'timetable',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter name.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter Number of News to show.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("select the sorting order", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Column Size", 'wp_dictate'),
            "param_name" => "column_size",
            "value" => array_flip(array('span12' => '1 Clomn', 'span6' => '2 Column', 'span4' => '3 Column', 'span3' => '4 Column')),
            "description" => __("Choose the column size in which you are putting This Section.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Services Areas", 'wp_dictate'),
    "base" => "sh_service_areas",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'timetable',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter name.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "num",
            "value" => '',
            "description" => __("Enter Number of service Area's to Show.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Column Size", 'wp_dictate'),
            "param_name" => "column_size",
            "value" => array_flip(array('span12' => '1 Clomn', 'span6' => '2 Column', 'span4' => '3 Column', 'span3' => '4 Column')),
            "description" => __("Choose the column size in which you are putting This Section.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Awards", 'wp_dictate'),
    "base" => "sh_awards",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'timetable',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter name.", 'wp_dictate')
        ),
        array(
            "type" => "attach_images",
            "holder" => "div",
            "class" => "",
            "heading" => __("Image", 'wp_dictate'),
            "param_name" => "awards",
            "value" => '',
            "description" => __("Upload image.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Services 7", 'wp_dictate'),
    "base" => "sh_services_7",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title of this Section.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => array(3, 4, 6),
            "description" => __("Choose number of posts", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => false))),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort", 'wp_dictate'),
            "param_name" => "sort",
            "value" => array_flip(array('date' => 'Date', 'title' => 'Title', 'name' => 'Name', 'author' => 'Author', 'comment_count' => 'Comment Count', 'random' => 'Random')),
            "description" => __("Enter posts category.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Linked to Detailed Page ?", 'wp_dictate'),
            "param_name" => "linked",
            "value" => array_flip(array('yes' => 'Yes', 'no' => 'No')),
            "description" => __("Select how to sort it.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Find a Doctor", 'wp_dictate'),
    "base" => "sh_find_a_doctor",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title for this Section.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title Style", 'wp_dictate'),
            "param_name" => "title_style",
            "value" => array_flip(array('simple' => 'Simple Title', 'grey_title' => 'Grey Title')),
            "description" => __("Enter Title Style.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Tag Line", 'wp_dictate'),
            "param_name" => "tag_line",
            "value" => '',
            "description" => __("Enter Tag Line if you Choosed the Grey Title.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Gallery", 'wp_dictate'),
    "base" => "sh_gallery",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title for this Section.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Gallery", 'wp_dictate'),
            "param_name" => "gallery",
            "value" => array_flip(sh_get_posts_array('dict_gallery')),
            "description" => __("Choose Gallery.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Columns", 'wp_dictate'),
            "param_name" => "cols",
            "value" => array_flip(array('span6' => '2 Columns', 'span4' => '3 Columns', 'span3' => '4 Columns')),
            "description" => __("Choose Number of Columns for the Gallery.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Weekly Schedule", 'wp_dictate'),
    "base" => "sh_weekly_schedule",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'our-staff',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter the title here.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Opening Tim", 'wp_dictate'),
            "param_name" => "opening_time",
            "value" => '',
            "description" => __("Enter the Opening Time.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Closing Tim", 'wp_dictate'),
            "param_name" => "closing_time",
            "value" => '',
            "description" => __("Enter the Closing Time.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sunday", 'wp_dictate'),
            "param_name" => "sunday_option",
            "value" => array_flip(array('on' => 'ON', 'off' => 'OFF')),
            "description" => __("Choose On or Off for Sunday.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Tag Line", 'wp_dictate'),
            "param_name" => "tagline",
            "value" => '',
            "description" => __("Enter the Tag Line.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Daily Schedule", 'wp_dictate'),
    "base" => "sh_daily_schedule",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'our-staff',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Name", 'wp_dictate'),
            "param_name" => "name",
            "value" => '',
            "description" => __("Enter the title here.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Monday", 'wp_dictate'),
            "param_name" => "monday",
            "value" => '',
            "description" => __("Enter the timing for Monday.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Teusday", 'wp_dictate'),
            "param_name" => "teusday",
            "value" => '',
            "description" => __("Enter the timing for Teusday.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Wednesday", 'wp_dictate'),
            "param_name" => "wednesday",
            "value" => '',
            "description" => __("Enter the timing for Wednesday.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Thirsday", 'wp_dictate'),
            "param_name" => "thirsday",
            "value" => '',
            "description" => __("Enter the timing for Thirsday.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Friday", 'wp_dictate'),
            "param_name" => "friday",
            "value" => '',
            "description" => __("Enter the timing for Friday.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Saturday", 'wp_dictate'),
            "param_name" => "saturday",
            "value" => '',
            "description" => __("Enter the timing for Saturday.", 'wp_dictate')
        ), array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sunday", 'wp_dictate'),
            "param_name" => "sunday",
            "value" => '',
            "description" => __("Enter the timing for Sunday.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Tag Line", 'wp_dictate'),
            "param_name" => "tagline",
            "value" => '',
            "description" => __("Enter the Tag Line.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Text Parallax Slider", 'wp_dictate'),
    "base" => "sh_parralex_textbox",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'our-staff',
    "params" => array(
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Image", 'wp_dictate'),
            "param_name" => "bg",
            "value" => '',
            "description" => __("Insert the background image URL.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 1 Title", 'wp_dictate'),
            "param_name" => "title1",
            "value" => '',
            "description" => __("Enter the title for Slide 1.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 1 Boxed Title", 'wp_dictate'),
            "param_name" => "boxed_title1",
            "value" => '',
            "description" => __("Enter the Boxed title for Slide 1.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 1 Text", 'wp_dictate'),
            "param_name" => "text1",
            "value" => '',
            "description" => __("Enter the text for Slide 1.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 2 Title", 'wp_dictate'),
            "param_name" => "title2",
            "value" => '',
            "description" => __("Enter the title for Slide 2.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 2 Boxed Title", 'wp_dictate'),
            "param_name" => "boxed_title2",
            "value" => '',
            "description" => __("Enter the Boxed title for Slide 2.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 2 Text", 'wp_dictate'),
            "param_name" => "text2",
            "value" => '',
            "description" => __("Enter the text for Slide 2.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 3 Title", 'wp_dictate'),
            "param_name" => "title3",
            "value" => '',
            "description" => __("Enter the title for Slide 3.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 3 Boxed Title", 'wp_dictate'),
            "param_name" => "boxed_title3",
            "value" => '',
            "description" => __("Enter the Boxed title for Slide 3.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 3 Text", 'wp_dictate'),
            "param_name" => "text3",
            "value" => '',
            "description" => __("Enter the text for Slide 3.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 4 Title", 'wp_dictate'),
            "param_name" => "title4",
            "value" => '',
            "description" => __("Enter the title for Slide 4.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 4 Boxed Title", 'wp_dictate'),
            "param_name" => "boxed_title4",
            "value" => '',
            "description" => __("Enter the Boxed title for Slide 4.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 4 Text", 'wp_dictate'),
            "param_name" => "text4",
            "value" => '',
            "description" => __("Enter the text for Slide 4.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 5 Title", 'wp_dictate'),
            "param_name" => "title5",
            "value" => '',
            "description" => __("Enter the title for Slide 5.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 5 Boxed Title", 'wp_dictate'),
            "param_name" => "boxed_title5",
            "value" => '',
            "description" => __("Enter the Boxed title for Slide 5.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Slide 5 Text", 'wp_dictate'),
            "param_name" => "text5",
            "value" => '',
            "description" => __("Enter the text for Slide 5.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Our History", 'wp_dictate'),
    "base" => "sh_our_history",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'our-staff',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter the title.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter the Number.", 'wp_dictate')
        ),
    )
);
$vc_array[] = array(
    "name" => __("Our Products", 'wp_dictate'),
    "base" => "sh_our_products",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'services-icon',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter Title for this Section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number of Products", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter the number of products", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array('date' => __('Date', 'wp_dictate'), 'title' => __('Title', 'wp_dictate'), 'name' => __('Name', 'wp_dictate'), 'author' => __('Author', 'wp_dictate'), 'comment_count' => __('Comment Count', 'wp_dictate'), 'rand' => __('Random', 'wp_dictate'))),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __('Category', 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'product_cat', 'hide_empty' => FALSE))),
            "description" => __('Choose Category.', 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(__('Ascending Order', 'wp_dictate') => 'ASC', __('Descending Order', 'wp_dictate') => 'DESC'),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);
$vc_array[] = array(
    "name" => __("Best Sellers", 'wp_dictate'),
    "base" => "sh_best_sellers",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => 'faqs',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for section", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Creative News", 'wp_dictate'),
    "base" => "sh_creative_news",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Simple Services", 'wp_dictate'),
    "base" => "sh_simple_services",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __('Category', 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => FALSE))),
            "description" => __('Choose Category.', 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Welcome Box", 'wp_dictate'),
    "base" => "sh_welcome_box",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sub Title:", 'wp_dictate'),
            "param_name" => "sub_title",
            "value" => '',
            "description" => __("Enter sub title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Description:", 'wp_dictate'),
            "param_name" => "desc",
            "value" => '',
            "description" => __("Enter Description for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Button Title:", 'wp_dictate'),
            "param_name" => "btn_title",
            "value" => '',
            "description" => __("Enter Button Title of theis section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Button Link:", 'wp_dictate'),
            "param_name" => "btn_link",
            "value" => '',
            "description" => __("Enter Button link.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Banner", 'wp_dictate'),
    "base" => "sh_banner",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Select Image:", 'wp_dictate'),
            "param_name" => "img",
            "value" => '',
            "description" => __("Select Your Banner Image.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Testimonial Carousal", 'wp_dictate'),
    "base" => "sh_testimonial_carousal",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of show testimonial.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Fancy News", 'wp_dictate'),
    "base" => "sh_fancy_news",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Blog Tipsy List", 'wp_dictate'),
    "base" => "sh_tipsy_list",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __('Category', 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'category', 'hide_empty' => FALSE))),
            "description" => __('Choose Category.', 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Creative Our Affiliation", 'wp_dictate'),
    "base" => "sh_creative_our_affiliation",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of affiliated companies to show.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Simple Text", 'wp_dictate'),
    "base" => "sh_simple_text",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textarea_raw_html",
            "holder" => "div",
            "class" => "",
            "heading" => __("Text or Code:", 'wp_dictate'),
            "param_name" => "code",
            "value" => '',
            "description" => __("Enter simple text or html for this section.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Simple Image", 'wp_dictate'),
    "base" => "sh_simple_image",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Image:", 'wp_dictate'),
            "param_name" => "img",
            "value" => '',
            "description" => __("Selec image for this section.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Services with Parallax", 'wp_dictate'),
    "base" => "sh_services_with_parallax",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __('Category', 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => FALSE))),
            "description" => __('Choose Category.', 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Creative Portfolio", 'wp_dictate'),
    "base" => "sh_creative_portfolio",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts to show for each category.", 'wp_dictate')
        ),
        array(
            "type" => "checkbox",
            "holder" => "div",
            "class" => "",
            "heading" => __("Category:", 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'portfolio_category', 'hide_empty' => FALSE))),
            "description" => __("Select Category.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Packages", 'wp_dictate'),
    "base" => "sh_packages",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts to show for each category.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Creative Packages", 'wp_dictate'),
    "base" => "sh_creative_packages",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts to show for each category.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("About Box", 'wp_dictate'),
    "base" => "sh_about_box",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Image:", 'wp_dictate'),
            "param_name" => "img",
            "value" => '',
            "description" => __("Upload Image.", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Description:", 'wp_dictate'),
            "param_name" => "desc",
            "value" => '',
            "description" => __("Enter your description.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Button Text:", 'wp_dictate'),
            "param_name" => "btn_txt",
            "value" => '',
            "description" => __("Enter button text.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Button Link:", 'wp_dictate'),
            "param_name" => "btn_link",
            "value" => '',
            "description" => __("Enter button link.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Fancy Toggle", 'wp_dictate'),
    "base" => "sh_accordian_block",
    "class" => "",
    "as_parent" => array('only' => 'sh_accordian'),
    "content_element" => true,
    "show_settings_on_create" => false,
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Toggle Block", 'wp_dictate'),
    "base" => "sh_accordian",
    "class" => "",
    "content_element" => true,
    "as_child" => array('only' => 'sh_accordian_block'),
    "icon" => '',
    "category" => __('Dictate', 'wp_dictate'),
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "description" => __("Enter the title of the accordian", 'wp_dictate')
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __('Content', 'wp_dictate'),
            "param_name" => "acc_content",
            'value' => '',
            "description" => __("Enter the Content:", 'wp_dictate')
        ),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => __("Background Image:", 'wp_dictate'),
            "param_name" => "img",
            "value" => '',
            "description" => __("Upload Image.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Modern Services", 'wp_dictate'),
    "base" => "sh_modern_services",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __('Category', 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'services_department', 'hide_empty' => FALSE))),
            "description" => __('Choose Category.', 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Our Staff", 'wp_dictate'),
    "base" => "sh_our_staff",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title:", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title for this section.", 'wp_dictate')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of posts.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __('Category', 'wp_dictate'),
            "param_name" => "cat",
            "value" => array_flip(sh_get_categories(array('taxonomy' => 'department', 'hide_empty' => FALSE))),
            "description" => __('Choose Category.', 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        )
    )
);

$vc_array[] = array(
    "name" => __("Testimonial Parallax Carousal", 'wp_dictate'),
    "base" => "sh_testimonial_parallax_carousal",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Number:", 'wp_dictate'),
            "param_name" => "number",
            "value" => '',
            "description" => __("Enter number of show testimonial.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Overlay:", 'wp_dictate'),
            "param_name" => "overly",
            "value" => array(
                __('True', 'wp_dictate') => 'true',
                __('False', 'wp_dictate') => 'false',
            ),
            "description" => __("Overlay this section to the parallax.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sort By", 'wp_dictate'),
            "param_name" => "orderby",
            "value" => array_flip(array(
                'date' => __('Date', 'wp_dictate'),
                'title' => __('Title', 'wp_dictate'),
                'name' => __('Name', 'wp_dictate'),
                'author' => __('Author', 'wp_dictate'),
                'comment_count' => __('Comment Count', 'wp_dictate'),
                'rand' => __('Random', 'wp_dictate'),
                    )
            ),
            "description" => __("Choose Sorting by.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Sorting Order", 'wp_dictate'),
            "param_name" => "order",
            "value" => array(
                __('Ascending Order', 'wp_dictate') => 'ASC',
                __('Descending Order', 'wp_dictate') => 'DESC',
            ),
            "description" => __("Choose Sorting Order.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Simple Image Carousel", 'wp_dictate'),
    "base" => "sh_simple_carousel",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => '',
    "params" => array(
        array(
            "type" => "attach_images",
            "holder" => "div",
            "class" => "",
            "heading" => __("Images:", 'wp_dictate'),
            "param_name" => "img",
            "value" => '',
            "description" => __("Select images.", 'wp_dictate')
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Overlap:", 'wp_dictate'),
            "param_name" => "overlap",
            "value" => array(
                __('True', 'wp_dictate') => 'true',
                __('False', 'wp_dictate') => 'false',
            ),
            "description" => __("Overla this section.", 'wp_dictate')
        ),
    )
);

$vc_array[] = array(
    "name" => __("Appointment Box", 'wp_dictate'),
    "base" => "sh_appointment_parallax",
    "class" => "",
    "category" => __('Dictate', 'wp_dictate'),
    "icon" => "",
    "params" => array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Title", 'wp_dictate'),
            "param_name" => "title",
            "value" => '',
            "description" => __("Enter title here.", 'wp_dictate')
        ),
    )
);

foreach ($vc_array as $vc_arr) {

    foreach (sh_set($vc_arr, 'params') as $k => $param) {

        if (sh_set($param, 'holder')) {
            unset($param['holder']);
            $vc_arr['params'][$k] = $param;
        }

        if (sh_set($param, 'type') == 'dropdown') {
            if (array_key_exists('value', $param)) {
                $new_elment = array(__('Please select', 'wp_dictate') . ' ' . strtolower(sh_set($param, 'heading')) => 0);
                $param['value'] = array_merge($new_elment, $param['value']);
                $vc_arr['params'][$k]['value'] = $param['value'];
            }
        }
    }
    vc_map($vc_arr);
}

class WPBakeryShortCode_sh_accordian_block extends WPBakeryShortCodesContainer {
    
}

class WPBakeryShortCode_sh_accordian extends WPBakeryShortCode {
    
}

function sh_custom_css_classes_for_vc_row_and_vc_column($class_string, $tag) {
    $dir = ABSPATH . 'wp-content/plugins/js_composer/js_composer.php';
    $vc = get_plugin_data($dir, $markup = true, $translate = true);

    if ($tag == 'vc_row' || $tag == 'vc_row_inner') {
        //$class_string = str_replace('vc_row wpb_row vc_inner vc_row-fluid', '', $class_string);
        return;
    }

    if ($vc['Version'] <= '4.3.1') {
        if ($tag == 'vc_column' || $tag == 'vc_column_inner') {
            $class_string = str_replace('vc_span1', 'span1', $class_string);
            $class_string = str_replace('vc_span2', 'span2', $class_string);
            $class_string = str_replace('vc_span3', 'span3', $class_string);
            $class_string = str_replace('vc_span4', 'span4', $class_string);
            $class_string = str_replace('vc_span5', 'span5', $class_string);
            $class_string = str_replace('vc_span6', 'span6', $class_string);
            $class_string = str_replace('vc_span7', 'span7', $class_string);
            $class_string = str_replace('vc_span8', 'span8', $class_string);
            $class_string = str_replace('vc_span9', 'span9', $class_string);
            $class_string = str_replace('vc_span10', 'span10', $class_string);
            $class_string = str_replace('vc_span11', 'span11', $class_string);
            $class_string = str_replace('vc_span12', 'span12', $class_string);
        }
    } else {
        if ($tag == 'vc_column' || $tag == 'vc_column_inner') {
            $class_string = str_replace('vc_col-sm-1', 'span1', $class_string);
            $class_string = str_replace('vc_col-sm-2', 'span2', $class_string);
            $class_string = str_replace('vc_col-sm-3', 'span3', $class_string);
            $class_string = str_replace('vc_col-sm-4', 'span4', $class_string);
            $class_string = str_replace('vc_col-sm-5', 'span5', $class_string);
            $class_string = str_replace('vc_col-sm-6', 'span6', $class_string);
            $class_string = str_replace('vc_col-sm-7', 'span7', $class_string);
            $class_string = str_replace('vc_col-sm-8', 'span8', $class_string);
            $class_string = str_replace('vc_col-sm-9', 'span9', $class_string);
            $class_string = str_replace('vc_col-sm-10', 'span10', $class_string);
            $class_string = str_replace('vc_col-sm-11', 'span11', $class_string);
            $class_string = str_replace('vc_col-sm-12', 'span12', $class_string);
        }
    }
    return $class_string;
}

// Filter to Replace default css class for vc_row shortcode and vc_column
add_filter('vc_shortcodes_css_class', 'sh_custom_css_classes_for_vc_row_and_vc_column', 10, 2);

function vc_theme_vc_row($atts, $content = null) {

    extract(shortcode_atts(array(
        'el_class' => '',
        'bg_image' => '',
        'bg_color' => '',
        'bg_image_repeat' => '',
        'font_color' => '',
        'padding' => '',
        'margin_bottom' => '',
        'css' => '',
        'full_width' => '',
        'container' => 'true',
        'title' => '',
        'sub_title' => '',
        'title_bg' => '',
        'heading_style' => '',
        'parallax' => '',
        'parallax_type' => '',
        'parallax_bg' => '',
        'bottom_space' => '55'
                    ), $atts));

    $atts['base'] = '';
    wp_enqueue_style('js_composer_front');
    wp_enqueue_script('wpb_composer_front_js');
    wp_enqueue_style('js_composer_custom_css');
    $vc_row = new WPBakeryShortCode_VC_Row($atts);
	//printr($full_width);
    $el_class = $vc_row->getExtraClass($el_class);
    $output = '';
    $css_class = $el_class;
    $row_title = ($title) ? $title : '';
    $row_sub_title = ($sub_title) ? $sub_title : '';
    $row_title_bg = ($title_bg) ? $title_bg : '';
    $heading = ($heading_style) ? $heading_style : '';
	if ($css)
		$css_class .= vc_shortcode_custom_css_class($css, ' ') . ' ';
	$output = '';
    $style = $vc_row->buildStyle($bg_image, $bg_color, $bg_image_repeat, $font_color, $padding, $margin_bottom);

	$full_width_defaults = ($full_width && $full_width=='stretch_row')? 'data-vc-full-widt = true" data-vc-full-width-init = "true"':'';

	$full_width_defaults .= ($full_width && $full_width!='stretch_row')? 'data-vc-stretch-content="true"':'';

	$full_width_style ="";

	$full_width_style .= ($full_width && $full_width=='stretch_row')? 'style="position: relative; left:-74.45px; box-sizing: border-box; width: 1349px; padding-left: 540.45px; padding-right: 143.55px;"':'';

	$full_width_style .= ($full_width && $full_width!='stretch_row')? 'style="position: relative; left: -74.45px; box-sizing: border-box; width: 1349px;"':'';

	$full_width_class = ($full_width && $full_width=='stretch_row_content_no_spaces')? ' vc_row-no-padding ':'';

	$css_class  .=  $full_width_class;
	//printr($el_class);

    if ($container == 'true'):
        $output .= '<section ' . $style . '>';
        if ($parallax == 'true'):
            if ($parallax_bg):
                $img = wp_get_attachment_image_src($parallax_bg, 'full');
            else:
                $img = array('0' => '');
            endif;
            if ($parallax_type == 'ptrn'): $ptrn = 'pattern';
                $st = 'no-repeat 0 0; background-attachment:fixed';
            else: $ptrn = '';
                $st = '';
            endif;
            $output.= '<div style="background:url(' . $img[0] . ') ' . $st . ';" class="fixed-img ' . $ptrn . '"></div>';
        endif;
        $output .= '<div class="container"><div class="row ' . $css_class . '">';
        if ($row_title):
            $ext = explode(' ', $row_title, 2);
            if ($heading == 'fancy-title'):
                $output .= '<div class="span12"><div class="fancy-title">
								<span>' . $row_sub_title . '</span>
								<h2><strong>' . sh_set($ext, '0') . '</strong> ' . sh_set($ext, '1') . '</h2>
								<i>' . ucwords($row_title_bg) . '</i>
							</div></div>';
            else:
                $output .= '<div class="span12"><div class="col-title">
								<h2>' . $row_title . '</h2>
							</div></div>';
            endif;
        endif;
        $output .= wpb_js_remove_wpautop($content) . '</div><div class="space"  style="height:' . $bottom_space . 'px;"></div></div></section>';
        return $output;
    else:
        $output .= '<section ' . $style . '>';
        if ($parallax == 'true'):
            if ($parallax_bg):
                $img = wp_get_attachment_image_src($parallax_bg, 'full');
            else:
                $img = array('0' => '');
            endif;
            if ($parallax_type == 'ptrn'): $ptrn = 'pattern';
                $st = 'no-repeat 0 0; background-attachment:fixed';
            else: $ptrn = '';
                $st = '';
            endif;
            $output.= '<div style="background:url(' . $img[0] . ') ' . $st . ';" class="fixed-img ' . $ptrn . '"></div>';
        endif;

        $output .= '<div class="row-fluid ' . $css_class . '">' . wpb_js_remove_wpautop($content) . '</div>
		<div class="space"  style="height:' . $bottom_space . 'px;"></div></section>';
        return $output;
        $output .= '<div class="row-fluid ' . $css_class . '">';
        if ($row_title):
            $ext = explode(' ', $row_title, 2);
            if ($heading == 'fancy-title'):
                $output .= '<div class="span12"><div class="fancy-title">
								<span>' . $row_sub_title . '</span>
								<h2><strong>' . sh_set($ext, '0') . '</strong> ' . sh_set($ext, '1') . '</h2>
								<i>' . ucwords($row_title_bg) . '</i>
							</div></div>';
            else:
                $output .= '<div class="span12"><div class="col-title">
								<h2>' . $row_title . '</h2>
							</div></div>';
            endif;
        endif;
        $output .= wpb_js_remove_wpautop($content) . '</div></section>';
        return $output;
    endif;
}

function vc_theme_vc_column($atts, $content = null) {

    extract(shortcode_atts(array('width' => '1/1', 'el_class' => ''), $atts));

    $width = wpb_translateColumnWidthToSpan($width);
    $dir = ABSPATH . 'wp-content/plugins/js_composer/js_composer.php';
    $vc = get_plugin_data($dir, $markup = true, $translate = true);
    
    if ($vc['Version'] <= '4.3.1') {
        $width = str_replace('vc_col-sm-', 'span', $width);
    } else {
       
        $width = str_replace('vc_col-sm-', 'span', $width);
    }

    $el_class = ($el_class) ? ' ' . $el_class : '';
    return '<div class="' . $width . ' ' . $el_class . '">' . do_shortcode($content) . '</div>';
}

$param = array(
    "type" => "dropdown",
    "holder" => "div",
    "class" => "",
    "heading" => __("Container", 'wp_dictate'),
    "param_name" => "container",
    "value" => array('True' => 'true', 'False' => 'false'),
    "description" => __("Choose whether you want to add a container before row or not.", 'wp_dictate')
);

$bottom_space = array(
    "type" => "textfield",
    "holder" => "div",
    "class" => "",
    "heading" => __("Bottom Space", 'wp_dictate'),
    "param_name" => "bottom_space",
    "description" => __("Enter the number of pixcel to add space from bottom of this column.", 'wp_dictate')
);
$title = array(
    "type" => "textfield",
    "holder" => "div",
    "class" => "",
    "heading" => __("Title:", 'wp_dictate'),
    "param_name" => "title",
    "description" => __("Enter Your Title.", 'wp_dictate')
);
$sub_title = array(
    "type" => "textfield",
    "holder" => "div",
    "class" => "",
    "heading" => __("Sub Title:", 'wp_dictate'),
    "param_name" => "sub_title",
    "description" => __("Enter Your Sub Title.", 'wp_dictate')
);
$title_bg = array(
    "type" => "textfield",
    "holder" => "div",
    "class" => "",
    "heading" => __("Backgroun Text:", 'wp_dictate'),
    "param_name" => "title_bg",
    "description" => __("Enter Your Sub Title background text.", 'wp_dictate')
);
$heading_style = array(
    "type" => "dropdown",
    "holder" => "div",
    "class" => "",
    "heading" => __("Heading:", 'wp_dictate'),
    "param_name" => "heading_style",
    "value" => array(__('Fancy', 'wp_dictate') => 'fancy-title', __('Normal', 'wp_dictate') => 'col-title'),
    "description" => __("Select Heading Style.", 'wp_dictate')
);
$parallax = array(
    "type" => "dropdown",
    "holder" => "div",
    "class" => "",
    "heading" => __("Parallax:", 'wp_dictate'),
    "param_name" => "parallax",
    "value" => array('False' => 'false', 'True' => 'true'),
    "description" => __("Make this section as parallax.", 'wp_dictate')
);
$parallax_type = array(
    "type" => "dropdown",
    "holder" => "div",
    "class" => "",
    "heading" => __("Parallax Type:", 'wp_dictate'),
    "param_name" => "parallax_type",
    "value" => array(__('Image', 'wp_dictate') => 'img', __('Pattren', 'wp_dictate') => 'ptrn'),
    "description" => __("Select type of parallax.", 'wp_dictate')
);
$parallax_img = array(
    "type" => "attach_image",
    "holder" => "div",
    "class" => "",
    "heading" => __("Parallax Background:", 'wp_dictate'),
    "param_name" => "parallax_bg",
    "description" => __("Make this section as parallax.", 'wp_dictate')
);
vc_add_param('vc_row', $param);
vc_add_param('vc_row', $bottom_space);
vc_add_param('vc_row', $title);
vc_add_param('vc_row', $sub_title);
vc_add_param('vc_row', $title_bg);
vc_add_param('vc_row', $heading_style);
vc_add_param('vc_row', $parallax);
vc_add_param('vc_row', $parallax_type);
vc_add_param('vc_row', $parallax_img);
