<?php
class SH_Options_google_map extends SH_Options{	
	/**
	 * Field Constructor.
	 *
	 * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
	 *
	 * @since SH_Options 1.0
	*/
	function __construct($field = array(), $value ='', $parent){
		parent::__construct($parent->sections, $parent->args, $parent->extra_tabs);
		$this->field = $field;
		$this->value = $value;
		$this->atts = $this->extract_atts( sh_set( $field, 'attributes' ) );
		//$this->render();
		
	}//function
	
	
	
	/**
	 * Field Render Function.
	 *
	 * Takes the vars and outputs the HTML for the field in the settings
	 *
	 * @since SH_Options 1.0
	*/
	function render(){
		
		$class = (isset($this->field['class']))?$this->field['class']:'regular-text';
		
		$name = isset( $this->field['name'] ) ? $this->field['name'] : $this->args['opt_name'].'['.$this->field['id'].']';
		echo '<input type="text" id="searchTextField" name="'.$name.'" '.$this->atts.'value="'.esc_attr(stripslashes($this->value)).'" class="'.$class.' text-input" />';
		echo (isset($this->field['desc']) && !empty($this->field['desc']))?' <span class="description">'.$this->field['desc'].'</span>':'';
		
		echo '<div id="map_canvas" style="width:100%; height: 200px;" class="clear"></div>';
	
	}//function
	
	
	function enqueue()
	{
		wp_enqueue_script('google-map-libs', "http://maps.googleapis.com/maps/api/js?sensor=false&libraries=places", array('jquery') );
		wp_enqueue_script(
			'nhp-opts-field-google-map-js', 
			SH_FRW_URL.'theme_options/fields/google_map/field_google_map.js', 
			time(),
			true
		);
	}
	
}//class
?>