<?php
if(!class_exists('SH_Options')){
	get_template_part( 'framework/theme_options/options' );
}
function sh_setup_framework_options()
{
	$args = array();
	//Set it to dev mode to view the class settings/info in the form - default is false
	$args['dev_mode'] = true;
	//google api key MUST BE DEFINED IF YOU WANT TO USE GOOGLE WEBFONTS
	//$args['google_api_key'] = '***';
	//Remove the default stylesheet? make sure you enqueue another one all the page will look whack!
	//$args['stylesheet_override'] = true;
	//Add HTML before the form
	$args['intro_text'] = __('<p>This is the HTML which can be displayed before the form, it isnt required, but more info is always better. Anything goes in terms of markup here, any HTML.</p>', 'wp_dictate');
	//Setup custom links in the footer for share icons
	$args['share_icons']['twitter'] = array(
											'link' => 'http://twitter.com/lee__mason',
											'title' => 'Folow me on Twitter', 
											'img' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_322_twitter.png'
											);
	$args['share_icons']['linked_in'] = array(
											'link' => 'http://uk.linkedin.com/pub/lee-mason/38/618/bab',
											'title' => 'Find me on LinkedIn', 
											'img' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_337_linked_in.png'
											);
	$args['opt_name'] = 'wp_dictate';
	$args['menu_title'] = __('Theme Options', 'wp_dictate');
	//Custom Page 4Title for options page - default is "Options"
	$args['page_title'] = __('Dictate Theme Options', 'wp_dictate' );
	//Custom page slug for options page (wp-admin/themes.php?page=***) - default is "nhp_theme_options"
	$args['page_slug'] = 'sh_theme_options';
	$args['page_type'] = 'submenu';
	$args['page_parent'] = 'themes.php';
	//custom page location - default 100 - must be unique or will override other items
	$args['page_position'] = 27;
	//Custom page icon class (used to override the page icon next to heading)
	$args['page_icon'] = 'icon-themes';
			
	//Set ANY custom page help tabs - displayed using the new help tab API, show in order of definition		
	$args['help_tabs'][] = array(
								'id' => 'sh-opts-1',
								'title' => __('Theme Information 1', 'wp_dictate'),
								'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'wp_dictate')
								);
	$args['help_tabs'][] = array(
								'id' => 'nhp-opts-2',
								'title' => __('Theme Information 2', 'wp_dictate'),
								'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'wp_dictate')
								);
	//Set the Help Sidebar for the options page - no sidebar by default										
	$args['help_sidebar'] = __('<p>This is the sidebar content, HTML is allowed.</p>', 'wp_dictate');
	if( count($_POST) ) {
		if( $opt_name = sh_set( $_POST, $args['opt_name'] ) ) update_option( $args['opt_name'], $opt_name );
	}
	$sections = array();
	$sections[] = array(
					'title' => __('General Settings', 'wp_dictate'),
					'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
					'id' => 'general_settings',
					
					'children' => array(
						array(
							'title' => __('General Settings', 'wp_dictate'),
							'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
							'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
							'id' => 'theme_general_settings',
							'fields' => array(
							
									array(
										'id' => 'theme_general_color_scheme', //must be unique
										'type' => 'color', //builtin fields include:
										'title' => __('Theme Color Scheme', 'wp_dictate'),
										'desc' => __('If you choose this option please select "No Color" from Predefined Color Schemes Drop Down Below.', 'wp_dictate'),
										'attributes' => array('style' => 'width:40%'),
										'std' => '#49A3DF'
									),
									array(
										'type' => 'select', //builtin fields include:
										'id' => 'theme_color_scheme',
										'title' => __('Predefined Color Schemes', 'wp_dictate'),
										'options' => array(
											'' => 'No Color', 
											'blue' => 'Blue', 
											'chocolate' => 'Chocolate',
											'darkbrown' => 'Dark Brown',
											'darkgray' => 'Dark Gray',
											'darkorange' => 'Dark Orange',
											'indianred' => 'Indian red', 
											'lagoon' => 'Lagoon',
											'lagoon2' => 'Lagoon 2',
											'lagoon3' => 'Lagoon 3',
											'orange' => 'Orange',
											'purple' => 'Purple',
											'red' => 'Red',
											'red-fam' => 'Red Fam',
											'slate-blue' => 'Slate Blue',
											'wooden' => 'Wooden'
										),
										'desc' => __('Choose One of Our Predefined Color Schemes', 'wp_dictate'),
										'attributes' => array('style' => 'width:40%'),
										'std' => '',
									),
									array(
										'id' => 'twitter_api_key', //must be unique
										'type' => 'text', //builtin fields include:
										'title' => __('Twitter API key', 'wp_dictate'),
										'desc' => __('Enter the Twitter API key', 'wp_dictate'),
										//'attributes' => array('style' => 'width:40%'),
									),
									array(
										'id' => 'twitter_secret_key', //must be unique
										'type' => 'text', //builtin fields include:
										'title' => __('Twitter Secret key', 'wp_dictate'),
										'desc' => __('Enter the Twitter Secret key', 'wp_dictate'),
										//'attributes' => array('style' => 'width:40%'),
									),
									array(
										'id' => 'twitter_token', //must be unique
										'type' => 'text', //builtin fields include:
										'title' => __('Twitter Token', 'wp_dictate'),
										'desc' => __('Enter the Twitter Token', 'wp_dictate'),
										//'attributes' => array('style' => 'width:40%'),
									),
									array(
										'id' => 'twitter_token_secret', //must be unique
										'type' => 'text', //builtin fields include:
										'title' => __('Twitter Secret Token', 'wp_dictate'),
										'desc' => __('Enter the Twitter Secret Token', 'wp_dictate'),
										//'attributes' => array('style' => 'width:40%'),
									),
									array(
										'id' => 'sh_rtl', //must be unique
										'type' => 'button_set', //builtin fields include:
										'title' => __('RTL(Right to Left)', 'wp_dictate'),
										'desc' => __('Turn RTL On or Off', 'wp_dictate'),
										'attributes' => array('style' => 'width:40%'),
									),
									array(
										'id' => 'custom_css', //must be unique
										'type' => 'textarea', //builtin fields include:
										'title' => __('Custom Style', 'wp_dictate'),
										'desc' => __('Please Input custom css Enclosed with Style Tag.', 'wp_dictate'),
									),	
								),
								
							),
						array(
							'title' => __('Choose Header Style', 'wp_dictate'),
							'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
							'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
							'id' => 'sub_general_settings',
							'fields' => array(
									array(
										'type'=>'image_boxes',
										'id' => 'custom_header',
										'title' => '',
										'attributes' => array('style' => 'width:40%'),
										'options'=> array(
													'dafault'=>array('label'=>'<ul><li>Left Side Logo</li><li>Right Side Menu</li></ul>', 'img'=>'/img/header-sticky-menu.jpg'), 
													'toggle'=>array('label'=>'<ul><li>Header Toggle</li><li>Right Side Menu</li></ul>', 'img'=>'/img/header-toggle.jpg'), 
													'middle_logo'=>array('label'=>'<ul><li>Middle Logo</li><li>Down Menu</li></ul>', 'img'=>'/img/header-with-middle-logo.jpg'), 
													'social_icons'=>array('label'=>'<ul><li>Left Side Logo</li><li>Right Side Menu with Social Icons</li></ul>', 'img'=>'/img/header-with-social-icons.jpg'),),
										'desc' => __('Sort the modules through drag & drop.', 'wp_dictate'),
										'std' => '',
										'settings' => array( 'hide_title'=>true )
									),
									array(
										'id' => '', //must be unique
										'type' => 'heading', //builtin fields include:
										'heading'=>__('Sticky Option', 'wp_dictate')
									),
									array(
										'id' => 'sh_custom_stickey_menu', //must be unique
										'type' => 'button_set', //builtin fields include:
										'title' => __('Stickey Header', 'wp_dictate'),
										'desc' => __('Turn This Option On to Make any "Non Sticky Header" , Stikcey.', 'wp_dictate'),
									),
									array(
										'id' => '', //must be unique
										'type' => 'heading', //builtin fields include:
										'heading'=>__('Logo Settings', 'wp_dictate')
									),
									array(
										'id' => 'site_favicon', //must be unique
										'type' => 'upload', //builtin fields include:
										'title' => __('Upload your Favicon From Here', 'wp_dictate'),
										'title' => __('Favicon', 'wp_dictate'),
										'desc' => __('The Favicon size shold be 16x16 px.', 'wp_dictate'),
									),
									array(
										'id' => 'logo_text_status', //must be unique
										'type' => 'button_set', //builtin fields include:
										'title' => __('Use Logo Text', 'wp_dictate'),
										'desc' => __('Use Text Instead of Logo Click the Button to On of Off the Text in the header instead of Logo', 'wp_dictate'),
									),
									
									array(
										'id' => 'logo_text', //must be unique
										'type' => 'text', //builtin fields include:
										'title' => __('Logo Text', 'wp_dictate'),
										'desc' => __('Enter the Text here, you want to as Logo', 'wp_dictate'),
										'attributes' => array('class'=>'input-field')
									),
									
									array(
										'id' => 'logo_text_color', //must be unique
										'type' => 'color', //builtin fields include:
										'title' => __('Logo Color', 'wp_dictate'),
										'desc' => __('Pick color for Logo text', 'wp_dictate'),
									),
									
									array(
										'id' => 'logo_font', //must be unique
										'type' => 'multi_fields', //builtin fields include:
										'title' => __('Logo Font Settings', 'wp_dictate'),
										'desc' => __('Set Logo Font Settings', 'wp_dictate'),
										'fields' => array(
											array(
												'id' => 'logo_text_font_size', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Size', 'wp_dictate'),
												'desc' => '',
												'options' => array_combine(range(2, 40, 2), range(2, 40, 2))
											),
											array(
												'id' => 'logo_text_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family' )
											),
											array(
												'id' => 'logo_text_font_style', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Style', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'style' )
											),
										)
									),
									array(
										'id' => 'site_salogan', //must be unique
										'type' => 'text', //builtin fields include:
										'title' => __('Site Slogan', 'wp_dictate'),
										'desc' => __('Enter the Sub-heading or Tag Line to show below Logo Upload your site Logo here', 'wp_dictate'),
									),
									
									array(
										'id' => 'slogan_settings', //must be unique
										'type' => 'multi_fields', //builtin fields include:
										'title' => __('Slogan Settings', 'wp_dictate'),
										'desc' => __(' Choose the salogan settings here', 'wp_dictate'),
										'fields' => array(
											array(
												'id' => 'salogan_font_size', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Size', 'wp_dictate'),
												'desc' => '',
												'options' => array_combine(range(2, 40, 2), range(2, 40, 2))
											),
											array(
												'id' => 'salogan_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family' )
											),
											array(
												'id' => 'salogan_font_style', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Style', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'style' )
											),
										)
									),
									
									array(
										'id' => 'logo_image', //must be unique
										'type' => 'upload', //builtin fields include:
										'title' => __('Logo Image', 'wp_dictate'),
										'desc' => __('Upload Logo here but be sure that the Logo Text button should be Off', 'wp_dictate'),
									),
									array(
										'id' => 'logo_margin_top', //must be unique
										'type' => 'text', //builtin fields include:
										'title' => __('Logo Margin Top', 'wp_dictate'),
										'desc' => __('Set Margine from the Top.', 'wp_dictate'),
									),
									array(
										'id' => 'logo_size', //must be unique
										'type' => 'multi_fields', //builtin fields include:
										'title' => __('Logo Size', 'wp_dictate'),
										'desc' => __('Select the Height and Width of the Logo image to show in the header', 'wp_dictate'),
										'fields' => array(
											array(
												'id' => 'logo_width', //must be unique
												'type' => 'text', //builtin fields include:
												'title' => __('Logo Width', 'wp_dictate'),
												'desc' =>__( 'It is recommended that your logo size should be undex 220px width', 'wp_dictate'),
												'options' => array_combine(range(6, 100, 2), range(6, 100, 2))
											),
											array(
												'id' => 'logo_height', //must be unique
												'type' => 'text', //builtin fields include:
												'title' => __('Logo Height', 'wp_dictate'),
												'desc' => '',
												'options' => array_combine(range(6, 36, 2), range(6, 36, 2))
											),
										)
									),
								),
								
							),
							
							array(
								'title' => __('Footer Settings', 'wp_dictate'),
								'desc' => __('<p class="description">This section contains footer options about the theme.</p>', 'wp_dictate'),
								'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
								'id' => 'sub_footer_settings',
								
								'fields' => array(
									array(
										'id' => 'show_footer', //must be unique
										'type' => 'button_set', //builtin fields include:
														 
										'title' => __('Show Footer', 'wp_dictate'),
										'desc' => __('Enable / Disable footer area', 'wp_dictate'),
										'options' => array('1'=>'Enable', '0' => 'Disable')
									),
									array(
										'id' => 'footer_image', //must be unique
										'type' => 'upload', //builtin fields include:
										'title' => __('Footer Image', 'wp_dictate'),
										'desc' => __('Upload Footer Image here.', 'wp_dictate'),
									),
									array(
										'id' => 'copyright_text', //must be unique
										'type' => 'textarea', //builtin fields include:
														 
										'title' => __('Copyright Text', 'wp_dictate'),
										'desc' => __('Enter the Copyrights Text here to show in the Footer You can use HTML tags in this area as well', 'wp_dictate'),
									),
									array(
										'id' => 'footer_analytics', //must be unique
										'type' => 'textarea', //builtin fields include:
														 
										'title' => __('Footer Analytics / Scripts', 'wp_dictate'),
										'desc' => __('In this area you can put Google Analytics Code or any other Script that you want to be included in the footer before the Body tag.', 'wp_dictate'),
									),
									
								),
							),
							
							array(
								'title' => __('Contact Page Settings', 'wp_dictate'),
								'desc' => __('<p class="description">This section contains contact options about the theme.</p>', 'wp_dictate'),
								'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
								'id' => 'sub_contact_settings',
								
								'fields' => array(
									array(
										'id' => 'contact_email', //must be unique
										'type' => 'text', //builtin fields include:														 
										'title' => __('Contact Email', 'wp_dictate'),
										'desc' => __('Enter the email address where do you want to recieve emails sent through contact form', 'wp_dictate'),
										'std'=> get_bloginfo( 'admin_email' )
									),
									array(
										'id' => 'contact_email2', //must be unique
										'type' => 'text', //builtin fields include:														 
										'title' => __('Contact Email 2', 'wp_dictate'),
										'desc' => __('Enter the email address where do you want to recieve emails sent through contact form', 'wp_dictate'),
										//'std'=> get_bloginfo( 'admin_email' )
									),
									array(
										'id' => 'success_message', //must be unique
										'type' => 'textarea', //builtin fields include:
														 
										'title' => __('Success Message', 'wp_dictate'),
										'desc' => __('Enter the Success Code to show once the email is sent through contact form', 'wp_dictate'),
									),
									array(
										'id' => 'captcha_status', //must be unique
										'type' => 'button_set', //builtin fields include:
														 
										'title' => __('Captcha Status', 'wp_dictate'),
										'desc' => __('Enable / disable google recaptcha on contact form', 'wp_dictate'),
									),
									
									array(
										'id' => 'captcha_api', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Captcha API Key', 'wp_dictate'),
										'desc' => __('Enter the captcha API key of your Google account.', 'wp_dictate'),
									),
									array(
										'id' => 'captcha_secret_key', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Captcha Secret', 'wp_dictate'),
										'desc' => __('Enter the secret key of your Google account.', 'wp_dictate'),
									),
									
									array(
										'id' => 'google_map_code', //must be unique
										'type' => 'textarea', //builtin fields include:
														 
										'title' => __('Google Map Code', 'wp_dictate'),
										'desc' => __('Enter the Google Map Code of your company or office to be shown on Contact Us page.', 'wp_dictate'),
									),
								),
							),
						)
				);
	
	$sections[] = array(
				'title' => __('Slider Settings', 'wp_dictate'),
				'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
				'icon' => SH_FRW_URL.'theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
				'id' => 'homepage_settings',
				
				'children' => array(
					array(
						'title' => __('Camera Slider Settings', 'wp_dictate'),
						'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
						'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
						'id' => 'sub_camera_slider_settings',
						
						'fields' => array(
										
										
										array(
												'type' => 'select', //builtin fields include:
												'id' => 'cam_easing',
												'title' => __('Easing', 'wp_dictate'),
												'options' => array('linear'=>'linear',
																	'swing'=>'swing',
																	'easeInQuad'=>'easeInQuad',
																	'easeOutQuad'=>'easeOutQuad',
																	'easeInOutQuad'=>'easeInOutQuad',
																	'easeInCubic'=>'easeInCubic',
																	'easeOutCubic'=>'easeOutCubic',
																	'easeInOutCubic'=>'easeInOutCubic',
																	'easeInQuart'=>'easeInQuart',
																	'easeOutQuart'=>'easeOutQuart',
																	'easeInOutQuart'=>'easeInOutQuart',
																	'easeInQuint'=>'easeInQuint',
																	'easeOutQuint'=>'easeOutQuint',
																	'easeInOutQuint'=>'easeInOutQuint',
																	'easeInExpo'=>'easeInExpo',
																	'easeOutExpo'=>'easeOutExpo',
																	'easeInOutExpo'=>'easeInOutExpo',
																	'easeInSine'=>'easeInSine',
																	'easeOutSine'=>'easeOutSine',
																	'easeInOutSine'=>'easeInOutSine',
																	'easeInCirc'=>'easeInCirc',
																	'easeOutCirc'=>'easeOutCirc',
																	'easeInOutCirc'=>'easeInOutCirc',
																	'easeInElastic'=>'easeInElastic',
																	'easeOutElastic'=>'easeOutElastic',
																	'easeInOutElastic'=>'easeInOutElastic',
																	'easeInBack'=>'easeInBack',
																	'easeOutBack'=>'easeOutBack',
																	'easeInOutBack'=>'easeInOutBack',
																	'easeInBounce'=>'easeInBounce',
																	'easeOutBounce'=>'easeOutBounce',
																	'easeInOutBounce'=>'easeInOutBounce',),
												'attributes' => array('style' => 'width:40%'),
												'std' => '',
											),
										
										array(
												'type' => 'text', //builtin fields include:
												'id' => 'cam_height',
												'title' => __('Height', 'wp_dictate'),
												'attributes' => array('style' => 'width:40%'),
												'std' => '50%',
												'desc' => __("here you can type pixels (for instance '300px'), a percentage (relative to the width of the slideshow, for instance '50%') or 'auto'", 'wp_dictate')
											),
										array(
												'type' => 'text', //builtin fields include:
												'id' => 'cam_time',
												'title' => __('Speed', 'wp_dictate'),
												'attributes' => array('style' => 'width:40%'),
												'std' => '6000',
												'desc' => __('milliseconds between the end of the sliding effect and the start of the nex one', 'wp_dictate')
											),
										array(
												'type' => 'button_set', //builtin fields include:
												'id' => 'cam_thumbnails',
												'title' => __('Thumbnail', 'wp_dictate'),
												'options' => array('true'=>'True', 'false'=>'False'),
												'attributes' => array('style' => 'width:40%'),
												'std' => 'false',
											),
										array(
												'type' => 'button_set', //builtin fields include:
												'id' => 'cam_hover',
												'title' => __('Pause on Mouseover', 'wp_dictate'),
												'options' => array('true'=>'True', 'false'=>'False'),
												'attributes' => array('style' => 'width:40%'),
												'std' => 'true',
												'desc' => __('true, false. Puase on state hover. Not available for mobile devices', 'wp_dictate')
											),
										
										
										array(
												'type' => 'button_set', //builtin fields include:
												'id' => 'cam_pauseOnClick',
												'title' => __('Pause on Click', 'wp_dictate'),
												'options' => array('true'=>'True', 'false'=>'False'),
												'attributes' => array('style' => 'width:40%'),
												'std' => 'true',
												'desc' => __('true, false. It stops the slideshow when you click the sliders.', 'wp_dictate')
											),
										
																				
										
										array(
												'type' => 'text', //builtin fields include:
												'id' => 'cam_transPeriod',
												'title' => __('Transition Period', 'wp_dictate'),
												'attributes' => array('style' => 'width:40%'),
												'std' => '1500',
												'desc' => __('lenght of the sliding effect in milliseconds', 'wp_dictate')
											),
								
							),
							
						),
						array(
						'title' => __('Parallax Slider Settings', 'wp_dictate'),
						'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
						'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
						'id' => 'sub_parallax_slider_settings',
						
						'fields' => array(
										array(
												'type' => 'text', //builtin fields include:
												'id' => 'par_speed',
												'title' => __('Speed', 'wp_dictate'),
												'attributes' => array('style' => 'width:40%'),
												'std' => '1000',
											),
										array(
												'type' => 'select', //builtin fields include:
												'id' => 'par_easing',
												'title' => __('Easing', 'wp_dictate'),
												'options' => array('linear'=>'linear',
																	'swing'=>'swing',
																	'easeInQuad'=>'easeInQuad',
																	'easeOutQuad'=>'easeOutQuad',
																	'easeInOutQuad'=>'easeInOutQuad',
																	'easeInCubic'=>'easeInCubic',
																	'easeOutCubic'=>'easeOutCubic',
																	'easeInOutCubic'=>'easeInOutCubic',
																	'easeInQuart'=>'easeInQuart',
																	'easeOutQuart'=>'easeOutQuart',
																	'easeInOutQuart'=>'easeInOutQuart',
																	'easeInQuint'=>'easeInQuint',
																	'easeOutQuint'=>'easeOutQuint',
																	'easeInOutQuint'=>'easeInOutQuint',
																	'easeInExpo'=>'easeInExpo',
																	'easeOutExpo'=>'easeOutExpo',
																	'easeInOutExpo'=>'easeInOutExpo',
																	'easeInSine'=>'easeInSine',
																	'easeOutSine'=>'easeOutSine',
																	'easeInOutSine'=>'easeInOutSine',
																	'easeInCirc'=>'easeInCirc',
																	'easeOutCirc'=>'easeOutCirc',
																	'easeInOutCirc'=>'easeInOutCirc',
																	'easeInElastic'=>'easeInElastic',
																	'easeOutElastic'=>'easeOutElastic',
																	'easeInOutElastic'=>'easeInOutElastic',
																	'easeInBack'=>'easeInBack',
																	'easeOutBack'=>'easeOutBack',
																	'easeInOutBack'=>'easeInOutBack',
																	'easeInBounce'=>'easeInBounce',
																	'easeOutBounce'=>'easeOutBounce',
																	'easeInOutBounce'=>'easeInOutBounce',),
												'attributes' => array('style' => 'width:40%'),
												'std' => 'true',
											),
											array(
												'type' => 'select', //builtin fields include:
												'id' => 'par_easingBg',
												'title' => __('Background Easing', 'wp_dictate'),
												'options' => array('linear'=>'linear',
																	'swing'=>'swing',
																	'easeInQuad'=>'easeInQuad',
																	'easeOutQuad'=>'easeOutQuad',
																	'easeInOutQuad'=>'easeInOutQuad',
																	'easeInCubic'=>'easeInCubic',
																	'easeOutCubic'=>'easeOutCubic',
																	'easeInOutCubic'=>'easeInOutCubic',
																	'easeInQuart'=>'easeInQuart',
																	'easeOutQuart'=>'easeOutQuart',
																	'easeInOutQuart'=>'easeInOutQuart',
																	'easeInQuint'=>'easeInQuint',
																	'easeOutQuint'=>'easeOutQuint',
																	'easeInOutQuint'=>'easeInOutQuint',
																	'easeInExpo'=>'easeInExpo',
																	'easeOutExpo'=>'easeOutExpo',
																	'easeInOutExpo'=>'easeInOutExpo',
																	'easeInSine'=>'easeInSine',
																	'easeOutSine'=>'easeOutSine',
																	'easeInOutSine'=>'easeInOutSine',
																	'easeInCirc'=>'easeInCirc',
																	'easeOutCirc'=>'easeOutCirc',
																	'easeInOutCirc'=>'easeInOutCirc',
																	'easeInElastic'=>'easeInElastic',
																	'easeOutElastic'=>'easeOutElastic',
																	'easeInOutElastic'=>'easeInOutElastic',
																	'easeInBack'=>'easeInBack',
																	'easeOutBack'=>'easeOutBack',
																	'easeInOutBack'=>'easeInOutBack',
																	'easeInBounce'=>'easeInBounce',
																	'easeOutBounce'=>'easeOutBounce',
																	'easeInOutBounce'=>'easeInOutBounce',),
												'attributes' => array('style' => 'width:40%'),
												'std' => 'true',
											),
											
									)
						),
						array(
						'title' => __('SliceBox Slider Settings', 'wp_dictate'),
						'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
						'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
						'id' => 'sub_slicebox_slider_settings',
						
						'fields' => array(
										
										array(
												'type'=>'text',
												'id' => 'slic_speed',
												'title' => __('Speed', 'wp_dictate'),
												'attributes' => array('style' => 'width:40%'),
												'desc' => __('animation speed. this is the speed that takes "1" cuboid to rotate', 'wp_dictate'),
												'std' => '600',
										),
										array(
												'type'=>'select',
												'id' => 'slic_easing',
												'title' => __('Easing', 'wp_dictate'),
												'attributes' => array('style' => 'width:40%'),
												'desc' => __('Transition Easing', 'wp_dictate'),
												'options' =>array('linear'=>'linear',
																	'swing'=>'swing',
																	'easeInQuad'=>'easeInQuad',
																	'easeOutQuad'=>'easeOutQuad',
																	'easeInOutQuad'=>'easeInOutQuad',
																	'easeInCubic'=>'easeInCubic',
																	'easeOutCubic'=>'easeOutCubic',
																	'easeInOutCubic'=>'easeInOutCubic',
																	'easeInQuart'=>'easeInQuart',
																	'easeOutQuart'=>'easeOutQuart',
																	'easeInOutQuart'=>'easeInOutQuart',
																	'easeInQuint'=>'easeInQuint',
																	'easeOutQuint'=>'easeOutQuint',
																	'easeInOutQuint'=>'easeInOutQuint',
																	'easeInExpo'=>'easeInExpo',
																	'easeOutExpo'=>'easeOutExpo',
																	'easeInOutExpo'=>'easeInOutExpo',
																	'easeInSine'=>'easeInSine',
																	'easeOutSine'=>'easeOutSine',
																	'easeInOutSine'=>'easeInOutSine',
																	'easeInCirc'=>'easeInCirc',
																	'easeOutCirc'=>'easeOutCirc',
																	'easeInOutCirc'=>'easeInOutCirc',
																	'easeInElastic'=>'easeInElastic',
																	'easeOutElastic'=>'easeOutElastic',
																	'easeInOutElastic'=>'easeInOutElastic',
																	'easeInBack'=>'easeInBack',
																	'easeOutBack'=>'easeOutBack',
																	'easeInOutBack'=>'easeInOutBack',
																	'easeInBounce'=>'easeInBounce',
																	'easeOutBounce'=>'easeOutBounce',
																	'easeInOutBounce'=>'easeInOutBounce',),
												'std' => 'easing',
										),
										array(
												'type'=>'text',
												'id' => 'slic_interval',
												'title' => __('Interval', 'wp_dictate'),
												'attributes' => array('style' => 'width:40%'),
												'desc' => __('time (ms) between each rotation, if autoplay is true', 'wp_dictate'),
												'std' => '3000',
										),
										
									)
						)
					)
			);
	
	/** Font Settings */
	$sections[] = array(
					'title' => __('Font Options', 'wp_dictate'),
					'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
					'id' => 'font_options',
					
					'children' => array(
						array(
							'title' => __('Heading Fonts', 'wp_dictate'),
							'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
							'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
							'id' => 'sub_heading_fonts',
							'fields' => array(
									array(
										'type'=>'multi_fields',
										'id' => 'h1_typography',
										'title' => __('H1 Typography', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of H1 ', 'wp_dictate'),
										'fields' => array(
											
											array(
												'id' => 'h1_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
											
										)
									),
									
									array(
										'type'=>'multi_fields',
										'id' => 'h2_typography',
										'title' => __('H2 Typography', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of H2', 'wp_dictate'),
										'fields' => array(
											
											array(
												'id' => 'h2_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
											
										)
									),
									
									array(
										'type'=>'multi_fields',
										'id' => 'h3_typography',
										'title' => __('H3 Typography', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of H3', 'wp_dictate'),
										'fields' => array(
											
											array(
												'id' => 'h3_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
											
										)
									),
									
									array(
										'type'=>'multi_fields',
										'id' => 'h4_typography',
										'title' => __('H4 Typography', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of H4', 'wp_dictate'),
										'fields' => array(
											
											array(
												'id' => 'h4_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
											
										)
									),
									
									array(
										'type'=>'multi_fields',
										'id' => 'h5_typography',
										'title' => __('H5 Typography', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of H5', 'wp_dictate'),
										'fields' => array(
										
											array(
												'id' => 'h5_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
											
										)
									),
									
									array(
										'type'=>'multi_fields',
										'id' => 'h6_typography',
										'title' => __('H6 Typography', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of H6', 'wp_dictate'),
										'fields' => array(
										
											array(
												'id' => 'h6_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
											
										)
									),
									
									
									
								),
								
							),
							
							array(
								'title' => __('Body Font', 'wp_dictate'),
								'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
								'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
								'id' => 'sub_body_font',
								
								'fields' => array(
									array(
										'type'=>'multi_fields',
										'id' => 'body_typography',
										'title' => __('Body Font Options', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of Body tag', 'wp_dictate'),
										'fields' => array(
											
											array(
												'id' => 'body_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
											
										)
									),
									array(
										'type'=>'multi_fields',
										'id' => 'grey_area_typography',
										'title' => __('Grey Area Typography', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of Grey Area.', 'wp_dictate'),
										'fields' => array(
											
											array(
												'id' => 'grey_area_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
											
										)
									),
									array(
										'type'=>'multi_fields',
										'id' => 'footer_typography',
										'title' => __('Footer Options', 'wp_dictate'),
										'desc' => __('Change the Typography Settings of Footer area', 'wp_dictate'),
										'fields' => array(
										
											array(
												'id' => 'footer_font_family', //must be unique
												'type' => 'select', //builtin fields include:
												'title' => __('Font Family', 'wp_dictate'),
												'desc' => '',
												'options' => sh_set( sh_google_fonts(), 'family')
											),
										)
									),
									
								),
							),
							
						)
				);
	
	$sections[] = array(
					'title' => __('Donation Settings', 'wp_dictate'),
					'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
					'id' => 'donation_settings',
					'children' => array(
						array(
							'title' => __('Donation Settings', 'wp_dictate'),
							'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
							'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
							'id' => 'sub_donation_settings',
							'fields' => array(
									array(
										'id' => 'header_donation_status', //must be unique
										'type' => 'button_set', //builtin fields include:
										'title' => __('Header Donation Status', 'wp_dictate'),
										'desc' => __('Enable / Disable Header Donation Bar', 'wp_dictate'),
										'options' => array('1'=>'Enable', '0' => 'Disable')
									),
									array(
										'id' => 'paypal_type', //must be unique
										'type' => 'select', //builtin fields include:
														 
										'title' => __('Paypal Type', 'wp_dictate'),
										'desc' => __('Select Which Paypal Version you want to use - Live or Sandbox', 'wp_dictate'),
										'options' => array('live'=>'Live', 'sandbox' => 'Sandbox')
									),
									array(
										'id' => 'paypal_title', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Title', 'wp_dictate'),
										'desc' => __('Enter the title show on header paypal donation section', 'wp_dictate'),
									),
									array(
										'id' => 'paypal_currency', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Currency Symbol', 'wp_dictate'),
										'std' => '$'
									),
									array(
										'id' => 'paypal_raised', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Raised', 'wp_dictate'),
										'std' => '0'
									),
									array(
										'id' => 'paypal_target', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Target', 'wp_dictate'),
										'std' => '25000'
									),
									array(
										'id' => 'paypal_username', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Paypal Username', 'wp_dictate'),
										'desc' => __('Enter the paypal username. To get API username <a href="http://developer.paypal.com">visit</a>', 'wp_dictate'),
										'options' => array('live'=>'Live', 'sandbox' => 'Sandbox')
									),
									array(
										'id' => 'paypal_api_username', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Paypal API Username', 'wp_dictate'),
										'desc' => __('Enter the paypal API username', 'wp_dictate'),
									),
									
									array(
										'id' => 'paypal_api_password', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Paypal API Password', 'wp_dictate'),
										'desc' => __('Enter the paypal api password', 'wp_dictate'),
									),
									array(
										'id' => 'paypal_api_signature', //must be unique
										'type' => 'text', //builtin fields include:
														 
										'title' => __('Paypal API Signature', 'wp_dictate'),
										'desc' => __('Enter the paypal api signature', 'wp_dictate'),
									),
									array(
										'id' => 'paypal_note', //must be unique
										'type' => 'textarea', //builtin fields include:
														 
										'title' => __('Note', 'wp_dictate'),
										'desc' => __('Enter the note to show on donation section in header', 'wp_dictate'),
									),
									
								),
							),
						)
				);
				
//'''''''''''''''' 
$sections[] = array(
					'title' => __('Service Areas', 'wp_dictate'),
					'desc' => __('<p class="description">This section contains general options about the theme.</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_023_cogwheels.png',
					'id' => 'service_area_section',
					'fields' => array(
						array(
                                    'id' => 'service_areas', //must be unique
                                    'type' => 'multi_group', //builtin fields include:
                                    'title' => __('Add Service Areas', 'wp_dictate'),
                                    'attributes' => array('style' => 'width:40%'),
                                    'std' => '',
                                    'field'=>array(
                                            array(
                                                'id' => 'service_name', //must be unique
                                                'type' => 'text', //builtin fields include:
                                                'title' => __('Service Name', 'wp_dictate'),
                                                'desc' => __('Enter the name of Service Area', 'wp_dictate'),
                                                'attributes' => array('style' => 'width:40%'),
                                                'std' => ''
                                            ),
											 array(
                                                'id' => 'service_link', //must be unique
                                                'type' => 'text', //builtin fields include:
                                                'title' => __('Service Link', 'wp_dictate'),
                                                'desc' => __('Enter the external link for this Service Area', 'wp_dictate'),
                                                'attributes' => array('style' => 'width:40%'),
                                                'std' => ''
                                            ),
										 )
							),
						)
				);
	$sections[] = array(
					'title' => __('Sidebar Creator', 'wp_dictate'),
					'desc' => __('<p class="description">You can create as many sidebars as you required.</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_062_attach.png',
					'id' => 'sidebar_creator',
					'fields' => array(
							array(
								'id' => 'dynamic_sidebars', //must be unique
								'type' => 'multi_text', //builtin fields include:
												 
								'title' => __('Sidebar Name', 'wp_dictate'),
								'desc' => __('Enter the sidebar name', 'wp_dictate'),
							),
							
					)
				);
	
	/** Page settings */
	$sections[] = array(
					'title' => __('Page Settings', 'wp_dictate'),
					'desc' => __('<p class="description">Set the page settings</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_062_attach.png',
					'id' => 'page_settings',
					'fields' => array(
							array(
								'id' => '404_page_heading',
								'type' => 'text',
								'title' => __('404 Page Heading', 'wp_dictate'), 
								'std' => '404'
							),
							array(
								'id' => '404_page_sub_heading',
								'type' => 'text',
								'title' => __('404 Page Sub Heading', 'wp_dictate'), 
								'std' => ''
							),
							array(
								'id' => '404_page_content',
								'type' => 'textarea',
								'title' => __('404 Page Content', 'wp_dictate'), 
								'std' => ''
							),
							array(
								'id' => '404_page_main_title_grey',
								'type' => 'textarea',
								'title' => __('404 Page Grey Main Title', 'wp_dictate'), 
								'std' => ''
							),
							array(
								'id' => '404_page_main_title_colored',
								'type' => 'textarea',
								'title' => __('404 Page Colored Main Title', 'wp_dictate'), 
								'std' => ''
							),
							array(
								'id' => '404_page_sub_title',
								'type' => 'textarea',
								'title' => __('404 Page Sub Title', 'wp_dictate'), 
								'std' => ''
							),
							array(
								'type' => 'select', //builtin fields include:
								'id' => 'page_sidebar_position',
								'title' => __('Page Sidebar Position', 'wp_dictate'),
								'options' => array( 'right' => 'Right', 'left' => 'Left' ),
								'desc' => __('Choose the Page Sidebar Position', 'wp_dictate'),
								'attributes' => array('style' => 'width:40%'),
								'std' => '',
							),
							array(
								'id' => 'page_comments_status', //must be unique
								'type' => 'button_set', //builtin fields include:
								'title' => __('Page Comments Status', 'wp_dictate'),
								'desc' => __('Set Page Comments Status', 'wp_dictate'),
							),
					)
				);
	/** Blog Settings */
	$sections[] = array(
					'title' => __('Blog Settings', 'wp_dictate'),
					'desc' => __('<p class="description">Set the Blog settings</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_062_attach.png',
					'id' => 'blog_settings',
					'fields' => array(
							array(
								'id' => 'blog_heading', //must be unique
								'type' => 'text', //builtin fields include:
								'title' => __('Blog Heading Text', 'wp_dictate'),
								'desc' => __('Change the style of blog heading', 'wp_dictate'),
								'attributes' => array('class'=>'input-field')
							),
							array(
								'id' => 'blog_heading_font', //must be unique
								'type' => 'multi_fields', //builtin fields include:
								'title' => __('Blog Heading Font Settings', 'wp_dictate'),
								'desc' => __('Change Blog Heading Font Settings', 'wp_dictate'),
								'fields' => array(
									array(
										'id' => 'blog_heading_font_size', //must be unique
										'type' => 'select', //builtin fields include:
										'title' => __('Font Size', 'wp_dictate'),
										'desc' => '',
										'options' => array_combine(range(6, 34, 2), range(6, 34, 2))
									),
									array(
										'id' => 'blog_heading_font_family', //must be unique
										'type' => 'select', //builtin fields include:
										'title' => __('Font Family', 'wp_dictate'),
										'desc' => '',
										'options' => sh_set( sh_google_fonts(), 'family' )
									),
									array(
										'id' => 'blog_heading_font_style', //must be unique
										'type' => 'select', //builtin fields include:
										'title' => __('Font Style', 'wp_dictate'),
										'desc' => '',
										'options' => sh_set( sh_google_fonts(), 'style' )
									),
									array(
										'id' => 'blog_heading_color', //must be unique
										'type' => 'color', //builtin fields include:
										'title' => __('Logo Color', 'wp_dictate'),
										'desc' => __('Pick color for Logo text', 'wp_dictate'),
									),
								)
							),
							array(
								'id' => 'blog_sub_heading_text', //must be unique
								'type' => 'text', //builtin fields include:
								'title' => __('Blog Sub Heading Text', 'wp_dictate'),
								'desc' => __('Change Blog Sub Heading Text', 'wp_dictate'),
							),
							array(
								'id' => 'blog_sub_heading_font', //must be unique
								'type' => 'multi_fields', //builtin fields include:
								'title' => __('Blog Sub Heading Font Settings', 'wp_dictate'),
								'desc' => __('Change Blog Sub Heading Font Settings', 'wp_dictate'),
								'fields' => array(
									array(
										'id' => 'blog_sub_heading_font_size', //must be unique
										'type' => 'select', //builtin fields include:
										'title' => __('Font Size', 'wp_dictate'),
										'desc' => '',
										'options' => array_combine(range(6, 34, 2), range(6, 34, 2))
									),
									array(
										'id' => 'blog_sub_heading_font_family', //must be unique
										'type' => 'select', //builtin fields include:
										'title' => __('Font Family', 'wp_dictate'),
										'desc' => '',
										'options' => sh_set( sh_google_fonts(), 'family' )
									),
									array(
										'id' => 'blog_sub_heading_font_style', //must be unique
										'type' => 'select', //builtin fields include:
										'title' => __('Font Style', 'wp_dictate'),
										'desc' => '',
										'options' => sh_set( sh_google_fonts(), 'style' )
									),
									array(
										'id' => 'blog_sub_heading_color', //must be unique
										'type' => 'color', //builtin fields include:
										'title' => __('Logo Color', 'wp_dictate'),
										'desc' => __('Pick color for Logo text', 'wp_dictate'),
									),
								)
							),
							array(
								'id' => '', //must be unique
								'type' => 'heading', //builtin fields include:
								'heading'=>__('Choose Blog View Style', 'wp_dictate')
							),
							array(
								'type'=>'image_boxes',
								'id' => 'blog_view_style',
								'title' => '',
								'attributes' => array('style' => 'width:40%'),
								'options'=> array(
											'list'=>array('label'=>'<ul><li>List View</li></ul>', 'img'=>'/img/list-view.jpg'), 
											'grid'=>array('label'=>'<ul><li>Grid View</li></ul>', 'img'=>'/img/grid-view.jpg'),),
								'desc' => __('Sort the modules through drag & drop.', 'wp_dictate'),
								'std' => '',
								'settings' => array( 'hide_title'=>true )
							),
							array(
								'id' => '', //must be unique
								'type' => 'heading', //builtin fields include:
								'heading'=>__('Choose Blog Grid View Styles', 'wp_dictate')
							),
							array(
								'type'=>'image_boxes',
								'id' => 'blog_grid_view_style',
								'title' => '',
								'attributes' => array('style' => 'width:40%'),
								'options'=> array(
											'two_column_blog'=>array('label'=>'<ul><li>Two column with sidebar</li></ul>', 'img'=>'/img/header-simple.jpg'), 
											'three_column_blog'=>array('label'=>'<ul><li>Three column without sidebar</li></ul>', 'img'=>'/img/header-sticky-menu.jpg'),),
								'desc' => __('Sort the modules through drag & drop.', 'wp_dictate'),
								'std' => '',
								'settings' => array( 'hide_title'=>true )
							),
					)
				);
	/** Layout Settings */
	$sections[] = array(
					'title' => __('Layout Settings', 'wp_dictate'),
					'desc' => __('<p class="description">Set the Layout settings</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_062_attach.png',
					'id' => 'layout_settings',
					'fields' => array(
							array(
								'id' => 'boxed_layout_status', //must be unique
								'type' => 'button_set', //builtin fields include:
								'title' => __('Use Boxed Layout', 'wp_dictate'),
								'desc' => __('Use Boxed Layout', 'wp_dictate'),
							),
							array(
								'id' => 'layout_pattern', //must be unique
								'type' => 'multi_fields', //builtin fields include:
								'title' => __('Select Pattern Or Image', 'wp_dictate'),
								'desc' => __('Select Pattern Or Image', 'wp_dictate'),
								'fields' => array(
									array(
										'type' => 'select', //builtin fields include:
										'id' => 'layout_sidebar_patron',
										'title' => __('Responsive Options', 'wp_dictate'),
										'options' => array( 'bg-body1' => 'Background 1', 'bg-body2' => 'Background 2', 'bg-body3' => 'Background 3', 'bg-body4' => 'Background 4', 'bg-body5' => 'Background 5', ),
										'attributes' => array('style' => 'width:40%'),
										'std' => '',
									),
									array(
										'id' => 'layout_patron_image', //must be unique
										'type' => 'upload', //builtin fields include:
										'title' => __('Patron Image', 'wp_dictate'),
									),
								)
							),
					)
				);
	/** Coming Soon Settings */
	$sections[] = array(
					'title' => __('Coming Soon Settings', 'wp_dictate'),
					'desc' => __('<p class="description">Set the Coming Soon Settings</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_062_attach.png',
					'id' => 'coming_soon_settings',
					'fields' => array(
							array(
								'id' => 'coming_soon_status', //must be unique
								'type' => 'button_set', //builtin fields include:
								'title' => __('Enable Coming Soon', 'wp_dictate'),
								'desc' => __('Enable Coming Soon', 'wp_dictate'),
							),
							array(
								'id' => 'coming_soon_footer', //must be unique
								'type' => 'button_set', //builtin fields include:
								'title' => __('Enable Coming Soon Footer', 'wp_dictate'),
								'desc' => __('Enable Coming Soon Footer', 'wp_dictate'),
							),
							array(
								'id' => 'coming_soon_title', //must be unique
								'type' => 'text', //builtin fields include:
								'title' => __('Coming Soon Title', 'wp_dictate'),
								'desc' => __('Coming Soon Title', 'wp_dictate'),
							),
							array(
								'id' => 'coming_soon_desc', //must be unique
								'type' => 'textarea', //builtin fields include:
								'title' => __('Coming Soon Description', 'wp_dictate'),
								'desc' => __('Coming Soon Description', 'wp_dictate'),
							),
							array(
								'id' => 'coming_soon_timer', //must be unique
								'type' => 'date', //builtin fields include:
								'title' => __('Select CountDown Time', 'wp_dictate'),
								'desc' => __('Select CountDown Time', 'wp_dictate'),
							),
							array(
								'id' => 'feedburner', //must be unique
								'type' => 'text', //builtin fields include:
								'title' => __('Enter your feed burner id', 'wp_dictate'),
								'desc' => __('Enter your feed burner id', 'wp_dictate'),
							),
							array(
								'id' => 'coming_soon_gallery', //must be unique
								'type' => 'gallery', //builtin fields include:
								'title' => __('Select Backgorund Images', 'wp_dictate'),
								'desc' => __('Select Backgorund Images', 'wp_dictate'),
							),
							
					)
				);
	
	$sections[] = array(
					'title' => __('Social Network Settings', 'wp_dictate'),
					'desc' => __('<p class="description">Add edit remove the information about social networks.</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_062_attach.png',
					'id' => 'social_network_settings',
					'fields' => array(
							array(
								'id' => 'facebook', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Facebook URL', 'wp_dictate'),
								'desc' => __('Insert the url to facebook profile or page', 'wp_dictate'),
							),
							array(
								'id' => 'twitter', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Twitter URL', 'wp_dictate'),
								'desc' => __('Insert the url to twitter profile', 'wp_dictate'),
							),
							array(
								'id' => 'google-plus', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Google Plus URL', 'wp_dictate'),
								'desc' => __('Insert the url to Google Plus profile or page', 'wp_dictate'),
							),
							array(
								'id' => 'linkedin', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Linkedin URL', 'wp_dictate'),
								'desc' => __('Insert the url to Linkedin profile or page', 'wp_dictate'),
							),
							array(
								'id' => 'youtube', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Youtube URL', 'wp_dictate'),
								'desc' => __('Insert the url to Youtube profile or page', 'wp_dictate'),
							),
							array(
								'id' => 'skype', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Skype URL', 'wp_dictate'),
								'desc' => __('Insert the url to Skype profile or page', 'wp_dictate'),
							),
							array(
								'id' => 'flicker', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Flicker URL', 'wp_dictate'),
								'desc' => __('Insert the url to Flicker profile or page', 'wp_dictate'),
							),
							array(
								'id' => 'xing', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Xing URL', 'wp_dictate'),
								'desc' => __('Insert the url to Xing', 'wp_dictate'),
							),
							array(
								'id' => 'pinterest', //must be unique
								'type' => 'text', //builtin fields include:
												 
								'title' => __('Pinterest URL', 'wp_dictate'),
								'desc' => __('Insert the url to Pinterest', 'wp_dictate'),
							),
					),
					
				);
	
	/** Page settings */
	$sections[] = array(
					'title' => __('Portfolio Settings', 'wp_dictate'),
					'desc' => __('<p class="description">Set the portfolio Settings</p>', 'wp_dictate'),
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_062_attach.png',
					'id' => 'portfolio_settings',
					'fields' => array(
							
							array(
								'id' => 'columns',
								'type' => 'select',
								'title' => __('Portfolio Columns', 'wp_dictate'),
								'options' => array('2column'=>'2 Columns' , '3column'=>'3 Columns', '4column'=>'4 Columns') 
							)
					)
				);
	
	apply_filters('sh-opts-sections-theme', $sections);				
				
	$tabs = array();
			
	if (function_exists('wp_get_theme')){
		$theme_data = wp_get_theme();
		$theme_uri = $theme_data->get('ThemeURI');
		$description = $theme_data->get('Description');
		$author = $theme_data->get('Author');
		$version = $theme_data->get('Version');
		$tags = $theme_data->get('Tags');
	}/*else{
		$theme_data = get_theme_data(trailingslashit(get_stylesheet_directory()).'style.css');
		$theme_uri = $theme_data['URI'];
		$description = $theme_data['Description'];
		$author = $theme_data['Author'];
		$version = $theme_data['Version'];
		$tags = $theme_data['Tags'];
	}*/
	$theme_info = '<div class="nhp-opts-section-desc">';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-uri">'.__('<strong>Theme URL:</strong> ', 'wp_dictate').'<a href="'.$theme_uri.'" target="_blank">'.$theme_uri.'</a></p>';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-author">'.__('<strong>Author:</strong> ', 'wp_dictate').$author.'</p>';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-version">'.__('<strong>Version:</strong> ', 'wp_dictate').$version.'</p>';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-description">'.$description.'</p>';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-tags">'.__('<strong>Tags:</strong> ', 'wp_dictate').implode(', ', $tags).'</p>';
	$theme_info .= '</div>';
	$tabs['theme_info'] = array(
					'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_195_circle_info.png',
					'title' => __('Theme Information', 'wp_dictate'),
					'content' => $theme_info
					);
	
	if(file_exists(trailingslashit(get_stylesheet_directory()).'README.html')){
		$tabs['theme_docs'] = array(
						'icon' => get_template_directory().'/framework/theme_options/img/glyphicons/glyphicons_071_book.png',
						'title' => __('Documentation', 'wp_dictate'),
						'content' => nl2br(file_get_contents(trailingslashit(get_stylesheet_directory()).'README.html'))
						);
	}//if
	global $NHP_Options;
	$NHP_Options = new SH_Options($sections, $args, $tabs);
}//function
add_action('init', 'sh_setup_framework_options', 0);
/*
 * 
 * Custom function for the callback referenced above
 *
 */
function my_custom_field($field, $value){
	print_r($field);
	print_r($value);
}//function
/*
 * 
 * Custom function for the callback validation referenced above
 *
 */
function validate_callback_function($field, $value, $existing_value){
	
	$error = false;
	$value =  'just testing';
	/*
	do your validation
	
	if(something){
		$value = $value;
	}elseif(somthing else){
		$error = true;
		$value = $existing_value;
		$field['msg'] = 'your custom error message';
	}
	*/
	
	$return['value'] = $value;
	if($error == true){
		$return['error'] = $field;
	}
	return $return;
	
}//function
?>