<?php 
class SH_Admin_Page
{
	protected $section = '';
	protected $sections = '';
	protected $page = '';
	
	function __construct()
	{
		global $pagenow;
		add_action( 'admin_menu', array($this, '__init') );
		
		if( $pagenow == 'admin.php' && is_admin() ){
			
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue' ) );
			
			$this->sections = array('sh_timetable','sh_monday', 'sh_tuesday', 'sh_wednesday', 'sh_thursday', 'sh_friday', 'sh_saturday');
			$this->page = sh_set( $_GET, 'page' );
			if( in_array( $this->page, $this->sections ) ){
				$this->section = $this->page;
			}
		}
	}
	
	function __init()
	{
		add_menu_page( __('Timetable', 'wp_dictate'), __('Timetable', 'wp_dictate'), 'manage_options', 'sh_timetable', array($this, 'menu'), get_template_directory_uri().'/img/icons/timetable.png');
		
		add_submenu_page( 'sh_timetable', __('Sunday', 'wp_dictate'), __('Sunday', 'wp_dictate'), 'manage_options', 'sh_timetable', array($this, 'menu') );
		
		add_submenu_page( 'sh_timetable', __('Monday', 'wp_dictate'), __('Monday', 'wp_dictate'), 'manage_options', 'sh_monday', array($this, 'menu') );
		add_submenu_page( 'sh_timetable', __('Tuesday', 'wp_dictate'), __('Tuesday', 'wp_dictate'), 'manage_options', 'sh_tuesday', array($this, 'menu') );
		add_submenu_page( 'sh_timetable', __('Wednesday', 'wp_dictate'), __('Wednesday', 'wp_dictate'), 'manage_options', 'sh_wednesday', array($this, 'menu') );
		add_submenu_page( 'sh_timetable', __('Thursday', 'wp_dictate'), __('Thursday', 'wp_dictate'), 'manage_options', 'sh_thursday', array($this, 'menu') );
		add_submenu_page( 'sh_timetable', __('Friday', 'wp_dictate'), __('Friday', 'wp_dictate'), 'manage_options', 'sh_friday', array($this, 'menu') );
		add_submenu_page( 'sh_timetable', __('Saturday', 'wp_dictate'), __('Saturday', 'wp_dictate'), 'manage_options', 'sh_saturday', array($this, 'menu') );
	}
	
	function enqueue()
	{
		global $wp_styles, $pagenow;
		//printr($wp_styles);
		
		wp_enqueue_script('jquery-select2', SH_FRW_URL.'resource/js/jquery.select2.min.js');
		wp_enqueue_script( array('jquery-ui-accordion', 'jquery-ui-sortable') );
		wp_enqueue_style( 'jquery-ui-all', SH_FRW_URL.'resource/css/jquery.ui.all.css', array('media-views') );
		wp_enqueue_style( 'timetable', SH_FRW_URL.'resource/css/timetable.css' );
		wp_enqueue_style('admin-custom-styles', SH_FRW_URL.'resource/css/style.css');
	}
	
	function menu()
	{	
		global $pagenow;
                
		$settings = get_option( $this->page );
		//printr( $settings );
		if( count( $_POST ) ){
			update_option( $this->page,  $_POST );
			$settings = $_POST;
		}
		
		if( $pagenow == 'admin.php' && is_admin() ){
			if( in_array( $this->section, $this->sections ) ){
				
				include( SH_FRW_DIR.'modules/timetable/config.php' );
				$fields = $options;
				$nph = new SH_Options;
                              
				$post_type = $nph->args['opt_name'];
				//printr($nph);
				if( $fields && is_array( $fields ) ): ?>
					<script type="text/javascript">
					jQuery(document).ready(function($) {
						$('.fields_set select').select2();
						if( $('#start_date') ){
							//$('#start_date, #end_date').datepicker();
						}
					});
					</script>
		
					<?php include('admin_view.php'); 
				endif;				
				
			}
		}
	}
}
new SH_Admin_Page;