<?php
class Dictate_Homepage{
	
	function __construct($settings)
	{
		if( !$settings ) return;
		foreach( $settings as $s => $v )
		{
			if( sh_set( $v, $s.'_status' ) ){
				if( method_exists( $this, $s ) ) $this->$s();
			}
		}
	}
	
	function services()
	{
		
	}
	
	function staff()
	{
		global $post;
		$query = new WP_Query( array( 'post_type'=>'dict_team' ) );
		$res = array_chunk((array)sh_set($query, posts), 2);?>
        <section class="cols">
            <div class="container">
                <div class="left-cols span7">
                    <div class="col-title">
                        <h2>Our Staff</h2>
                    </div>
                    <div id="slider4"> <a href="#" class="buttons next"></a> <a href="#" class="buttons prev"></a>
                        <div class="viewport">
                            <ul class="overview" style="">
                                <?php foreach( $res as $r ):?>
                                <li>
                                    <?php foreach( $r as $post ): setup_postdata( $post ); ?>
                                    <div class="staff">
                                        <?php the_post_thumbnail( 'thumbnail' ); ?>
                                        <div class="staff-intro">
                                            <h3>
                                                <?php the_title(); ?>
                                            </h3>
                                            <?php $post_type = sh_set( $post, 'post_type' ); ?>
                                            <span><?php echo sh_set( get_post_meta( get_the_ID(), '_'.$post_type.'_settings', true), 'designation'); ?></span> </div>
                                        <?php the_excerpt(); ?>
                                    </div>
                                    <?php endforeach; ?>
                                </li>
                                <?php endforeach; 
								wp_reset_query();?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="right-cols span5">
                    <div class="col-title">
                        <h2>Why Choose Us</h2>
                    </div>
                    <dl class="accordions">
                        <dt><a href="">The Benfits of Middle-Age Fitness</a></dt>
                        <dd class="opened" style="display: none;">
                            <p>Lorem Ipsum is simply dummy text of the printing and typesettin simply dummy text of the printing and typesetting.</p>
                        </dd>
                        <dt><a href="">Day care snacks lacking in nutritional value.</a></dt>
                        <dd style="display: none;">
                            <p>Lorem Ipsum is simply dummy text of the printing and typesettin simply dummy text of the printing and typesetting.</p>
                        </dd>
                        <dt><a href="">New study links lutein with eye health benifits.</a></dt>
                        <dd style="display: none;">
                            <p>Lorem Ipsum is simply dummy text of the printing and typesettin simply dummy text of the printing and typesetting.</p>
                        </dd>
                        <dt><a href="">Lorem Ipsum is simply dummy text of the printing.</a></dt>
                        <dd style="display: none;">
                            <p>Lorem Ipsum is simply dummy text of the printing and typesettin simply dummy text of the printing and typesetting.</p>
                        </dd>
                    </dl>
                </div>
            </div>
        </section>
		<?php
	}
	
	function choose_us()
	{
		
	}
	
	function recent_events()
	{
		$query = new WP_Query( array( 'post_type'=>'dict_event' ) );
		
		?>
        <section class="cols">
            <div class="container">
                <div class="col-title">
                    <h2><?php _e( 'Recent Events', 'wp_dictate' ) ?></h2>
                </div>
                <div class="event-ver2"> <a href="#" class="viewall-btn" title=""><?php _e( 'View All', 'wp_dictate' ); ?></a>
                	<?php while( $query->have_posts() ): $query->the_post(); ?>
                    <div class="span4"> <?php the_post_thumbnail( 'thumbnail' ); ?>
                        <div class="event-caption">
                            <h5><?php the_title(); ?></h5>
                            <span><?php echo get_the_date(); ?></span> </div>
                        <div class="event-desc">
                            <?php the_excerpt(); ?>
                            <span>by <strong><?php the_author(); ?></strong></span> 
                        </div>
                    </div>
                    <?php endwhile; ?>
                    
                </div>
            </div>
        </section>
		<?php wp_reset_query();
	}
	
	function affiliation()
	{
		global $post;
		$query = new WP_Query( array( 'post_type'=>'dict_partner' ) );
		?>
        <section class="cols">
            <div class="container">
                <div class="col-title">
                    <h2>Our Affiliation</h2>
                </div>
                <div id="slider5">
                    <a href="#" class="buttons next"></a>
                    <a href="#" class="buttons prev"></a>
                    <div class="viewport">
                        <ul class="overview" style="">
                        	
							<?php while( $query->have_posts() ): $query->the_post(); ?>
                                <li>
                                    <a href="<?php echo sh_set(get_post_meta(get_the_ID(), '_'.$post->post_type.'_settings', true), 'link'); ?>" title="<?php the_title(); ?>">		
                                        <?php the_post_thumbnail('thumbnail'); ?>
                                    </a>
                                </li>
                            <?php endwhile; ?>
                            
                        </ul>
                    </div>
                </div>			
                
            </div>
        </section>
		<?php
		wp_reset_query();
	}
	
	
	function appointment()
	{
		?>
        <section class="cols">
            <div class="container">
                <div class="make-app-toggle">
                    <div class="make-app">
                        <div class="app-button">Make An Appointment</div>
                    </div>
                    <div class="make-app-form" style="display: none;">
                        <form class="row-fluid">
                            <div class="span4">
                                <input type="text" placeholder="Full Name" class="input-block-level">
                                <input type="text" placeholder="Phone Number" class="input-block-level">
                            </div>
                            <div class="span4">
                                <input type="email" placeholder="Email" class="input-block-level">
                                <input type="text" placeholder="App Date" class="small-field app-date" id="popupDatepicker">
                                <input type="text" placeholder="App Time" class="small-field app-time">
                            </div>
                            <div class="span4">
                                <textarea placeholder="Description" class="input-block-level"></textarea>
                            </div>
                            <p>Lorem ipsum dolor sit amet, consectetur. Nulla fringilla purus at leo dignissim congue.</p>
                            <input type="submit" value="Submit Now" class="app-form-submit">
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <?php
	}
}
