<?php 
$settings = get_option( 'wp_dictate');//printr($settings);
if( sh_set( $settings, 'header_donation_status' ) =='false' ) return;
require_once('libpaypal.php');
		
//Create the authentication
$pp_type = (sh_set($settings, 'paypal_type') == 'sandbox') ? true : false;
$auth = new PaypalAuthenticaton(sh_set($settings, 'paypal_username'), sh_set($settings, 'paypal_api_username'), sh_set($settings, 'paypal_api_password'), sh_set($settings, 'paypal_api_signature'), $pp_type);		
//Create the paypal object
$paypal = new Paypal($auth);
$pp_settings = new PaypalSettings();
$pp_settings->allowMerchantNote = true;
$pp_settings->logNotifications = true;
//the base url
$return =  'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$selected_page = get_page(sh_set($settings, 'selected_page'));
if(count($_POST) && $notif = $paypal->handleNotification())
sh_store_paypal_trans($notif);
$current_pos = $wpdb->get_row("SELECT SUM(total) as total FROM `".$wpdb->prefix."donation` WHERE `status` = 'Completed'"); 
$total = isset($current_pos->total) ? $current_pos->total : 1;
$total = (is_numeric(sh_set($settings, 'paypal_raised')) && sh_set($settings, 'paypal_raised') < sh_set($settings, 'paypal_target')) ? sh_set($settings, 'paypal_raised') : $total;
$dtotal = (is_numeric(sh_set($settings, 'paypal_raised')) && sh_set($settings, 'paypal_raised') < sh_set($settings, 'paypal_target')) ? sh_set($settings, 'paypal_raised') : 0;
$percent = (sh_set($settings, 'paypal_target')) ? $total / sh_set($settings, 'paypal_target') : 0;
$action = $paypal->getButtonAction(); //get button action
$products = array();
$params = $paypal->getButtonParams($products, "$return?action=paid", "$return?action=cancel", "$return?action=notify"); //get params for the form
unset($params['currency_code']);
unset($params['amount']);
$params['cmd'] = '_donations';
$params['item_name'] = 'Donation';?>
<div class="donate">
    <div class="container">
        <div class="donate-box">
            <h3><?php echo stripslashes(sh_set( $settings, 'paypal_title' )); ?></h3>
            <?php echo apply_filters( 'the_content', sh_set( $settings, 'paypal_note' ) ); ?>
        </div>
        <div class="donate-box">
            <div class="recieved">
                <h5><?php echo sh_set($settings, 'currency').number_format($dtotal, 0, '.', ','); ?> <span class="black"><?php _e('Recieved', 'wp_dictate'); ?></span></h5>
            </div>
            <div class="target">
                <h5><span class="black"><?php _e('Target', 'wp_dictate'); ?></span> <?php echo sh_set($settings, 'currency').number_format(sh_set($settings, 'paypal_target'), 0, '.', ','); ?></h5>
            </div>
            <div class="progress">
                <div class="bar" style="width: <?php echo $percent*100; ?>%;"></div>
            </div>
        </div>
        <div class="donate-box">
        	<form action="<?php echo $action; ?>" method="post">
				
				<?php foreach($params as $key => $value): ?>
                    <input type="hidden" name="<?php echo $key; ?>" value="<?php echo $value; ?>"/>
                <?php endforeach;?> 
                <button type="submit" class="donate-btn"><?php _e('DONATE <span>Now</span>', 'wp_dictate'); ?></button>
                
            </form>
        </div>
        <div class="donate-updown">
            <h6><?php _e('DONATE <span class="black">US</span>', 'wp_dictate'); ?></h6>
        </div>
    </div>
</div>
<!-- Top Donation Bar -->