<?php
	$filteration = array(
						'pages' => range(10, 50, 10),
						'sort' => array('default'=>__('Default', 'wp_dictate'), 'price_asc'=>__('Price (Low &gt; High)', 'wp_dictate'), 'price_desc'=>__('Price (High &gt; Low)', 'wp_dictate'),
										'rating_desc'=>__('Rating (Highest)', 'wp_dictate'), 'rating_asc'=>__('Rating (Lowest)', 'wp_dictate'), 'title_asc'=>__('Name (A - Z)', 'wp_dictate'),
										'title_desc'=>__('Name (Z - A)', 'wp_dictate'),),	
					);
$request_uri = 'http://'.$_SERVER['HTTP_HOST']. $_SERVER['REQUEST_URI'];
?>
<div class="row-fluid">
    <div class="span12">
        <section id="wrap-cat">
            <header class="wrap-header">
                <div class="display">
                	<b><?php _e('Display:', 'wp_dictate'); ?></b>
                    <?php $url_method = (strstr( $request_uri, '?' ) ) ? '&' : '?' ; ?>
                    <a data-original-title="<?php _e('View List Style', 'wp_dictate'); ?>" data-placement="top" data-toggle="tooltip" class="list list-icon" href="<?php echo $request_uri.$url_method.'pro_view=list'; ?>"><?php _e( 'List View', 'wp_dictate' ); ?></a>
                    <a data-original-title="<?php _e('View Grid Style', 'wp_dictate'); ?>" data-placement="top" data-toggle="tooltip" class="grid grid-icon" href="<?php echo $request_uri.$url_method.'pro_view=grid'; ?>"><?php _e( 'Grid View', 'wp_dictate' );?></a>
                </div>
                
                <form method="post">                                   
                <div class="limit">
                	<b><?php _e('Show:', 'wp_dictate'); ?></b>
                    
                    <select name="pages" onchange="this.form.submit();">
                        <?php foreach( $filteration['pages'] as $page ): ?>
                        	<?php $selected = ( $pag = sh_set($_SESSION, 'bistro_pro_per_page') ) ? 'selected="selected"' : ''; ?>
                            <option value="<?php echo $page;?>" <?php echo $selected; ?>><?php echo $page; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="sort">
                	<b><?php _e('Sort:', 'wp_dictate'); ?></b>
                    <select name="sort" onchange="this.form.submit();">
                    	<?php foreach( $filteration['sort'] as $k => $v ): ?>
                        	<?php $selected = ( $pag = sh_set($_SESSION, 'bistro_pro_sort') ) ? 'selected="selected"' : ''; ?>
                        	<option value="<?php echo $k; ?>" <?php echo $selected; ?>><?php echo $v; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                </form>
            </header>
        </section>
    </div>
</div>