<?php

//Products Tabs
class SH_Our_Location extends WP_Widget {

    /** constructor */
    function __construct() {
        parent::__construct(/* Base ID */'OurLocation', /* Name */ __('Our Location', 'wp_dictate'), array('description' => __('This widgtes is used to add Location Informations to Footer', 'wp_dictate')));
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        $sub_title = apply_filters('widget_sub_title', $instance['sub_title']);
        $text = apply_filters('widget_text', $instance['text']);
        $by_email = apply_filters('widget_by_email', $instance['by_email']);
        $by_phone = apply_filters('widget_by_phone', $instance['by_phone']);
        $address = apply_filters('widget_address', $instance['address']);
        echo $before_widget;
        ?>
        <?php echo $before_title . $title . '<span>' . $sub_title . '</span>' . $after_title; ?>

        <div class="location">
            <p>
        <?php echo $text; ?>
            </p>
            <ul>
                <li>
                    <i class="theme-icon email"></i>
                    <span class="source"><?php _e('by e-mail:', 'wp_dictate') ?></span>
                    <span class="detail">
                        <a title="" href=""><?php echo $by_email ?></a>
                    </span>
                </li>
                <li>
                    <i class="theme-icon phone"></i>
                    <span class="source"><?php _e('by phone:', 'wp_dictate') ?></span>
                    <span class="detail">
                        <a title="" href=""><?php echo $by_phone; ?></a>
                    </span>
                </li>
                <li>
                    <i class="theme-icon home"></i>
                    <span class="source"><?php _e('Address:', 'wp_dictate') ?></span>
                    <span class="detail">
                        <a title="" href=""><?php echo $address; ?></a>
                    </span>
                </li>
            </ul>
        </div>
        <?php
        echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['sub_title'] = strip_tags($new_instance['sub_title']);
        $instance['text'] = $new_instance['text'];
        $instance['by_email'] = $new_instance['by_email'];
        $instance['by_phone'] = $new_instance['by_phone'];
        $instance['address'] = $new_instance['address'];
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {
        $title = ($instance) ? esc_attr($instance['title']) : __('Our', 'wp_dictate');
        $sub_title = ($instance) ? esc_attr($instance['sub_title']) : __('Location', 'wp_dictate');
        $text = ($instance) ? esc_attr($instance['text']) : '';
        $by_email = ($instance) ? esc_attr($instance['by_email']) : __('info@yoursite.com', 'wp_dictate');
        $by_phone = ($instance) ? esc_attr($instance['by_phone']) : __('+900-78601', 'wp_dictate');
        $address = ($instance) ? esc_attr($instance['address']) : '';
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('sub_title'); ?>"><?php _e('Sub Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('sub_title'); ?>" name="<?php echo $this->get_field_name('sub_title'); ?>" type="text" value="<?php echo $sub_title; ?>" />
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('text'); ?>"><?php _e('Text:', 'wp_dictate'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>" > <?php echo $text; ?></textarea> 
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('by_email'); ?>"><?php _e('By Email:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('by_email'); ?>" name="<?php echo $this->get_field_name('by_email'); ?>" type="text" value="<?php echo $by_email; ?>" /> 
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('by_phone'); ?>"><?php _e('By Phone:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('by_phone'); ?>" name="<?php echo $this->get_field_name('by_phone'); ?>" type="text" value="<?php echo $by_phone; ?>" /> 
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('address'); ?>"><?php _e('Address:', 'wp_dictate'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('address'); ?>" name="<?php echo $this->get_field_name('address'); ?>" > <?php echo $address; ?></textarea> 
        </p>


        <?php
    }

}

// Contact Us
class SH_Contact_Us extends WP_Widget {

    /** constructor */
    function __construct() {
        parent::__construct(/* Base ID */'ContactUs', /* Name */ __('Contact Us', 'wp_dictate'), array('description' => __('This widgtes is used to add Contact Form to Footer', 'wp_dictate')));
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        $sub_title = apply_filters('widget_sub_title', $instance['sub_title']);
        $email = apply_filters('widget_email', $instance['email']);

        echo $before_widget;
        ?>
        <?php echo $before_title . $title . '<span>' . $sub_title . '</span>' . $after_title; ?>

        <div class="contact-form">

            <form id="dict_contact_form" name="contact_form" method="post" action="<?php echo admin_url('admin-ajax.php?action=dictate_ajax_callback&subaction=sh_contact_form_submit2'); ?>">
                <div class="msgs"></div>
                <input name="contact_name" value="" type="text" placeholder="Name">
                <input name="contact_phone" value="" type="text" placeholder="Phone #">
                <input name="contact_phone2" value="" type="text" placeholder="2nd Phone #">
                <input name="contact_email" value="" type="email" placeholder="Email">
                <textarea name="contact_message" placeholder="Message" rows="4"></textarea>
                <input name="submit" class="submit" type="Submit" value="<?php _e('Submit', 'wp_dictate'); ?>">

            </form>
        </div>

        <?php
        echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['sub_title'] = strip_tags($new_instance['sub_title']);
        $instance['email'] = $new_instance['email'];
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {
        $title = ($instance) ? esc_attr($instance['title']) : __('Contact', 'wp_dictate');
        $sub_title = ($instance) ? esc_attr($instance['sub_title']) : __('Us', 'wp_dictate');
        $email = ($instance) ? esc_attr($instance['email']) : '';
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('sub_title'); ?>"><?php _e('Sub Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('sub_title'); ?>" name="<?php echo $this->get_field_name('sub_title'); ?>" type="text" value="<?php echo $sub_title; ?>" />
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('email'); ?>"><?php _e('Email:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('email'); ?>" name="<?php echo $this->get_field_name('email'); ?>" type="text" value="<?php echo $email; ?>" /> 
        </p>
        <?php
    }

}

// Flicker Gallery
class SH_Flickr extends WP_Widget {

    /** constructor */
    function __construct() {
        parent::__construct(/* Base ID */'SH_Flickr', /* Name */ __('Flickr Feed', 'wp_dictate'), array('description' => __('Fetch the latest feed from Flickr', 'wp_dictate')));
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {
        extract($args);
        wp_enqueue_script(array('flickrjs'));
        $title = apply_filters('widget_title', $instance['title']);
        $sub_title = apply_filters('widget_sub_title', $instance['sub_title']);
        $text = apply_filters('widget_text', $instance['text']);

        echo $before_widget;
        ?>
        <?php echo $before_title . $title . '<span>' . $sub_title . '</span>' . $after_title; ?>
        <?php $limit = ($instance['number']) ? $instance['number'] : 8; ?>
        <p><?php echo $text; ?></p>
        <div class="flickr-images">
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                    jQuery('.flickr-images').jflickrfeed({
                        limit: <?php echo $limit; ?>,
                        qstrings: {id: '<?php echo $instance['flickr_id']; ?>'},
                        itemTemplate: '<a href="{{link}}"><img src="{{image_s}}" alt="{{title}}" /></a>'
                    });
                });
            </script>
        </div>
        <?php
        echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['sub_title'] = strip_tags($new_instance['sub_title']);
        $instance['flickr_id'] = $new_instance['flickr_id'];
        $instance['text'] = $new_instance['text'];
        $instance['number'] = $new_instance['number'];
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {
        $title = ($instance) ? esc_attr($instance['title']) : __('Recent From', 'wp_dictate');
        $sub_title = ($instance) ? esc_attr($instance['sub_title']) : __(' Flickr', 'wp_dictate');
        $flickr_id = ($instance) ? esc_attr($instance['flickr_id']) : '';
        $text = ($instance) ? esc_attr($instance['text']) : '';
        $number = ( $instance ) ? esc_attr($instance['number']) : 8;
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('sub_title'); ?>"><?php _e('Sub Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('sub_title'); ?>" name="<?php echo $this->get_field_name('sub_title'); ?>" type="text" value="<?php echo $sub_title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('flickr_id'); ?>"><?php _e('Flickr ID:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('flickr_id'); ?>" name="<?php echo $this->get_field_name('flickr_id'); ?>" type="text" value="<?php echo $flickr_id; ?>" />
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('text'); ?>"><?php _e('Text:', 'wp_dictate'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>" > <?php echo $text; ?></textarea> 
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of Tweets:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" />
        </p>


        <?php
    }

}

// Tabber Widget
class SH_Tabber extends WP_Widget {

    /** constructor */
    function __construct() {
        parent::__construct(/* Base ID */'SH_Tabber', /* Name */ __('Tabber ', 'wp_dictate'), array('description' => __('Fetch the latest , Popular posts and comments in tabber form', 'wp_dictate')));
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {
        extract($args);
        $number_of_latest_posts = apply_filters('widget_number_of_latest_posts', $instance['number_of_latest_posts']);
        $number_of_comments = apply_filters('widget_number_of_comments', $instance['number_of_comments']);
        $number_of_popular_posts = apply_filters('widget_number_of_popular_posts', $instance['number_of_popular_posts']);

        //echo $before_widget;
        ?>
        <div class="tabbable sidebar-tabs">
            <ul class="nav nav-tabs">
                <li class="active"><a href="#popular" data-toggle="tab"><?php _e('Popular Posts', 'wp_dictate'); ?></a></li>
                <li class=""><a href="#latest" data-toggle="tab"><?php _e('Latest Posts', 'wp_dictate'); ?></a></li>
                <li class=""><a href="#tabs_comments" data-toggle="tab"><?php _e('Comments', 'wp_dictate'); ?></a></li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane fade active in" id="popular">
        <?php
        global $posts;
        $posts = query_posts('meta_key=_dict_post_views&orderby=meta_value_num&order=DESC&posts_per_page=' . $number_of_popular_posts);
        if (have_posts()): while (have_posts()): the_post();
                $views = get_post_meta(get_the_ID(), '_dict_post_views', true);
                ?>
                            <div class="tab-post">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('103x103');
                            } ?>
                                <div class="tabpost-detail">
                                    <p><a title="" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
                                    <span><i class="theme-icon calender"></i><?php echo get_the_date(); ?></span>
                                    <span><i class="theme-icon views"></i><?php echo number_format((int) $views); ?> <?php _e('views', 'wp_dictate'); ?></span>
                                </div>
                            </div>
                            <?php
                        endwhile;
                    endif;
                    wp_reset_query();
                    ?>
                </div> <!-- Popular Posts -->
                <div class="tab-pane fade" id="latest">
                    <?php
                    query_posts('posts_per_page=' . $number_of_latest_posts);
                    if (have_posts()): while (have_posts()): the_post();
                            $views = get_post_meta(get_the_ID(), '_dict_post_views', true);
                            ?>

                            <div class="tab-post">
                <?php if (has_post_thumbnail()) {
                    the_post_thumbnail('103x103');
                } ?>
                                <div class="tabpost-detail">
                                    <p><a title="" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
                                    <span><i class="theme-icon calender"></i><?php echo get_the_date(); ?></span>
                                    <span><i class="theme-icon views"></i><?php echo number_format((int) $views); ?> <?php _e('views', 'wp_dictate'); ?></span>
                                </div>
                            </div>

                        <?php endwhile;
                    endif;
                    wp_reset_query(); ?>
                </div> <!-- Latest Posts -->
        <?php
        $comments = get_comments(array("namber" => $number_of_comments));
        //print_r($comments);
        ?> 
                <div class="tab-pane fade" id="tabs_comments">
                    <?php
                    foreach ($comments as $comment) {
                        $cat = get_category($comment->comment_post_ID);
                        //printr($cat);
                        ?>
                        <div class="tab-post">
                            <div class="tabpost-detail">
                                <p><a href="#" title="">"<?php echo $comment->comment_content; ?>"</a></p>
                                <span><i class="theme-icon user-small"></i>By: <a title="" href="<?php echo sh_set($comment, 'comment_author_url'); ?>"><?php echo sh_set($comment, 'comment_author'); ?></a><i class="theme-icon post-cat"></i><a title="" href="<?php echo get_category_link(sh_set($cat, 'term_id')); ?>"><?php echo sh_set($cat, 'name'); ?></a></span>					
                            </div>
                        </div>
        <?php } ?>
                </div> <!-- Posts Comments -->
            </div>
        </div>
        <?php
        //echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['number_of_latest_posts'] = $new_instance['number_of_latest_posts'];
        $instance['number_of_comments'] = $new_instance['number_of_comments'];
        $instance['number_of_popular_posts'] = $new_instance['number_of_popular_posts'];
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {
        $number_of_latest_posts = ( $instance ) ? esc_attr($instance['number_of_latest_posts']) : 4;
        $number_of_comments = ( $instance ) ? esc_attr($instance['number_of_comments']) : 4;
        $number_of_popular_posts = ( $instance ) ? esc_attr($instance['number_of_popular_posts']) : 4;
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('number_of_latest_posts'); ?>"><?php _e('No. of Latest Posts:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number_of_latest_posts'); ?>" name="<?php echo $this->get_field_name('number_of_latest_posts'); ?>" type="text" value="<?php echo $number_of_latest_posts; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number_of_comments'); ?>"><?php _e('No. of Comments:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number_of_comments'); ?>" name="<?php echo $this->get_field_name('number_of_comments'); ?>" type="text" value="<?php echo $number_of_comments; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number_of_popular_posts'); ?>"><?php _e('No. of Popular Posts:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number_of_popular_posts'); ?>" name="<?php echo $this->get_field_name('number_of_popular_posts'); ?>" type="text" value="<?php echo $number_of_popular_posts; ?>" />
        </p>
        <?php
    }

}

// Social Networks 
class SH_Social_Networks extends WP_Widget {

    /** constructor */
    function __construct() {
        parent::__construct(/* Base ID */'widget-social', /* Name */ 'Social Networks', array('description' => 'Socail Network Widget'));
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {
        global $post;

        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        echo $before_widget;

        if ($title)
            echo $before_title . $title . $after_title;
        include_once(get_template_directory() . '/framework/helpers/codebird.php');

        $theme_options = get_option('wp_dictate');

        Codebird::setConsumerKey(sh_set($theme_options, 'twitter_api_key'), sh_set($theme_options, 'twitter_secret_key'));
        $cb = Codebird::getInstance();
        $cb->setToken(sh_set($theme_options, 'twitter_token'), sh_set($theme_options, 'twitter_token_secret'));
        //$twitter_settings = get_option( 'wp_dictate');

        $params = array(
            'screen_name' => sh_set($instance, 'twitter_url')
        );
        $reply = $cb->users_show($params);
        echo $before_widget;
        ?>
        <div class="sidebar-box">
        <?php if ($facebook = sh_set($instance, 'facebook_url')):?>
                <a class="likes" title="" href="http://www.facebook.com/<?php echo $facebook; ?>">
                    <img alt="" src="<?php echo get_template_directory_uri(); ?>/img/resource/fb-likes.png">
                    <?php echo $this->get_likes($facebook, sh_set($instance, 'facebook_token')); ?>
                    <span><?php _e('Likes', 'wp_dictate'); ?></span>
                </a>

            <?php endif; ?>
            <?php if ($twitter = sh_set($instance, 'twitter_url')): ?>

                <a class="likes" title="" href="http://www.twitter.com/<?php echo $twitter; ?>">
                    <img alt="" src="<?php echo get_template_directory_uri(); ?>/img/resource/tweet-likes.png">                    
                <?php echo number_format((int) sh_set($reply, 'followers_count')); ?>
                    <span><?php _e('Followers', 'wp_dictate'); ?></span>
                </a>

                <?php endif; ?>
        <?php if ($google_plus = sh_set($instance, 'gplus_url')): ?>

            <?php
            if (!strstr($google_plus, 'http://') && !strstr($google_plus, 'https://')) {
                $google_plus = 'https://plus.google.com/' . $google_plus;
            }
            ?>

                <a class="likes" title="" href="<?php echo $google_plus; ?>">
                    <img alt="" src="<?php echo get_template_directory_uri(); ?>/img/resource/gplus-likes.png">                    
            <?php echo $this->get_plusones($google_plus); ?>
                    <span><?php _e('Followers', 'wp_dictate'); ?></span>
                </a>


        <?php endif; ?>
        </div> </div>

    <?php
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['facebook_url'] = strip_tags($new_instance['facebook_url']);
        $instance['facebook_token'] = strip_tags($new_instance['facebook_token']);
        $instance['twitter_url'] = strip_tags($new_instance['twitter_url']);
        $instance['gplus_url'] = strip_tags($new_instance['gplus_url']);

        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {
        if ($instance) {
            $post_title = esc_attr($instance['title']);
            $facebook_url = esc_attr($instance['facebook_url']);
            $facebook_token = esc_attr($instance['facebook_token']);
            $twitter_url = esc_attr($instance['twitter_url']);
            $gplus_url = esc_attr($instance['gplus_url']);
        } else {
            $post_title = __('Social Networks', 'wp_dictate');
            $facebook_url = '';
            $twitter_url = '';
            $gplus_url = '';
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dictate'); ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $post_title; ?>" />
        </p>
        <p>
            <label for="facebook"><?php _e('Facebook ID:', 'wp_dictate'); ?></label><br />
            <input class="widefat" type="text" value="<?php echo $facebook_url; ?>" name="<?php echo $this->get_field_name('facebook_url'); ?>" id="<?php echo $this->get_field_id('facebook_url'); ?>">
        </p>
        <p>
            <label for="facebook_token"><?php _e('Facebook Access Token:', 'wp_dictate'); ?></label><br />
            <input class="widefat" type="text" value="<?php echo $facebook_token; ?>" name="<?php echo $this->get_field_name('facebook_token'); ?>" id="<?php echo $this->get_field_id('facebook_token'); ?>">
        </p>
        <p>
            <label for="twitter"><?php _e('Twitter ID:', 'wp_dictate'); ?></label><br />
            <input class="widefat" type="text" value="<?php echo $twitter_url; ?>" name="<?php echo $this->get_field_name('twitter_url'); ?>" id="<?php echo $this->get_field_id('twitter_url'); ?>">
        </p>
        <p>
            <label for="twitter"><?php _e('Gplus URL:', 'wp_dictate'); ?></label><br />
            <input class="widefat" type="text" value="<?php echo $gplus_url; ?>" name="<?php echo $this->get_field_name('gplus_url'); ?>" id="<?php echo $this->get_field_id('gplus_url'); ?>">
        </p>

        <?php
        //printr($twitter_settings);
    }

    function get_likes($url, $token) {
       
        $page_id = $url;

        if (strstr($url, 'http://')) {
            $parse = parse_url($url);
            $url = str_replace('/', '', sh_set($parse, 'path'));
        }
     
        $content = wp_remote_get('https://graph.facebook.com/'.$url.'?access_token='.$token);
   
        if (sh_set($content, 'body'))
            return number_format((int) sh_set(json_decode(sh_set($content, 'body')), 'likes', 0));
    }

    function get_plusones($url) {


        //$doc = new DOMDocument();
        //@$doc->loadHTMLFile('https://apis.google.com/_/+1/fastbutton?url='.urlencode($url)); 
        if (strstr($url, 'http://') || strstr($url, 'https://')) {
            preg_match('/[0-9]+/', $url, $match);
            if (sh_set($match, 0))
                $url = $match[0];
        }

        if ($url) {
            if (!function_exists('curl_init')) {
                $content = @file_get_contents('https://www.googleapis.com/plus/v1/people/' . $url . '?key=AIzaSyAtF_e9L7pavcb_dAwu_2Q7SmW0owktCv8'); //echo $data;exit;
            } else {
                $ch = curl_init('https://www.googleapis.com/plus/v1/people/' . $url . '?key=AIzaSyAtF_e9L7pavcb_dAwu_2Q7SmW0owktCv8');
                @curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
                curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (X11; Linux i686; rv:20.0) Gecko/20121230 Firefox/20.0');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                $content = curl_exec($ch);
                curl_close($ch);
            }
            $likes = 0;
            if ($content) {
                $likes = sh_set(json_decode($content), 'plusOneCount');
            }
            return number_format((int) $likes);
        }
    }

}

////
//Galleries
class SH_Galleries extends WP_Widget {

    function __construct() {
        parent::__construct(/* Base ID */'Galleries', /* Name */ __('Galleries', 'wp_dictate'), array('description' => __('This widgtes is used to add Galleries.', 'wp_dictate')));
    }

    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        $sub_title = apply_filters('widget_sub_title', $instance['sub_title']);
        $number = apply_filters('widget_number', $instance['number']);
        echo $before_widget;
        echo $before_title . $title . ' <span>' . $sub_title . '</span>' . $after_title;

        $Records = '';
        $CoverImage = '';

        $Posts = query_posts('post_type=dict_gallery&showposts=' . $number);

        if (have_posts()): while (have_posts()): the_post();

                $Records .= '<div class="gallery-item">
					   <a href="' . get_permalink() . '" title="">' . get_the_post_thumbnail(get_the_ID(), '103x103') . '</a>
					 </div>';
            endwhile;
        endif;
        wp_reset_query();
        ?>
        <div class="sidebar-gallery ">
        <?php echo $Records; ?>
        </div>
        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['sub_title'] = strip_tags($new_instance['sub_title']);
        $instance['number'] = $new_instance['number'];
        return $instance;
    }

    function form($instance) {
        $title = ($instance) ? esc_attr($instance['title']) : __('Gallery', 'wp_dictate');
        $sub_title = ($instance) ? esc_attr($instance['sub_title']) : __('Items', 'wp_dictate');
        $number = ($instance) ? esc_attr($instance['number']) : '';
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('sub_title'); ?>"><?php _e('Sub Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('sub_title'); ?>" name="<?php echo $this->get_field_name('sub_title'); ?>" type="text" value="<?php echo $sub_title; ?>" />
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number Of Galleries:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" /> 
        </p>
        <?php
    }

}

//Galleries
class SH_Popular_Video extends WP_Widget {

    function __construct() {
        parent::__construct(/* Base ID */'PopularVideo', /* Name */ __('Popular Video', 'wp_dictate'), array('description' => __('This widgtes is used to add popular video to sidebar.', 'wp_dictate')));
    }

    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        $sub_title = apply_filters('widget_sub_title', $instance['sub_title']);
        $number = apply_filters('widget_number', $instance['number']);
        $posttype = apply_filters('widget_posttype', $instance['posttype']);

        //$posttype = ( !empty( $posttype ) ) ? $posttype: 'dict_gallery';
        echo $before_widget;
        echo $before_title . $title . ' <span>' . $sub_title . '</span>' . $after_title;
        $meta = get_post_meta($posttype, '_dict_gallery_settings', true);
        //printr($meta);
        $videos = sh_set($meta, 'videos');

        if ($videos && is_array($videos)):
            $single_vid = array_rand($videos, 1);
            if (isset($videos[$single_vid])):
                $video_image = sh_video_image($videos[$single_vid]);
                ?>
                <div class="sidebar-video"> 
                    <img src="<?php echo $video_image; ?>" alt="<?php echo get_the_title($posttype); ?>" /> 
                    <a class="html5lightbox" rel="prettyPhoto" href="<?php echo $videos[$single_vid]; ?>" title=""> <span class="play-icon"></span> </a> 
                    <a class="html5lightbox" data-group="sidebar-video" rel="prettyPhoto" title="" href="<?php echo $videos[$single_vid]; ?>">
                        <div class="video-title"><?php echo get_the_title($posttype); ?></div>
                    </a>
                </div>
                <?php
            endif;
        endif;
        ?>
        <?php //echo $Records;?>
        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['sub_title'] = strip_tags($new_instance['sub_title']);
        $instance['number'] = $new_instance['number'];
        $instance['posttype'] = $new_instance['posttype'];
        return $instance;
    }

    function form($instance) {
        $title = ($instance) ? esc_attr($instance['title']) : __('Popular', 'wp_dictate');
        $sub_title = ($instance) ? esc_attr($instance['sub_title']) : __('Video', 'wp_dictate');
        $number = ($instance) ? esc_attr($instance['number']) : '';
        $posttype = ($instance) ? $instance['posttype'] : 1;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('sub_title'); ?>"><?php _e('Sub Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('sub_title'); ?>" name="<?php echo $this->get_field_name('sub_title'); ?>" type="text" value="<?php echo $sub_title; ?>" />
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number Of Videos:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" /> 
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('posttype'); ?>"><?php _e('Video Gallery:', 'wp_dictate'); ?></label>
        <?php $gallery = sh_get_posts_array('dict_gallery'); ?>
            <select class="widefat" id="<?php echo $this->get_field_id('posttype'); ?>" name="<?php echo $this->get_field_name('posttype'); ?>">
        <?php
        if ($gallery):
            foreach ($gallery as $k => $g):
                $selected = ( $k == $posttype ) ? 'selected="selected"' : '';
                ?>
                        <option value="<?php echo $k; ?>" <?php echo $selected; ?>><?php echo $g; ?></option>
            <?php endforeach;
        endif;
        ?>
            </select>
        </p>
        <?php
    }

}

class SH_show_pages extends WP_Widget {

    /** constructor */
    function __construct() {
        parent::__construct(/* Base ID */'DictatePages', /* Name */ __('Dictate Pages', 'wp_dictate'), array('description' => __('This widgtes is used to add pages to Footer', 'wp_dictate')));
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        $sub_title = apply_filters('widget_sub_title', $instance['sub_title']);
        $page_ids = apply_filters('widget_page_ids', $instance['page_ids']);

        echo $before_widget;
        ?>
        <?php
        echo $before_title . $title . '<span> ' . $sub_title . '</span>' . $after_title;
        $page_id_arr = explode(',', $page_ids);
        ?>

        <div class="menu-footer-menu-container">
            <ul class="menu">
        <?php
        foreach ($page_id_arr as $page_id):
            $page_data = get_page($page_id);
            ?>
                    <li class="menu-item"><a href="<?php echo get_page_link($page_id); ?>" title=""><?php echo sh_set($page_data, 'post_title'); ?></a></li>
        <?php endforeach; ?>
            </ul>
        </div>

        <?php
        echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['sub_title'] = strip_tags($new_instance['sub_title']);
        $instance['page_ids'] = strip_tags($new_instance['page_ids']);
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {
        $title = ($instance) ? esc_attr($instance['title']) : __('Quick', 'wp_dictate');
        $sub_title = ($instance) ? esc_attr($instance['sub_title']) : __('Menu', 'wp_dictate');
        $page_ids = ($instance) ? esc_attr($instance['page_ids']) : '';
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('sub_title'); ?>"><?php _e('Sub Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('sub_title'); ?>" name="<?php echo $this->get_field_name('sub_title'); ?>" type="text" value="<?php echo $sub_title; ?>" />
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('page_ids'); ?>"><?php _e('Page IDs:', 'wp_dictate'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('page_ids'); ?>" name="<?php echo $this->get_field_name('page_ids'); ?>" > <?php echo $page_ids; ?></textarea> 
        </p>
        <?php
    }

}

class SH_appointment_sidebox extends WP_Widget {

    /** constructor */
    function __construct() {
        parent::__construct(/* Base ID */'AppointmentSidebox', /* Name */ __('Appointment Sidebox', 'wp_dictate'), array('description' => __('This widgtes is used to add Appointment sidebox to sidebar', 'wp_dictate')));
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        $sub_title = apply_filters('widget_sub_title', $instance['sub_title']);
        $tag_line = apply_filters('widget_page_ids', $instance['tag_line']);

        echo $before_widget;
        ?>

        <div class="gray-title">
            <span><i class="fa fa-calendar"></i></span>
            <h3><?php echo $title; ?></h3>
            <h5><?php echo $sub_title; ?></h5>
        </div>

        <div class="appointment-gray">
            <p><?php echo $tag_line; ?></p>
            <?php $form = '
				<form id="dict_appointment" class="appointment-form" action="' . admin_url('admin-ajax.php?action=dictate_ajax_callback&subaction=sh_appointment_form_submit') . '">
						<div class="msgs"></div>
						<div class="row-fluid">
							<div class="span12">
							  <span><i class="fa fa-user"></i></span>
							  <input name="appointment_name" type="text" placeholder="' . __('Name Of Patient', 'wp_dictate') . '" >
							</div>
						</div>
						 <div class="row-fluid">
							<div class="span6">
						<span><i class="fa fa-mobile-phone"></i></span>
						  <input name="appointment_phone" type="text" placeholder="' . __('Phone No', 'wp_dictate') . '" >
							
							</div>
					<div class="span6">
						<span><i class="fa fa-user-md"></i></span>
							
						  <input type="text" placeholder="' . __('Doctor Name', 'wp_dictate') . '" >
							</div>
				</div>	
				<div class="row-fluid">
					<div class="span12">
						<span><i class="fa fa-envelope"></i></span>
						 
						  <input name="appointment_email" type="email" placeholder="' . __('Email', 'wp_dictate') . '" >
						 </div>
				</div>
					'.wp_enqueue_script('jquery').
            wp_enqueue_script('jquery-ui-core').
            wp_enqueue_script('jquery-ui-datepicker').
            wp_enqueue_style('jquery-ui-css', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css').'
				<div class="row-fluid">
					<div class="span6">
						<span><i class="fa fa-calendar"></i></span>
						  <input  name="appointment_date" type="text" id="date" placeholder="' . __('Date', 'wp_dictate') . '" >
							</div>
					<div class="span6">
						<span><i class="fa fa-thumbs-o-up"></i></span>
							
						  <input  name="appointment_time" type="text" placeholder="' . __('Time', 'wp_dictate') . '" >
</div>
				</div>	
				<div class="row-fluid">
					<div class="span12">
						<span><i class="fa fa-user"></i></span>
						 
						  <input name="appointment_description" type="text" placeholder="' . __('Additional Info', 'wp_dictate') . '" >
</div>
				</div>
						  <input type="submit" value="' . __('Submit', 'wp_dictate') . '" class="submit">
						</form>'; ?>
        <?php echo $form; ?>
        </div>

        <?php
        echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['sub_title'] = strip_tags($new_instance['sub_title']);
        $instance['tag_line'] = strip_tags($new_instance['tag_line']);
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {
        $title = ($instance) ? esc_attr($instance['title']) : __('Appointment', 'wp_dictate');
        $sub_title = ($instance) ? esc_attr($instance['sub_title']) : __('Sidebox', 'wp_dictate');
        $tag_line = ($instance) ? esc_attr($instance['tag_line']) : '';
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('sub_title'); ?>"><?php _e('Sub Title:', 'wp_dictate'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('sub_title'); ?>" name="<?php echo $this->get_field_name('sub_title'); ?>" type="text" value="<?php echo $sub_title; ?>" />
        </p>
        <p>    
            <label for="<?php echo $this->get_field_id('tag_line'); ?>"><?php _e('Tag Line:', 'wp_dictate'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('tag_line'); ?>" name="<?php echo $this->get_field_name('tag_line'); ?>" > <?php echo $tag_line; ?></textarea> 
        </p>
        <?php
    }

}
