<?php
/** A function to fetch the categories from wordpress */
function sh_get_categories($arg = false)
{
	global $wp_taxonomies;
	if( ! empty($arg['taxonomy']) && ! isset($wp_taxonomies[$arg['taxonomy']]))
	{
		register_taxonomy( $arg['taxonomy'], 'sh_'.$arg['taxonomy']);
	}
	
	$categories = get_categories($arg);
	$cats = array();
	$cat[] = __('All Categories', 'wp_dictate');
	foreach($categories as $category)
	{
		$cats[$category->term_id] = $category->name;
	}
	return $cats;
}
function sh_get_sidebars()
{
	global $wp_registered_sidebars;
	$sidebars = !($wp_registered_sidebars) ? get_option('wp_registered_sidebars') : $wp_registered_sidebars;
	
	$data = array('' => __('No Sidebar', 'wp_dictate'));
	foreach( (array)$sidebars as $sidebar)
	{
		$data[sh_set($sidebar, 'id')] = sh_set($sidebar, 'name');
	}
	return $data;
}
if ( ! function_exists('sh_character_limiter'))
{
	function sh_character_limiter($str, $n = 500, $end_char = '&#8230;', $allowed_tags = false)
	{
		if($allowed_tags) $str = strip_tags($str, $allowed_tags);
		if (strlen($str) < $n)	return $str;
		$str = preg_replace("/\s+/", ' ', str_replace(array("\r\n", "\r", "\n"), ' ', $str));
		if (strlen($str) <= $n) return $str;
		$out = "";
		foreach (explode(' ', trim($str)) as $val)
		{
			$out .= $val.' ';
			
			if (strlen($out) >= $n)
			{
				$out = trim($out);
				return (strlen($out) == strlen($str)) ? $out : $out.$end_char;
			}		
		}
	}
}
function get_social_icons()
{
	$t = $GLOBALS['_sh_base'];
	$options = $t->alloption('wp_bistro');//printr($options);
	$icons = array('facebook'=>__('Like us on Facebook', 'wp_dictate'), 'twitter'=>__('Follow us on Twitter', 'wp_dictate'), 'google-plus'=>__('Circle Us on Google Plus', 'wp_dictate'), 'linkedin'=>__('Follow us on Linkedin', 'wp_dictate'), 'xing'=>__('Follow us on Xing', 'wp_dictate'), 'pinterest'=>__('Follow us on Pinterest', 'wp_dictate'));			
	if( $options ):?>
    <ul class="social">
    	<?php foreach( $icons as $i => $str ): ?>
        	<?php if( $url = sh_set( $options, $i ) ): ?>
        		<li><a href="<?php echo $url; ?>" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="<?php echo $str; ?>"><i class="icon-<?php echo $i; ?>"></i></a></li>
        	<?php endif; ?>
        <?php endforeach; ?>
    </ul>
    <?php endif;
	
}
function sh_get_posts_array( $post_type = 'post', $new = false)
{
	global $wpdb;
	$res = $wpdb->get_results( "SELECT `ID`, `post_title` FROM `" .$wpdb->prefix. "posts` WHERE `post_type` = '$post_type' AND `post_status` = 'publish' ", ARRAY_A );
	$return = array();
        if($new == true){
            foreach( $res as $r) $return[] = array('label' => sh_set($r, 'post_title'), 'value' => sh_set($r, 'ID'));
        }else{
            foreach( $res as $r) $return[sh_set($r, 'ID')] = sh_set($r, 'post_title').'-'.sh_set($r, 'ID');
        }

	return $return;
}
if( !function_exists( 'bistro_slug' ) )
{
	function bistro_slug( $string )
	{
		$string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
		return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
	}
}
function get_the_breadcrumb()
{
	global $_webnukes;
	$queried_object = get_queried_object();
	
	$breadcrumb = '';
	if ( ! is_home())
	{
		$breadcrumb .= '<li><a href="'.home_url().'">'.__('Home', 'wp_dictate').'</a></li>';
		
		/** If category or single post */
		if(is_category())
		{
			$breadcrumb .= '<li><span class="divider">/</span><a href="'.get_category_link(get_query_var('cat')).'">'.single_cat_title('', FALSE).'</a></li>';
		}
		elseif(is_tax())
		{
			$breadcrumb .= '<li><span class="divider">/</span><a href="'.get_term_link($queried_object).'">'.$queried_object->name.'</a></li>';
		}
		elseif(is_page()) /** If WP pages */
		{
			global $post;
			if($post->post_parent)
			{
                $anc = get_post_ancestors($post->ID);
                foreach($anc as $ancestor)
				{
                    $breadcrumb .= '<li><span class="divider">/</span><a href="'.get_permalink($ancestor).'">'.get_the_title($ancestor).'</a></li>';
                }
				$breadcrumb .= '<li><span class="divider">/</span>'.get_the_title($post->ID).'</li>';
				
            }else $breadcrumb .= '<li><span class="divider">/</span><a href="'.get_permalink().'">'.get_the_title().'</a></li>';
		}
		elseif (is_singular())
		{
			if($category = wp_get_object_terms(get_the_ID(), array('category', 'wpsc_product_category', 'portfolio_category')))
			{
				if( !is_wp_error($category) )
				{
					$breadcrumb .= '<li><span class="divider">/</span><a href="'.get_term_link(sh_set($category, '0')).'">'.sh_set( sh_set($category, '0'), 'name').'</a></li>';
					$breadcrumb .= '<li><span class="divider">/</span><a href="'.get_permalink().'">'.get_the_title().'</a></li>';
				}
			}else{
				$breadcrumb .= '<li><span class="divider">/</span><a href="'.get_permalink().'">'.get_the_title().'</a></li>';
			}
		}
		elseif(is_tag()) $breadcrumb .= '<li><span class="divider">/</span><a href="'.get_term_link($queried_object).'">'.single_tag_title('', FALSE).'</a></li>'; /**If tag template*/
		elseif(is_day()) $breadcrumb .= '<li><span class="divider">/</span><a href="">'.__('Archive for ', 'wp_dictate').get_the_time('F jS, Y').'</a></li>'; /** If daily Archives */
		elseif(is_month()) $breadcrumb .= '<li><span class="divider">/</span><a href="' .get_month_link(get_the_time('Y'), get_the_time('m')) .'">'.__('Archive for ', 'wp_dictate').get_the_time('F, Y').'</a></li>'; /** If montly Archives */
		elseif(is_year()) $breadcrumb .= '<li><span class="divider">/</span><a href="'.get_year_link(get_the_time('Y')).'">'.__('Archive for ', 'wp_dictate').get_the_time('Y').'</a></li>'; /** If year Archives */
		elseif(is_author()) $breadcrumb .= '<li><a href="'. esc_url( get_author_posts_url( get_the_author_meta( "ID" ) ) ) .'">'.__('Archive for ', 'wp_dictate').get_the_author().'</a></li>'; /** If author Archives */
		elseif(is_search()) $breadcrumb .= '<li><span class="divider">/</span>'.__('Search Results for ', 'wp_dictate').get_search_query().'</li>'; /** if search template */
		elseif(is_404()) $breadcrumb .= '<li><span class="divider">/</span>'.__('404 - Not Found', 'wp_dictate').'</li>'; /** if search template */
		else $breadcrumb .= '<li><span class="divider">/</span><a href="'.get_permalink().'">'.get_the_title().'</a></li>'; /** Default value */
	}
	return '<ul class="breadcrumb">'.$breadcrumb.'</ul>';
}
function sh_register_user( $data )
{
	//printr($data);
	$user_name = sh_set( $data, 'user_login' );
	$user_email = sh_set( $data, 'user_email' );
	$user_pass = sh_set( $data, 'user_password' );
	$policy = sh_set( $data, 'policy_agreed');
	
	$user_id = username_exists( $user_name );
	$message = '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>'.__('You must agreed the policy', 'wp_dictate').'</h5></div>';;
	if( !$policy ) $message = '';
	if ( !$user_id && email_exists($user_email) == false ) {
		if( $policy ){
			$random_password = ( $user_pass ) ? $user_pass : wp_generate_password( $length=12, $include_standard_special_chars=false );
			$user_id = wp_create_user( $user_name, $random_password, $user_email );
			if ( is_wp_error($user_id) && is_array( $user_id->get_error_messages() ) ) 
			{
				foreach($user_id->get_error_messages() as $message)	$message .= '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>'.$message.'</h5></div>';
			}
			else $message = '<div class="alert-success" style="margin-bottom:10px;padding:10px"><h5>'.__('Registration Successful - An email is sent', 'wp_dictate').'</h5></div>';
		}
		
	} else {
		$message .= '<div class="alert-error" style="margin-bottom:10px;padding:10px"><h5>'.__('Username or email already exists.  Password inherited.', 'wp_dictate').'</h5></div>';
	}
	return $message;
}
function sh_comments_list($comment, $args, $depth)
{
	$GLOBALS['comment'] = $comment; ?>
    <li id="">
    
		<div id="comment-<?php comment_ID();?>">
        
			<?php /** check if this comment author not have approved comments befor this */
            if($comment->comment_approved == '0' ) : ?>
                <em><?php /** print message below */
                _e( 'Your comment is awaiting moderation.', 'wp_dictate' ); ?></em>
                <br />
            <?php endif; ?>
            
            <?php echo get_avatar( $comment, 86 ); ?>
            
            <div class="comment-details">
                <h6><?php comment_author(); ?> <span><?php comment_date( get_option( 'date_format' ) );?></span></h6>
                <?php comment_text(); ?>
                <?php /** check if thread comments are enable then print a reply link */
                comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
                
                <span class="replies"><?php esc_html_e('Replies', 'wp_dictate');?></span>
            </div>
            
        </div>
                
	<?php
}
/**
 * Outputs a complete commenting form for use within a template.
 * Most strings and form fields may be controlled through the $args array passed
 * into the function, while you may also choose to use the comment_form_default_fields
 * filter to modify the array of default fields if you'd just like to add a new
 * one or remove a single field. All fields are also individually passed through
 * a filter of the form comment_form_field_$name where $name is the key used
 * in the array of fields.
 *
 * @since 3.0.0
 * @param array $args Options for strings, fields etc in the form
 * @param mixed $post_id Post ID to generate the form for, uses the current post if null
 * @return void
 */
function sh_comment_form( $args = array(), $post_id = null ) {
	if ( null === $post_id )
		$post_id = get_the_ID();
	else
		$id = $post_id;
	$commenter = wp_get_current_commenter();
	$user = wp_get_current_user();
	$user_identity = $user->exists() ? $user->display_name : '';
	$args = wp_parse_args( $args );
	if ( ! isset( $args['format'] ) )
		$args['format'] = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : 'xhtml';
	$req      = get_option( 'require_name_email' );
	$aria_req = ( $req ? " aria-required='true'" : '' );
	$html5    = 'html5' === $args['format'];
	$fields   =  array(
		'author' => '<div class="row-fluid"><div class="comment-form-author span4">' . '<label for="author">' . __( 'Name', 'wp_dictate' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
		            '<input class="input-block-level" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></div>',
		'email'  => '<div class="comment-form-email span4"><label for="email">' . __( 'Email', 'wp_dictate' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
		            '<input class="input-block-level" id="email" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></div>',
		'url'    => '<div class="comment-form-url span4"><label for="url">' . __( 'Website', 'wp_dictate' ) . '</label> ' .
		            '<input class="input-block-level" id="url" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></div></div>',
	);
	$required_text = sprintf( ' ' . __('Required fields are marked %s', 'wp_dictate'), '<span class="required">*</span>' );
	$defaults = array(
		'fields'               => apply_filters( 'comment_form_default_fields', $fields ),
		'comment_field'        => '<div class="row-fluid"><div class="comment-form-comment span12"><label for="comment">' . _x( 'Comment', 'noun', 'wp_dictate' ) . '</label> <textarea class="input-block-level" id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea></div></div>',
		'must_log_in'          => '<p class="must-log-in">' . sprintf( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'wp_dictate' ), wp_login_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
		'logged_in_as'         => '<p class="logged-in-as">' . sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'wp_dictate' ), get_edit_user_link(), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
		'comment_notes_before' => '<p class="comment-notes">' . __( 'Your email address will not be published.', 'wp_dictate' ) . ( $req ? $required_text : '' ) . '</p>',
		'comment_notes_after'  => '<p class="form-allowed-tags">' . sprintf( __( 'You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s', 'wp_dictate' ), ' <code>' . allowed_tags() . '</code>' ) . '</p>',
		'id_form'              => 'commentform',
		'id_submit'            => 'submit',
		'title_reply'          => __( '<i class="theme-icon big comment-icon"></i>Leave a Reply', 'wp_dictate' ),
		'title_reply_to'       => __( 'Leave a Reply to %s', 'wp_dictate' ),
		'cancel_reply_link'    => __( 'Cancel reply', 'wp_dictate' ),
		'label_submit'         => __( 'Post Comment', 'wp_dictate' ),
		'format'               => 'xhtml',
	);
	$args = wp_parse_args( $args, apply_filters( 'comment_form_defaults', $defaults ) );
	?>
		<?php if ( comments_open( $post_id ) ) : ?>
			<?php do_action( 'comment_form_before' ); ?>
			<div id="respond" class="comment-respond message">
				
                <h4 id="reply-title" class="comment-reply-title"><?php comment_form_title( $args['title_reply'], $args['title_reply_to'] ); ?> <small><?php cancel_comment_reply_link( $args['cancel_reply_link'] ); ?></small></h4>
				
				<?php if ( get_option( 'comment_registration' ) && !is_user_logged_in() ) : ?>
					<?php echo $args['must_log_in']; ?>
					<?php do_action( 'comment_form_must_log_in_after' ); ?>
				<?php else : ?>
					<form action="<?php echo site_url( '/wp-comments-post.php' ); ?>" method="post" id="<?php echo esc_attr( $args['id_form'] ); ?>" class="comment-form"<?php echo $html5 ? ' novalidate' : ''; ?>>
						<?php do_action( 'comment_form_top' ); ?>
						<?php if ( is_user_logged_in() ) : ?>
							<?php echo apply_filters( 'comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity ); ?>
							<?php do_action( 'comment_form_logged_in_after', $commenter, $user_identity ); ?>
						<?php else : ?>
							<?php echo $args['comment_notes_before']; ?>
							<?php
							do_action( 'comment_form_before_fields' );
							foreach ( (array) $args['fields'] as $name => $field ) {
								echo apply_filters( "comment_form_field_{$name}", $field ) . "\n";
							}
							do_action( 'comment_form_after_fields' );
							?>
						<?php endif; ?>
						<?php echo apply_filters( 'comment_form_field_comment', $args['comment_field'] ); ?>
						<?php echo $args['comment_notes_after']; ?>
						<p class="form-submit">
							<button class="submit-btn" name="submit" type="submit" id="<?php echo esc_attr( $args['id_submit'] ); ?>" ><?php echo esc_attr( $args['label_submit'] ); ?></button>
							<?php comment_id_fields( $post_id ); ?>
						</p>
						<?php do_action( 'comment_form', $post_id ); ?>
					</form>
				<?php endif; ?>
			</div><!-- #respond -->
			<?php do_action( 'comment_form_after' ); ?>
		<?php else : ?>
			<?php do_action( 'comment_form_comments_closed' ); ?>
		<?php endif; ?>
	<?php
}
function sh_contact_form_submit()
{
	if( !count( $_POST ) ) return;
	
	
	_load_class( 'validation', 'helpers', true );
	$t = &$GLOBALS['_sh_base'];//printr($t);
	$settings = get_option('wp_bistro');
	/** set validation rules for contact form */
	$t->validation->set_rules('contact_name','<strong>'.__('Name', 'wp_dictate').'</strong>', 'required|min_length[4]|max_lenth[30]');
	$t->validation->set_rules('contact_email','<strong>'.__('Email', 'wp_dictate').'</strong>', 'required|valid_email');
	$t->validation->set_rules('contact_message','<strong>'.__('Message', 'wp_dictate').'</strong>', 'required|min_length[5]');
	if( sh_set($settings, 'captcha_status') == 'on')
	{
		if( sh_set( $_POST, 'contact_captcha') !== sh_set( $_SESSION, 'captcha'))
		{
			$t->validation->_error_array['captcha'] = __('Invalid captcha entered, please try again.', 'wp_dictate');
		}
	}
	
	$messages = '';
	
	if($t->validation->run() !== FALSE && empty($t->validation->_error_array))
	{
		
		$name = $t->validation->post('contact_name');
		$email = $t->validation->post('contact_email');
		$message = $t->validation->post('contact_message');
		$contact_to = ( sh_set($settings, 'contact_email') ) ? sh_set($settings, 'contact_email') : get_option('admin_email');
		
		$headers = 'From: '.$name.' <'.$email.'>' . "\r\n";
		wp_mail($contact_to, __('Contact Us Message', 'wp_dictate'), $message, $headers);
		
		$message = sh_set($settings, 'success_message') ? $settings['success_message'] : sprintf( __('Thank you <strong>%s</strong> for using our contact form! Your email was successfully sent and we will be in touch with you soon.','wp_dictate'), $name);
		$messages = '<div class="alert alert-success">
						<p class="title">'.__('SUCCESS! ', 'wp_dictate').$message.'</p>
					</div>';
							
	}else
	{
		 if( is_array( $t->validation->_error_array ) )
		 {
			 foreach( $t->validation->_error_array as $msg )
			 {
				 $messages .= '<div class="alert alert-error">
									<p class="title">'.__('Error! ', 'wp_dictate').$msg.'</p>
								</div>';
			 }
		 }
	}
	
	return $messages;
}
function sh_blog_excerpt_more( $more ) {
	return '';
}
add_filter('excerpt_more', 'sh_blog_excerpt_more');
function _the_pagination($args = array(), $echo = 1)
{
	
	global $wp_query;
	
	$default =  array('base' => str_replace( 99999, '%#%', esc_url( get_pagenum_link( 99999 ) ) ), 'format' => '?paged=%#%', 'current' => max( 1, get_query_var('paged') ),
						'total' => $wp_query->max_num_pages, 'next_text' => __('Next', 'wp_dictate'), 'prev_text' => __('Previous', 'wp_dictate'), 'type'=>'list');
						
	$args = wp_parse_args($args, $default);			
	
	$pagination = '<div class="pagination pagination-left">'.paginate_links($args).'</div>';
	
	if(paginate_links(array_merge(array('type'=>'array'),$args)))
	{
		if($echo) echo $pagination;
		return $pagination;
	}
}
/*function sh_include_file( $path, $args )
{
	if( file_exists( get_template_directory().DIRECTORY_SEPARATOR.$path ) ) 
	include( get_template_directory().DIRECTORY_SEPARATOR.$path );
}*/
function sh_create_donation_table()
{
	global $wpdb;
	$query = "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."donation` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `transID` varchar(30) NOT NULL,
			  `status` varchar(20) NOT NULL,
			  `total` float NOT NULL,
			  `donalID` varchar(30) NOT NULL,
			  `donalName` varchar(120) NOT NULL,
			  `donalEmail` varchar(240) NOT NULL,
			  `note` text NOT NULL,
			  `data` text NOT NULL,
			  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
			  PRIMARY KEY (`id`)
			) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1";
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	$wpdb->query($query);
}
function sh_store_paypal_trans( $data )
{
	global $wpdb;
	$array = array('transID'=>$data->transactionId, 'status'=>$data->status, 'total'=>$data->total, 'donalID'=>$data->buyer->id, 
					'donalName'=>$data->buyer->firstName.' ' .$data->buyer->lastName, 'donalEmail'=>$data->buyer->email, 'note'=>$data->products[0]->name,
					'data'=>serialize($data), 'date'=>date('Y-m-d H:i:s', $data->date )
					);
					
	if($transID = $wpdb->get_row("SELECT `transID` FROM `".$wpdb->prefix."donation` WHERE `transID` = '".$data->transactionId."'")){
		echo '<p class="errormsg donationmsg">The transaction is already in our record.</p>';
	}
	elseif($data->status == 'Completed') {
		$result = $wpdb->insert('fw_donation', $array);
		if($result) echo '<p class="successmsg donationmsg">'.__('Thank you for your donation.',THEME_NAME).'</p>';
	}
	else{
		$result = $wpdb->insert('fw_donation', $array);
		echo '<p class="errormsg donationmsg">'.__('Sorry! unfortunetly the transaction is failed.',THEME_NAME).'</p>';
	}
}
function sh_blog_list_view()
{
	while( have_posts() ): the_post(); ?>
    
    <div class="blog-list">
        <div class="blog-list-img">
            <?php the_post_thumbnail( '770x264' ); ?>
            <div class="grid-hover-icon"><a title="" href="<?php the_permalink(); ?>"><i class="theme-icon chain"></i></a></div>
        </div><!-- Blog List Image -->
        <div class="blog-list-details">
            <div class="blog-post-meta">
            <?php $views = get_post_meta(get_the_ID() , 'sh_dict_views', true); ?>
				<div class="blog-list-date">
                            <i class="icon-calendar"></i><span><?php echo get_the_time('d' , get_the_ID()); ?></span> <?php echo get_the_time('M'  , get_the_ID()); ?> <span><?php echo get_the_time('Y'  , get_the_ID()); ?></span>
                        </div>
              
                <div class="blog-post-views"><?php echo number_format( (int) $views ); ?> <?php _e('views', 'wp_dictate'); ?></div>
            </div>
            <div class="blog-list-desc">
			<br />
                <h3><a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                <ul>
                    <li><i class="theme-icon post-cat"></i><?php _e('Posted in', 'wp_dictate'); ?> &acute;  <?php the_category(); ?></li>
                    <li><i class="theme-icon comments"></i><a title="" href="#"><?php comments_number(); ?></a></li>
                </ul>
                <?php the_excerpt(); ?>
                <?php /*?><a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>" class="continue"><?php _e('Continue Reading', 'wp_dictate');?></a><?php */?>
            </div>
        </div><!-- Blog List Details -->
    </div>
    
    <?php endwhile;
}
function sh_blog_grid_view()
{
	if( have_posts() ):
	while( have_posts() ): the_post();?>
   
        <li>
            <div <?php post_class('blog-list')?>>
                <div class="blog-list-img">
                    <?php the_post_thumbnail('770x264'); ?>
                    <div class="grid-hover-icon"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><i class="theme-icon chain"></i></a></div>
                </div><!-- Blog List Image -->
                <div class="blog-list-details">
                    <div class="blog-post-meta">
                        <div class="blog-list-date">
                            <i class="icon-calendar"></i><span><?php echo get_the_time('d' , get_the_ID()); ?></span> <?php echo get_the_time('M'  , get_the_ID()); ?> <span><?php echo get_the_time('Y'  , get_the_ID()); ?></span>
                        </div>
                        <?php $views = get_post_meta(get_the_ID() , 'sh_dict_views', true); ?>
                        <div class="blog-post-views"><?php echo number_format( sh_post_views() ); ?> <?php _e('views', 'wp_dictate'); ?></div>
                    </div>
                    <div class="blog-list-desc">
					<br />
                        <h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h3>
                        <ul>
                            <li><i class="theme-icon post-cat"></i><?php _e('Posted in', 'wp_dictate');?> &acute;  <?php the_category(', '); ?></li>
                            <li><i class="theme-icon comments"></i><a href="<?php the_permalink(); ?>#comments" title="<?php the_title(); ?>"><?php comments_number(); ?></a></li>
                        </ul>
                        <p><?php echo get_the_excerpt(); ?></p>
                       <?php /*?> /*<a class="continue" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php _e('Continue Reading', 'wp_dictate'); ?></a>*/?>
                    </div>
                </div><!-- Blog List Details -->
            </div>
            
        </li>
						
	<?php endwhile;
	else:?>
		
        <li><p><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'wp_dictate' ); ?></p>
		<?php if( !is_search() ) get_search_form(); ?>
        </li>
        <?php
		
	endif;
}
/*function sh_blog_grid_view()
{
	while( have_posts() ): the_post();?>
    
    <div class="grid-view span4">
        <div class="grid-view-img">
            <?php the_post_thumbnail( '370x195' ); ?>
            <div class="grid-hover-icon"><a title="" href="<?php the_permalink(); ?>"><i class="theme-icon chain"></i></a></div>
        </div>
        <div class="post-date"><i class="theme-icon calender"></i><?php echo get_the_date(); ?></div>
        <h3><a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
        <span class="posted">Posted in; <?php the_category(); ?> </span>
        <?php the_excerpt(); ?>
        <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>" class="continue"><?php _e('Continue Reading', 'wp_dictate');?></a>
    </div>
    
    <?php endwhile;
}*/
function sh_social_sharing()
{
	?>
    <ul>
        <li><a target="_blank" title="<?php _e('Share on Twitter', 'wp_dictate'); ?>" href="https://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php echo urlencode(get_permalink()); ?>&related="><i class="theme-icon twitter"></i></a></li>
        <li><a target="_blank" title="<?php _e('Share on Facebook', 'wp_dictate'); ?>" href="http://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()); ?>&display=popup"><i class="theme-icon facebook"></i></a></li>
        <li><a target="_blank" title="<?php _e('Share on Google Plus', 'wp_dictate'); ?>" href="https://plus.google.com/share?url=<?php echo urlencode(get_permalink()); ?>&t=<?php the_title(); ?>"><i class="theme-icon gplus"></i></a></li>
        
        
        <li><a target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo urlencode(get_permalink()); ?>&amp;title=<?php the_title(); ?>&amp;ro=false&amp;summary=<?php echo sh_cus_excerpt(30); ?>&amp;source=" title=""><i class="theme-icon linkedin"></i></a></li>
    </ul>
    <?php 
}
function sh_grab_video( $url, $opt )
{
	if( !esc_url($url) ) return;
	//$opt = get_post_meta( get_the_ID(), '_dictate_gal_videos', true );
	$key = md5( $url );
	if( sh_set( $opt, $key ) ) return sh_set( $opt, $key );
	
	$grab = new SH_grab( $url );
	$res = $grab->result();
	
	if( $res ) {
		$opt[$key] = sh_set( $res, '0' );
		update_post_meta( get_the_ID(), '_dictate_gal_videos', $opt );
		return sh_set( $res, '0' );
	}
	return false;
}
function sh_post_views()
{
	global $post;
	$id = sh_set($post, 'ID');
	if( !$id ) return;
	
	$meta = get_post_meta( $id, '_dict_post_views', true);
	$views = ( $meta ) ? $meta + 1 : 1;
	
	update_post_meta( $id, '_dict_post_views',  (int)$views ); 
	
	return $views;
}
function sh_google_fonts()
{
	$options = get_option( 'sh_google_fonts_array' );
	if( ! $options ) {
		
		$fp = @fopen( get_template_directory().'/framework/resource/default_fonts', 'r');
		if( !$fp ) return array();
		$read = fread($fp, 1024000);//printr(json_decode($read));
		
	}else return $options;
	
	$return = array();
	$style = array();
	
	if( $items = sh_set( json_decode($read), 'items' ) )
	{
		foreach( $items as $item )
		{
			if( $styles = sh_set( $item, 'variants') ){
				foreach( $styles as $s ) $style[$s] = $s;
			}
			$return[sh_set( $item, 'family' )] = sh_set( $item, 'family' );
		}
	}
	update_option( 'sh_google_fonts_array', array('family'=>$return, 'style'=>$style ) );
	return array('family'=>$return, 'style'=>$style );
}
function sh_theme_color_scheme( $cookie = false )
{
	$opt = get_option('wp_dictate');
	$styles = sh_set($opt, 'theme_general_color_scheme');
        
	$theme_general_color_scheme = sh_set($opt, 'theme_color_scheme');
        
	if( $theme_general_color_scheme ) { 
		//$_COOKIE['sh_color_scheme'] = isset( $_COOKIE['sh_color_scheme'] ) ? $_COOKIE['sh_color_scheme'] : $theme_general_color_scheme;
		echo '<link rel="stylesheet" type="text/css" href="'.get_template_directory_uri().'/css/colors/'.$theme_general_color_scheme.'.css" />';
	
	}else if( $styles ) {
		
		$_COOKIE['sh_color_scheme'] = isset( $_COOKIE['sh_color_scheme'] ) ? $_COOKIE['sh_color_scheme'] : $styles;
		$custom_style = ( $cookie && isset( $_COOKIE['sh_color_scheme'] ) ) ? $_COOKIE['sh_color_scheme'] : $styles;
	
		
		$content = sh_set(wp_remote_request(get_template_directory_uri().'/css/color.css'), 'body');
                
		
		if( $custom_style ){
			$replace = str_replace('#ec4974', $custom_style, $content );
			$replace = str_replace('#ca1d4b', $custom_style, $replace);
			$replace = ( $custom_style ) ? $replace : $content ;
		}else $replace = $content;
		
		$output = "\n".'<style title="sh_color_scheme">'.$replace.'</style>';
		return $output ; 
	}
}
function sh_get_font_settings( $FontSettings = array(), $StyleBefore = '', $StyleAfter = '' )
{
	$i = 1;
	$settings = get_option( 'wp_dictate' );
	$Style = '';
	foreach( $FontSettings as $k => $v )
	{
			if( $v == 'font-size' )
			{
				$Style .= ( sh_set( $settings, $k )  ) ? $v.':'.sh_set( $settings, $k ).'px !important ;': '';
			}else{
				$Style .= ( sh_set( $settings, $k )  ) ? $v.':'.sh_set( $settings, $k ).' !important ;': '';
			}
			
		
	}
	return ( !empty( $Style ) ) ? $StyleBefore.$Style.$StyleAfter: '';
}
function sh_header_settings($settings = array())
{
	//$settings = get_option( 'wp_dictate' );
	$settings = ( $settings ) ? $settings : get_option( 'wp_dictate' );
	
	$return = array();
	$return['responsive'] = ( sh_set( $settings, 'layout_responsive_options' ) == 'true' ) ? true : false;
	
	$return['boxed'] = '';
	
	if( (is_home() || is_front_page()) && sh_set( $settings, 'home_page_boxed_layout_status') == 'true')
		$return['boxed'] = 'boxed';
	elseif(sh_set( $settings, 'boxed_layout_status') == 'true')
		$return['boxed'] = 'boxed';	
	
	if( sh_set($settings, 'layout_responsive_width') && sh_set($return, 'boxed') ) $return['width'] = ' width:'.sh_set($settings, 'layout_responsive_width').'px;'; 
	
	$return['pattern_image'] = ( sh_set( $return, 'boxed' ) && sh_set( $settings, 'layout_patron_image' ) ) ? 'background-image:url('.sh_set( $settings, 'layout_patron_image' ).');' : '';
	
	$return['pattern'] = ( sh_set( $return, 'boxed' ) && !sh_set( $settings, 'layout_patron_image' ) ) ? sh_set( $settings, 'layout_sidebar_patron', 'bg-body1' ) : '';
	
	return $return;
}
function sh_font_awesome( $code = false )
{
	$pattern = '/\.(fa-(?:\w+(?:-)?)+):before/';
	$subject = file_get_contents(get_template_directory().'/css/font-awesome/css/font-awesome.min.css');
	
	preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);
	
	$icons[] = __('No Icon', 'wp_dictate');
	foreach($matches as $match){
		$value = str_replace( 'icon-', '', $match[1] );
		if( $code ) $icons[$match[1]] = stripslashes($match[2]);
		else $icons['fa '.$match[1]] = ucwords(str_replace('-', ' ', $value));//$match[2];
	}
	return $icons;
}
add_action( 'pre_get_posts', 'sh_pre_get_posts' );
function sh_pre_get_posts($query)
{
	if ( !is_admin() && $query->is_main_query() ) {
		if ($query->is_search) {
		  $query->set('post_type', array( 'post', 'dict_gallery', 'dict_faqs', 'dict_testimonial', 'dict_portfolio', 'dict_team', 'dict_event', 'dict_service' ) );
		}
	  }
}
function sh_posts_list()
{
 $args = array(
    'post_type' => 'dict_service',
    'posts_per_page' => -1,
    'post_status' => 'publish',
   );
 $list = array();
 query_posts($args);
 while( have_posts() ): the_post();
  $list[get_the_title()] = get_the_ID();
 endwhile;
 wp_reset_query();
 return $list;
}
function sh_video_image($url){
	$image_url = parse_url($url);
	if($image_url['host'] == 'www.youtube.com' || $image_url['host'] == 'youtube.com'){
		$array = explode("&", $image_url['query']);
		return "http://img.youtube.com/vi/".substr($array[0], 2)."/0.jpg";
	} else if($image_url['host'] == 'www.vimeo.com' || $image_url['host'] == 'vimeo.com'){
		$hash = unserialize(file_get_contents("http://vimeo.com/api/v2/video/".substr($image_url['path'], 1).".php"));
		return $hash[0]["thumbnail_medium"];
	}
}
