<?php
class SH_Taxonomies
{
	function __construct()
	{
		// Hook into the 'init' action
		add_action( 'init', array($this, 'taxonomies'), 0 );
	}
	
	// Register Custom Taxonomy
	function taxonomies()  {
		$labels = array(
			'name'                       => _x( 'Department', 'Categories', 'wp_dictate' ),
			'singular_name'              => _x( 'Department', 'Department', 'wp_dictate' ),
			'menu_name'                  => __( 'Departments', 'wp_dictate' ),
			'all_items'                  => __( 'All Departments', 'wp_dictate' ),
			'parent_item'                => __( 'Parent Department', 'wp_dictate' ),
			'parent_item_colon'          => __( 'Parent Department:', 'wp_dictate' ),
			'new_item_name'              => __( 'New Department Name', 'wp_dictate' ),
			'add_new_item'               => __( 'Add New Department', 'wp_dictate' ),
			'edit_item'                  => __( 'Edit Department', 'wp_dictate' ),
			'update_item'                => __( 'Update Department', 'wp_dictate' ),
			'separate_items_with_commas' => __( 'Separate Departments with commas', 'wp_dictate' ),
			'search_items'               => __( 'Search Departments', 'wp_dictate' ),
			'add_or_remove_items'        => __( 'Add or remove Departments', 'wp_dictate' ),
			'choose_from_most_used'      => __( 'Choose from the most used Departments', 'wp_dictate' ),
		);
	
		$rewrite = array(
			'slug'                       => 'department',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'department', array('dict_team'), $args );
		
		$labels = array(
			'name'                       => _x( 'Department', 'Categories', 'wp_dictate' ),
			'singular_name'              => _x( 'Department', 'Department', 'wp_dictate' ),
			'menu_name'                  => __( 'Departments', 'wp_dictate' ),
			'all_items'                  => __( 'All Departments', 'wp_dictate' ),
			'parent_item'                => __( 'Parent Department', 'wp_dictate' ),
			'parent_item_colon'          => __( 'Parent Department:', 'wp_dictate' ),
			'new_item_name'              => __( 'New Department Name', 'wp_dictate' ),
			'add_new_item'               => __( 'Add New Department', 'wp_dictate' ),
			'edit_item'                  => __( 'Edit Department', 'wp_dictate' ),
			'update_item'                => __( 'Update Department', 'wp_dictate' ),
			'separate_items_with_commas' => __( 'Separate Departments with commas', 'wp_dictate' ),
			'search_items'               => __( 'Search Departments', 'wp_dictate' ),
			'add_or_remove_items'        => __( 'Add or remove Departments', 'wp_dictate' ),
			'choose_from_most_used'      => __( 'Choose from the most used Departments', 'wp_dictate' ),
		);
	
		$rewrite = array(
			'slug'                       => 'services_department',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'services_department', array('dict_service'), $args );
		
		/** Register Portfolio Category */
		
		$labels = array(
			'name'                       => _x( 'Category', 'Categories', 'wp_dictate' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dictate' ),
			'menu_name'                  => __( 'Categories', 'wp_dictate' ),
			'all_items'                  => __( 'All Categories', 'wp_dictate' ),
			'parent_item'                => __( 'Parent Category', 'wp_dictate' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dictate' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dictate' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dictate' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dictate' ),
			'update_item'                => __( 'Update Category', 'wp_dictate' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dictate' ),
			'search_items'               => __( 'Search Categories', 'wp_dictate' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dictate' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dictate' ),
		);
	
		$rewrite = array(
			'slug'                       => 'portfolio_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'portfolio_category', array('dict_portfolio'), $args );
	}
}