<?php

class SH_Shortcodes {

    protected $keys;
    protected $toggle_count = 0;

    function __construct() {
        $GLOBALS['sh_toggle_count'] = 0;
        add_action('init', array($this, 'add'));
    }

    function add() {
        include(SH_FRW_DIR . 'resource/shortcodes.php');
        $this->keys = array_keys($options);
        foreach ($this->keys as $k) {
            if (method_exists($this, $k))
                add_shortcode('sh_' . $k, array($this, $k));
        }
    }

    function services_custom($atts, $content = null) {

        extract(shortcode_atts(array(
            'select_post' => '',
            's1_link' => '',
            's1_number' => '',
                        ), $atts));


        $output = '';
        $output .= '
					<div class="container">
						<div class="row-fluid">			
					';
        //printr($atts);
        $args = array('post_type' => 'dict_service', 'p' => $select_post);

        $posts = query_posts($args);

        if (have_posts()): while (have_posts()): the_post();

                $meta = get_post_meta(get_the_id(), '_dict_service_settings', true);
                $char_limit = (sh_set($meta, 'char_limit')) ? sh_set($meta, 'char_limit') : 150;
                $contents = substr(get_the_excerpt(), 0, (int) $char_limit);
                $span = ($s1_number == 3) ? 'span4' : 'span3';
                $output.='
					<div class="' . $span . '">
						<div class="service">

<div class="creative-service">
 ' . get_the_post_thumbnail(get_the_id(), '235x129') . '
</div>

							

							<div class="creative-service">';

                $output.= '<h3><a href="' . $s1_link . '">' . get_the_title() . '</a></h3>';
                $output.='<p>' . $contents . '</p>
  <a href="' . $s1_link . '" >Read More...</a>



							</div>
						






						</div>
					</div>';
            endwhile;
        endif;
        wp_reset_query();

        $output.='
					
						</div>
					</div>

				

				';

        return $output;
    }

    function faqs($atts, $content = null) {
        extract(shortcode_atts(array(
            'number' => 10,
            'sort' => 'date'
                        ), $atts));

        $query = new WP_Query('post_type=dict_faqs&showposts=' . $number . '&sortby=' . $sort . '');
        $output = '';
        $count = 0;
        while ($query->have_posts()): $query->the_post();
            $class = ( $count == 0 ) ? 'class="active"' : '';
            $o_class = ( $count == 0 ) ? 'class="opened"' : '';

            $output .= '<dt><a href="javascript:void(0);" ' . $class . '>' . get_the_title() . '</a></dt>
						<dd style="" ' . $o_class . '>' . apply_filters('the_content', get_the_content()) . '</dd>';
            $count++;
        endwhile;
        return '<dl class="accordions">' . $output . '</dl>';
    }

    function skills($atts, $content = null) {
        extract(shortcode_atts(array(
            'name' => 'Skill Type 1',
            'skill' => '70',
            'class' => 'rounded'
                        ), $atts));

        $output = '';
        $output .= '<h4>' . $name . '</h4>
					<span>' . $skill . '%</span>
					<div class="progress">
						<div class="bar" style="width: ' . $skill . '%;"></div>
					</div>';
        return '<div class="our-skill ' . strtolower($class) . '">' . $output . '</div>';
    }

    function toggle($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'icon' => '',
            'content_' => '',
            'acc_style' => '',
            'first' => false,
            'last' => false,
                        ), $atts));
        $opened = ( $first == 'True' ) ? 'opened' : '';

        $output = '';
        $i = ($icon) ? '<i class="' . $icon . '"></i>' : '';
        $simple_class = ($acc_style == 'simple') ? 'accordion-simple' : '';
        if ($first == 'True')
            $output .= '<dl class="accordions ' . $simple_class . '">';
        $output .= '<dt><a href="">' . $i . $title . '</a></dt>';
        $output .= '<dd class="' . $opened . '" ><p>' . $content . '</p></dd>';
        if ($last == 'True')
            $output .='</dl>';

        return $output;
    }

    function price_table($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'sub_title' => '',
            'currency' => '',
            'price' => '',
            'duration' => '',
            'image' => '',
            'option1' => '',
            'option2' => '',
            'option3' => '',
            'option4' => '',
            'link' => ''
                        ), $atts));

        $output = '';
        $image_src = wp_get_attachment_image_src($image, "245x130");
        $output .= '<ul>';
        $output .= '<li class="table-img"><img alt="" src="' . sh_set($image_src, 0) . '"></li>';
        $output .= '<li class="price-head"><h3>' . $title . '</h3><p>' . $sub_title . '</p></li>';
        $output .= '<li class="year">' . $currency . ' ' . $price . '<span>' . $duration . '</span></li>';
        $output .= '<li>' . $option1 . '</li><li>' . $option2 . '</li><li>' . $option3 . '</li><li>' . $option4 . '</li>';
        $output .= '<li class="subscribe"><a href="' . $link . '"><button>Subscribe</button></a></li>';
        $output .= '</ul>';
        return $output;
    }

    function alert_box($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'message' => '',
            'type' => 'success'
                        ), $atts));

        $output = '';

        $output .= '<div class="alertbox ' . $type . '"><span class="close">x</span>';
        $output .= '<i class="theme-icon big ' . $type . '-icon"></i>' . $title . '</h5>';
        $output .= '<p>' . $message . '</p>';
        $output .='</div>';

        return $output;
    }

    function button($atts, $content = null) {
        extract(shortcode_atts(array(
            'text' => '',
            'size' => 'large',
            'color' => 'cyan',
            'shadow' => 'none',
            'link' => ''
                        ), $atts));

        $output = '';
        $output .= '<a class="button ' . $size . ' ' . $color . ' ' . $shadow . '" title="" href="' . $link . '">' . $text . '</a>';
        return $output;
    }

    function recent_posts($atts, $content = null) {
        wp_enqueue_script(array('jquery-tinycarousel-min'));
        extract(shortcode_atts(array(
            'title' => __('Recent <span>Posts</span>', 'wp_dictate'),
            'number' => '',
            'category' => ''
                        ), $atts));

        $output = '';
        $output .= '<div class="recent-posts"><div class="main-title first"><h3>' . $title . '</h3></div></div>';
        $output.= '<div id="slider3"><a href="#" class="buttons next"></a><a href="#" class="buttons prev"></a><div class="viewport">
        <ul class="overview">';

        query_posts('cat=' . $category . '&posts_per_page=' . $number . '');

        if (have_posts()): while (have_posts()): the_post();
                $content = substr(strip_tags(get_the_content()), 0, 30);
                $output.='<li>
		
					<div class="post-img">' . get_the_post_thumbnail() . '
						<a title="" href="' . get_permalink() . '" class="recent-post-link"><i class="theme-icon chain"></i></a>
					</div>
					
					<h6><a title="" href="' . get_permalink() . '">' . substr(get_the_title(), 0, 40) . '</a></h6>
					
				</li>';
            endwhile;
        endif;
        wp_reset_query();
        $output .='
				</ul>
			</div>
		</div>';

        return $output;
    }

    function appointment_dropdown($atts, $content = null) {
        extract(shortcode_atts(array(
            'name' => '',
                        ), $atts));

        $output = '';
        $output .= '<div class="container">
						<div class="make-app-toggle">
							<div class="make-app click">
								<div class="app-button">' . $name . '</div>
							</div>
							<div class="make-app-form" style="">
								<form name="dict_appointment" id="dict_appointment" class="row-fluid" action="' . admin_url('admin-ajax.php?action=dictate_ajax_callback&subaction=sh_appointment_form_submit') . '">
									<div class="span4">
										<input name="appointment_name" type="text" placeholder="' . __('Full Name', 'wp_dictate') . '" class="input-block-level">
										<input name="appointment_phone" type="text" placeholder="' . __('Phone Number', 'wp_dictate') . '" class="input-block-level">
									</div>
									<div class="span4">
										<input name="appointment_email" type="email" placeholder="' . __('Email', 'wp_dictate') . '" class="input-block-level">
										
										<input name="appointment_email2" type="email" placeholder="' . __('2nd Email', 'wp_dictate') . '" class="input-block-level">
										<input name="appointment_date" type="text" placeholder="' . __('App Date', 'wp_dictate') . '" class="datepicker small-field app-date" id="popupDatepicker">
										<input name="appointment_time" type="text" placeholder="' . __('App Time', 'wp_dictate') . '" class="timepicker small-field app-time">
									</div>
									<div class="span4">
										<textarea name="appointment_description" placeholder="' . __('Description', 'wp_dictate') . '" class="input-block-level"></textarea>
									</div>
									<p>' . $content . '</p>
									<input type="submit" value="' . __('Submit Now', 'wp_dictate') . '" class="app-form-submit">
									<div class="msgs"></div>
								</form>
							</div>
						</div>
					</div>
				';
        return $output;
    }

    function appointment_sidebox($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Ready To Serve You Happily', 'wp_dictate'),
            'name' => __('Appointment Box', 'wp_dictate'),
            'text' => '',
                        ), $atts));
        $output = '';
        $output .= '<div class="sidebox">
					  <div class="sidebox-head">
						<h2>' . $name . '<span>' . $title . '</span></h2>
					  </div>
					  <div class="sidebox-body">
						<p> ' . $text . '</p>
						<form id="dict_appointment" class="appointment-form" action="' . admin_url('admin-ajax.php?action=dictate_ajax_callback&subaction=sh_appointment_form_submit') . '">
						<div class="msgs"></div>
						  <input name="appointment_name" type="text" placeholder="' . __('Name Of Patient', 'wp_dictate') . '" class="full">
						  <span class="half-fields">
						  <input name="appointment_phone" type="text" placeholder="' . __('Phone No', 'wp_dictate') . '" class="half">
						  <input type="text" placeholder="' . __('Doctor Name', 'wp_dictate') . '" class="half">
						  </span>
						  <input name="appointment_email" type="email" placeholder="' . __('Email', 'wp_dictate') . '" class="full">
						  <span class="half-fields">
						  <input  name="appointment_date" type="text" placeholder="' . __('Date', 'wp_dictate') . '" class="half">
						  <input  name="appointment_time" type="text" placeholder="' . __('Time', 'wp_dictate') . '" class="half">
						  </span>
						  <input name="appointment_description" type="text" placeholder="' . __('Additional Info', 'wp_dictate') . '" class="full">
						  <input type="submit" value="' . __('Submit', 'wp_dictate') . '" class="submit">
						</form>
					  </div>
				</div>
				';
        return $output;
    }

    function appointment_sidebox_2($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Ready To Serve You Happily', 'wp_dictate'),
            'text' => '',
            'title_style' => '',
            'tag_line' => ''
                        ), $atts));

        $output = '';
        $output = ($title_style == 'simple') ? '<div class="col-title"><h2>' . $title . '</h2></div>' : '<div class="gray-title"><span><i class="fa fa-search"></i></span><h3>' . $title . '</h3><h5>' . $tag_line . '</h5></div>';
        $output.='<div class="appointment-gray">';
        $output.= ($text) ? '<p>' . $text . '</p>' : '';
        $output.='<form id="dict_appointment" class="appointment-form" action="' . admin_url('admin-ajax.php?action=dictate_ajax_callback&subaction=sh_appointment_form_submit') . '">
						<div class="msgs"></div>
						<div class="row-fluid">
							<div class="span12">
								<span><i class="fa fa-user"></i></span><input  name="appointment_name" type="text" placeholder="' . __("Name Of Patient", 'wp_dictate') . '">
							</div>
						</div>	
						<div class="row-fluid">
							<div class="span6">
								<span><i class="fa fa-mobile-phone"></i></span><input name="appointment_phone" type="text" placeholder="' . __("Phone Number", 'wp_dictate') . '">
							</div>
							<div class="span6">
								<span><i class="fa fa-user-md"></i></span><input type="text" placeholder="' . __("Doctor Name", 'wp_dictate') . '">
							</div>
						</div>	
						<div class="row-fluid">
							<div class="span12">
								<span><i class="fa fa-envelope"></i></span><input name="appointment_email" type="email" placeholder="' . __("Email", 'wp_dictate') . '">
							</div>
						</div>	
						<div class="row-fluid">
							<div class="span6">
								<span><i class="fa fa-calendar"></i></span><input name="appointment_date" type="text" placeholder="' . __("Date", 'wp_dictate') . '">
							</div>
							<div class="span6">
								<span><i class="fa fa-clock-o"></i></span><input name="appointment_time" type="text" placeholder="' . __("Time", 'wp_dictate') . '">
							</div>
						</div>	
						<div class="row-fluid">
							<div class="span12">
								<span><i class="fa fa-user"></i></span><input name="appointment_description" type="text" placeholder="' . __("Additional Info", 'wp_dictate') . '">
							</div>
						</div>
						<input type="submit" value="' . __("submit", 'wp_dictate') . '">
						</form>
					</div>';
        return $output;
    }

    function time_table($atts, $content = null) {
        extract(shortcode_atts(array(
            'name' => '',
            'tt_days' => '',
                        ), $atts));

        $days_arr = explode(',', $tt_days);

        $days = array();
        if (in_array('sh_timetable', $days_arr)) : $days['sh_timetable'] = __("Sunday", 'wp_dictate');
        endif;
        if (in_array('sh_monday', $days_arr)) : $days['sh_monday'] = __("Monday", 'wp_dictate');
        endif;
        if (in_array('sh_tuesday', $days_arr)) : $days['sh_tuesday'] = __("Tuesday", 'wp_dictate');
        endif;
        if (in_array('sh_wednesday', $days_arr)) : $days['sh_wednesday'] = __("Wednesday", 'wp_dictate');
        endif;
        if (in_array('sh_thursday', $days_arr)) : $days['sh_thursday'] = __("Thursday", 'wp_dictate');
        endif;
        if (in_array('sh_friday', $days_arr)) : $days['sh_friday'] = __("Friday", 'wp_dictate');
        endif;
        if (in_array('sh_saturday', $days_arr)) : $days['sh_saturday'] = __("Saturday", 'wp_dictate');
        endif;
        $output = '<div class="tabbable gallery-tabs">';
        $output .= '<ul class="nav nav-tabs">';
        $count = 1;
        foreach ($days as $k => $v) {
            $active = ( $count == 1 ) ? 'active' : '';
            $output .= '<li class="' . $active . '"><a href="#' . $k . '" data-toggle="tab">' . $v . '</a></li>';

            $count ++;
        }
        $output .= '</ul>';
        $output .= '<div class="tab-content">';
        $count = 1;

        foreach ($days as $d => $value) {
            $active = ( $count == 1 ) ? ' active' : ' fade';
            $output.='
				
				<div class="tab-pane fade in' . $active . '" id="' . $d . '"><div class="timetable">';

            $option = (get_option($d)) ? get_option($d) : array();
            if (!empty($option)) {
                foreach (sh_set($option, 'field') as $index => $op) {

                    $post_meta = get_post_meta(sh_set($op, 'member'), '_dict_team_settings', true);

                    $member_info = get_post(sh_set($op, 'member'));

                    $output .='
					
						<div class="doc-time">
							<div class="doc-time-img">
								' . get_the_post_thumbnail(sh_set($op, 'member'), '470x522') . '
								<a title="" rel="prettyPhoto[ajax]" href="' . admin_url('admin-ajax.php?action=dictate_ajax_callback&subaction=appointment_form&ajax=true') . '" class="html5lightbox">
									<div class="doc-time-hover">
										<img alt="" src="' . get_template_directory_uri() . '/img/appointment-icon.png">
										' . __('Appointment', 'wp_dictate') . '
									</div>
								</a>
							</div>
							<div class="doc-details">
								<ul>
									<li class="head"><a href="' . get_permalink(sh_set($member_info, 'ID')) . '"><i class="theme-icon user"></i>' . sh_set($member_info, 'post_title') . '</a></li>
									<li><i class="theme-icon tool"></i>' . sh_set($post_meta, 'designation') . '</li>
									<li><i class="theme-icon clock"></i>' . sh_set($op, 'start_time') . ' - ' . sh_set($op, 'end_time') . '</li>
									<li><i class="theme-icon home"></i>' . get_the_term_list($member_info->ID, 'department', '', ', ') . '</li>
								</ul>
							</div>
							<div class="share-bar">
								<p>' . __('Share Us', 'wp_dictate') . '</p>
								<ul>
									<li><a title="" href="mailto:' . sh_set($post_meta, 'email') . '"><i class="theme-icon mail"></i></a></li>
									<li><a title="" href="' . esc_url(sh_set($post_meta, 'twitter')) . '"><i class="theme-icon twitter"></i></a></li>
									<li><a title="" href="' . esc_url(sh_set($post_meta, 'facebook')) . '"><i class="theme-icon facebook"></i></a></li>
									<li><a title="" href="' . esc_url(sh_set($post_meta, 'gplus')) . '"><i class="theme-icon gplus"></i></a></li>
								</ul>
							</div>
	
					</div>';

                    $count++;
                }
            }
            $output .='</div></div>';
        }

        $output .= '</div></div>';
        return $output;
    }

    function time_table_2($atts, $content = null) {
        extract(shortcode_atts(array(
            'name' => '',
            'slogan' => '',
            'view_all_link' => '',
            'tt_days' => '',
                        ), $atts));

        $days_arr = explode(',', $tt_days);
        $days = array();
        if (in_array('sh_timetable', $days_arr)) : $days['sh_timetable'] = __("Sunday", 'wp_dictate');
        endif;
        if (in_array('sh_monday', $days_arr)) : $days['sh_monday'] = __("Monday", 'wp_dictate');
        endif;
        if (in_array('sh_tuesday', $days_arr)) : $days['sh_tuesday'] = __("Tuesday", 'wp_dictate');
        endif;
        if (in_array('sh_wednesday', $days_arr)) : $days['sh_wednesday'] = __("Wednesday", 'wp_dictate');
        endif;
        if (in_array('sh_thursday', $days_arr)) : $days['sh_thursday'] = __("Thursday", 'wp_dictate');
        endif;
        if (in_array('sh_friday', $days_arr)) : $days['sh_friday'] = __("Friday", 'wp_dictate');
        endif;
        if (in_array('sh_saturday', $days_arr)) : $days['sh_saturday'] = __("Saturday", 'wp_dictate');
        endif;
        $output = '
		<div class="boxes-left">
			<div class="sidebox-head">
				<h2>' . $name . '<span>' . $slogan . '</span></h2>
			</div>
			<div class="tab-pane fade active in" id="timetable">
				<div class="tabbable timetable-tabs tabs-below">';
        $output .= '
					<ul class="nav days nav-tabs">';
        $count = 1;
        foreach ($days as $k => $v) {

            if ($count == 1)
                $active = 'active';
            else
                $active = '';
            $output .= '
						<li class="' . $active . '"><a href="#' . $k . '" data-toggle="tab">' . $v . '</a></li>';
            $count++;
        }
        $output .= '
					</ul>';
        $output .= '
					<div class="tab-content">';
        $count = 1;
        foreach ($days as $d => $value) {
            if ($count == 1)
                $active = 'active';
            else
                $active = '';
            $output.='
				
						<div class="tab-pane ' . $active . '" id="' . $d . '">
							<div class="doctors-time">';
            $option = get_option($d); //printr(sh_set($option, 'field'));
            if(!empty($option)){
                foreach (sh_set($option, 'field') as $index => $op) {
                    if ($index > 4)
                        continue;

                    $post_meta = get_post_meta(sh_set($op, 'member'), '_dict_team_settings', true);
                    $member_info = get_post(sh_set($op, 'member'));
                    $output .='
                                                                    <div class="doc">
                                                                            <div class="doc-img">
                                                                                    ' . get_the_post_thumbnail(sh_set($op, 'member'), 'thumbnail') . '
                                                                            </div>
                                                                            <div class="caption">
                                                                                    <h5><i class="theme-icon user-small"></i><a href="' . get_permalink(sh_set($member_info, 'ID')) . '">' . sh_set($member_info, 'post_title') . '</a></h5>
                                                                                    <h5><i class="theme-icon tool"></i>' . sh_set($post_meta, 'designation') . '</h5>
                                                                                    <h5><i class="theme-icon clock"></i>' . date('h:i a', strtotime(sh_set($op, 'start_time'))) . ' - ' . date('h:i a', strtotime(sh_set($op, 'end_time'))) . '</h5>
                                                                            </div> 
                                                                    </div>';
                }
            }
            $output .='
								<a title="" href="' . $view_all_link . '">' . __('View All', 'wp_dictate') . '</a>
							</div>
						</div>';
            $count++;
        }
        $output .= '
				</div>
				</div>
			</div>
    	</div>';
        return $output;
    }

    function services_1($atts, $content = null) {
        extract(shortcode_atts(array(
            's1_number' => '',
            'cat' => '',
            'sort' => 'date',
            'linked' => '',
                        ), $atts));

        $output = '';
        $output .= '<section class="service-new">
					<div class="container">
						<div class="row-fluid">			
					';
        //printr($atts);
        $args = array('post_type' => 'dict_service', 'posts_per_page' => $s1_number, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'services_department', 'field' => 'id', 'terms' => (int) $cat));
        $posts = new WP_Query($args);
        if ($posts->have_posts()): while ($posts->have_posts()): $posts->the_post();
                $meta = get_post_meta(get_the_id(), '_dict_service_settings', true);
                $char_limit = (sh_set($meta, 'char_limit')) ? sh_set($meta, 'char_limit') : 150;
                $contents = substr(get_the_excerpt(), 0, (int) $char_limit);
                $span = ($s1_number == 3) ? 'span4' : 'span3';
                if (sh_set($meta, 'font')) {
                    $fa = 'fa';
                } else {
                    $fa = '';
                }
                $output.='
					<div class="' . $span . '">
						<div class="service">
							<div class="service-icon"><i class="' . $fa . ' ' . sh_set($meta, 'font', 'fa fa-globe') . '" style="color:' . sh_set($meta, 'color', '#32a2b1') . '" ></i></div>
							<div class="service-desc">';
                $output.= ($linked == 'yes') ? '<h3><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>' : '<h3>' . get_the_title() . '</h3>';
                $output.='<p>' . $contents . '</p>
							</div>
						
						</div>
					</div>';
            endwhile;
        endif;
        wp_reset_query();
        $output.='
					
						</div>
					</div>
				</section>
				';
        return $output;
    }

    function services_2($atts, $content = null) {
        extract(shortcode_atts(array(
            'cat' => '',
            'sort' => 'date',
            'linked' => '',
                        ), $atts));

        $output = '';
        $output .= '<section class="cols">
				<div class="container">
					<div class="service-block">';

        $args = array('post_type' => 'dict_service', 'posts_per_page' => 3, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'services_department', 'field' => 'id', 'terms' => $cat));

        query_posts($args);

        if (have_posts()): while (have_posts()): the_post();
                $meta = get_post_meta(get_the_ID(), '_dict_service_settings', true);
                $char_limit = (sh_set($meta, 'char_limit')) ? (int) sh_set($meta, 'char_limit') : 150;

                $contents = substr(get_the_excerpt(), 0, (int) $char_limit);
                $output.='
						<div class="span4">
						<i class="' . sh_set($meta, 'font', 'fa fa-globe') . '" style="color:' . sh_set($meta, 'color', '#32a2b1') . '" ></i>';
                $output.= ($linked == 'yes') ? '<h3><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>' : '<h3>' . get_the_title() . '</h3>';
                $output.='
							<p>' . $contents . '</p>
						</div>';
            endwhile;
        endif;
        wp_reset_query();
        $output.='
				</div>
			</div></section>
			';
        return $output;
    }

    function services_3($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'subtitle' => '',
            'cat' => '',
            'sort' => 'date',
            'linked' => '',
                        ), $atts));

        $output = '';
        $output .= '<section class="pattern2" id="simple-services">
						<div class="title">
							<div class="container">
								<h2>' . $title . ' <span class="slogan">' . $subtitle . '</span></h2>
							</div>
						</div>
						<div class="container">
							<div>';

        $args = array('post_type' => 'dict_service', 'posts_per_page' => 3, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'services_department', 'field' => 'id', 'terms' => $cat));
        query_posts($args);

        if (have_posts()): while (have_posts()): the_post();
                $meta = get_post_meta(get_the_ID(), '_dict_service_settings', true);
                $char_limit = (sh_set($meta, 'char_limit')) ? sh_set($meta, 'char_limit') : 150;
                $contents = substr(get_the_excerpt(), 0, $char_limit);
//printr($meta);
                $output.='
								<div class="service-box span4">
									<div class="service-box-img">
									<a href="' . get_permalink() . '"><i class="' . sh_set($meta, 'font', 'fa fa-globe') . '" style="color:' . sh_set($meta, 'color', '#32a2b1') . '" ></i></a>
									</div>';
                $output.= '<h3><a href="' . get_permalink() . '">' . get_the_title() . '</h3></a>';
                $output.='<p>' . $contents . '</p>
								</div>	';
            endwhile;
        endif;
        wp_reset_query();
        $output.='
							</div>
						</div>
					</section>
					';
        return $output;
    }

    function services_4($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('The Expert Services', 'wp_dictate'),
            'subtitle' => '',
            'cat' => '',
            'sort' => 'date',
            'img' => '',
            'linked' => '',
                        ), $atts));

        $args = array('post_type' => 'dict_service', 'posts_per_page' => 3, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'services_department', 'field' => 'id', 'terms' => $cat));

        query_posts($args);


        $Record = '';
        $i = 1;

        if (have_posts()): while (have_posts()): the_post();

                $PostClass = ( $i == 1 ) ? 'toggle activate' : 'toggle';

                $Name = ( isset($Settings['name']) && !empty($Settings['name']) ) ? '<a title="" href="' . get_permalink() . '"><i class="theme-icon views-white"></i>By: ' . $Settings['name'] . '</a>' : '';
                $meta = get_post_meta(get_the_ID(), '_dict_service_settings', true);
                $char_limit = (sh_set($meta, 'char_limit')) ? sh_set($meta, 'char_limit') : 150;
                $contents = substr(get_the_excerpt(), 0, $char_limit);

                $Record .= '<div class="' . $PostClass . '">
					  <div class="toggle-inside">
						<div class="toggle-title"> 
							<div class="circle"><i class="toggle-icon fa fa-th-large ' . sh_set($meta, 'font', 'fa fa-glass') . '"></i></div>';
                $Record.= ($linked == 'yes') ? '<h3><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>' : '<h3>' . get_the_title() . '</h3>';
                $Record.='</div>
						<div class="toggle-img"> ' . get_the_post_thumbnail(get_the_ID(), "670x465") . ' </div>
						<div class="toggle-detail">
						  <div>
							<p>' . $contents . '</p>
						  </div>
						</div>
					  </div>
					</div>';
                $i++;
            endwhile;
        endif;
        wp_reset_query();
        $img_src = ($img) ? sh_set(wp_get_attachment_image_src($img, 'full'), 0) : '';
        $style = ($img_src) ? 'style=" background-image:url(' . $img_src . ')"' : '';
        $output = '<section id="services-toggles">
					<div class="fixed-img section-bg2" ' . $style . '></div>
					<div class="title">
					  <div class="container">
						<h2>' . $title . ' <span class="slogan">' . $subtitle . '</span></h2>
					  </div>
					</div>
					<div class="toggles-style">
					  <div class="container">
					    ' . $Record . '
					  </div>
					</div>
				  </section>';
        return $output;
    }

    function services_5($atts, $content = null) {
        extract(shortcode_atts(array(
            'number' => 3,
            'cat' => '',
            'sort' => 'date',
            'linked' => '',
                        ), $atts));

        $args = array('post_type' => 'dict_service', 'posts_per_page' => $number, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'services_department', 'field' => 'id', 'terms' => $cat));

        $Posts = query_posts($args);

        $TotalPosts = count($Posts);
        $PostBatch = 3;
        $output = '';
        $i = 1;
        $EndingTagAppended = FALSE;
        $StrtingTag = '<section class="cols services-modern">';
        $StrtingTag .= '  <div class="container">';
        $StrtingTag .= '    <div class="row-fluid">';
        $CloseTag = '    </div>';
        $CloseTag .= '  </div>';
        $CloseTag .= '</div>';

        foreach ($Posts as $Psot) {
            $NewSecStrtTag = ( $TotalPosts < $PostBatch || $i == 1 || $EndingTagAppended === TRUE ) ? $StrtingTag : '';
            $NewSecCloseTag = ( $i == $TotalPosts || ( $TotalPosts < $PostBatch && $i == $TotalPosts ) || ( $i % $PostBatch == 0 && $i !== 1 ) ) ? $CloseTag : '';
            $EndingTagAppended = ( $i == $TotalPosts || ( $TotalPosts < $PostBatch && $i == $TotalPosts ) || ( $i % $PostBatch == 0 && $i !== 1 ) ) ? TRUE : FALSE;
            $meta = get_post_meta($Psot->ID, '_dict_service_settings', true);
            $output .= $NewSecStrtTag .
                    '<div class="span4"> <i class="' . sh_set($meta, 'font', 'fa fa-globe') . '"></i>';
            $output.= ($linked == 'yes') ? '<h3><a href="' . get_permalink($Psot->ID) . '">' . get_the_title($Psot->ID) . '</a></h3>' : '<h3>' . get_the_title($Psot->ID) . '</h3>';
            $output.= '<p>' . apply_filters('the_content', $Psot->post_content) . '</p>
						</div>' .
                    $NewSecCloseTag;
            $i++;
        }
        wp_reset_query();
        return $output;
    }

    function services_6($atts, $content = null) {
        global $posts;
        wp_enqueue_script(array('carouFredSel-6.2.1', 'jquery.touchSwipe.min', 'jquery.mousewheel.min'));
        extract(shortcode_atts(array(
            'number' => '8',
            'cat' => '',
            'sort' => 'date',
            'bg' => '',
            'linked' => '',
                        ), $atts));
        $args = array('post_type' => 'dict_service', 'showposts' => $number, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'services_department', 'field' => 'id', 'terms' => $cat));
        $Posts = query_posts($args); //printr($Posts);
        $newposts = array_chunk($Posts, 4);
        $Records = '';
        foreach ($newposts as $Psot) {
            $Records .= '<li>';
            foreach ($Psot as $p) {
                $meta = get_post_meta(sh_set($p, 'ID'), '_dict_service_settings', true);
                $Records .=
                        '<div class="span3">
								<div class="our-service-box">';
                $Records.= ($linked == 'yes') ? '<h3><a href="' . get_permalink(sh_set($p, 'ID')) . '">' . get_the_title(sh_set($p, 'ID')) . '</a></h3>' : '<h3>' . get_the_title() . '</h3>';
                $Records.='<i style="color:' . sh_set($meta, 'color', '#32a2b1') . '" class="' . sh_set($meta, 'font') . '"></i>
								  <p>' .sh_character_limiter(sh_set($p, 'post_content'), 130) . '</p>
								</div>
							 </div>';
            }
            $Records .= '</li>';
        }
        wp_reset_query();

        $attach = ($bg) ? wp_get_attachment_image_src($bg, 'large') : '';
        $backg = ( $attach ) ? 'background-image:url(' . sh_set($attach, 0) . ');' : '';

        $output = '<section class="rounded-bg">
					<div class="fixed-bg fixed-bg1" style="' . $backg . '"></div>
					<div class="container">
					  <div class="list_carousel6"> 
					  	<a id="prev5" class="service-pagi prev" href="#" style="display: block;"></a>
						<a id="next5" class="service-pagi next" href="#" style="display: block;"></a>
						
						  <ul id="special-services" >
							' . $Records . '
						  </ul>
						
						<div class="clearfix"></div>
					  </div>
					</div>
				  </section>';

        $output .= '<script type="text/javascript">
					/*** Document Ready Function ***/
					jQuery(document).ready(function($){
						jQuery(\'#special-services\').carouFredSel({
							auto: false,
							prev: \'#prev5\',
							next: \'#next5\',
							mousewheel: true,
							
							swipe: {
								onMouse: true,
								onTouch: true
							}
						});
					});
					</script>';
        return $output;
    }

    function our_staff_slider($atts, $content = null) {
        global $posts;
        wp_enqueue_script('jquery-tinycarousel-min');

        extract(shortcode_atts(array(
            'number' => 4,
            'name' => "",
            'cat' => '',
            'sort' => 'date'
                        ), $atts));

        $output = '';
        $output .= '
		
			<div class="col-title">
				<h2>' . $name . '</h2>
			</div>
			<div id="slider4">
				<a class="buttons next" href="#"></a>
				<a class="buttons prev" href="#"></a>
				<div class="viewport">
					<ul class="overview">';

        $args = array('post_type' => 'dict_team', 'posts_per_page' => $number, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'department', 'field' => 'id', 'terms' => $cat));

        $team_posts = query_posts($args);
        if(!empty($team_posts)){
            $_posts = array_chunk($team_posts, 2);

            foreach ($_posts as $_post_chunk) {
                //printr($_post_chunk);
                $output.='<li>';
                foreach ($_post_chunk as $_post) {
                    $post_meta = get_post_meta($_post->ID, '_dict_team_settings', true);
                    //printr($post_meta);
                    $output.='
                                                            <div class="staff">
                                                                    <div class="blog-list-img">
                                                                            ' . get_the_post_thumbnail($_post->ID, '400x240') . '
                                                                            <div class="grid-hover-icon"><a title="" href="' . get_permalink($_post->ID) . '"><i class="theme-icon chain"></i></a></div>
                                                                    </div>
                                                                    <div class="staff-intro">
                                                                            <h3><a href="' . get_permalink(sh_set($_post, 'ID')) . '">' . sh_set($_post, 'post_title') . '</a></h3>
                                                                            <span>' .
                            sh_set($post_meta, 'designation') . '</span>
                                                                    </div>
                                                                    <p>' . substr(strip_tags(sh_set($_post, 'post_content')), 0, 105) . '</p>
                                                            </div>';
                }
                $output.='
                                                    </li>';
            }
        }
        $output.='
					</ul>
				</div>
			</div>';
        wp_reset_query();
        return $output;
    }

    function our_staff_slider_2($atts, $content = null) {
        global $posts;
        wp_enqueue_script(array('owl.carousel.min'));
        extract(shortcode_atts(array(
            'number' => 4,
            'name' => "",
            'cat' => '',
            'sort' => 'date'
                        ), $atts));
        $output = '';
        $output .= '
			<div class="col-title">
				<h2>' . $name . '</h2>
			</div>
			<div class="staff-carousel">';
        $args = array('post_type' => 'dict_team', 'posts_per_page' => $number, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'department', 'field' => 'id', 'terms' => $cat));
        $posts = query_posts($args);
        $_posts = array_chunk($posts, 2);
        foreach ($_posts as $_post_chunk) {
            //printr($_post_chunk);
            $output.='<div class="staff-slide">
						<div class="row-fluid">';
            foreach ($_post_chunk as $_post) {
                $post_meta = get_post_meta($_post->ID, '_dict_team_settings', true);
                //printr($post_meta);
                $output.='<div class="span6">
								<div class="staff-member">
								<div class="staff-member-img">
									' . get_the_post_thumbnail($_post->ID, '140x140') . '
									<ul>';
                $output.= (sh_set($post_meta, 'twitter')) ? '<li><a href="' . sh_set($post_meta, 'twitter') . '" title=""><i class="fa fa-twitter"></i></a></li>' : '';
                $output .= (sh_set($post_meta, 'facebook')) ? '<li><a href="' . sh_set($post_meta, 'facebook') . '" title=""><i class="fa fa-facebook"></i></a></li>' : '';
                $output .= (sh_set($post_meta, 'skype')) ? '<li><a href="' . sh_set($post_meta, 'skype') . '" title=""><i class="fa fa-skype"></i></a></li>' : '';

                $output .= '
									</ul>
								</div>
									<h3><a href="' . get_permalink(sh_set($_post, 'ID')) . '">' . sh_set($_post, 'post_title') . '</a></h3>
									<span>' .
                        sh_set($post_meta, 'designation') . '</span>
								<p>' . substr(strip_tags(sh_set($_post, 'post_content')), 0, 105) . '</p>
							</div>
						</div>';
            }
            $output.='</div></div>';
        }
        $output.='</div>
			<script>
			jQuery(document).ready(function($){
				jQuery(".staff-carousel").owlCarousel({
					autoPlay :true,
					stopOnHover : true,
					navigation:true,
					autoHeight : true,
					pagination:false,
					items : 1, //10 items above 1000px browser width
					itemsDesktop : [1000,1], //5 items between 1000px and 901px
					itemsDesktopSmall : [900,1], // betweem 900px and 601px
					itemsTablet: [600,1], //2 items between 600 and 0
					itemsMobile : false ,
					goToFirstSpeed : 2000,
					slideSpeed:1500,
					transitionStyle:\'fadeUp\'
				});
			});
			</script>
			';
        wp_reset_query();
        return $output;
    }

    function recent_events($atts, $content = null) {
        extract(shortcode_atts(array(
            'number' => 3,
            'name' => "",
                        ), $atts));

        $events_page = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => 'tpl-events.php'));
        $args = array('post_type' => 'dict_event', 'posts_per_page' => $number);

        $output = '';
        $posts = query_posts($args);
        $output = '<div class="col-title"><h2>' . $name . '</h2></div>';
        $output.='
				<div class="event-ver2">
				<a title="" class="viewall-btn" href="' . get_page_link(sh_set(sh_set($events_page, 0), 'ID')) . '">' . __('View All', 'wp_dictate') . '</a>';
        if (have_posts()) : while (have_posts()): the_post();
                $content = substr(get_the_content(), 0, 120);
                $title = substr(get_the_title(), 0, 20);
                $span_class = ($number == 3) ? 'span4' : 'span3';
                $output.='
					<div class="' . $span_class . '">
							' . get_the_post_thumbnail(get_the_ID(), "770x385") . '
						<div class="event-caption">
							<h5><a href="' . get_permalink(get_the_id()) . '">' . $title . '</a></h5>
							<span>' . get_the_date("d M") . '</span>
						</div>
						<div class="event-desc">
							<a href="' . get_permalink(get_the_id()) . '">' . $title . '</a>
							<p>' . $content . '</p>
							<span>' . __("by ", 'wp_dictate') . ' <strong>' . get_the_author() . '</strong></span>
						</div>
					</div>';
            endwhile;
        endif;
        wp_reset_query();
        $output.= '
				</div>';
        return $output;
    }

    function recent_events_2($atts, $content = null) {
        global $post;

        extract(shortcode_atts(array(
            'name' => "",
            'post_ids' => '',
            'slogan' => '',
            'title_style' => '',
                        ), $atts));

        $args = array('post_type' => 'dict_event');
        if ($post_ids && $post_ids != 'null')
            $args['post__in'] = explode(',', $post_ids);
        $output = '';
        $posts = new WP_Query($args);

        $output .= '<div class="boxes-left">';
        $output.=($title_style == 'simple') ? '<div class="col-title"><h2>' . $name . '</h2></div>' : '<div class="sidebox-head"><h2>' . $name . '<span>' . $slogan . '</span></h2></div>';
        $output.='
			  <div id="events" class="tab-pane fade in">
				<div class="tabbable tabs-below events">
				  <div class="tab-content">';
        $count = 0;
        $active = '';
        if ($posts->have_posts()) : while ($posts->have_posts()): $posts->the_post();
                $settings = get_post_meta(get_the_ID(), '_dict_event_settings', true);
                $active = ($count == 0) ? "active" : "";
                $output.='
                <div id="event' . get_the_ID() . '" class="tab-pane fade ' . $active . ' in">
                  <div class="event-img"> 
                        ' . get_the_post_thumbnail(get_the_ID(), "770x385") . ' 
                  </div>
                <div class="post-details">
                        <h2><a href="' . get_permalink() . '" title="">' . get_the_title() . '</a></h2>
                        <div class="post-meta"> 
                                <span>                 
                                        <span class="published-date"><i class="theme-icon calender"></i><span>' . date(get_option('date_format'), strtotime(sh_set($settings, 'start_date'))) . '</span></span>  
                                        <span class="post-time"><i class="theme-icon clock"></i>' . date('h:i a', strtotime(sh_set($settings, 'start_time'))) . '</span>
                                </span>
                        </div>
                        <article>
                          <p>' . substr(get_the_content(), 0, 300) . '</p>
                          <a class="readmore" href="' . get_permalink() . '" title="">' . __("Read More", 'wp_dictate') . '</a> 
                        </article>
                  </div>
                </div>';
                $count++;
            endwhile;
        endif;
        wp_reset_query();
        $output.='
				  </div>
				  <ul class="nav nav-tabs">';
        $count = 0;
        $active = '';
        if ($posts->have_posts()) : while ($posts->have_posts()): $posts->the_post();
                $active = ($count == 0) ? ' class="active"' : "";
                $output.='
					<li'.$active.'> 
					  <a data-toggle="tab" href="#event' . get_the_ID() . '"> 
						<span class="events-thumb">
							' . get_the_post_thumbnail(get_the_ID(), "235x129") . '
							<h4>' . get_the_title() . '<span>' . __("By ", 'wp_dictate') . sh_set($settings, 'organizer') . '</span></h4>
						</span>
					  </a>
					</li>
					';
                $count++;
            endwhile;
        endif;
        wp_reset_query();
        $output.='
				  </ul>
				</div>
			  </div>
			</div>
		
		';
        $output .='<script>
				jQuery(document).ready(function($){
					jQuery("#events .nav.nav-tabs").owlCarousel({
						autoPlay :false,
						stopOnHover : true,
                                                loop : true,
						navigation:true,
                                                margin:30,
						autoHeight : true,
						pagination:false,
						items : 3, 
						
					});
				});
			</script>';
        return $output;
    }

    function our_affiliation($atts, $content = null) {
        extract(shortcode_atts(array('title' => __('Our Affiliation', 'wp_dictate'), 'number' => 3), $atts));
        wp_enqueue_script('jquery-tinycarousel-min');
        query_posts('post_type=dict_partner&posts_per_page=' . $number);
        $Record = '';
        if (have_posts()):
            while (have_posts()): the_post();
                $Settings = get_post_meta(get_the_ID(), '_dict_partner_settings', true);
                $link = strstr(sh_set($Settings, 'link'), 'http://') ? sh_set($Settings, 'link') : 'http://' . sh_set($Settings, 'link');
                $Record .= '<li> <a title="' . get_the_title() . '" href="' . $link . '"> ' . get_the_post_thumbnail() . ' </a> </li>';
            endwhile;
        endif;
        wp_reset_query();
        $output = '<div class="col-title">
						<h2>' . $title . '</h2>
					  </div>
					  <div id="slider5"> <a class="buttons next" href="#"></a> <a class="buttons prev disable" href="#"></a>
						<div class="viewport">
						  <ul class="overview" style="">
							' . $Record . '
						  </ul>
						</div>
					  </div>
				  <script type="text/javascript">
				  	jQuery(document).ready(function($){
						jQuery(\'#slider5\').tinycarousel(
						{
							display: 1,
							interval: false
						});
					});
				  </script>';
        return $output;
    }

    function testimonial($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Happy Customers', 'wp_dictate'),
            'slogan' => '',
            'number' => 2
                        ), $atts));
        query_posts('post_type=dict_testimonial&posts_per_page=' . $number);
        $Date = get_the_date();
        $Record = '';
        if (have_posts()): while (have_posts()): the_post();
                $Settings = get_post_meta(get_the_ID(), '_dict_testimonial_settings', true);
                $content = substr(get_the_excerpt(), 0, 120);
                $Record .= '<div class="clients">
					  <p><i class="theme-icon comma-start"></i>' . $content . '<i class="theme-icon comma-end"></i></p>
					  <div class="abt-client"> <span>' . $Date . '</span>
					  <p>' . $Settings['name'] . '</p>
					  <i>' . $Settings['designation'] . '</i> </div>
					  ' . get_the_post_thumbnail(get_the_ID(), '103x103') . '
					</div>';
            endwhile;
        endif;
        wp_reset_query();
        $output = '<div class="boxes-right">
					  <div class="sidebox-head">
						<h2>' . $title . '<span>' . $slogan . '</span></h2>
					  </div>
					  ' . $Record . '
				   </div>';
        return $output;
    }

    function testimonial_2($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Customer Reviews', 'wp_dictate'),
            'number' => 2
                        ), $atts));
        query_posts('post_type=dict_testimonial&posts_per_page=' . $number);
        $Record = '';
        if (have_posts()): while (have_posts()): the_post();
                $content = substr(get_the_content(), 0, 120);
                $Settings = get_post_meta(get_the_ID(), '_dict_testimonial_settings', true);

                $SocialLinks = '';

                if (!empty($Settings['facebook_link']) || !empty($Settings['twiter_link']) || !empty($Settings['linked_link'])) {
                    $Link = '';

                    $Link .= (!empty($Settings['facebook_link']) ) ? '<li><a title="" href="' . $Settings['facebook_link'] . '"><i class="theme-icon facebook"></i></a></li>' : '';
                    $Link .= (!empty($Settings['twiter_link']) ) ? '<li><a title="" href="' . $Settings['twiter_link'] . '"><i class="theme-icon twitter"></i></a></li>' : '';
                    $Link .= (!empty($Settings['linked_link']) ) ? '<li><a title="" href="' . $Settings['linked_link'] . '"><i class="theme-icon linkedin"></i></a></li>' : '';
                    $SocialLinks = '<ul>
							  ' . $Link . '
							</ul>';
                }
                $Record .= '<div class="customer"> ' . get_the_post_thumbnail(get_the_id(), '103x103') . '
					  <div class="rev">
						<p>' . $content . '</p>
						<span>' . $Settings['name'] . '</span>
						' . $SocialLinks . '
					  </div>
					</div>';
            endwhile;
        endif;
        wp_reset_query();

        $output = '<section class="cols">
					  <div class="container">
						<div class="col-title"><h2>' . $title . '</h2></div>
						<div class="reviews">
						  ' . $Record . '
						</div>
					  </div>
				   </section>';
        return $output;
    }

    function testimonial_3($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Customer Reviews', 'wp_dictate'),
            'number' => 2
                        ), $atts));
        query_posts('post_type=dict_testimonial&posts_per_page=' . $number);
        $Date = get_the_date();
        $Record = '';
        if (have_posts()): while (have_posts()): the_post();
                $settings = get_post_meta(get_the_ID(), '_dict_testimonial_settings', true);
                $Record .= '<div class="span6">
								<div class="customers-testimonials">
									' . get_the_post_thumbnail() . '
									<p>"' . substr(strip_tags(apply_filters('the_content', get_the_content())), 0, 120) . ' "</p>
									<span>' . sh_set($settings, 'name') . '</span>
									<ul>';
                $Record .= (sh_set($settings, 'facebook_link')) ? '<li><a href="' . sh_set($settings, 'facebook_link') . '" title=""><i class="fa fa-facebook"></i></a></li>' : '';
                $Record .= (sh_set($settings, 'twiter_link')) ? '<li><a href="' . sh_set($settings, 'twiter_link') . '" title=""><i class="fa fa-twitter"></i></a></li>' : '';
                $Record .= (sh_set($settings, 'linked_link')) ? '<li><a href="' . sh_set($settings, 'linked_link') . '" title=""><i class="fa fa-linkedin"></i></a></li>' : '';

                $Record .='</ul></div></div>';

            endwhile;
        endif;
        wp_reset_query();
        $output = '<div class="col-title"><h2>' . $title . '</h2></div>
		<div class="customers-reviews">
			<div>
				' . $Record . '
			</div>
		</div>';
        return $output;
    }

    function portfolio($atts, $content = null) {
        wp_enqueue_script('prettyPhoto');
        extract(shortcode_atts(array(
            'title' => __('Portfolio', 'wp_dictate'),
            'number' => 2
                        ), $atts));


        $Posts = query_posts('post_type=dict_portfolio&posts_per_page=' . $number);
        $TotalPosts = count($Posts);
        $PostBatch = 4;
        $i = 1;
        $EndingTagAppended = FALSE;
        $StrtingTag = '<div class="port-sec">';
        $CloseTag = '</div>';
        $Record = '';
        if (have_posts()):
            while (have_posts()): the_post();

                $NewSecStrtTag = ( $TotalPosts < $PostBatch || $i == 1 || $EndingTagAppended === TRUE ) ? $StrtingTag : '';
                $NewSecCloseTag = ( $i == $TotalPosts || ( $TotalPosts < $PostBatch && $i == $TotalPosts ) || ( $i % $PostBatch == 0 && $i !== 1 ) ) ? $CloseTag : '';
                $EndingTagAppended = ( $i == $TotalPosts || ( $TotalPosts < $PostBatch && $i == $TotalPosts ) || ( $i % $PostBatch == 0 && $i !== 1 ) ) ? TRUE : FALSE;

                $Settings = get_post_meta(get_the_ID(), '_dict_portfolio_settings', true);

                $Name = sh_set($Settings, 'name');

                $Name = ( isset($Name) && !empty($Name) ) ? '<i class="theme-icon views-white"></i>' . __('By:', 'wp_dictate') . ' ' . $Name . '' : '';
                $Comments = get_comments_number(get_the_id());
                $image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                $Record .= $NewSecStrtTag .
                        '<div class="portfolio">
							  <div class="port-img"> <a class="html5lightbox" rel="prettyPhoto" href="' . sh_set($image, 0) . '" data-group="portfolio" title=""> <span class="img-icon"></span> </a> ' . get_the_post_thumbnail(get_the_ID(), "570x194") . '
								<a title="" href="' . get_permalink() . '"><h4>' . get_the_title() . '</h4></a>
								<div class="meta"> 
								  ' . $Name . '
								  <i class="theme-icon calender-white"></i>0n: ' . get_the_date('d') . 'th ' . get_the_date('F Y') . '
								  <i class="theme-icon comment-white"></i>' . $Comments . __(' Comments', 'wp_dictate') . '
								</div>
							  </div>
							</div>' .
                        $NewSecCloseTag;

                $i++;
            endwhile;
        endif;
        wp_reset_query();
        $output = '<section class="cols">
					<div class="container">
					  <div class="col-title"><h2>' . $title . '</h2></div>
					  <div class="port-main">
					    ' . $Record . '
					  </div>
					</div>
				   </section>';
        return $output;
    }

    function about($atts, $content = null) {
        extract(shortcode_atts(array('text' => '', 'title' => '', 'bg' => ''), $atts));
        $backg = '';
        if ($bg) {
            $att = wp_get_attachment_image_src($bg, 'large');
            if ($att)
                $backg = 'background-image:url(' . sh_set($att, 0) . ');';
        }
        $output = '<div class="abt-sec">
					<div class="moving-bg" style="' . $backg . '">
					  <div class="about">
						<h1>' . $title . '</h1>
						<p>' . $text . '</p>
					  </div>
					</div>
				  </div>';
        return $output;
    }

    function team_1($atts, $content = null) {
        global $post;
        extract(shortcode_atts(array('slogan' => '', 'number' => '', 'title' => '', 'cat' => '', 'img' => ''), $atts));
        wp_enqueue_script('jquery-tinycarousel-min');
        $img_src = ($img) ? sh_set(wp_get_attachment_image_src($img, 'full'), 0) : '';
        $output = '<section class="pattern2" id="serve">
					<div class="fixed-img section-bg1" style="background-image:url(' . $img_src . ');"></div>
					<div class="title">
						<div class="container">
						<h2>' . $title . '<span class="slogan">' . $slogan . '</span> </h2>
					</div>
				  </div><!-- Section Title -->
				  <div id="slider1">
					<div class="container"> <span class="carousel-pagination"> <a href="#" class="buttons prev">left</a> <a href="#" class="buttons next disable">right</a> </span>
					  <div class="viewport">
						<ul class="overview">';
        $args = array('post_type' => 'dict_team', 'posts_per_page' => $number);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'department', 'field' => 'id', 'terms' => $cat));
        $posts = query_posts($args);
        if (have_posts()) : while (have_posts()) : the_post();
                $post_meta = get_post_meta($post->ID, '_dict_team_settings', true);
                $content = substr(get_the_excerpt(), 0, 100);
                $full = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                $output.='
				<li>
					<div class="serve-img"> 
						' . get_the_post_thumbnail($post->ID, "470x522") . '
						<div class="serve-hover">
							<p>' . $content . '</p>
							<a class="link" title="" href="' . get_permalink() . '"></a>
							<a data-group="team" rel="prettyPhoto" class="html5lightbox" href="' . sh_set($full, 0) . '"><span class="magnify"></span></a>';
                $output.= (sh_set($post_meta, 'skill_1_name')) ? '
							<div class="progress indivisual">
								<div style="width: ' . sh_set($post_meta, 'skill_1_percent') . '%;" class="bar"></div>
								<span>' . sh_set($post_meta, 'skill_1_name') . '</span><i>' . sh_set($post_meta, 'skill_1_percent') . '%</i>
							</div>' : '';
                $output.= (sh_set($post_meta, 'skill_1_name')) ? '
							<div class="progress indivisual">
								<div style="width: ' . sh_set($post_meta, 'skill_2_percent') . '%;" class="bar"></div>
								<span>' . sh_set($post_meta, 'skill_2_name') . '</span><i>' . sh_set($post_meta, 'skill_2_percent') . '%</i>
							</div>' : '';
                $output.= '
						</div>
					</div>
					<div class="figcaption"> 
						<div class="serve-intro">
							<h3><i class="theme-icon user"></i>' . get_the_title() . '</h3>
							<span class="speciality">' . sh_set($post_meta, 'designation') . '</span> 
						</div> 
						<div class="contact">
							<h4>' . __('Contact', 'wp_dictate') . '</h4>
							<ul>';
                $output.= (sh_set($post_meta, 'email')) ? '<li><a title="" href="' . sh_set($post_meta, 'email') . '"><i class="theme-icon mail"></i></a></li>' : '';
                $output.= (sh_set($post_meta, 'twitter')) ? '<li><a title="" href="' . sh_set($post_meta, 'twitter') . '"><i class="theme-icon twitter"></i></a></li>' : '';
                $output.= (sh_set($post_meta, 'facebook')) ? '<li><a title="" href="' . sh_set($post_meta, 'facebook') . '"><i class="theme-icon facebook"></i></a></li>' : '';
                $output.= (sh_set($post_meta, 'skype')) ? '<li><a title="" href="' . sh_set($post_meta, 'skype') . '"><i class="theme-icon skype"></i></a></li>' : '';
                $output.= '</ul>
						</div> 
					</div>
				</li>';
            endwhile;
        endif;
        wp_reset_query();
        $output.='</ul>
					  </div>
					</div>
				  </div>  <!-- Our Team Carousel -->
				</section>';
        return $output;
    }

    function team_2($atts, $content = null) {
        extract(shortcode_atts(array('number' => 2, 'title' => '', 'cat' => ''), $atts));

        wp_enqueue_script(array('owl.carousel.min'));

        $args = array('post_type' => 'dict_team', 'posts_per_page' => $number);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'department', 'field' => 'id', 'terms' => $cat));

        $Posts = query_posts($args);

        $TotalPosts = count($Posts);
        $PostBatch = 3;
        $i = 1;
        $EndingTagAppended = FALSE;
        $StrtingTag = '<li>';
        $CloseTag = '</li>';

        $Record = '';
        if (have_posts()):
            while (have_posts()): the_post();

                $content = substr(get_the_content(), 0, 180);
                $NewSecStrtTag = ( $TotalPosts < $PostBatch || $i == 1 || $EndingTagAppended === TRUE ) ? $StrtingTag : '';
                $NewSecCloseTag = ( $i == $TotalPosts || ( $TotalPosts < $PostBatch && $i == $TotalPosts ) || ( $i % $PostBatch == 0 && $i !== 1 ) ) ? $CloseTag : '';
                $EndingTagAppended = ( $i == $TotalPosts || ( $TotalPosts < $PostBatch && $i == $TotalPosts ) || ( $i % $PostBatch == 0 && $i !== 1 ) ) ? TRUE : FALSE;

                $Settings = get_post_meta(get_the_ID(), '_dict_team_settings', true);

                $Name = sh_set($Settings, 'name');

                $Name = ( isset($Name) && !empty($Name) ) ? '<a title="" href="' . get_permalink() . '"><i class="theme-icon views-white"></i>' . __('By: ', 'wp_dictate') . $Name . '</a>' : '';
                $Comments = get_comments_number();

                $Record .= $NewSecStrtTag .
                        '<div class="span4">
							  <div class="team-modern-image"> ' . get_the_post_thumbnail(get_the_ID(), "770x578") . '
								<div> <span>' . get_the_date('m/d/Y') . '</span> <span>' . sh_set($Settings, 'designation') . '</span> </div>
							  </div>
							  <h3><a href="' . get_permalink() . '" title="' . get_the_title() . '">' . get_the_title() . '</a></h3>
							  <p>' . $content . '</p>
							</div>' .
                        $NewSecCloseTag;
                $i++;

            endwhile;
        endif;
        wp_reset_query();

        $output = '<section class="team-modern">
					<div class="team-title">
					  <h2>' . $title . '</h2>
					</div>
					<div class="container">
					  <div class="row-fluid">
						<div class="list_carousel7">
						  <div class="caroufredsel_wrapper" >
							<ul id="carousel" >
							  ' . $Record . '
							</ul>
						  </div>
						  <div class="clearfix"></div>
						</div>
					  </div>
					</div>
				  </section>
				  <script>
				jQuery(document).ready(function(){
					$("#carousel").owlCarousel({
						autoPlay :false,
						stopOnHover : false,
						navigation:true,
						autoHeight : true,
                                                loop : true,
						pagination:false,
						items : 1, //10 items above 1000px browser width
						itemsMobile : true ,
						goToFirstSpeed : 2000,
						slideSpeed:1500,
						transitionStyle:\'backSlide\'
					});
				});
			</script>';
        return $output;
    }

    function team_3($atts, $content = null) {
        extract(shortcode_atts(array('number' => 2, 'title' => '', 'cat' => ''), $atts));

        $args = array('post_type' => 'dict_team', 'posts_per_page' => $number);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'department', 'field' => 'id', 'terms' => $cat));

        $Posts = get_posts($args);
        $output = '<div class="our-team">
					<div class="col-title"><h2>' . $title . '</h2></div>
					<ul>';

        foreach ($Posts as $post):
            $Settings = get_post_meta(sh_set($post, 'ID'), '_dict_team_settings', true);
            $output.= '<li>
							' . get_the_post_thumbnail(sh_set($post, 'ID'), "370x152") . '
							<div class="team-intro">
								<h4><a href="' . get_permalink(sh_set($post, 'ID')) . '">' . sh_set($post, 'post_title') . '</a></h4>
								<span>' . sh_set($Settings, 'designation') . '</span>
							</div>
						</li> ';
        endforeach;

        $output.= '</ul>
				</div>';
        return $output;
    }

    function employee($atts, $content = null) {
        wp_enqueue_script(array('carouFredSel-6.2.1', 'jquery.touchSwipe.min', 'jquery.mousewheel.min'));
        extract(shortcode_atts(array('number' => 3, 'title' => '', 'subtitle' => '', 'cat' => ''), $atts));
        $output = '
		<div class="emp">
			<div class="col-title"><h2>' . $title . ' ' . $subtitle . '</h2></div>
				<div class="list_carousel4">
					<div id="pager2" class="pager"></div>
							<ul id="employee" >';

        $args = array('post_type' => 'dict_team', 'posts_per_page' => $number);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'department', 'field' => 'id', 'terms' => $cat));

        query_posts($args);

        if (have_posts()): while (have_posts()): the_post();

                $Settings = get_post_meta(get_the_ID(), '_dict_team_settings', true);
                $content = substr(get_the_excerpt(), 0, 250);
                $skills = '<a href="' . get_permalink() . '"<span>' . get_the_title(get_the_ID()) . '</span></a>';
                //printr($Settings);
                foreach (range(1, 4) as $count) {
                    if (sh_set($Settings, 'skill_' . $count . '_name') && sh_set($Settings, 'skill_' . $count . '_percent')) {
                        $skills .= '<h5>' . sh_set($Settings, 'skill_' . $count . '_name') . '</h5><span>' . sh_set($Settings, 'skill_' . $count . '_percent') . '%</span>
							<div class="progress">
							  <div class="bar" style="width: ' . sh_set($Settings, 'skill_' . $count . '_percent') . '%;"></div>
							</div>';
                    }
                }
                //printr($Settings);
                $output .= '
								<li>
									' . get_the_post_thumbnail(get_the_ID(), "770x578") . '
									<div class="performance">
										' . $skills . '																				
									</div>	
									<p>' . $content . '</p>
								</li>
				  ';
            endwhile;
        endif;
        wp_reset_query();

        $output .= '
						</ul>
				<div class="clearfix"></div>
			</div>
		</div>';

        $output .= '<script type="text/javascript">
						/*** Document Ready Function ***/
						jQuery(document).ready(function($){
							
							jQuery(\'#employee\').carouFredSel({
								auto: false,
								pagination: "#pager2",
								mousewheel: true,
								
								swipe: {
									onMouse: true,
									onTouch: true
								}
							});
						});
					</script>';

        return $output;
    }

    function company_progress($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'from_last_year' => '',
            'gross_revenue' => '',
            'net_revenue' => '',
            'text' => '',
            'jan' => '',
            'feb' => '',
            'mar' => '',
            'apr' => '',
            'may' => '',
            'jun' => '',
            'jul' => '',
            'aug' => '',
            'sep' => '',
            'oct' => '',
            'nov' => '',
            'dec' => ''
                        ), $atts));

        return '<div class="">
				  <div class="col-title"><h2>' . $title . '</h2></div>
				  <ul class="records">
					<li>
					  <div class="pull-left">
						<h6>' . __('Inquires', 'wp_dictate') . '</h6>
						<ul class="monthly-progress">
						  <li><span class="month-bar"><span style="height: ' . $jan . '%;" class="fill"></span></span><i>J</i></li>
						  <li><span class="month-bar"><span style="height: ' . $feb . '%;" class="fill"></span></span><i>F</i></li>
						  <li><span class="month-bar"><span style="height: ' . $mar . '%;" class="fill"></span></span><i>M</i></li>
						  <li><span class="month-bar"><span style="height: ' . $apr . '%;" class="fill"></span></span><i>A</i></li>
						  <li><span class="month-bar"><span style="height: ' . $may . '%;" class="fill"></span></span><i>M</i></li>
						  <li><span class="month-bar"><span style="height: ' . $jun . '%;" class="fill"></span></span><i>J</i></li>
						  <li><span class="month-bar"><span style="height: ' . $jul . '%;" class="fill"></span></span><i>J</i></li>
						  <li><span class="month-bar"><span style="height: ' . $aug . '%;" class="fill"></span></span><i>A</i></li>
						  <li><span class="month-bar"><span style="height: ' . $sep . '%;" class="fill"></span></span><i>S</i></li>
						  <li><span class="month-bar"><span style="height: ' . $oct . '%;" class="fill"></span></span><i>O</i></li>
						  <li><span class="month-bar"><span style="height: ' . $nov . '%;" class="fill"></span></span><i>N</i></li>
						  <li><span class="month-bar"><span style="height: ' . $dec . '%;" class="fill"></span></span><i>D</i></li>
						</ul>
					  </div>
					  <div class="pull-right margin-top"> <span>' . $from_last_year . '</span>
						<h6>' . __('FROM LAST YEAR', 'wp_dictate') . '</h6>
					  </div>
					</li>
					<li>
					  <div class="pull-left">
						<h6>' . __('Gross Revenue', 'wp_dictate') . '</h6>
						<span>' . $gross_revenue . '</span> </div>
					  <div class="pull-right">
						<h6>' . __('Net Revenue', 'wp_dictate') . '</h6>
						<span>' . $net_revenue . '</span> </div>
					</li>
				  </ul>
				  <div class="col-title"><h2>' . __('SOME TIPS OF SUCCESS', 'wp_dictate') . '</h2></div>
				  <p class="tips">' . $text . '</p>
				</div>';
    }

    function camera_slider($atts, $content = null) {

        extract(shortcode_atts(array('number' => 3), $atts));
        wp_enqueue_script(array('jquery_camera_min'));
        $theme_settings = get_option('wp_dictate'); //printr($theme_settings);
        $fl_array = preg_grep("/cam_/", array_keys($theme_settings)); //printr($fl_array);
        query_posts('post_type=dict_camera_slider&posts_per_page=' . $number);
        $Pager = $Record = '';
        $i = 1;
        $theme_settings = get_option('wp_dictate');
        //printr($theme_settings);
        if (have_posts()): while (have_posts()): the_post();
                $Settings = get_post_meta(get_the_ID(), '_dict_camera_slider_settings', true);
                $Record .= '<div data-thumb="' . sh_set(wp_get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail'), '0') . '" data-src="' . sh_set(wp_get_attachment_image_src(get_post_thumbnail_id(), 'large'), '0') . '">
					  <div class="camera_caption slide' . $i . ' ' . sh_set($Settings, 'fx') . '">
						' . apply_filters('the_content', get_the_content(get_the_id())) . '
					  </div>
					</div>';
                $i++;
            endwhile;
        endif;
        wp_reset_query();
        $output = '<div class="slider-area">
					<div class="camera_wrap camera_azure_skin" id="camera_wrap_1">
					' . $Record . '
					</div>
				  </div>';
        $slider_options = '';
        foreach ($fl_array as $arr) {
            if (!sh_set($theme_settings, $arr))
                continue;
            //if( sh_set( $theme_settings, $arr ) > 100 ) echo is_integer(sh_set( $theme_settings, $arr ));exit;
            if ($this->bolean(sh_set($theme_settings, $arr)) || sh_set($theme_settings, $arr) > 100) {
                $slider_options .= str_replace('cam_', '', $arr) . ':' . sh_set($theme_settings, $arr) . ',';
            } else {
                $slider_options .= str_replace('cam_', '', $arr) . ':"' . sh_set($theme_settings, $arr) . '",'; //printr($slider_options);
            }
        }
        $output .= "<script type=\"text/javascript\">
			jQuery(document).ready(function($) {
				if (jQuery('#camera_wrap_1').length > 0){
					jQuery('#camera_wrap_1').camera({" . $slider_options . "});
				}
			});
		</script>";
        return $output;
    }

    function flex_slider($atts, $content = null) {
        extract(shortcode_atts(array('number' => 3), $atts));

        wp_enqueue_script(array('jquery_flexslider'));

        query_posts('post_type=flex_slider&posts_per_page=' . $number);
        $output = '';

        if (have_posts()): while (have_posts()): the_post();
                $Record .= '<li> 
					  ' . $PostThumb . '
					  <div class="flex-caption">
						<h4>' . get_the_title() . '</h4>
						' . get_the_excerpt() . '
					  </div>
					</li>';
            endwhile;
        endif;
        wp_reset_query();
        $output .= "
		<script type=\"text/javascript\">
			jQuery(window).load(function() {
				jQuery('.flexslider').flexslider({
				  animation: \"slide\",
				  controlsContainer: \".flex-container\"
			  });
			});
		</script>";
        return $output;
    }

    function slice_box_slider($atts, $content = null) {
        extract(shortcode_atts(array('number' => 3), $atts));

        wp_enqueue_script(array('jquery-slicebox'));

        $theme_settings = get_option('wp_dictate'); //printr($theme_settings);

        $fl_array = preg_grep("/slic_/", array_keys($theme_settings)); //printr($fl_array);
        query_posts('post_type=dict_slicebox&posts_per_page=' . $number);

        $Record = '';

        if (have_posts()): while (have_posts()): the_post();
                $Record .= '<li> <a href="' . get_permalink() . '" title="' . get_the_title() . '">
					  ' . get_the_post_thumbnail(get_the_id(), 'full') . '
					  </a>
					  <div class="sb-description">
						' . get_the_content() . '
					  </div>
					</li>';

            endwhile;
        endif;

        wp_reset_query();
        $output = '<div class="slider-area">
					  <div class="wrapper">
						<ul id="sb-slider" class="sb-slider">
						  ' . $Record . '
						</ul>
						<div id="nav-arrows" class="nav-arrows"> <a href="#">Next</a> <a href="#">Previous</a> </div>
					  </div>
					</div>';

        return $output;
    }

    function parallex_slider($atts, $content = null) {
        extract(shortcode_atts(array('number' => 3, 'sort' => ''), $atts));

        wp_enqueue_script(array('jquery_parallax'));
        $output = '';
        ob_start();
        include(get_template_directory() . '/framework/modules/parallex_slider.php');
        $output = ob_get_contents();
        ob_end_clean();
        return $output;
    }

    function blog_posts($atts, $content = null) {
        extract(shortcode_atts(array('number' => 3, 'sort' => '', 'cat' => ''), $atts));

        $args = array('showposts' => $number, 'orderby' => $sort);
        if ($cat)
            $args['category__in'] = $cat;

        query_posts($args);
        $output = '';
        ob_start();
        sh_blog_list_view();
        $output = ob_get_contents();
        ob_end_clean();
        wp_reset_query();

        return $output;
    }

    function descriptive_portfolio($atts, $content = null) {
        //wp_enqueue_script('prettyPhoto');
        extract(shortcode_atts(array(
            'title' => __('Portfolio', 'wp_dictate'),
            'number' => 6,
            'cols' => '',
            'post_type' => 'portfolio',
                        ), $atts));

        $output = '
		
		<div id="grid" class="portfolio-cols cols">
		<div class="col-title"><h2>' . $title . '</h2></div>
        <div class="row">';
        $args = array('post_type' => $post_type, 'posts_per_page' => $number);
        $Posts = get_posts($args);
        $chunks = array_chunk($Posts, 1);
        foreach ($chunks as $chunk):
            $output.='<div class="' . $cols . '">';
            foreach ($chunk as $c):
                //printr($c);
                $output.='<div class="category_1" data-cat="1"><div class="portfolio-style">
						<div class="portfolio-style-img">
							' . get_the_post_thumbnail(sh_set($c, 'ID')) . '
							<a href="' . get_permalink(sh_set($c, 'ID')) . '" title=""><i class="fa fa-link"></i>' . __("Detail", 'wp_dictate') . '</a>
						</div>
						<i>' . get_the_time('d-m-y', sh_set($c, 'ID')) . '</i>
						<h3><a href="' . get_permalink(sh_set($c, 'ID')) . '" title="">' . get_the_title(sh_set($c, 'ID')) . '</a></h3>
						<p>' . substr(strip_tags(apply_filters('the_content', sh_set($c, 'post_content'))), 0, 200) . '</p>
					</div></div>';
            endforeach;
            $output.='</div>';
        endforeach;
        $output.='</div></div>';

        wp_reset_query();
        return $output;
    }

    function portfolio_with_filters($atts, $content = null) {
        extract(shortcode_atts(array(
            'number' => 6,
            'cols' => '',
            'portfolio_desc' => false,
                        ), $atts));
        wp_enqueue_script('jquery.mixitup.min');
        $terms = get_terms('portfolio_category', array('hide_empty' => 0));
        $output = '<div class="container"><div class="controls"><ul><li class="filter" data-filter="all">' . __("All", 'wp_dictate') . '</li>';
        foreach ($terms as $term):
            $output.='<li class="filter" data-filter="category_' . sh_set($term, 'term_id') . '">' . sh_set($term, 'name') . '</li>';
        endforeach;
        $output.='</ul></div>';
        $output.='<div id="grid" class="row">';
        $args = array('post_type' => 'dict_portfolio', 'posts_per_page' => $number);
        $Posts = get_posts($args);
        foreach ($Posts as $chunk):
            $post_term = get_the_terms($chunk, 'portfolio_category');
            $output.='<div class="' . $cols . ' mix category_' . sh_set(current($post_term), 'term_id') . ' mix_all" data-cat="' . sh_set(current($post_term), 'term_id') . '">';

            $output.='<div class="portfolio-style"><div class="portfolio-style-img">' . get_the_post_thumbnail(sh_set($chunk, 'ID'));
            $output.=($portfolio_desc) ? '' : '<span>' . get_the_title(sh_set($chunk, 'ID')) . '</span>';
            $output.='<a href="' . get_permalink(sh_set($chunk, 'ID')) . '" title=""><i class="fa fa-link"></i>' . __("Detail", 'wp_dictate') . '</a></div>';
            $output.=($portfolio_desc) ? '<i>' . get_the_date() . '</i><h3><a href="' . get_permalink(sh_set($chunk, 'ID')) . '">' . get_the_title(sh_set($chunk, 'ID')) . '</a></h3><p>' . substr(strip_tags(apply_filters('the_content', sh_set($chunk, 'post_content'))), 0, 200) . '</p>' : '';
            $output.='</div></div>';
        endforeach;
        $output.='</div></div><script type="text/javascript">
	jQuery(function($){
		jQuery("#grid").mixitup();
	});
</script>';
        wp_reset_query();
        return $output;
    }

    function aboutus_video($atts, $content = null) {
        extract(shortcode_atts(array(
            'bg' => '',
            'title' => __('After Being Featured In Too Many Magazines ', 'wp_dictate'),
            'text' => '',
            'mp4_vid' => '',
            's1_fa' => '',
            's1_name' => '',
            's2_fa' => '',
            's2_name' => '',
            's3_fa' => '',
            's3_name' => '',
                        ), $atts));

        $attach = ($bg) ? wp_get_attachment_image_src($bg, 'large') : '';
        $backg = ( $attach ) ? 'background-image:url(' . sh_set($attach, 0) . ');' : '';
        $output = '<section class="parallax double-shade">
						<div class="fixed-img" style="' . $backg . ' no-repeat 0 0 fixed"></div>
							<div class="container">
								<div class="video-parallax">
									<div class="row-fluid">
										<div class="span6">
											<video preload="auto" autoplay loop="loop" muted="muted" controls>
												<source src="' . $mp4_vid . '" type="video/mp4">
											</video>
										</div>
									<div class="span6">
									<div class="video-desc">
										<h4>' . $title . '</h4>
										<p>' . $text . '</p>
										<div class="fancy-service">
											<div class="row-fluid">
												<div class="span4">
													<div class="transparent-service">
														<i class="' . $s1_fa . '"></i>
														<span>' . $s1_name . '</span>
													</div>
												</div>
												<div class="span4">
													<div class="transparent-service">
														<i class="' . $s2_fa . '"></i>
														<span>' . $s2_name . '</span>
													</div>
												</div>
												<div class="span4">
													<div class="transparent-service">
														<i class="' . $s3_fa . '"></i>
														<span>' . $s3_name . '</span>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>';
        return $output;
    }

    function services_bg_video($atts, $content = null) {
        extract(shortcode_atts(array(
            'bg' => 3,
            'title' => __('We are excited to launch our new  <span>COMPANY AND PRODUCTS</span>.  After being featured in too many magazines to mention and having created an online stir.', 'wp_dictate'),
            'text' => '',
            'mp4_vid' => '',
            's1_fa' => '',
            's1_name' => '',
            's2_fa' => '',
            's2_name' => '',
            's3_fa' => '',
            's3_name' => '',
            's4_fa' => '',
            's4_name' => '',
            'bg_op' => ''
                        ), $atts));

        $attach = ($bg) ? wp_get_attachment_image_src($bg, 'large') : '';
        $backg = ( $attach ) ? 'background-image:url(' . sh_set($attach, 0) . ');' : '';

        $output = '<section class="parallax">';
        $output.= ($bg_op == 'vid') ? '<video class="parallax-video" poster="" preload="auto" autoplay loop="loop" muted="muted"><source src="' . $mp4_vid . '" type="video/mp4"></video>' : '';

        $output.= ($bg_op == 'image') ? '<div class="fixed-img" style="' . $backg . ' no-repeat 0 0 fixed"></div>' : '';

        $output.='<div class="container">
					<div class="row-fluid">
						<div class="span12">
							<h3>' . $title . '</h3>
							<p>' . $text . '</p>
						</div>
					</div>
					<div class="row-fluid">
						<div class="span3">
							<div class="transparent-service">
								<i class="fa ' . $s1_fa . '"></i>
								<span>' . $s1_name . '</span>
							</div>
						</div>
						<div class="span3">
							<div class="transparent-service">
								<i class="fa ' . $s2_fa . '"></i>
								<span>' . $s2_name . '</span>
							</div>
						</div>
						<div class="span3">
							<div class="transparent-service">
								<i class="fa ' . $s3_fa . '"></i>
								<span>' . $s3_name . '</span>
							</div>
						</div>
						<div class="span3">
							<div class="transparent-service">
								<i class="fa ' . $s4_fa . '"></i>
								<span>' . $s4_name . '</span>
							</div>
						</div>
					</div>
				</div>
			</section>';
        return $output;
    }

    function price_table_2($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('PRO', 'wp_dictate'),
            'currency' => '',
            'price_before_decimal' => '',
            'price_after_decimal' => '',
            'duration' => '',
            'sp1_name' => '',
            'sp1_fa' => '',
            'sp2_name' => '',
            'sp2_fa' => '',
            'sp3_name' => '',
            'sp3_fa' => '',
            'sp4_name' => '',
            'sp4_fa' => '',
            'sp5_name' => '',
            'sp5_fa' => '',
            'sp6_name' => '',
            'sp6_fa' => '',
            'sp7_name' => '',
            'sp7_fa' => '',
            'sp8_name' => '',
            'sp8_fa' => '',
            'sp9_name' => '',
            'sp9_fa' => '',
            'sp10_name' => '',
            'sp10_fa' => '',
                        ), $atts));


        $output = '<div class="span3"><ul>';
        $output.='<li class="head"><h4>' . $title . '</h4></li>';

        $output.= ($sp1_name) ? '<li><i class="' . $sp1_fa . '"></i>' . $sp1_name . '</li>' : '';
        $output.= ($sp2_name) ? '<li><i class="' . $sp2_fa . '"></i>' . $sp2_name . '</li>' : '';
        $output.= ($sp3_name) ? '<li><i class="' . $sp3_fa . '"></i>' . $sp3_name . '</li>' : '';
        $output.= ($sp4_name) ? '<li><i class="' . $sp4_fa . '"></i>' . $sp4_name . '</li>' : '';
        $output.= ($sp5_name) ? '<li><i class="' . $sp5_fa . '"></i>' . $sp5_name . '</li>' : '';
        $output.= ($sp6_name) ? '<li><i class="' . $sp6_fa . '"></i>' . $sp6_name . '</li>' : '';
        $output.= ($sp7_name) ? '<li><i class="' . $sp7_fa . '"></i>' . $sp7_name . '</li>' : '';
        $output.= ($sp8_name) ? '<li><i class="' . $sp8_fa . '"></i>' . $sp8_name . '</li>' : '';
        $output.= ($sp9_name) ? '<li><i class="' . $sp9_fa . '"></i>' . $sp9_name . '</li>' : '';
        $output.= ($sp10_name) ? '<li><i class="' . $sp10_fa . '"></i>' . $sp10_name . '</li>' : '';

        $output.='<li class="table-bottom"><i>' . $currency . '</i><h5>' . $price_before_decimal . '</h5><span>' . $price_after_decimal . ' / ' . $duration . '</span></li>';
        $output.='</ul></div>';
        return $output;
    }

    function news($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('News', 'wp_dictate'),
            'number' => 6,
            'sort' => '',
            'column_size' => '',
                        ), $atts));
        $output = '';
        $args = array('post_type' => 'dict_our_news', 'posts_per_page' => $number, 'order_by' => $sort);
        $Posts = new WP_Query($args);
        $news_page = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => 'tpl-news.php'));
        $output.='<div class="col-title"><h2>' . $title . '</h2></div><div class="our-news">
		<a class="view-all-btn" href="' . get_page_link(sh_set(sh_set($news_page, 0), 'ID')) . '" >' . __("View All", 'wp_dictate') . '</a>
		<div class="row-fluid">';
        while ($Posts->have_posts()): $Posts->the_post();
            $output.='<div class="' . $column_size . '">';
            $output.='<div class="news">
					<h5><a title="" href="' . get_permalink() . '">' . get_the_title() . '</a></h5>
					<span><i class="fa fa-calendar"></i>' . get_the_time('M-d-y', get_the_ID()) . '</span>
					<span><i class="fa fa-user"></i>' . __("by ", 'wp_dictate') . get_the_author() . '</span>
				</div>';
            $output.='</div>';
        endwhile;
        $output.='</div></div>';
        wp_reset_query();
        return $output;
    }

    function awards($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Awards', 'wp_dictate'),
            'awards' => '',
                        ), $atts));

        //printr($awards);
        $output = '<div class="col-title"><h2>' . $title . '</h2></div>';

        $attachments_ids = explode(',', $awards);
        $chunks = array_chunk($attachments_ids, 3);
        //printr($chunks);
        foreach ($chunks as $chunk):
            $output.='<div class="awards"><div class="row-fluid">';
            foreach ($chunk as $c):
                $output.='<div class="span4">' . wp_get_attachment_image($c, '235x129') . '</div>';
            endforeach;
            $output.='</div></div>';
        endforeach;

        return $output;
    }

    function service_areas($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Awards', 'wp_dictate'),
            'column_size' => '',
            'num' => ''
                        ), $atts));

        $settings = get_option('wp_dictate');
        $services = sh_set($settings, 'service_areas');
        unset($services['%s']);
        $output = '<div class="col-title"><h2>' . $title . '</h2></div><div class="row-fluid services-list">';
        $loop_count = 0;
        if (is_array($services)):
            foreach ($services as $chunk):
                $output.='<div class="' . $column_size . '"><div class="service-list"><ul>';
                $output.='<li><i class="fa fa-circle-thin"></i>';
                $output.=(sh_set($chunk, 'service_link')) ? '<a href="' . sh_set($chunk, 'service_link') . '">' : '';
                $output.='<span data-title="' . sh_set($chunk, 'service_name') . '">' . sh_set($chunk, 'service_name') . '</span>';
                $output.=(sh_set($chunk, 'service_link')) ? '</a>' : '';
                $output.='</li>';
                $output.='</ul></div></div>';
                $loop_count++;
                if ($loop_count == $num)
                    break;
            endforeach;
        endif;
        $output.='</div>';

        return $output;
    }

    function services_7($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'number' => '',
            'cat' => '',
            'sort' => 'date',
            'linked' => '',
                        ), $atts));
        if ($number == 3) {
            $cold = 'span4';
        } elseif ($number == 4) {
            $cold = 'span3';
        } elseif ($number == 6) {
            $cold = 'span4';
        }
        $args = array('post_type' => 'dict_service', 'posts_per_page' => $number, 'orderby' => $sort);
        if ($cat != '')
            $args['tax_query'] = array(array('taxonomy' => 'services_department', 'field' => 'id', 'terms' => (int) $cat));
        $output = ($title) ? '<div class="col-title"><h2>' . $title . '</h2></div>' : '';
        $output .= '<div class="row-fluid">';
        global $more;
        $more = 0;
        query_posts($args);
        if (have_posts()): while (have_posts()): the_post();
                $content = get_the_content('Read More...');
                $output.='<div class="' . $cold . '">
						<div class="creative-service">
							' . get_the_post_thumbnail(get_the_id(), '235x129') . '';
                $output.= ($linked == 'yes') ? '<h3><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>' : '<h3>' . get_the_title() . '</h3>';
                $output .='	
							<p>' . substr($content, 0, 150) . '</p>
							<a href="' . get_the_permalink() . '" >Read More...</a>
						</div>
					</div>';
            endwhile;
        endif;
        wp_reset_query();

        $output.='</div>';
        return $output;
    }

    function news_2($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('News', 'wp_dictate'),
            'number' => 6,
            'sort' => '',
            'column_size' => '',
                        ), $atts));

        $args = array('post_type' => 'dict_our_news', 'posts_per_page' => $number, 'order_by' => $sort);
        $Posts = new WP_Query($args);
        $news_page = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => 'tpl-news.php'));
        $output = '<div class="col-title"><h2>' . $title . '</h2></div><div class="award-style2">
		<a class="view-all-btn" href="' . get_page_link(sh_set(sh_set($news_page, 0), 'ID')) . '" >' . __("View All", 'wp_dictate') . '</a>';
        while ($Posts->have_posts()): $Posts->the_post();
            $output.='<div class="' . $column_size . '">';
            $output.='<div class="award">
		
		<span class="awarded-date"><i>' . get_the_time("d", get_the_ID()) . '</i><span>' . get_the_time("M", get_the_ID()) . '</span></span>
                <h5><a title="" href="' . get_permalink() . '">' . get_the_title() . '</a></h5>
                <span><i class="fa fa-user"></i>' . __("by ", 'wp_dictate') . get_the_author() . '</span>
            </div>';
            $output.='</div>';
        endwhile;
        $output.='</div>';
        wp_reset_query();
        return $output;
    }

    function find_a_doctor($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Find a Doctor', 'wp_dictate'),
            'title_style' => '',
            'tag_line' => ''
                        ), $atts));

        wp_enqueue_script('google-map-libs');
        wp_enqueue_script('mymap');

        $template = $events_page = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => 'tpl-team.php'));
        $output = ($title_style == 'simple') ? '<div class="col-title"><h2>' . $title . '</h2></div>' : '<div class="gray-title"><span><i class="fa fa-search"></i></span><h3>' . $title . '</h3><h5>' . $tag_line . '</h5></div>';
        $output .= '<div class="find-doctor">
						<form class="doctor-search" method="get" action="' . get_permalink(sh_set(sh_set($template, 0), 'ID')) . '">
							<input type="hidden" name="page_id" value="' . sh_set(sh_set($template, 0), 'ID') . '" />
							<input type="radio" name="keyword" class="styled"  value="name"  /> <label>' . __("BY NAME", 'wp_dictate') . '</label>
							<input type="radio" name="keyword" class="styled" value="speciality" /> <label>' . __("BY SPECIALITY", 'wp_dictate') . '</label>
							<input type="text" name="search_term" />
							<input type="submit" value=""/>
							<h5>' . __("ADVANCED SEARCH", 'wp_dictate') . '</h5>
							<div class="row-fluid">
								<div class="span12">
									<h6>' . __("LOCATION", 'wp_dictate') . '</h6>
									<input type="text" id="searchTextField" class="input-block-level" name="doc_loc">
								</div>
							</div>
							<div class="row-fluid">
								<div class="span6">
									<h6>' . __("GENDER", 'wp_dictate') . '</h6>
										<input type="radio" name="gender" class="styled" value="female"  /> <label>' . __("Female", 'wp_dictate') . '</label>
										<input type="radio" name="gender" class="styled" value="male"  /> <label>' . __("Male", 'wp_dictate') . '</label>
								</div>
							</div>
						</form>
					</div>';
        return $output;
    }

    function gallery($atts, $content = null) {
      
        extract(shortcode_atts(array(
            'title' => __('Gallery', 'wp_dictate'),
            'gallery' => '',
            'cols' => '',
                        ), $atts));
        $settings = get_post_meta($gallery, '_dict_gallery_settings', true);

        $ids = array_filter(explode(',', sh_set($settings, 'gallery')));
        $output = '<div class="col-title cols"><h2>' . $title . '</h2></div><div id="gallery" class="tab-pane fade active in row-fluid">';
        if ($ids && is_array($ids)) :
            $new_att = get_posts(array('post_type' => 'attachment', 'post__in' => $ids, 'posts_per_page' => -1));
           
            foreach ($new_att as $new_a):

                $output.='<div class="' . $cols . '">
					<div class="gallery-column">
					' . wp_get_attachment_image(sh_set($new_a, 'ID'), '570x422') . '
                     <div class="date">
					 	<img src="' . get_template_directory_uri() . '/img/gallery-img-icon.png" alt="" />
                        <p>' . date('d', strtotime(sh_set($new_a, 'post_date'))) . '
							<span>' . date('F Y', strtotime(sh_set($new_a, 'post_date'))) . '</span>
						</p>
                      </div>
                      <div class="img-title">' . sh_set($new_a, 'post_title') . '</div>
                                <div class="onhover">
                                      <p>' . get_the_title(sh_set($new_a, 'post_parent')) . ' / ' . get_the_title(sh_set($new_a, 'ID')) . '</p>
                                      <a class="img-link" href="' . get_permalink(sh_set($new_a, 'ID')) . '" title="" ><img src="' . get_template_directory_uri() . '/img/link.png" alt="" /></a>
                                      <a class="img-magnify" rel="prettyPhoto" data-group="all" href="' . sh_set(wp_get_attachment_image_src($new_a->ID, 'large'), '0') . '" title="" >
                                      <img src="' . get_template_directory_uri() . '/img/magnify.png" alt="" /></a>
                              </div>
                      </div></div>';
            endforeach;
        endif;
        $new_att = get_posts(array('post_type' => 'attachment', 'post__in' => $ids));
        $opt = sh_set($settings, 'videos');
        if ($opt && is_array($opt) && sh_set($opt, 0)):
            foreach ((array) sh_set($settings, 'videos') as $new_a):
                $output.=' <div class="' . $cols . '">
		<div class="gallery-column">';
                $video_data = sh_grab_video($new_a, $opt);
                $output.='<img src="' . sh_set($video_data, 'thumb') . '" alt="' . sh_set($video_data, 'title') . '
                  <img src="' . get_template_directory_uri() . '/img/gallery-img-icon.png" alt="" />
				  <div class="date">
                  <p>' . get_the_date(sh_set($new_a, 'ID'), 'd') . '<span>' . get_the_date(sh_set($new_a, 'ID'), 'F Y') . '</span></p>
				  </div>
                  <div class="img-title">' . sh_set($video_data, 'title') . '</div>';

                $output.=(sh_set($settings, 'on_hover') == 'true') ? '<div class="onhover">
						<p>' . get_the_title(sh_set($new_a, 'ID')) . ' / ' . sh_set($video_data, 'title') . '</p>
						<a class="img-magnify" rel="prettyPhoto" data-group="all" href="' . $new_a . '" title="" >
						<img src="' . get_template_directory_uri() . '/img/magnify.png" alt="" />
						</a>
				</div>' : '';
                $output.='</div></div>';
            endforeach;
        endif;
        $output.='</div>';
        return $output;
    }

    function bolean($value) {
        if ($value == 'true' || $value == 'false')
            return true;
        else
            return false;
    }

    function integers($value) {
        if ($value == 'true' || $value == 'false')
            return true;
        else
            return false;
    }

    function weekly_schedule($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Weekly Scedule', 'wp_dictate'),
            'opening_time' => '',
            'closing_time' => '',
            'sunday_option' => '',
            'tagline' => '',
                        ), $atts));
        $output = '<div class="col-title"><h2>' . $title . '</h2></div>
				<div class="office-timing">
					<div class="row-fluid">
						<div class="span4">
							<div class="analog-clock"><img alt="" src="' . get_template_directory_uri() . '/img/analog-clock.png"></div>
						</div>
						<div class="span8">
							<ul>
								<li>' . __("OPENING TIME : ", 'wp_dictate') . ' ' . $opening_time . '</li>
								<li>' . __("CLOSING TIME : ", 'wp_dictate') . ' ' . $closing_time . '</li>
								<li>' . __("SUNDAY : ", 'wp_dictate') . ' ' . $sunday_option . '</li>
							</ul>
						</div>
					</div>
					<p>' . $tagline . '</p>
				</div>';
        return $output;
    }

    function daily_schedule($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Daily Scedule', 'wp_dictate'),
            'monday' => '',
            'tuesday' => '',
            'wednesday' => '',
            'thirsday' => '',
            'friday' => '',
            'saturday' => '',
            'sunday' => '',
            'tagline' => '',
                        ), $atts));
        $output = '<div class="col-title"><h2>' . $title . '</h2></div>
				<div class="office-timing">
					<div class="row-fluid">
						<div class="span12">
							<ul>
								<li>' . __("Monday: ", 'wp_dictate') . ' ' . $monday . '</li>
								<li>' . __("Tuesday: ", 'wp_dictate') . ' ' . $tuesday . '</li>
								<li>' . __("Wednesday: ", 'wp_dictate') . ' ' . $wednesday . '</li>
								<li>' . __("Thirsday: ", 'wp_dictate') . ' ' . $thirsday . '</li>
								<li>' . __("Friday: ", 'wp_dictate') . ' ' . $friday . '</li>
								<li>' . __("Saturday: ", 'wp_dictate') . ' ' . $saturday . '</li>
								<li>' . __("SUNDAY : ", 'wp_dictate') . ' ' . $sunday . '</li>
							</ul>
						</div>
					</div>
					<p>' . $tagline . '</p>
				</div>';
        return $output;
    }

    function parralex_textbox($atts, $content = null) {
        extract(shortcode_atts(array(
            'title1' => __('Creat Amazing Sites', 'wp_dictate'),
            'boxed_title1' => '',
            'text1' => '',
            'title2' => __('Creat Amazing Sites', 'wp_dictate'),
            'boxed_title2' => '',
            'text2' => '',
            'title3' => __('Creat Amazing Sites', 'wp_dictate'),
            'boxed_title3' => '',
            'text3' => '',
            'title4' => __('Creat Amazing Sites', 'wp_dictate'),
            'boxed_title4' => '',
            'text4' => '',
            'title5' => __('Creat Amazing Sites', 'wp_dictate'),
            'boxed_title5' => '',
            'text5' => '',
            'bg' => '',
                        ), $atts));
        
        
        wp_enqueue_script(array('owl.carousel.min'));
        $attach = ($bg) ? wp_get_attachment_image_src($bg, 'large') : '';
        $backg = ( $attach ) ? 'background-image:url(' . sh_set($attach, 0) . ');' : '';
        $output = '
				<section class="parallax-section blackish">
						<div class="parallax-image" style = "' . $backg . '"  data-velocity=".3"></div>
						<div class="text-slider">';
        $output.= ($title1) ?
                '<div class="text-slide">
							<h2>' . $title1 . '</h2>
							<h1>' . $boxed_title1 . '</h1>
							<p>' . $text1 . '</p>
						</div>' : '';
        $output.= ($title2) ?
                '<div class="text-slide">
							<h2>' . $title2 . '</h2>
							<h1>' . $boxed_title2 . '</h1>
							<p>' . $text2 . '</p>
						</div>' : '';
        $output.= ($title3) ?
                '<div class="text-slide">
							<h2>' . $title3 . '</h2>
							<h1>' . $boxed_title3 . '</h1>
							<p>' . $text3 . '</p>
						</div>' : '';
        $output.= ($title4) ?
                '<div class="text-slide">
							<h2>' . $title4 . '</h2>
							<h1>' . $boxed_title4 . '</h1>
							<p>' . $text4 . '</p>
						</div>' : '';
        $output.= ($title5) ?
                '<div class="text-slide">
							<h2>' . $title5 . '</h2>
							<h1>' . $boxed_title5 . '</h1>
							<p>' . $text5 . '</p>
						</div>' : '';

        $output .='</div></section>
			<script>
				jQuery(document).ready(function($){
					jQuery(".text-slider").owlCarousel({
						autoPlay :true,
						stopOnHover : true,
						navigation:true,
						autoHeight : true,
						pagination:false,
						items : 1, //10 items above 1000px browser width
						itemsDesktop : [1000,1], //5 items between 1000px and 901px
						itemsDesktopSmall : [900,1], // betweem 900px and 601px
						itemsTablet: [600,1], //2 items between 600 and 0
						itemsMobile : false ,
						goToFirstSpeed : 2000,
						slideSpeed:1500,
						transitionStyle:\'backSlide\'
					});
				});
			</script>
				';
        return $output;
    }

    function our_history($atts, $content = null) {
        wp_enqueue_script(array('owl.carousel.min', 'prettyPhoto'));
        extract(shortcode_atts(array(
            'title' => __('Our History', 'wp_dictate'),
            'number' => 6
                        ), $atts));

        $output = '';
        $output .= '<div class="col-title"><h2>' . $title . '</h2></div>';
        $output .= '<div class="history-wrapper"><div class="company-history">';

        $Posts = query_posts('post_type=dict_history&posts_per_page=' . $number);

        if (have_posts()): while (have_posts()): the_post();
                $output .= '<div class="year">
						<div class="year-detail">
							' . get_the_post_thumbnail(get_the_ID(), '470x522') . '
							<h4>' . get_the_title() . '</h4>
							<p>' . substr(strip_tags(apply_filters('the_content', get_the_content())), 0, 200) . '</p>
						</div>
					</div>';
            endwhile;
        endif;
        wp_reset_query();
        $output .= '</div></div>
		<script>
			jQuery(document).ready(function(){
				jQuery(".company-history").owlCarousel({
					autoPlay :true,
					stopOnHover : true,
					navigation:false,
					autoHeight : true,
					pagination:false,
					items : 4,
					goToFirstSpeed : 2000,
					slideSpeed:1500
				});
			});
		</script>';
        return $output;
    }

    function our_products($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => __('Our Products', 'wp_dictate'),
            'number' => '4',
            'orderby' => 'date',
            'order' => 'ASC',
            'cat' => ''
                        ), $atts));


        $query_args = array(
            'showposts' => $number,
            'post_status' => 'publish',
            'post_type' => 'product',
            'orderby' => $orderby,
            'order' => $order
        );

        if ($cat)
            $query_args['tax_query'] = array(array('taxonomy' => 'product_cat', 'field' => 'id', 'terms' => $cat));

        $prods = new WP_Query($query_args);
        $output = '';
        include( get_template_directory() . '/framework/modules/recent_products.php');
        wp_reset_query();

        return $output;
    }

    function best_sellers($atts, $content = null) {
        global $woocommerce;

        extract(shortcode_atts(array(
            'title' => __('Best Sellers', 'wp_dictate'),
            'number' => '4',
            'order' => 'DESC',
                        ), $atts));


        $query_args = array(
            'posts_per_page' => $number,
            'post_status' => 'publish',
            'post_type' => 'product',
            'meta_key' => 'total_sales',
            'orderby' => 'meta_value_num',
            'no_found_rows' => 1,
        );

        $query_args['meta_query'] = array();


        $query_args['meta_query'][] = array(
            'key' => '_price',
            'value' => 0,
            'compare' => '>',
            'type' => 'DECIMAL',
        );

        $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
        $query_args['meta_query'][] = $woocommerce->query->visibility_meta_query();

        //printr($query_args);

        $prods = new WP_Query($query_args);

        $stlye = '';

        include( get_template_directory() . '/framework/modules/recent_products.php');

        return $output;
    }

    function creative_news($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => '',
            'number' => '4',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'creative_news';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function simple_services($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => '',
            'number' => '4',
            'cat' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'simple_services';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function welcome_box($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => '',
            'sub_title' => '',
            'desc' => '',
            'btn_title' => '',
            'btn_link' => '',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'welcome_box';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function banner($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'img' => '',
                        ), $atts)
        );

        $output = '';
        $imgs = wp_get_attachment_image_src($img, '370x164');
        $output .= '<div class="adds">
						<img src="' . $imgs[0] . '" alt="" />
					</div>';
        return $output;
    }

    function testimonial_carousal($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'number' => '',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'testimonial_carousal';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function fancy_news($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => '',
            'number' => '4',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'fancy_news';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function tipsy_list($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => '',
            'number' => '4',
            'cat' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'tipsy_list';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function creative_our_affiliation($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => 'Our Affiliation',
            'number' => '5',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'creative_our_affiliation';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function simple_text($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'code' => '',
                        ), $atts)
        );

        $output = '<div class="simple-text">
					' . rawurldecode(base64_decode($code)) . '
				  </div>';
        return $output;
    }

    function simple_image($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'img' => '',
                        ), $atts)
        );
        $img = wp_get_attachment_image_src($img, '470x522');
        $output = '<div class="simple-img">
					<img src="' . $img[0] . '" alt="" />
				  </div>';
        return $output;
    }

    function services_with_parallax($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'number' => '4',
            'cat' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'services_with_parallax';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function creative_portfolio($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'number' => '',
            'cat' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'creative_portfolio';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function packages($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'number' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'packages';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function creative_packages($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'number' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'creative_packages';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function about_box($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'img' => '',
            'desc' => '',
            'btn_txt' => '',
            'btn_link' => '',
            'title' => '',
                        ), $atts)
        );

        $output = '';
        $image = wp_get_attachment_image_src($img, '770x385');
        if ($title):
            $output .= '<div class="col-title">
            			<h2>' . $title . '</h2>
        			</div>';
        endif;
        $output .= '<div class="about-us">
					<img alt="" src="' . $image[0] . '" />
					<p>' . $desc . '</p>';
        if ($btn_txt):
            $output .= '<a title="" href="' . $btn_link . '">' . $btn_txt . ' <i class="fa fa-angle-double-right"></i></a>';
        endif;
        $output .= '</div>';

        return $output;
    }

    function accordian_block($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
                        ), $atts)
        );

        $output = '';
        if ($title):
            $output .= '<div class="col-title">
            			<h2>' . $title . '</h2>
        			</div>';
        endif;
        $output .=' <div class="fancy-toggle">
						' . do_shortcode($content) . '
					</div>';

        return $output;
    }

    function accordian($atts, $content = null) {
        extract(shortcode_atts(array(
            'title' => '',
            'acc_content' => '',
            'img' => '',
                        ), $atts)
        );

        $output = '';
        $image = wp_get_attachment_image_src($img, '370x152');
        $output .= '<div class="toggle-item">
						<div class="bg-img"><img src="' . $image[0] . '" alt=""></div>
						<h2>' . $title . '</h2>
						<div class="content">
							<p>' . $acc_content . '</p>
						</div>
					</div>';

        return $output;
    }

    function modern_services($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => '',
            'number' => '4',
            'cat' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'modern_services';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function our_staff($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => '',
            'number' => '4',
            'cat' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'our_staff';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function testimonial_parallax_carousal($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'number' => '4',
            'overly' => '',
            'orderby' => 'date',
            'order' => 'DESC',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'testimonial_parallax_carousal';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function simple_carousel($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'img' => '',
            'overlap' => '',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'simple_carousel';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

    function appointment_parallax($atts, $content = null) {
        extract(shortcode_atts(
                        array(
            'title' => '',
                        ), $atts)
        );

        $output = '';
        $shortcode = 'appointment_parallax';
        include (get_template_directory() . '/framework/modules/shortcodes/query_codes.php' );
        return $output;
    }

}
