<?php 
class SH_Meta_boxes
{
	
	var $_fields = '';
	
	
	function __construct()
	{
		//include(get_template_directory().'/includes/resource/awesom_icons.php');
		$GLOBALS['_font_awesome'] = '';//$awesome_icons;
		
		add_action( 'admin_init', array( $this, 'add_metabox' ) );
		add_action('admin_enqueue_scripts', array($this, 'enqueue') );
		add_action( 'save_post', array( $this, 'publish_post' ) );
		
		
	}
	
	function enqueue()
	{
		wp_register_script('jquery-select2', SH_FRW_URL.'resource/js/select2.js');
		wp_register_style('admin-custom-styles', SH_FRW_URL.'resource/css/style.css');
		wp_register_style('select_style', SH_FRW_URL.'resource/css/select2.css');
		wp_register_style('fontawesome', SH_FRW_URL.'resource/css/font-awesome/css/font-awesome.min.css');
		$page = sh_set( $_GET, 'page' );
		if( $page == 'sh_theme_options' )
		{			
			wp_register_style('jquery-ui-datepicker-custom', SH_FRW_URL.'resource/css/jquery.ui.all.css');
			
		}
	}
	
	function add_metabox()
	{
		include(SH_FRW_DIR.'resource/settings.php');
		$this->_fields = $settings;
		$keys = array_keys( $this->_fields );
		//printr($keys);
		foreach( $keys as $k ){
			add_meta_box($k.'_settings', sprintf(__( '%s Settings', 'wp_dictate' ), ucwords(str_replace( array('dict_', '_'), ' ', $k ))), array( $this, 'inner_custom_box'), $k );			
		}
	}
	
	function inner_custom_box($post)
	{
		wp_enqueue_style(array('jquery-ui-datepicker-custom', 'admin-custom-styles', 'select_style', 'fontawesome'));
		wp_enqueue_script(array('jquery-ui-datepicker', 'jquery-select2'));
		$t = &$GLOBALS['_sh_base'];
		$post_type = sh_set( $post, 'post_type');
		
		$settings = get_post_meta( sh_set($post, 'ID' ), '_'.$post_type.'_settings', true);
		//printr($settings);
		//$fields = $t->_fields_enqueue(sh_set($this->_fields, $post_type), $settings); 
		//printr($fields);
		$fields = sh_set( $this->_fields, $post_type );
		//printr($fields);
		$nph = new SH_Options;
		$nph->args['opt_name'] = $post_type;
		//printr($nph);
		if( $fields && is_array( $fields ) ): ?>
        	<script type="text/javascript">
			jQuery(document).ready(function($) {
				function format(icon) {
						var originalOption = icon.element;
						return '<span class="fontawesome"><i class="fa ' + icon.id + '"></i> ' + icon.text + '</span>';
					}	
					jQuery('.fields_set select').select2({
					placeholder: "Select a State",
					allowClear: true,
					formatResult: format,
					formatSelection: format,
					escapeMarkup: function(m) { return m; }
				});
							//$('.fields_set select').select2();
				if( $('#start_date') ){
					//$('#start_date, #end_date').datepicker();
				}
			});
			</script>
			<?php foreach( $fields as $f):?>
                <div class="fields_set" >
                	<label><strong><?php echo sh_set( $f, 'title'); ?></strong></label>
                    <div class="field">
                    	<?php if( $n_field = sh_set( $f, 'fields' ) ): ?>
                        	<?php foreach( $n_field as $n_f ): ?>
                            	<?php echo $nph->_field_input($n_f, sh_set($settings, sh_set( $n_f, 'id' )) ); 	?>
                            <?php endforeach; ?>
                        <?php else: ?>
							<?php echo $nph->_field_input($f, sh_set($settings, sh_set( $f, 'id' )) ); 	?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach;
		endif;
	}
	
	
	function _html()
	{
	}
	
	function publish_post($post_id)
	{
		global $post;
		$post_type = sh_set( $_POST, 'post_type' );
		$setting = sh_set($this->_fields, $post_type);
		if( $this->_fields ):
			$types = array_merge(array('post', 'page'), array_keys( $this->_fields ));
		if( !in_array($post_type , $types) ) return;
		
		$data = sh_set( $_POST, $post_type);//array_intersect_key( $_POST, $setting);
		if( !$data ) return;
		//printr($data);
		if( $post_type == 'dict_team' ) 
		{
			if(sh_set($data , 'gender')) update_post_meta($post_id , '_dict_team_gender' , sh_set($data , 'gender'));
			if(sh_set($data , 'location')) update_post_meta($post_id , '_dict_team_location' , sh_set($data , 'location'));
			if(sh_set($data , 'speciality')) update_post_meta($post_id , '_dict_team_speciality' , sh_set($data , 'speciality'));
			
		}
		//printr(get_post_meta(72));
		if( $post_type == 'dict_event') update_post_meta( $post_id, '_dict_event_date', sh_set( $data, 'start_date'));
		update_post_meta( $post_id, '_'.$post_type.'_settings', $data );
		
		endif;
	}
}
