<?php

class SH_Enqueue {

    function __construct() {
        add_action('wp_enqueue_scripts', array(
            $this,
            'sh_enqueue_scripts'
        ));
        add_action('wp_head', array(
            $this,
            'wp_head'
        ));
        add_action('wp_footer', array(
            $this,
            'wp_footer'
        ));
    }

    function sh_enqueue_scripts() {
        $options = get_option('wp_dictate');
        $options = (!empty($options)) ? $options : array();
        $protocol = is_ssl() ? 'https' : 'http';
        $fl_array = preg_grep("/_font_family/", array_keys($options)); //printr($fl_array);
        $google_fonts = $this->google_fonts($options, $fl_array); //printr($google_fonts);
        $styles = array(
            'google_fonts' => $protocol . '://fonts.googleapis.com/css?family=Open+Sans+Condensed:300,300italic,700|Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic|Noto+Sans:400,400italic,700,700italic|PT+Sans+Caption:400,700|Lato:400,100,100italic,300,300italic,400italic,700,700italic|Roboto:400,100italic,100,300,300italic,400italic,500,500italic,700,700italic|' . $google_fonts,
            'prettyPhoto' => 'css/prettyPhoto.css',
            'animate' => 'css/animate.css',
            'layerslider' => 'layerslider/css/layerslider.css',
            'style' => 'css/coming_soon_style.css',
            'dic_common' => 'css/common.css',
            'bootstrap'=> 'css/bootstrap.css',
            'main_style' => 'style.css',
            'font-awesome' => 'css/font-awesome/css/font-awesome.css',
            'owl.carousel' => 'css/owl.carousel.css',
            //'jquery-ui-custom' => 'css/jquery-ui-custom.css',
            'date-picker' => 'css/jquery.datepick.css',
            'color_picker' => 'css/bootstrap-clockpicker.min.css',
            
        );
        $res_settings = sh_header_settings($options);
        $styles['responsive'] = 'css/responsive.css';
        foreach ($styles as $name => $style) {
            if ($name == 'main_style') {
                wp_enqueue_style($name, get_stylesheet_directory_uri() . '/' . $style);
            } else {
                if (strstr($style, $protocol))
                    wp_enqueue_style($name, $style);
                else
                    wp_enqueue_style($name, SH_URL . $style);
            }
        }

        $rtl_settings = get_option('wp_dictate');
        if (sh_set($rtl_settings, 'sh_rtl') == 'true')
            wp_enqueue_style('rtl_syle', SH_URL . 'css/rtl.css');
        $scripts = array(
            'google-map-libs' => "http://maps.googleapis.com/maps/api/js?sensor=false&libraries=places",
            'jQuery' => 'js/jquery.min.js',
            'mymap' => 'map.js',
            'bootstrap_min' => 'js/bootstrap.min.js',
            'jquery_camera_min' => 'js/camera/camera.min.js',
            'jquery_parallax' => 'js/parallax/parallax.js',
            'jquery-slicebox' => 'js/jquery.slicebox.js',
            'jquery-easing' => 'js/parallax/jquery.easing.1.3.js',
            'jquery_roundabout' => 'js/jquery.roundabout.min.js',
            'jquery-tinycarousel-min' => 'js/jquery.tinycarousel.min.js',
            'modernizr-custom-46884' => 'js/modernizr.custom.46884.js',
            'owl.carousel.min' => 'js/owl.carousel.min.js',
            'html5lightbox' => 'js/html5lightbox.js',
            'jquery_custom' => 'js/custom.js',
            'flickrjs' => 'js/jflickrfeed.min.js',
            'carouFredSel-6.2.1' => 'js/jquery.carouFredSel-6.2.1-packed.js',
            'html5shiv' => 'js/html5shiv.js',
            'jquery.mixitup.min' => 'js/jquery.mixitup.min.js',
            'prettyPhoto' => 'js/jquery.prettyPhoto.js',
            'jquery.mousewheel.min' => 'js/jquery.mousewheel.min.js',
            'jquery-prettyload' => 'js/jquery.prettyLoader.js',
            'jquery.touchSwipe.min' => 'js/jquery.touchSwipe.min.js',
            'styleswitcher' => 'js/styleswitcher.js',
            'wishlist-script' => 'js/wishlist-functions.js',
            'comming_script' => 'js/comming_script.js',
            'layerslider1' => 'layerslider/jQuery/jquery-easing-1.3.js',
            'layerslider2' => 'layerslider/jQuery/jquery-transit-modified.js',
            'layerslider3' => 'layerslider/js/layerslider.transitions.js',
            'layerslider4' => 'layerslider/js/layerslider.kreaturamedia.jquery.js',
            'jQueryui' => 'js/jquery-ui.js',
            'timepicker' => 'js/jquery-ui-timepicker.js',
            'timer' => 'js/timer.js',
            'isotop' => 'js/jquery.isotope.min.js',
            'isotop_init' => 'js/isotope-initialize.js',
            'date_picker_plugin' => 'js/jquery.plugin.min.js',
            'data_pick' => 'js/jquery.datepick.js',
            'clock_picker' => 'js/bootstrap-clockpicker.min.js',
            'custom_script' => 'js/script.js',
        );
        foreach ($scripts as $name => $js) {
            if (strstr($js, $protocol))
                wp_register_script($name, $js);
            wp_register_script($name, SH_URL . $js, '', '', true);
        }

        wp_enqueue_script(array(
            'jQuery',
            'jQueryui',
            'timepicker',
            'jquery-effects-core',
            'jquery-effects-blind',
            'bootstrap_min',
            'modernizr-custom-46884',
            'jquery_roundabout',
            'jquery-prettyload',
            'prettyPhoto',
            'html5shiv',
            'jquery.mixitup.min',
            'jquery.mousewheel.min',
            'jquery.touchSwipe.min',
            'wishlist-script',
            'owl.carousel.min',
            'comming_script',
            'layerslider1',
            'layerslider2',
            'layerslider3',
            'layerslider4',
            'timer',
            'isotop',
            'isotop_init',
        ));
        if (is_page_template('tpl-portfolio.php') || is_singular('dict_gallery'))
            wp_enqueue_script(array(
                'html5lightbox',
                'prettyPhoto'
            ));
        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
        if (is_singular())
            wp_enqueue_script(array(
                'prettyPhoto'
            ));
        wp_enqueue_script(array(
            'jquery_custom',
            'custom_script',
        ));
    }

    function wp_head() {
        echo '<script type="text/javascript"> if( ajaxurl === undefined ) var ajaxurl = "' . admin_url('admin-ajax.php') . '"; var theme_url = "' . get_template_directory_uri() . '";</script>';
        ?>
        <style type="text/css">
        <?php
        echo sh_get_font_settings(array(
            'body_font_family' => 'font-family',
                ), 'body, p {', '}');
        echo sh_get_font_settings(array(
            'h1_font_family' => 'font-family',
                ), 'h1 {', '}');
        echo sh_get_font_settings(array(
            'h2_font_family' => 'font-family',
                ), 'h2 {', '}');
        echo sh_get_font_settings(array(
            'h3_font_family' => 'font-family',
                ), 'h3 {', '}');
        echo sh_get_font_settings(array(
            'h4_font_family' => 'font-family',
                ), 'h4 {', '}');
        echo sh_get_font_settings(array(
            'h5_font_family' => 'font-family',
                ), 'h5 {', '}');
        echo sh_get_font_settings(array(
            'h6_font_family' => 'font-family',
                ), 'h6 {', '}');
        ?>
        </style>
        <?php
        $settings = get_option('wp_dictate');
       
        if ($custom_css = sh_set($settings, 'custom_css'))
            echo '<style>' . $custom_css . '</style>';
        echo sh_theme_color_scheme();
    }

    function wp_footer() {
        $settings = get_option('wp_dictate');

        // printr(sh_header_settings($settings));

        echo (isset($settings['footer_analytics']) && !empty($settings['footer_analytics'])) ? stripslashes($settings['footer_analytics']) : '';
    }

    function google_fonts($options, $fonts = array()) {
        if (!$fonts || !is_array($fonts))
            return '';

        // $styles = $fl_array = preg_grep("/_font_style/", array_keys($options));//printr($fl_array);

        $google_fonts = array();
        foreach ($fonts as $f) {
            $val = sh_set($options, $f);
            $style = sh_set($options, str_replace('_font_family', '_font_style', $f));
            $style = ($style) ? ':' . $style : '';
            if ($val)
                $google_fonts[$val] = str_replace(' ', '+', $val) . $style;
        }

        if ($google_fonts)
            return implode('|', $google_fonts);
        else
            return '';
    }

}
