<?php
/**
 * The template for displaying product content within loops.
 *
 * Override this template by copying it to yourtheme/woocommerce/content-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
global $product, $woocommerce_loop;
// Store loop count we're currently on
if (empty($woocommerce_loop['loop']))
    $woocommerce_loop['loop'] = 0;
// Store column count for displaying the grid
if (empty($woocommerce_loop['columns']))
    $woocommerce_loop['columns'] = apply_filters('loop_shop_columns', 4);
// Ensure visibility
if (!$product->is_visible())
    return;
// Increase loop count
$woocommerce_loop['loop'] ++;
// Extra post classes
$them_options = get_option('wp_dictate');
$classes = array();
if (0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'])
    $classes[] = 'first';
if (0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'])
    $classes[] = 'last';
$classes[] = (sh_set($them_options, 'product_columns') == '2column' ) ? 'span6' : 'span3';
?>
<div class="<?php echo implode(' ', $classes); ?>">
<?php if (sh_set($them_options, 'product_columns') == '2column'): ?>

        <div class="product">
            <div class="row-fluid">
                <div class="span6">
                        <?php //do_action( 'woocommerce_before_shop_loop_item' );  ?>
                    <div class="product-img">
    <?php the_post_thumbnail('270x270'); ?>
                        <a class="product-link" href="<?php the_permalink(); ?>" title=""><i class="fa fa-link"></i></a>
                    </div>
                </div>
                <div class="span6">
                    <div class="product-single-page ">
                        <?php
                        /**
                         * woocommerce_before_shop_loop_item_title hook
                         *
                         * @hooked woocommerce_show_product_loop_sale_flash - 10
                         * @hooked woocommerce_template_loop_product_thumbnail - 10
                         */
                        do_action('woocommerce_before_shop_loop_item_title');
                        ?>    
                        <h3><?php the_title(); ?></h3>
                        <?php
                        /**
                         * woocommerce_after_shop_loop_item_title hook
                         *
                         * @hooked woocommerce_template_loop_price - 10
                         */
                        do_action('woocommerce_after_shop_loop_item_title');
                        ?>
                        <?php if ($price_html = $product->get_price_html()) : ?>
                            <?php echo $price_html; ?>
                            <?php endif; ?>
                        <p>
                            <?php if (is_singular())
                                echo substr(get_the_excerpt(), 0, 50);
                            else
                                echo substr(get_the_excerpt(), 0, 250);
                            ?>
                        </p>

    <?php woocommerce_template_loop_add_to_cart(); ?>
                        <a class="add_to_wishlist" data-id="<?php echo get_the_ID(); ?>" href="javascript:void(0);" title=""><i class="fa fa-heart"></i></a>
                    </div>
                </div>
            </div>
        </div>

            <?php else: ?>

        <div class="product">
            <div class="product-img">
    <?php the_post_thumbnail('270x270'); ?>
                
            <?php woocommerce_template_loop_add_to_cart(); ?>
               <a class="add_to_wishlist like-product" data-id="<?php echo get_the_ID(); ?>" href="#" title=""><i class="fa fa-heart"></i></a>

            </div>

            <?php
            /**
             * woocommerce_before_shop_loop_item_title hook
             *
             * @hooked woocommerce_show_product_loop_sale_flash - 10
             * @hooked woocommerce_template_loop_product_thumbnail - 10
             */
            do_action('woocommerce_before_shop_loop_item_title');
            ?>    

            <h3><a href="<?php echo get_permalink(); ?>"><?php the_title(); ?></a></h3>

            <?php
            /**
             * woocommerce_after_shop_loop_item_title hook
             *
             * @hooked woocommerce_template_loop_price - 10
             */
            do_action('woocommerce_after_shop_loop_item_title');
            ?>

        <?php if ($price_html = $product->get_price_html()) : ?>
        <?php echo $price_html; ?>
    <?php endif; ?>
        </div>
<?php endif; ?>
</div>
