<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<?php $settings = get_option( 'wp_dictate'); ?>
    <meta charset="utf-8">
        <title><?php wp_title(); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <?php wp_head(); ?>
</head>
<body>
<div id="preloader">
	<div id="status"></div><span><?php _e( 'PLEASE WAIT....', 'wp_dictate' ) ?></span>
</div>
<?php $img_id = sh_set( $settings, 'coming_soon_gallery' ); $array = explode( ',', $img_id ); unset($array[0]); ?>
<div class="comming-soon-slider">
    <div id="layerslider-container-fw">
        <div id="layerslider" style="width: 100%; margin: 0px auto;">
        	<?php 
				foreach( $array as $img ): 
					$url = wp_get_attachment_image_src($img, 'full');
			?>
                    <div class="ls-layer" style="transition2d: 66; slidedelay: 6000;" >			
                        <img src="<?php echo $url[0]?>" class="ls-bg" alt="Slide background" />
                    </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<div class="comming-soon-page">	
    <h1><?php echo ucwords( sh_set( $settings, 'coming_soon_title' ) );?></h1>
    <h2><?php echo ucwords( sh_set( $settings, 'coming_soon_desc' ) );?></h2>
    <div class="timer">
        <div class="someTimer" data-date="<?php echo sh_set( $settings, 'coming_soon_timer' );?> 00:00:00" data-timer="0"></div>
    </div>		
    <h3><?php _e( 'WANT TO KNOW WHEN WE ARE LAUNCHING?', 'wp_dictate' ); ?></h3>
    <p><?php _e( 'Subscribe to entering you email below:', 'wp_dictate' ); ?></p>
    <form action="http://feedburner.google.com/fb/a/mailverify" method="post" class="newsletter-form" target="_blank">	
		<?php $message = __('Enter any Valid Email Address', 'wp_dictate'); ?>	
        <input type="text" placeholder="<?php echo $message; ?>" name="email" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$" required/>
        <input type="hidden" value="<?php echo sh_set( $settings, 'feedburner' )?>" name="uri" id="uri"/>
        <input type="hidden" name="loc" value="en_US"/>
        <input type="submit" class="btn btn-scheme" value="GO">
    </form>           
</div>
<?php if( sh_set( $settings, 'coming_soon_footer' ) == 'true' ): ?>
   <?php get_footer(); ?>
<?php else:
	wp_footer(); ?>
<?php endif; ?>
 
</body>
</html>