<?php

if( !function_exists('review_kit_rating') ){
	function review_kit_rating(  $atts , $return = ''){
		
		$postId 	 =  isset($atts['post-id']) ? $atts['post-id'] : 0;
		$rattingShow =  isset($atts['ratting-show']) ? $atts['ratting-show'] : 'yes';
		$countShow   =  isset($atts['count-show']) ? $atts['count-show'] : 'yes';
		$voteShow    =  isset($atts['vote-show']) ? $atts['vote-show'] : 'yes';
		$voteText    =  isset($atts['vote-text']) ? $atts['vote-text'] : 'Votes';
		
		$className   = isset($atts['class'] ) ? $atts['class'] : '';
		if($postId > 0){
			
			$likeData = '"xs_post_id":"'.$postId.'"';	
			// content key for submit array index
			$args = array(
				'orderby'          => 'date',
				'order'            => 'DESC',
				'post_type'        => 'xs_review',
				'post_status'      => 'publish',
				'meta_query' => array(
					array(
						'key' => 'xs_public_review_data',
						'value' => $likeData,
						'compare' => 'LIKE'
					)
				),
				'suppress_filters' => true,
	
			);
			$the_queryTotal = get_posts( $args );
			
			$overViewTotal = 0;
			$totalRattingsCount = 0;
			$rattingRatting = 5;
			$overViewArray = [];
				
			if ( count($the_queryTotal) > 0 ) {
				foreach ( $the_queryTotal as $post ) {
					
					$metaReviewID = $post->ID;
					$metaDataJson = get_post_meta( $metaReviewID, 'xs_public_review_data', false );
					
					if( is_array($metaDataJson) && sizeof($metaDataJson) > 0) {
						$getMetaData = json_decode( end($metaDataJson) );
					}else{
						$getMetaData = [];
					}
					
					$xs_reviwer_rattingOver = isset($getMetaData->xs_reviwer_ratting) ? $getMetaData->xs_reviwer_ratting : '0';
					$reviwerStyleLimitOver = isset($getMetaData->review_score_limit) ? $getMetaData->review_score_limit : '5';
					
					$overViewArray['xs_reviwer_ratting'][] = $xs_reviwer_rattingOver;
					$overViewArray['review_score_limit'][] = $reviwerStyleLimitOver;
					
				}
				
				$rattingRatting 	= max(isset($overViewArray['xs_reviwer_ratting']) ? $overViewArray['review_score_limit'] : 5);
				//$rattingRatting 	= 5;
				// count same values in array. Return array by unique.
				$arrayCountValues 	= array_count_values(  $overViewArray['xs_reviwer_ratting'] );
				
				$totalRattingsSum 	= array_sum( $overViewArray['xs_reviwer_ratting'] );
				$totalRattingsCount = count( $overViewArray['xs_reviwer_ratting'] );
				
				$overViewTotal = round(($totalRattingsSum   / $totalRattingsCount), 2);
			}

			$contentRatting = '';
			if($overViewTotal > 0):
				$contentRatting .= '<div class="'.esc_attr('xs-ratting-content '.$className).'">';
				if($rattingShow == 'yes'):
					$contentRatting .= rating_view_star_point($overViewTotal, $rattingRatting);
				endif;
				if($countShow == 'yes'):
					$contentRatting .= '<span class="wp-ratting-number"> '.$overViewTotal.'  <span>';
				endif;
				if($voteShow == 'yes'):
					$contentRatting .= '<span class="wp-ratting-vote"> '.$totalRattingsCount.'  '.$voteText.'<span>';
				endif;
				$contentRatting .= '</div>';
			endif;
			if($return == 'only_ratting'){
				return $overViewTotal;
			}
			return $contentRatting;
		}
	}
}

// ratting style global
if( !function_exists('rating_view_star_point') ){
	function rating_view_star_point($rat = 0, $max = 5){
		 $tarring = '';
		 $tarring .= '<div class="xs-review-rattting">';
		// $tarring .= '<span class="screen-rattting-text"> '.esc_html(round($rat, 1)).' </span>';
			 $halF = 0;
			 for($ratting = 1; $ratting <= $max; $ratting++ ):
				$rattingClass = 'dashicons-star-empty';
				if($halF == 1){
					$rattingClass = 'dashicons-star-half';
					$halF = 0;
				}
				if( $ratting <= $rat ){
					$rattingClass = 'dashicons-star-filled';
					if($ratting == floor($rat) ):
						$expLode = explode('.', $rat);
						if(is_array($expLode) && sizeof($expLode) > 1){
							$halF = 1;
						}
						
					endif;
				}
				
				$tarring .= '<div style="" class="xs-star dashicons-before '. esc_html($rattingClass).'" aria-hidden="true"></div>';
			endfor;
		 $tarring .= '</div>';
		 return $tarring;
	 }
}

