<?php
/* banner-php */
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

?>
<!-- article> --> 
<article id="post-<?php the_ID(); ?>" <?php post_class('pos-single ptype-content post-article single-post-article'); ?>>
    <?php 
    if( homeradar_get_option( 'single_featured' ) ): ?>
        <?php 
        // Get the list of files
        $slider_images = get_post_meta( get_the_ID(), '_cth_post_slider_images', true );
        if( !empty($slider_images)&& homeradar_get_option('blog_show_format' ) && get_post_format( ) !== 'gallery' ){ ?>
        <div class="list-single-main-media fl-wrap">

            <?php 
            $slider_args = array(
                'slidesToShow'      => 1,
                'responsive'        => false,
                'adaptiveHeight'    => true,
                'fade'              => false,
            );
            ?>
            <div class="single-carousel-wrap carousel-wrap post-carousel-wrap">
                <div class="single-carousel carousel lightgallery" data-options='<?php echo json_encode($slider_args); ?>'>
                    <?php 
                    foreach ( (array) $slider_images as $img_id => $img_url ) {
                        echo '<div class="slick-slide-item">';
                            echo wp_get_attachment_image( $img_id, 'homeradar-featured-image', '', array( 'class' => 'respimg no-lazy' ) );
                            echo '<a href="' . esc_url( wp_get_attachment_url( $img_id ) ) . '" class="gal-link popup-image"><i class="fal fa-search"></i></a>';
                        echo '</div>';
                    }
                    ?>
                </div>
                <div class="crs-button-prev lc-wbtn lc-wbtn_prev"><i class="fal fa-angle-left"></i></div>
                <div class="crs-button-next lc-wbtn lc-wbtn_next"><i class="fal fa-angle-right"></i></div>
            </div>

        </div>
        <?php
        }elseif(has_post_thumbnail( )){ ?>
        <div class="list-single-main-media fl-wrap">
            <?php the_post_thumbnail( 'homeradar-single-image', array( 'class' => 'respimg' ) ); ?>
        </div>
        <?php } 
        ?>
    <?php 
    endif; ?>
    <div class="psingle-block-box fl-wrap sblock_box">
        <?php 
        if( get_post_meta( get_the_ID(), '_cth_show_page_header', true ) != 'yes' || ( get_post_meta( get_the_ID(), '_cth_show_page_header', true ) == 'yes' && get_post_meta( get_the_ID(), '_cth_show_page_title', true ) != 'yes' ) ) the_title( '<'.esc_attr( homeradar_get_option( 'single_title_tag' ) ).' class="post-opt-title">', '</'.esc_attr( homeradar_get_option( 'single_title_tag' ) ).'>' );
        homeradar_edit_link( get_the_ID() );
        ?>
        <?php homeradar_single_post_meta(); ?>
        <?php the_content();?>
        <div class="clearfix"></div>
        <?php homeradar_link_pages();?>
        
        <?php homeradar_single_post_tags(); ?>
        
        
    </div>
</article>
<!-- article end -->       
