<?php
/* banner-php */
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

?>
<!-- article> --> 
<article id="post-<?php the_ID(); ?>" <?php post_class('post-article ptype-content'); ?>>
    <?php 
	// Get the list of files
    $slider_images = get_post_meta( get_the_ID(), '_cth_post_slider_images', true );
    if( !empty( $slider_images ) && homeradar_get_option('blog_show_format', true ) && get_post_format( ) !== 'gallery' ){ ?>
	<div class="list-single-main-media fl-wrap">
        <?php 
        $slider_args = array(
            'slidesToShow'      => 1,
            'responsive'        => false,
            'adaptiveHeight'    => true,
            'fade'              => false,
        );
        ?>
        <div class="single-carousel-wrap carousel-wrap post-carousel-wrap">
            <div class="single-carousel carousel lightgallery" data-options='<?php echo json_encode($slider_args); ?>'>
                <?php 
                foreach ( (array) $slider_images as $img_id => $img_url ) {
                    echo '<div class="slick-slide-item">';
                        echo wp_get_attachment_image( $img_id, 'homeradar-featured-image', '', array( 'class' => 'respimg no-lazy' ) );
                        echo '<a href="' . esc_url( wp_get_attachment_url( $img_id ) ) . '" class="gal-link popup-image"><i class="fal fa-search"></i></a>';
                    echo '</div>';
                }
                ?>
            </div>
            <div class="crs-button-prev lc-wbtn lc-wbtn_prev"><i class="fal fa-angle-left"></i></div>
            <div class="crs-button-next lc-wbtn lc-wbtn_next"><i class="fal fa-angle-right"></i></div>
        </div>

    </div>
	<?php
	}elseif(has_post_thumbnail( )){ ?>
	<div class="list-single-main-media fl-wrap">
        <?php the_post_thumbnail( 'homeradar-featured-image', array( 'class' => 'respimg' ) ); ?>
    </div>
	<?php } ?>
	<div class="psingle-block-box fl-wrap sblock_box post-content-wrap">
        <?php
        homeradar_sticky_post();
        
        the_title( '<h2 class="post-opt-title"><a href="' . esc_url( get_permalink() ) . '">', '</a></h2>' );
        
        the_excerpt();
        ?>
		

		<?php homeradar_post_tags(); ?>

		
        <?php homeradar_post_meta(); ?>
        
        

    </div>
</article>
<!-- article end -->       
