<?php
/* banner-php */
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

get_header(); 

$sb_w = homeradar_get_option( 'blog-sidebar-width', '4' );


if( homeradar_get_option('show_blog_header', false) ) :?>
<!--  section  -->
<section class="parallax-section hidden-section single-par2" data-scrollax-parent="true">
    <div class="bg-wrap bg-parallax-wrap-gradien">
        <div class="bg par-elem" data-bg="<?php echo esc_url( homeradar_get_attachment_thumb_link( homeradar_get_option('blog_header_image' ), 'full' )  );?>" data-scrollax="properties: { translateY: '30%' }"></div>
    </div>
    <div class="container idx-5">
        <div class="container-inner">
            <div class="section-title center-align big-title">
                
                <<?php echo esc_attr( homeradar_get_option( 'post_heading_tag' ) );?> class="post-head-title"><span><?php echo wp_kses( homeradar_get_option('blog_head_title'), 'cth' );?></span></<?php echo esc_attr( homeradar_get_option( 'post_heading_tag' ) );?>>
                
                <?php echo wp_kses( homeradar_get_option('blog_head_intro'), 'cth' ); ?>
            </div>
            <div class="scroll-down-wrap">
                <div class="mousey">
                    <div class="scroller"></div>
                </div>
                <span><?php echo esc_html_x( 'Scroll Down To Discover', 'Post heade', 'homeradar' ); ?></span>
            </div>
        </div>
    </div>
</section>
<!--  section  end-->
<?php 
endif;?>
<?php homeradar_get_template_part( 'template-parts/breadcrumbs', '', array( 'is_top' => true ) ); ?>
<!--section -->   
<section class="gray-bg small-padding" id="main-sec">
    <div class="container">
            
        <div class="post-container fl-wrap">
            <div class="row">
                <?php if( homeradar_get_option( 'blog_layout' ) ==='left_sidebar' && is_active_sidebar( 'sidebar-1' ) ):?>
                <div class="col-md-<?php echo esc_attr($sb_w );?> blog-sidebar-column">
                    <div class="blog-sidebar box-widget-wrap fl-wrap fixed-bar left-sidebar">
                        <?php 
                            get_sidebar(); 
                        ?>                 
                    </div>
                </div>
                <?php endif;?>
                <?php if( homeradar_get_option( 'blog_layout' ) ==='fullwidth' || !is_active_sidebar( 'sidebar-1' ) ):?>
                <div class="col-md-12 display-posts nosidebar">
                <?php else:?>
                <div class="col-md-<?php echo (12 - $sb_w);?> col-wrap display-posts hassidebar">
                <?php endif;?>
                    <div class="spost-con-wrap fl-wrap list-posts-wrap" id="sec2">

                        <?php get_template_part( 'template-parts/loop' ); ?>

                    </div>
                    <!-- end spost-con-wrap -->
                </div>
                <!-- end display-posts col-md-8 -->

                <?php if( homeradar_get_option( 'blog_layout' ) === 'right_sidebar' && is_active_sidebar( 'sidebar-1' ) ):?>
                <div class="col-md-<?php echo esc_attr($sb_w );?> blog-sidebar-column">
                    <div class="blog-sidebar box-widget-wrap fl-wrap fixed-bar right-sidebar">
                        <?php 
                            get_sidebar(); 
                        ?>                 
                    </div>
                </div>
                <?php endif;?>
            </div><!-- end row -->
        </div><!-- end post-container -->
    </div><!-- end container -->
</section>
<div class="limit-box"></div>
<div class="clearfix"></div>
<?php get_footer();
