<?php
/* banner-php */

Redux::setSection( $opt_name, array(
    'title' => esc_html__('Product Page', 'homeradar'),
    'id'         => 'product-page-settings',
    'subsection' => true,
    'fields' => array(

        array(
            'id'       => 'shop_single_navigation',
            'type'     => 'switch',
            'on'        => esc_html__('Yes','homeradar'),
            'off'       => esc_html__('No','homeradar'),
            'title'    => esc_html__( 'Show Next/Prev products navigation', 'homeradar' ),
            'default'  => true,
        ),
        array(
            'id'        => 'shop_single_nav_same_term',
            'type'      => 'switch',
            'on'        => esc_html__('Yes','homeradar'),
            'off'       => esc_html__('No','homeradar'),
            'title'     => esc_html__( 'Next/Prev products should be in same category', 'homeradar' ),
            'default'  => false,
        ),
        array(
            'id' => 'shop_list_link',
            'type' => 'text',
            'title' => esc_html__('Shop List Link', 'homeradar'),
            'desc' => esc_html__('Link for shop list icon on single product page.', 'homeradar'),
            'default' => esc_url( home_url('/shop/' ) )
        ),

        array(
            'id' => 'single_related_count',
            'type' => 'text',
            'title' => esc_html__('Related Products Count', 'homeradar'),
            'desc' => esc_html__('Set number of related products to show ( -1 for all).','homeradar'),
            
            'default' => '3'
        ),

        array(
            'id' => 'single_up_sells_count',
            'type' => 'text',
            'title' => esc_html__('Up-Sells Count', 'homeradar'),
            'desc' => esc_html__('Set number of up-sells products to show ( -1 for all).','homeradar'),
            
            'default' => '-1'
        ),

    ),
) );