<?php
/* banner-php */

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Header Options', 'homeradar'),
    'id'         => 'header-settings',
    'subsection' => false,

    'icon'       => 'el-icon-briefcase',
    'fields'     => array(

        array(
            'id'      => 'header_height',
            'type'    => 'text',

            'title'   => esc_html_x('Header height', 'HomeRadar Options', 'homeradar'),
            'desc'    => esc_html_x('Set your site header height. Number in pixels. Default: 80.', 'HomeRadar Options', 'homeradar'),
            'default' => '80',

        ),

        array(
            'id'      => 'header_info',
            'type'    => 'textarea',

            'title'   => esc_html__('Header Contacts Info', 'homeradar'),
            'desc'    => esc_html__('Enter header contacts info for your site. Notice: only visible on large screen.', 'homeradar'),
            'default' => '',

        ),
        array(
            'id'      => 'show_fixed_search',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Search?', 'homeradar'),
            'default' => true,

        ),


        array(
            'id'      => 'show_wishlist',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Wishlist (Bookmarked listings)?', 'homeradar'),
            'default' => true,

        ),

        array(
            'id'      => 'show_userprofile',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show User Profile?', 'homeradar'),
            'default' => true,

        ),


        

        array(
            'id'      => 'user_menu_style',
            'type'    => 'select',
            'title'   => esc_html__('Logged In Style', 'homeradar'),
            'options' => array(
                'one' => esc_html__('Style One', 'homeradar'),
                'two' => esc_html__('Style Two', 'homeradar'),
            ),
            'default' => 'two',
        ),
    ),
));
