<?php
/* banner-php */

Redux::setSection( $opt_name, array(
    'title' => esc_html__('Portfolio', 'homeradar'),
    'id'         => 'portfolio-settings',
    'subsection' => false,
    
    'icon'       => 'el-icon-briefcase',
    'fields' => array(

        array(
            'id'       => 'folio_fullwidth_nav_menu',
            'type'     => 'switch',
            'title'    => esc_html__( 'Fullwidth Navigation Menu', 'homeradar' ),
            // 'subtitle' => esc_html__( '', 'homeradar' ),
            'default'  => false,
        ),

        array(
            'id'       => 'show_folio_header',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Portfolio Header', 'homeradar' ),
            // 'subtitle' => esc_html__( '', 'homeradar' ),
            'default'  => true,
        ),
        array(
                'id' => 'folio_home_text',
                'type' => 'text',
                'title' => esc_html__('Portfolio Heading Text', 'homeradar'),
                // 'subtitle' => esc_html__('', 'homeradar'),
                // 'desc' => esc_html__('', 'homeradar'),
                'default' => 'Our <strong> portfolio </strong>'
            ),
        array(
                'id' => 'folio_home_text_intro',
                'type' => 'textarea',
                'title' => esc_html__('Portfolio Intro Text', 'homeradar'),
                // 'subtitle' => esc_html__('', 'homeradar'),
                // 'desc' => esc_html__('', 'homeradar'),
                'default' => ''
            ),
        array(
                'id' => 'folio_header_video',
                'type' => 'text',
                'title' => esc_html__('Portfolio Header Video', 'homeradar'),
                // 'subtitle' => esc_html__('', 'homeradar'),
                'desc' => esc_html__('Please enter your Youtube video ID (ex: oDpSPNIozt8 ) here to use header background video feature or leave empty to use header background image selected bellow.', 'homeradar'),
                'default' => ''
            ),
        array(
            'id' => 'folio_header_image',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Portfolio Header Image', 'homeradar'),
            'default' => array('url' => get_template_directory_uri().'/assets/images/bg/17.jpg'),
        ),
        array(
            'id'       => 'show_folio_breadcrumbs',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Breadcrumbs', 'homeradar' ),
            'default'  => true,
        ),

        array(
            'id'       => 'show_folio_footer_content',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Content Footer', 'homeradar' ),
            'default'  => true,
        ),

        array(
            'id' => 'folio_style',
            'type' => 'select',
            'title' => esc_html__('Portfolio Layout', 'homeradar'),
            'desc' => '',
            'options' => array(
                            'horizontal' => 'Horizontal',
                            'horizontal_boxed' => 'Horizontal Boxed',
                            'vertical' => 'Vertical', 
                            'vertical_fullscreen' => 'Vertical Fullscreen', 
                            'parallax' => 'Parallax', 
                            
             ), //Must provide key => value pairs for select options
            'default' => 'parallax'
        ),
        array(
            'id' => 'folio_column',
            'type' => 'select',
            'title' => esc_html__('Portfolio Columns', 'homeradar'),
            'desc' => esc_html__('Vertical columns for Horizontal layout', 'homeradar'),
            'options' => array('five' => 'Five Columns','four' => 'Four Columns', 'three' => 'Three Columns','two' => 'Two Columns', 'one' => 'One Column'), //Must provide key => value pairs for select options
            'default' => 'two'
        ),
        array(
            'id'       => 'folio_show_filter',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Filter', 'homeradar' ),
            'default'  => true,
        ),
        array(
            'id'       => 'folio_show_counter',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Counter', 'homeradar' ),
            'default'  => true,
        ),
        array(
            'id'       => 'folio_posts_per_page',
            'type'     => 'text',
            'title'    => esc_html__( 'Posts per page', 'homeradar' ),
            'subtitle' => esc_html__( 'Number of post to show per page, -1 to show all posts.', 'homeradar' ),
            'default'  => 10,
        ),
        array(
            'id' => 'folio_filter_orderby',
            'type' => 'select',
            'title' => esc_html__('Order Filter By', 'homeradar'),
            'desc' => '',
            'options' => array(
                            'id' => esc_html__( 'ID', 'homeradar' ), 
                            'count' => esc_html__( 'Count', 'homeradar' ),
                            'name' => esc_html__( 'Name', 'homeradar' ), 
                            'slug' => esc_html__( 'Slug', 'homeradar' ),
                            'none' => esc_html__( 'None', 'homeradar' )
                        ), //Must provide key => value pairs for select options
            'default' => 'name'
        ),
        array(
            'id' => 'folio_filter_order',
            'type' => 'select',
            'title' => esc_html__('Order Filter', 'homeradar'),
            // 'subtitle' => esc_html__('', 'homeradar'),
            'desc' => '',
            'options' => array(
                            'ASC' => esc_html__( 'Ascending', 'homeradar' ), 
                            'DESC' => esc_html__( 'Descending', 'homeradar' ),
                        ), //Must provide key => value pairs for select options
            'default' => 'ASC'
        ),
        array(
            'id' => 'folio_archive_orderby',
            'type' => 'select',
            'title' => esc_html__('Order Portfolio By', 'homeradar'),
            // 'subtitle' => esc_html__('', 'homeradar'),
            'desc' => '',
            'options' => array(
                            'none' => esc_html__( 'None', 'homeradar' ), 
                            'ID' => esc_html__( 'Post ID', 'homeradar' ), 
                            'author' => esc_html__( 'Post Author', 'homeradar' ),
                            'title' => esc_html__( 'Post title', 'homeradar' ), 
                            'name' => esc_html__( 'Post name (post slug)', 'homeradar' ),
                            'date' => esc_html__( 'Created Date', 'homeradar' ),
                            'modified' => esc_html__( 'Last modified date', 'homeradar' ),
                            'parent' => esc_html__( 'Post Parent id', 'homeradar' ),
                            'rand' => esc_html__( 'Random', 'homeradar' ),
                        ), //Must provide key => value pairs for select options
            'default' => 'date'
        ),
        array(
            'id' => 'folio_archive_order',
            'type' => 'select',
            'title' => esc_html__('Order Portfolio', 'homeradar'),
            // 'subtitle' => esc_html__('', 'homeradar'),
            'desc' => '',
            'options' => array(
                            'DESC' => esc_html__( 'Descending', 'homeradar' ),
                            'ASC' => esc_html__( 'Ascending', 'homeradar' ), 
                            
                        ), //Must provide key => value pairs for select options
            'default' => 'DESC'
        ),
        array(
            'id' => 'folio_show_info_first',
            'type' => 'select',
            'title' => esc_html__('Show Info', 'homeradar'),
            // 'subtitle' => esc_html__('', 'homeradar'),
            'desc' => '',
            'options' => array(
                            'show_on_hover' => esc_html__( 'Show On Hover', 'homeradar' ),
                            'show' => esc_html__( 'Show', 'homeradar' ), 
                            'hide' => esc_html__( 'Hide', 'homeradar' ), 
                            
                        ), //Must provide key => value pairs for select options
            'default' => 'show_on_hover'
        ),
        
        array(
            'id' => 'folio_pad',
            'type' => 'select',
            'title' => esc_html__('Spacing', 'homeradar'),
            'subtitle' => esc_html__('The space between portfolio grid items.', 'homeradar'),
            'desc' => '',
            'options' => array(
                            'small' => esc_html__('Small','homeradar'), 
                            'big' =>  esc_html__('Big','homeradar'),
                            'none' =>  esc_html__('None','homeradar'),
                        ), //Must provide key => value pairs for select options
            'default' => 'small'
        ),
        array(
            'id'       => 'folio_enable_gallery',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enable Image Gallery on Portfolio Grid', 'homeradar' ),
            // 'subtitle' => esc_html__( '', 'homeradar' ),
            'default'  => false,
        ),
        array(
            'id'       => 'folio_disable_overlay',
            'type'     => 'switch',
            'title'    => esc_html__( 'Disbale Image Overlay Effect', 'homeradar' ),
            // 'subtitle' => esc_html__( '', 'homeradar' ),
            'default'  => false,
        ),
    ),
) );
