<?php
/* banner-php */

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Colors', 'homeradar'),
    'id'         => 'styling-settings',
    'subsection' => false,

    'icon'       => 'el-icon-magic',
    'fields'     => array(
        array(
            'id'      => 'use_custom_color',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Use Custom Colors', 'homeradar'),
            'desc'    => wp_kses(__('Set this option to <b>Yes</b> if you want to use color variants bellow.', 'homeradar'), array('b' => array(), 'strong' => array(), 'p' => array())),
            'default' => false,

        ),

        array(
            'id'      => 'theme-color',
            'type'    => 'color',
            'title'   => esc_html__('Theme Color', 'homeradar'),
            'desc'    => esc_html__('Default: #3270FC', 'homeradar'),
            'default' => '#3270FC',
        ),
        
        array(
            'id'      => 'main-bg-color',
            'type'    => 'color',
            'title'   => esc_html__('Body Background Color', 'homeradar'),
            'desc'    => esc_html__('Default: #FFFFFF', 'homeradar'),
            'default' => '',
        ),
        array(
            'id'      => 'loader-bg-color',
            'type'    => 'color',
            'title'   => esc_html__('Loader Background Color', 'homeradar'),
            'desc'    => esc_html__('Default: #FFFFFF', 'homeradar'),
            'default' => '',
        ),
        array(
            'id'      => 'body-text-color',
            'type'    => 'color',
            'title'   => esc_html__('Body Text Color', 'homeradar'),
            'desc'    => esc_html__('Default: #000', 'homeradar'),
            'default' => '#000',
        ),
        array(
            'id'      => 'paragraph-color',
            'type'    => 'color',
            'title'   => esc_html__('Paragraph Color', 'homeradar'),
            'desc'    => esc_html__('Default: #878C9F', 'homeradar'),
            'default' => '#878C9F',
        ),

        array(
            'id'      => 'link_colors',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Color', 'homeradar'),
            'default' => array(
                'regular' => '#000',
                'hover'   => '#000',
                'active'  => '#000',
            ),
            'active'  => true,
            'visited' => false,
        ),

        array(
            'id'      => 'header-bg-color',
            'type'    => 'color_rgba',
            'title'   => esc_html__('Header Bg Color', 'homeradar'),
            'desc'    => esc_html__('Default: #FFFFFF', 'homeradar'),
            'default' => array(
                'color' => '#FFFFFF',
                'alpha' => 1,
            ),
        ),
        array(
            'id'      => 'header-text-color',
            'type'    => 'color',
            'title'   => esc_html__('Header Color', 'homeradar'),
            'desc'    => esc_html__('Default: #144273', 'homeradar'),
            'default' => '#144273',
        ),
        array(
            'id'      => 'submenu-bg-color',
            'type'    => 'color_rgba',
            'title'   => esc_html__('Submenu Background Color', 'homeradar'),
            'desc'    => esc_html__('Default: #FFFFFF', 'homeradar'),
            'default' => array(
                'color' => '#FFFFFF',
                'alpha' => 1,
            ),
        ),
        array(
            'id'      => 'menu_colors',
            'type'    => 'link_color',
            'title'   => esc_html__('Menu Color', 'homeradar'),
            'default' => array(
                'regular' => '#fff',
                'hover'   => '#3270FC',
                'active'  => '#3270FC',
            ),
            'active'  => true,
            'visited' => false,
        ),
        array(
            'id'      => 'submenu_colors',
            'type'    => 'link_color',
            'title'   => esc_html__('Submenu Color', 'homeradar'),
            'default' => array(
                'regular' => '#000000',
                'hover'   => '#3270FC',
                'active'  => '#3270FC',
            ),
            'active'  => true,
            'visited' => false,
        ),
        array(
            'id'      => 'subfooter-bg-color',
            'type'    => 'color_rgba',
            'title'   => esc_html__('Footer Copyright Background Color', 'homeradar'),
            'desc'    => esc_html__('Default: #f5f7fb', 'homeradar'),
            'default' => array(
                'color' => '#f5f7fb',
                'alpha' => 1,
            ),
        ),

    ),
));
