<?php
/* banner-php */

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Blog Options', 'homeradar'),
    'id'         => 'blog-settings',
    'subsection' => false,

    'icon'       => 'el-icon-website',
    'fields'     => array(
        array(
            'id'      => 'show_blog_header',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Header', 'homeradar'),
            'default' => false,

        ),
        array(
            'id'      => 'blog_head_title',
            'type'    => 'text',
            'title'   => esc_html__('Header Title', 'homeradar'),
            'default' => 'Our Last News',
        ),
        array(
            'id'      => 'blog_head_intro',
            'type'    => 'textarea',
            'title'   => esc_html__('Header Intro', 'homeradar'),
            'default' => '<p class="head-intro">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut nec tincidunt arcu, sit amet fermentum sem.</p>',
        ),

        array(
            'id'      => 'blog_header_image',
            'type'    => 'image_id',
            'title'   => esc_html__('Header Background', 'homeradar'),
            'default' => '',
        ),

        array(
            'id'      => 'blog_layout',
            'type'    => 'image_select',
            'title'   => esc_html__('Blog Sidebar Layout', 'homeradar'),

            'options' => array(
                'fullwidth'     => array(
                    'alt' => 'Fullwidth',
                    'img' => get_template_directory_uri() . '/assets/redux/1col.png',
                ),
                'left_sidebar'  => array(
                    'alt' => 'Left Sidebar',
                    'img' => get_template_directory_uri() . '/assets/redux/2cl.png',
                ),
                'right_sidebar' => array(
                    'alt' => 'Right Sidebar',
                    'img' => get_template_directory_uri() . '/assets/redux/2cr.png',
                ),

            ),
            'default' => 'right_sidebar',
        ),

        array(
            'id'      => 'blog-sidebar-width',
            'type'    => 'select',
            'title'   => esc_html__('Sidebar Width', 'homeradar'),
            'desc'       => esc_html__( 'Based on Bootstrap 12 columns.', 'homeradar' ),
            'options' => array(
                '2' => esc_html__('2 Columns', 'homeradar'),
        '3' => esc_html__('3 Columns', 'homeradar'),
        '4' => esc_html__('4 Columns', 'homeradar'),
        '5' => esc_html__('5 Columns', 'homeradar'),
        '6' => esc_html__('6 Columns', 'homeradar'),
            ),
            'default' => '4',
        ),

        array(
            'id'      => 'blog_show_format',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Post Format on posts page', 'homeradar'),
            'default' => true,

        ),
        array(
            'id'      => 'blog_date',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Date', 'homeradar'),
            'default' => true,

        ),
        array(
            'id'      => 'blog_author',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Author', 'homeradar'),
            'default' => false,

        ),

        array(
            'id'      => 'blog_cats',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Categories', 'homeradar'),
            'default' => true,

        ),

        array(
            'id'      => 'blog_tags',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Tags', 'homeradar'),
            'default' => true,

        ),

        array(
            'id'      => 'blog_comments',
            'type'    => 'switch',
            'on'      => esc_html__('Yes', 'homeradar'),
            'off'     => esc_html__('No', 'homeradar'),
            'title'   => esc_html__('Show Comments', 'homeradar'),
            'default' => false,

        ),



    ),
));
