<?php
/* banner-php */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

if ( ! function_exists( 'homeradar_header_content' ) ) {
    add_action( 'homeradar_header', 'homeradar_header_content' );
    
    function homeradar_header_content() {
        ?>
        <!-- header-->
        <header id="masthead" class="homeradar-header main-header">

            <!--  logo  -->
            <div class="logo-holder">
                <?php 
                if(has_custom_logo()) the_custom_logo(); 
                else echo '<a class="custom-logo-link logo-text" href="'.esc_url( home_url('/' ) ).'"><h2>'.get_bloginfo( 'name' ).'</h2></a>'; 
                ?>
            </div>
            <!-- logo end  -->
            <!-- nav-button-wrap--> 
            <div class="nav-button-wrap color-bg nvminit">
                <div class="nav-button">
                    <span></span><span></span><span></span>
                </div>
            </div>
            <!-- nav-button-wrap end--> 
            

            
            

            <!-- header-search_btn-->         
            <?php if(homeradar_get_option('show_fixed_search', true )) echo do_shortcode( homeradar_check_shortcode('[homeradar_search_top]', 'homeradar_search_top') );?>

            <?php /* if(homeradar_get_option('show_addlisting', true ))*/ echo do_shortcode( homeradar_check_shortcode('[homeradar_submit_button]', 'homeradar_submit_button') );?>
             
            
            
            <?php echo do_shortcode( homeradar_check_shortcode('[langcurr]', 'langcurr') );?>
            
            
            
            <?php if(homeradar_get_option('show_wishlist', true )) echo do_shortcode( homeradar_check_shortcode('[homeradar_wishlist]', 'homeradar_wishlist') );?>
            
            <?php 
                 if(homeradar_get_option('show_userprofile', true )) echo do_shortcode( homeradar_check_shortcode('[homeradar_login style="'.esc_attr(homeradar_get_option('user_menu_style')).'"]', 'homeradar_login') ); 
            ?>
            
            
            <!--  navigation --> 
            <?php if ( has_nav_menu( 'top' ) ) : ?>
                <!--  .nav-holder -->
                <div class="nav-holder main-menu">
                    <?php get_template_part( 'template-parts/navigation/navigation', 'top' ); ?>
                </div><!-- .nav-holder -->
            <?php endif; ?>
            <!-- navigation  end -->

            <!-- header opt -->
            
            
            

            
            <!-- header opt end--> 
            


                       
                                     
            



            
            
            

        </header>
        <!--  header end -->
        <?php
    }
}