<?php
/* banner-php */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
class CTH_Theme_HFEle_Support {

    /**
     * Instance of CTH_Theme_HFEle_Support.
     *
     * @var CTH_Theme_HFEle_Support
     */
    private static $instance;

    /**
     *  Initiator
     */
    public static function instance() {
        if ( ! isset( self::$instance ) ) {
            self::$instance = new CTH_Theme_HFEle_Support();

            add_action( 'wp', [ self::$instance, 'hooks' ] );
        }

        return self::$instance;
    }

    /**
     * Run all the Actions / Filters.
     */
    public function hooks() {
        if ( hfe_header_enabled() ) {
            add_action( 'template_redirect', [ $this, 'homeradar_setup_header' ] );
            add_action( 'homeradar_header', [ 'Header_Footer_Elementor', 'get_header_content' ], 16 );
        }

        if ( hfe_is_before_footer_enabled() ) {
            add_action( 'homeradar_footer', [ 'Header_Footer_Elementor', 'get_before_footer_content' ], 16 );
        }

        if ( hfe_footer_enabled() ) {
            add_action( 'template_redirect', [ $this, 'homeradar_setup_footer' ] );
            add_action( 'homeradar_footer', [ 'Header_Footer_Elementor', 'get_footer_content' ], 16 );
        }
    }

    /**
     * Disable header from the theme.
     */
    public function homeradar_setup_header() {
        for ( $priority = 0; $priority < 16; $priority ++ ) {
            remove_all_actions( 'homeradar_header', $priority );
        }
    }

    /**
     * Disable footer from the theme.
     */
    public function homeradar_setup_footer() {
        for ( $priority = 0; $priority < 16; $priority ++ ) {
            remove_all_actions( 'homeradar_footer', $priority );
        }
    }


}

CTH_Theme_HFEle_Support::instance();

