<?php
/* banner-php */
/**
 * HomeRadar: Color Patterns
 */
// https://qiita.com/nanananamememe/items/6bc01e2e02fff8623331
class CTHColorChanger
{
    private $_r = 0, $_g = 0, $_b = 0, $_h = 0, $_s = 0, $_l = 0;

    public function lighten ($color, $lightness)
    {
        $this->setColor($color);
        $l = $this->_l;
        $l += $lightness;
        $this->_l = (100 < $l)?100:$l;
        $this->_getRgb();
        return $this->_decHex($this->_r) .  $this->_decHex($this->_g) .  $this->_decHex($this->_b);
    }

    public function darken ($color, $darkness)
    {
        $this->setColor($color);
        $l = $this->_l;
        $l -= $darkness;
        $this->_l = (0 > $l)?0:$l;
        $this->_getRgb();
        return $this->_decHex($this->_r) .  $this->_decHex($this->_g) .  $this->_decHex($this->_b);
    }

    public function saturate ($color, $per)
    {
        $this->setColor($color);
        $s = $this->_s;
        $s += $per;
        $this->_s = (100 < $s)?100:$s;
        $this->_getRgb();
        return $this->_decHex($this->_r) .  $this->_decHex($this->_g) .  $this->_decHex($this->_b);
    }

    public function desaturate ($color, $per)
    {
        $this->setColor($color);
        $s = $this->_s;
        $s -= $per;
        $this->_s = (0 > $s)?0:$s;
        $this->_getRgb();
        return $this->_decHex($this->_r) .  $this->_decHex($this->_g) .  $this->_decHex($this->_b);
    }

    public function _decHex ($dec)
    {
        return sprintf('%02s', dechex($dec));
    }

    public function adjust_hue($color, $per)
    {
        $this->setColor($color);
        $h = $this->_h;
        $h += $per;
        $this->_h = (360 < $h)?360:$h;
        $this->_getRgb();
        return $this->_decHex($this->_r) .  $this->_decHex($this->_g) .  $this->_decHex($this->_b);
    }

    private function setColor ($color)
    {
        $color = trim($color, '# ');
        $this->_r = hexdec(substr($color, 0, 2));
        $this->_g = hexdec(substr($color, 2, 2));
        $this->_b = hexdec(substr($color, 4, 2));
        $this->_maxRgb = max($this->_r, $this->_g, $this->_b);
        $this->_minRgb = min($this->_r, $this->_g, $this->_b);
        $this->_getHue();
        $this->_getSaturation();
        $this->_getLuminance();
    }

    private function _getHue ()
    {
        $r = $this->_r;
        $g = $this->_g;
        $b = $this->_b;
        $max = $this->_maxRgb;
        $min = $this->_minRgb;
        if ($r === $g && $r === $b) {
            $h = 0;
        } else {
            $mm = $max - $min;
            switch ($max) {
            case $r :
                $h = 60 * ($mm?($g - $b) / $mm:0);
                break;
            case $g :
                $h = 60 * ($mm?($b - $r) / $mm:0) + 120;
                break;
            case $b :
                $h = 60 * ($mm?($r - $g) / $mm:0) + 240;
                break;
            }
            if (0 > $h) {
                $h += 360;
            }
        }
        $this->_h = $h;
    }

    private function _getSaturation ()
    {
        $max = $this->_maxRgb;
        $min = $this->_minRgb;
        $cnt = round(($max + $min) / 2);
        if (127 >= $cnt) {
            $tmp = ($max + $min);
            $s = $tmp?($max - $min) / $tmp:0;
        } else {
            $tmp = (510 - $max - $min);
            $s = ($tmp)?(($max - $min) / $tmp):0;
        }
        $this->_s = $s * 100;
    }

    private function _getLuminance ()
    {
        $max = $this->_maxRgb;
        $min = $this->_minRgb;
        $this->_l = ($max + $min) / 2 / 255 * 100;
    }

    private function _getMaxMinHsl ()
    {
        $s = $this->_s;
        $l = $this->_l;
        if (49 >= $l) {
            $max = 2.55 * ($l + $l * ($s / 100));
            $min = 2.55 * ($l - $l * ($s / 100));
        } else {
            $max = 2.55 * ($l + (100 - $l) * ($s / 100));
            $min = 2.55 * ($l - (100 - $l) * ($s / 100));
        }
        $this->_maxHsl = $max;
        $this->_minHsl = $min;
    }

    private function _getRGB ()
    {
        $this->_getMaxMinHsl();
        $h = $this->_h;
        $s = $this->_s;
        $l = $this->_l;
        $max = $this->_maxHsl;
        $min = $this->_minHsl;
        if (60 >= $h) {
            $r = $max;
            $g = ($h / 60) * ($max - $min) + $min;
            $b = $min;
        } else if (120 >= $h) {
            $r = ((120 - $h) / 60) * ($max - $min) + $min;
            $g = $max;
            $b = $min;
        } else if (180 >= $h) {
            $r = $min;
            $g = $max;
            $b = (($h - 120) / 60) * ($max - $min) + $min;
        } else if (240 >= $h) {
            $r = $min;
            $g = ((240 - $h) / 60) * ($max - $min) + $min;
            $b = $max;
        } else if (300 >= $h) {
            $r = (($h - 240) / 60) * ($max - $min) + $min;
            $g = $min;
            $b = $max;
        } else {
            $r = $max;
            $g = $min;
            $b = ((360 - $h) / 60) * ($max - $min) + $min;
        }
        $this->_r = round($r);
        $this->_g = round($g);
        $this->_b = round($b);
    }
}


if (!function_exists('homeradar_hex2rgb')) {
    function homeradar_hex2rgb($hex) {
        
        $hex = str_replace("#", "", $hex);
        
        if (strlen($hex) == 3) {
            $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
            $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
            $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
        } 
        else {
            $r = hexdec(substr($hex, 0, 2));
            $g = hexdec(substr($hex, 2, 2));
            $b = hexdec(substr($hex, 4, 2));
        }
        $rgb = array($r, $g, $b);
        return $rgb;
    }
}
if (!function_exists('homeradar_colourBrightness')) {
    
    /*
     * $hex = '#ae64fe';
     * $percent = 0.5; // 50% brighter
     * $percent = -0.5; // 50% darker
    */
    function homeradar_colourBrightness($hex, $percent) {
        
        // Work out if hash given
        $hash = '';
        if (stristr($hex, '#')) {
            $hex = str_replace('#', '', $hex);
            $hash = '#';
        }
        
        /// HEX TO RGB
        $rgb = homeradar_hex2rgb($hex);
        
        //// CALCULATE
        for ($i = 0; $i < 3; $i++) {
            
            // See if brighter or darker
            if ($percent > 0) {
                
                // Lighter
                $rgb[$i] = round($rgb[$i] * $percent) + round(255 * (1 - $percent));
            } 
            else {
                
                // Darker
                $positivePercent = $percent - ($percent * 2);
                $rgb[$i] = round($rgb[$i] * $positivePercent) + round(0 * (1 - $positivePercent));
            }
            
            // In case rounding up causes us to go to 256
            if ($rgb[$i] > 255) {
                $rgb[$i] = 255;
            }
        }
        
        //// RBG to Hex
        $hex = '';
        for ($i = 0; $i < 3; $i++) {
            
            // Convert the decimal digit to hex
            $hexDigit = dechex($rgb[$i]);
            
            // Add a leading zero if necessary
            if (strlen($hexDigit) == 1) {
                $hexDigit = "0" . $hexDigit;
            }
            
            // Append to the hex string
            $hex.= $hexDigit;
        }
        return $hash . $hex;
    }
}
// https://www.ofcodeandcolor.com/cuttle/
/**
 * Change the brightness of the passed in color
 *
 * $diff should be negative to go darker, positive to go lighter and
 * is subtracted from the decimal (0-255) value of the color
 * 
 * @param string $hex color to be modified
 * @param string $diff amount to change the color
 * @return string hex color
 */
function homeradar_adjust_hue($hex, $diff) {
    $rgb = str_split(trim($hex, '# '), 2);
    foreach ($rgb as &$hex) {
        $dec = hexdec($hex);
        if ($diff >= 0) {
            $dec += $diff;
        }
        else {
            $dec -= abs($diff);         
        }
        $dec = max(0, min(255, $dec));
        $hex = str_pad(dechex($dec), 2, '0', STR_PAD_LEFT);
    }
    return '#'.implode($rgb);
}
if (!function_exists('homeradar_bg_png')) {
    function homeradar_bg_png($color, $input, $output) {
        $image = imagecreatefrompng($input);
        $rgbs = homeradar_hex2rgb($color);
        $background = imagecolorallocate($image, $rgbs[0], $rgbs[1], $rgbs[2]);
        
        imagepng($image, $output);
    }
}

if (!function_exists('homeradar_stripWhitespace')) {
    
    /**
     * Strip whitespace.
     *
     * @param  string $content The CSS content to strip the whitespace for.
     * @return string
     */
    function homeradar_stripWhitespace($content) {
        
        // remove leading & trailing whitespace
        $content = preg_replace('/^\s*/m', '', $content);
        $content = preg_replace('/\s*$/m', '', $content);
        
        // replace newlines with a single space
        $content = preg_replace('/\s+/', ' ', $content);
        
        // remove whitespace around meta characters
        // inspired by stackoverflow.com/questions/15195750/minify-compress-css-with-regex
        $content = preg_replace('/\s*([\*$~^|]?+=|[{};,>~]|!important\b)\s*/', '$1', $content);
        $content = preg_replace('/([\[(:])\s+/', '$1', $content);
        $content = preg_replace('/\s+([\]\)])/', '$1', $content);
        $content = preg_replace('/\s+(:)(?![^\}]*\{)/', '$1', $content);
        
        // whitespace around + and - can only be stripped in selectors, like
        // :nth-child(3+2n), not in things like calc(3px + 2px) or shorthands
        // like 3px -2px
        $content = preg_replace('/\s*([+-])\s*(?=[^}]*{)/', '$1', $content);
        
        // remove semicolon/whitespace followed by closing bracket
        $content = preg_replace('/;}/', '}', $content);
        
        return trim($content);
    }
}

if (!function_exists('homeradar_add_rgba_background_inline_style')) {
    function homeradar_add_rgba_background_inline_style($color = '#ed5153', $handle = 'skin') {
        $inline_style = '.testimoni-wrapper,.pricing-wrapper,.da-thumbs li  article,.team-caption,.home-centered{background-color:rgba(' . implode(",", hex2rgb($color)) . ', 0.9);}';
        wp_add_inline_style($handle, $inline_style);
    }
}

if (!function_exists('homeradar_overridestyle')) {
    function homeradar_overridestyle() {

        $theme_color_opt = esc_attr(homeradar_get_option('theme-color'));

        $colorChanger = new CTHColorChanger();
        $lighter_color = '#'.$colorChanger->lighten( $theme_color_opt, 10);
    	$inline_style = '

body{
    background: '.esc_attr(homeradar_get_option('main-bg-color')).';
    color: '.esc_attr(homeradar_get_option('body-text-color', '#000')).';
}
p{
    color: '.esc_attr(homeradar_get_option('paragraph-color', '#878C9F')).';
}
.loader-wrap{
    background: '.esc_attr(homeradar_get_option('loader-bg-color')).';
}
a{
    color: '.esc_attr(homeradar_global_var('link_colors', 'regular', true, '#000')).';
}
a:hover{
    color: '.esc_attr(homeradar_global_var('link_colors', 'hover', true, '#000')).';
}
a:active{
    color: '.esc_attr(homeradar_global_var('link_colors', 'active', true, '#000')).';
}







.contact-social.socials-st2 li a, .widget_archive span,.body-homeradar #review_form input#submit,
.color-bg, .color2-bg, .sb-btn-wrap:before, .irs-bar, .irs-slider,  .irs-bar-edge, .nice-select .option.focus, .nice-select .option.selected.focus  , .main-register-holder .tabs-menu li.current a , .tolt::after  , .scrollbar-inner .simplebar-scrollbar:before ,  .list-single-carousel-wrap .sw-btn  , .breadcrumb-link:before, .breadcrumb-items > a:before  , .slick-dots li.slick-active button  , .footer-social li a  , .scroll-nav li a.act-scrlink , .scroll-nav li span , .gal-link  , .show-info span   , .accordion a.toggle.act-accordion , .accordion a.toggle span  , .pac-item:hover , .progress-indicator:before  , .header-modal .tabs-menu li.current a , .categoties-column_container li a span , .categoties-column_container li a.act-category  , .pagination .page-numbers.current, .pagination .page-numbers:hover  , .cluster-visible , .more-filter-option-btn.mfilopact , .agent-card-social li a  , .card-info-content_social li a , .content-tabs li.current a , .tags-stylwrap a:hover  , .cat-item >  span , .user-profile-menu li a.user-profile-act:before  , .user-profile-menu li a span , .dashboard-stats i  , .chat-contacts-item:after , .message-counter  , .dashboard-addnew_btn:hover  , .onoffswitch-inner:before  , .dashboard-title-item:before , section.single-par2 .section-title:after , .contact-social li a:hover , .category-column:hover , .hero-notifer a , .listing-filters a.gallery-filter-active , .services-opions li i , .listing-carousel-wrapper.lc_hero .lc-wbtn  , .hero-title.ht-column:before  , .soc-log a   {
    background: '.$theme_color_opt.';
}
table a:hover, .wp-calendar-nav a:hover,.post-page-numbers:hover,.post-page-numbers.current,.cm-reply-wrap i,
.nav-holder nav li a i , .login-btn i , .header-search-button i , .dec-icon , .close-reg , .filter-tags input:checked:after , .custom-form  .filter-tags input:checked:after , .lost_password a:hover , .filter-tags label a , .show-reg-form:hover i  , .cart-btn:hover i   , .clear-wishlist , .widget-posts-descr-price span , .geodir-category-location a i , .widget-posts-descr h4 a:hover , .list-single-carousel-wrap .sw-btn:hover , .breadcrumb-current , .show-more-snopt , .like-btn i , .show-more-snopt-tooltip a i   , .pwh_counter span , .profile-widget-header-title h4 a  , .contats-list li a:hover , .contats-list li span i , .pass-input-wrap .eye  ,.footer-list li:before , .footer-list li a:hover  , .subfooter-nav li a , .footer-contacts li a:hover   , .fw_hours span strong , .scroll-nav li a:hover   , .list-single-header-price   , .list-single-stats li span i , .list-single-facts .inline-facts-wrap i , .footer-contacts li span i   , .share-btn i , .post-comm-counter span , .reviews-comments-item-date span i, .reviews-comments-item-date a i  , .rate-review span , .reviews-comments-item-text .box-widget-menu-btn , .print-btn  , .label:before  , .info-window-content h1 , .pac-icon:before   , .subm-mortgage , .geodir-category-content_price   , .geodir_save-btn , .compare-btn   , .lc-wbtn    , .compare-top-btn , .header-opt_btn span:after   , .header-opt-modal-item h4.lang-cur-act:after , .bwc_download-list a i , .bwc_download-list  a:hover:before , .listing-features li i  , .profile-widget-footer .custom-scroll-link:hover , .grid-opt li.grid-opt_act span.act-grid-opt , .list-main-wrap-title h2 span , .more-opt_btn span i  , .close_msotw   , .map-popup-price, .list-searh-input-wrap-title i  , .more-filter-option-btn i  , .loc-acta ,   .nice-select:after , .rooms-details-header h5 span , .rooms-area , .ssw-btn , .map-modal-close , .ftr-btn:hover , .agent-card-social li a:hover , .agent_card-title h4 a:hover , .agent-post_descr_counter span , .small-facts li span strong , .price-num-item , .pricing-header h3 span , .cat-item a:hover , .search-widget .search-submit , .post-opt li i  , .cat-item.cat-item_dec li:after  , .accordion-lite-header i , .accordion-lite-header.acc_open  , .faq-nav li a.act-scrlink , .faq-nav li a:before , .error-wrap a.btn , .error-wrap form  .search-submit  , .compare-link h4 a:hover , .compare-counter span , .dashbard-menu-avatar h4 span , .user-profile-menu li a i , .log-out-btn , .dashboard-stats-count , .tfp-btn:before , .tfp-btn strong , .tfp-det p a , .dasboard-widget-title h5 i , .chat-contacts-item .chat-contacts-item-text span   , .main-dashboard-message-text a , .main-dashboard-message-time  i  , .mark-btn , .reviews-comments-item-text h4 a span , .dashboard-listings-item_opt li a , .dashboard-listings-item_opt .viewed-counter i , .dashboard-listings-item_content h4 a:hover , .dashboard-search-listing button  , .radio input[type="radio"]:checked + span:before , .fuzone .fu-text i , .remove-rp  , .add-room-item i , .dasboard-scrollnav-wrap li a:hover , .dasboard-scrollnav-wrap li a.act-scrlink  , .photoUpload-files span i  , .bookings-item-header h4 a , .bookings-item-footer li a , .agent-card-facts li span , .dashbord-totop , .dashboard-footer-links li a , .section-title h4 , .team-content h5 , .team-social li a  , .services-item i , .serv-link  , .about-title h4 , .services-item h4 span , .share-container a , .contact-social li a  , #message div strong , .cnt-list a , .contact-notifer a , .contact-form-header h4 , .header-opt-modal-item h4 span ,  .card-info .box-widget-menu-btn:hover i , .listing-filters a i   , .hero-notifer a:hover , .secondary-nav li a:hover  , .nav-holder nav li a:hover  , .menusb  a.act-link , .menusb a.back , .menusb li i  , .close_sb-filter , .map-close   , .dashboard-submenu li a i , .dashboard-submenu-title span , .dashboard-submenu li a:hover , .dashbard-menu-close , .nav-holder nav li a.act-link{
    color: '.$theme_color_opt.';
}
.nav-holder nav{
    li{
        &.current-menu-ancestor > a,
        &.current-menu-item > a{
            color: '.$theme_color_opt.';
        }
    }
}
 .cluster-visible:before , blockquote , .fuzone {
    border-color: '.$theme_color_opt.';
}
.gradient-bg, .api-btn:hover, .subscribe-button:hover, .notification.success-notif, .onoffswitch-inner:after, .add-floor-btn:hover, .btn:hover, .add-list:hover, .clear_wishlist:hover, .log_btn:hover, .testim-link:hover, .footer-social li a:hover, .main-search-button:hover, .slsw_vis, .vishf, .vis-hiddenfilter2, .dashboard-menu-btn:hover, .soc-log a:hover, .notification-list-item:hover,
.contact-social.socials-st2 li a:hover,.body-homeradar #review_form input#submit:hover {
    background: -webkit-gradient(linear, left top, right top, from('.$theme_color_opt.'), to('.$lighter_color.'));
    background: -webkit-linear-gradient(left, '.$theme_color_opt.', '.$lighter_color.');
    background: -o-linear-gradient(left, '.$theme_color_opt.', '.$lighter_color.');
    background: linear-gradient(to right, '.$theme_color_opt.', '.$lighter_color.');
}
.green-color , .verified-badge  , .header-opt-modal-list li a:before    , .card-verified , .pricing-content li:before , .dashboard-stats-count span strong  {
    color: #40B69E;
}
.green-bg   , .review-notifer , .new-bookmark{
     background: #40B69E;
}
.blue-bg{
    background: '.$theme_color_opt.';
}
.card-verified.cv_not , .pricing-content li.not-included:before{
    color:#EF8C9B;
}
.ck-form input[type="checkbox"]:checked:after,
.hero-cat-link i,
.litem-ad,
.filter-inputs-row input:checked:after, i.lfact-icon, .lcomments-title h3 span, .reviews-total-score, .cm-logged-in-as a, .cm-must-log-in a,.lrooms-area , .service-ithead span
,.footer-list-inline a,.widget-title .rsswidget:hover,.geodir-category-content h3 a:hover
{
    color: '.$theme_color_opt.';
}
.litem-ad, .tag-items-wrap a:hover, .tagcloud a:hover, .mdimgs-wrap ul,.loader-inner {
    border-color: '.$theme_color_opt.';
}
.loader-inner {
    -webkit-box-shadow: 0 0 0 1px '.$theme_color_opt.' inset;
    box-shadow: 0 0 0 1px '.$theme_color_opt.' inset;
}
.progress-bar__progress{
    stroke: '.$theme_color_opt.';
}
.notification-list-remove,
.listing-type-active,
.listing-type-active:hover,
.tabs-working-hours .tabs-menu .active,
.cthiso-filters a.cthiso-filter-active,
.loading-indicator span,
.contact-item:after,
.cal-months-footer .btn-cal-cancel,
#chat-app .closechat_btn,
.body-homeradar div.product .woocommerce-tabs ul.tabs li.active,
.body-homeradar div.product form.cart .button,
.cth-woo-content-bot .woocommerce-loop-product__link,
.woocommerce-mini-cart__buttons.buttons a.button.checkout,
.body-homeradar nav.woocommerce-pagination .page-numbers:hover,
.body-homeradar nav.woocommerce-pagination .page-numbers.current,
.btn-unlock-month,
input.button-primary,
.listing-slider-wrap .lc-wbtn,
.switchbtn input:checked + .switchbtn-label, .lmembers-carousel-wrap .slick-dots li.slick-active button,.tag-items-wrap a:hover, .tagcloud a:hover,
.woocommerce-product-search button, .sticky-post-badge, .services-item.sty2 .service-icon, .follower-tabs li.current,
.message-input button,.to-top,.chat-widget-button,.cat-opt, .loader-inner:before
{
    background: '.$theme_color_opt.';
}
.btn-link,
.submit-field .lfield-icon,.edit-listing-link,.team-info h4, .list-item-widget-contacts li span i, .contats-list li span i,
.opening-hours .current-status,
.section-title.st-st2 .sec-title, .notification-msg a, .photoUpload > span i,.contact-date, .dashboard-chat-app-header i, .fchat-chatting-title a, .mdimgs-wrap ul .fu-text i,
.ctb-modal-close, .widget_archive ul li:after, 
.widget_meta ul a, .widget_rss ul a, .widget_recent_entries ul a, .widget_recent_comments ul a, #today
  {
    color: '.$theme_color_opt.';
}
.widget_archive,
.widget_pages,
.widget_nav_menu{
    a:hover{
        color: '.$theme_color_opt.';
    }
}

.checkinout-field .cal-date-checked, .checkinout-field .cal-date-checked:hover,.btn-check-availability, .available-cal-months .cal-date-available {
    background-color: '.$theme_color_opt.';
}
.green-bg{
    background: #5ECFB1;
}
.orange-bg   {
    background: #E9776D;
}

.del-bg,
.red-bg{
    background: #F75C96;
}
.yellow-bg{
    background: #F8BD38;
}
.purp-bg{
    background: #BE31E3;
}
.dark-blue-bg {
    background: #3d528b;
}
.body-homeradar ul.products li.product .onsale,.body-homeradar span.onsale{
    background-color: #5ECFB1;
}
.woocommerce-mini-cart__buttons.buttons a, .body-homeradar.woocommerce-cart table.cart td.actions .coupon button.button, .body-homeradar.woocommerce-cart .cart-collaterals .cart_totals button.button,
.body-homeradar .cth-add-to-cart a.product_type_grouped, .body-homeradar .cth-add-to-cart a.product_type_variable, .body-homeradar .cth-add-to-cart a.add_to_cart_button,
.body-homeradar.woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .body-homeradar.woocommerce-cart table.cart td.actions button.button, .body-homeradar.woocommerce-checkout .place-order button.button.alt
{
    background-color: '.$theme_color_opt.';
}
.body-homeradar .cth-add-to-cart a.product_type_grouped:hover, .body-homeradar .cth-add-to-cart a.product_type_variable:hover, .body-homeradar .cth-add-to-cart a.add_to_cart_button:hover{
    background-color: '.$lighter_color.';
}
.body-homeradar div.product p.price,
.body-homeradar ul.products li.product .price{
    color: '.$theme_color_opt.';
}



.main-header{
    background: '.esc_attr(homeradar_global_var('header-bg-color', 'rgba', true, '#2F3B59')).'; 
    color: '.esc_attr(homeradar_get_option('header-text-color', '#fff')).';
}



.header-search_btn, .main-header:before,
.header-search_container{
    background: #'.$colorChanger->lighten( esc_attr(homeradar_global_var('header-bg-color', 'color', true, '#3d528b')), 20) .'; 
}


.nav-holder nav li a{
    color: '.esc_attr(homeradar_global_var('menu_colors', 'regular', true, '#fff')).';
}
.nav-holder nav li a:hover{
    color: '.esc_attr(homeradar_global_var('menu_colors', 'hover', true, '#fff')).';
}
.nav-holder nav li.current-menu-ancestor>a, .nav-holder nav li.current-menu-item>a{
    color: '.esc_attr(homeradar_global_var('menu_colors', 'active', true, '#fff')).';
}
.nav-holder nav li ul{
    background: '.esc_attr(homeradar_global_var('submenu-bg-color', 'rgba', true, '#fff')).';
}
.nav-holder nav li ul a{
    color: '.esc_attr(homeradar_global_var('submenu_colors', 'regular', true, '#fff')).';
}
.nav-holder nav li ul a:hover{
    color: '.esc_attr(homeradar_global_var('submenu_colors', 'hover', true, '#fff')).';
}
.nav-holder nav li ul li.current-menu-ancestor>a, .nav-holder nav li ul li.current-menu-item>a{
    color: '.esc_attr(homeradar_global_var('submenu_colors', 'active', true, '#fff')).';
}

.sub-footer{
    background: '.esc_attr(homeradar_global_var('subfooter-bg-color', 'rgba', true, '#f5f7fb')).';
}


';   
        // Remove whitespace
        $inline_style = homeradar_stripWhitespace($inline_style);
        
        return $inline_style;
    }
}

if( !function_exists('homeradar_headerstyle') ){
    function homeradar_headerstyle(){
        $header_height = (float)homeradar_get_option('header_height', 80);
        $inline_style = '
.main-header{
    height: '.$header_height.'px;
}
#wrapper{
    padding-top: '.$header_height.'px;
}

.admin-bar #wrapper {
  padding-top: '.($header_height+32).'px;
}

.admin-bar .map-container.column-map {
  top: '.($header_height+32).'px; 
}

.admin-bar .hidden-search-column,
.admin-bar .list-main-wrap-header.anim_clw {
  top: '.($header_height+32).'px; }

@media screen and (max-width: 782px) {
  .admin-bar #wrapper {
    padding-top: '.($header_height+46).'px; } 
}

';
        // Remove whitespace
        $inline_style = homeradar_stripWhitespace($inline_style);
        
        return $inline_style;
    }
}