<?php
/* banner-php */
/**
 * HomeRadar back compat functionality
 *
 * Prevents HomeRadar from running on WordPress versions prior to 5.0,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 5.0.
 *
 */

/**
 * Prevent switching to HomeRadar on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since HomeRadar 1.0
 */
function homeradar_switch_theme() {
	switch_theme( WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'homeradar_upgrade_notice' );
}
add_action( 'after_switch_theme', 'homeradar_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * HomeRadar on WordPress versions prior to 5.0.
 *
 * @since HomeRadar 1.0
 *
 * @global string $wp_version WordPress version.
 */
function homeradar_upgrade_notice() {
	$message = sprintf( esc_html__( 'HomeRadar requires at least WordPress version 5.2. You are running version %s. Please upgrade and try again.', 'homeradar' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 5.0.
 *
 * @since HomeRadar 1.0
 *
 * @global string $wp_version WordPress version.
 */
function homeradar_customize() {
	wp_die( sprintf( esc_html__( 'HomeRadar requires at least WordPress version 5.2. You are running version %s. Please upgrade and try again.', 'homeradar' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'homeradar_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 5.0.
 *
 * @since HomeRadar 1.0
 *
 * @global string $wp_version WordPress version.
 */
function homeradar_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( esc_html__( 'HomeRadar requires at least WordPress version 5.2. You are running version %s. Please upgrade and try again.', 'homeradar' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'homeradar_preview' );
