<?php
/* banner-php */
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<?php if ( have_comments() || comments_open() ) : ?>
<div class="list-single-main-container comments-and-form-wrap mt-30">
<?php if ( have_comments() ) : ?>
<!-- psingle-block-box -->   
<div class="psingle-block-box fl-wrap" id="post-comments">
    <h3 class="post-comm-counter"><?php esc_html_e( 'Comments - ', 'homeradar' );?><span> <?php echo number_format_i18n( get_comments_number() ) ;?> </span></h3>
    <?php 
	$args = array(
		'walker'            => null,
		'max_depth'         => '',
		'style'             => 'div',
		'callback'          => 'homeradar_comments',
		'end-callback'      => null,
		'type'              => 'all',
		'reply_text'        => esc_html__('Reply','homeradar'),
		'page'              => '',
		'per_page'          => '',
		'avatar_size'       => 50,
		'reverse_top_level' => null,
		'reverse_children'  => '',
		'format'            => 'html5', //or xhtml if no HTML5 theme support
		'short_ping'        => false, // @since 3.6,
	    'echo'     			=> true, // boolean, default is true
	);
	?>
	<div class="list-single-main-item_content fl-wrap">
        <div class="reviews-comments-wrap">
        	<?php wp_list_comments($args);?>
        </div>
    </div>
    <?php
	// Are there comments to navigate through?
	if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
	?>
	<div class="comments-nav">
		<ul class="pager clearfix">
			<li class="previous"><?php previous_comments_link( wp_kses(__( '<i class="fa fa-angle-left"></i> Previous Comments', 'homeradar' ), array('i'=>array('class'=>array())) ) ); ?></li>
			<li class="next"><?php next_comments_link( wp_kses(__( 'Next Comments <i class="fa fa-angle-right"></i>', 'homeradar' ), array('i'=>array('class'=>array())) ) ); ?></li>
		</ul>
	</div>
	<?php endif; // Check for comment navigation ?>

  	<?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.' , 'homeradar' ); ?></p>
	<?php endif; ?>
</div>
<!-- psingle-block-box end -->   
<?php endif; ?>


<?php if(comments_open( )) : ?>
<!-- psingle-block-box -->   
<div class="psingle-block-box fl-wrap" id="post-respond">
    <div id="add-review" class="add-review-box">
        <?php
    		$commenter = wp_get_current_commenter();
    		$req = get_option( 'require_name_email' );
			$aria_req = ( $req ? " aria-required='true'" : '' );
			$char_req = ( $req ? '*' : '' );

			$comment_args = array(
			'title_reply'=> esc_html__( 'Add Comment', 'homeradar' ),
			'fields' => apply_filters( 'comment_form_default_fields', 
			array(                     
					'author' => '<div class="row"><div class="col-md-6 hasIcon mb-20"><label for="author">'.esc_html__('Your Name ','homeradar'). $char_req .'<span class="dec-icon"><i class="fas fa-user"></i></span></label><input type="text" class="has-icon" id="author" name="author" placeholder="'.esc_attr__('Your Name ','homeradar'). $char_req .'" value="' . esc_attr( $commenter['comment_author'] ) . '" ' . $aria_req . ' size="40"></div>',
					'email' =>'<div class="col-md-6 hasIcon mb-20"><label for="email">'.esc_html__('Your Email ','homeradar'). $char_req .'<span class="dec-icon"><i class="fas fa-envelope"></i></span></label><input class="has-icon" id="email" name="email" type="email" placeholder="'.esc_attr__('Your Email ','homeradar'). $char_req .'" value="' . esc_attr(  $commenter['comment_author_email'] ) .'" ' . $aria_req . ' size="40"></div></div>',
					) 
				),
			'comment_field' => '<textarea name="comment" id="comment" cols="40" rows="3" placeholder="'.esc_attr__('Your Comment:','homeradar').'" '.$aria_req.'></textarea>',
			'id_form'=>'commentform',
			'class_form'=>'add-comment custom-form',
			'id_submit' => 'submit',
			'class_submit'=>'btn color2-bg',
			'label_submit' => esc_html__('Submit Comment','homeradar'),
			'must_log_in'=> '<p class="not-empty">' . __( 'You must be <a class="comment-log-popup logreg-modal-open" href="#">logged in</a> to post a comment.' ,'homeradar') . '</p>',
			'logged_in_as' => '<p class="not-empty">' . sprintf( wp_kses(__( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s">Log out?</a>','homeradar' ),array('a'=>array('href'=>array(),'title'=>array(),'target'=>array())) ), ( method_exists('Esb_Class_Dashboard', 'screen_url') ? Esb_Class_Dashboard::screen_url() : admin_url( 'profile.php' ) ), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '</p>',
			'comment_notes_before' => '<p class="email-safe">'.esc_html__('Your email is safe with us.','homeradar').'</p>',
			'comment_notes_after' => '',
			);

			if( function_exists( 'homeradar_addons_get_login_button_attrs' ) ){
				$logBtnAttrs = homeradar_addons_get_login_button_attrs( '', 'current' );
				$comment_args['must_log_in'] = sprintf( __( 'You must be <a class="comment-log-popup %1$s" href="%2$s">logged in</a> to post a comment.' ,'homeradar'), esc_attr( $logBtnAttrs['class'] ), esc_url( $logBtnAttrs['url'] ) );
			}
		?>
		<?php comment_form($comment_args); ?>
	</div>
</div>
<!-- psingle-block-box end --> 

<?php endif;?>
</div>
<?php endif;?>

