<?php
/* banner-php */
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 */


get_header(); 

?>
<section class="parallax-section color-bg ovf-hidden" data-scrollax-parent="true" id="main-sec">
    <div class="container idx-5">
        <div class="error-wrap">
            <div class="hero-text-big"><?php esc_html_e( '404','homeradar' ); ?></div>
            <?php echo wp_kses( homeradar_get_option( 'error404_msg'), 'cth' ); ?>
            <div class="clearfix"></div>
            <?php get_search_form();?>
            <div class="clearfix"></div>
            <?php 
            if (homeradar_get_option( 'error404_btn' )) : 
            ?>
                <p><?php esc_html_e( 'Or', 'homeradar' );?></p>
                <a href="<?php echo esc_url( home_url() );?>" class="btn color-bg"><?php esc_html_e( 'Back to Home Page', 'homeradar' ); ?></a>
            <?php 
            endif; ?>
        </div>
    </div>
    <div class="pwh_bg fw-pwh" data-bg="<?php echo esc_url( homeradar_get_attachment_thumb_link( homeradar_get_option( 'error404_bg' ), 'full' )  );?>">
        <div class="mrb_pin vis_mr mrb_pin3 "></div>
        <div class="mrb_pin vis_mr mrb_pin4 "></div>
    </div>
</section>
<?php get_footer();

