<?php
/* add_ons_php */

/**
 * Core class used to implement a Recent Posts widget.
 *
 *
 * @see WP_Widget
 */
class HomeRadar_Agents extends WP_Widget {

	/**
	 * Sets up a new Recent Posts widget instance.
	 *
	 * @access public
	 */
	public function __construct() {
		$widget_ops = array('classname' => 'homeradar_agents', 'description' => '' );
		parent::__construct('homeradar-agents', __('HomeRadar Recent Agents','homeradar-add-ons'), $widget_ops);
		$this->alt_option_name = 'homeradar_agents';
	}

	/**
	 * Outputs the content for the current Recent Posts widget instance.
	 *
	 * @access public
	 *
	 * @param array $args     Display arguments including 'before_title', 'after_title',
	 *                        'before_widget', and 'after_widget'.
	 * @param array $instance Settings for the current Recent Posts widget instance.
	 */
	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number )
			$number = 5;
		// $show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;
		$show_thumbnail = isset( $instance['show_thumbnail'] ) ? $instance['show_thumbnail'] : true;
		
		// $show_comment = isset( $instance['show_comment'] ) ? $instance['show_comment'] : false;
		$show_btn = isset( $instance['show_btn'] ) ? $instance['show_btn'] : true;

		/**
		 * Filter the arguments for the Recent Posts widget.
		 *
		 *
		 * @see WP_Query::get_posts()
		 *
		 * @param array $args An array of arguments used to retrieve the recent posts.
		 */
		$r = new WP_Query( apply_filters( 'widget_agents_args', array(
			'post_type'			  => 'lagent',
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
		) ) );

		if ($r->have_posts()) :
		?>
		<?php echo $args['before_widget']; ?>
		<?php if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
		<div class="box-widget-content">
			<div class="widget-posts fl-wrap">
				<ul class="no-list-style widget-agents">
				<?php while ( $r->have_posts() ) : $r->the_post(); ?>
					<li class="widget-posts-item clearfix">
					<?php if(has_post_thumbnail( ) && $show_thumbnail == true) :?>
		                <a href="<?php the_permalink(); ?>" class="widget-posts-img"><?php the_post_thumbnail( 'homeradar-recent',array('class'=>'respimg'));?></a>
		            <?php endif;?>
		            	<div class="widget-posts-descr agent-post_descr<?php if($show_thumbnail == false || !has_post_thumbnail( ) ) echo ' widget-hide-thumb';?>">

		                    <h4><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>

	                        <div class="agent-post_descr_counter fl-wrap"><span>21</span> Property Listings</div>
	                        <?php 
                            $rating = get_post_meta( get_the_ID(), ESB_META_PREFIX.'rating_average', true ); 
                            if( !empty($rating) ) :
                                $rating_base = (int)homeradar_addons_get_option('rating_base'); 
                                if(empty($rating_base)) $rating_base = 5;
                            ?>
                            <div class="listing-rating card-popup-rainingvis" data-rating="<?php echo $rating; ?>" data-stars="<?php echo $rating_base; ?>"></div>
                            <?php 
                            endif; ?>
	                        <?php 
				            $email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'email', true );
				            $phone = get_post_meta( get_the_ID(), ESB_META_PREFIX.'phone', true );
				            ?>
				            <?php if( !empty($email) ): ?><a href="mailto:<?php echo esc_attr( $email ) ;?>" class="tolt ftr-btn" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Write Message', 'homeradar-add-ons' ); ?>"><i class="fal fa-envelope"></i></a><?php endif; ?>
				            <?php if( !empty($phone) ): ?><a href="tel:<?php echo esc_attr( $phone );?>" class="tolt ftr-btn" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Call Now', 'homeradar-add-ons' ); ?>"><i class="fal fa-phone"></i></a><?php endif; ?>

		                </div>
		            </li>
				<?php endwhile; ?>
	            </ul>

				<?php if( $show_btn ): ?><a href="<?php echo get_permalink( esb_addons_get_wpml_option( 'agents_page' ) ); ?>" class="btn float-btn color-bg small-btn widget-viewall-btn mt-15"><?php _e( 'View All Agents', 'homeradar-add-ons' ); ?></a><?php endif; ?>
	        </div>

	    </div>
		<?php echo $args['after_widget']; ?>
		<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;
	}

	/**
	 * Handles updating the settings for the current Recent Posts widget instance.
	 *
	 * @access public
	 *
	 * @param array $new_instance New settings for this instance as input by the user via
	 *                            WP_Widget::form().
	 * @param array $old_instance Old settings for this instance.
	 * @return array Updated settings to save.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['number'] = (int) $new_instance['number'];
		// $instance['show_date'] = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
		$instance['show_thumbnail'] = isset( $new_instance['show_thumbnail'] ) ? (bool) $new_instance['show_thumbnail'] : true;
		// $instance['show_comment'] = isset( $new_instance['show_comment'] ) ? (bool) $new_instance['show_comment'] : false;
		$instance['show_btn'] = isset( $new_instance['show_btn'] ) ? (bool) $new_instance['show_btn'] : false;
		return $instance;
	}

	/**
	 * Outputs the settings form for the Recent Posts widget.
	 *
	 * @access public
	 *
	 * @param array $instance Current settings.
	 */
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		// $show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
		$show_thumbnail = isset( $instance['show_thumbnail'] ) ? (bool) $instance['show_thumbnail'] : true;
		// $show_comment = isset( $instance['show_comment'] ) ? (bool) $instance['show_comment'] : false;
		$show_btn = isset( $instance['show_btn'] ) ? (bool) $instance['show_btn'] : true;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ,'homeradar-add-ons'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:' ,'homeradar-add-ons'); ?></label>
		<input class="tiny-text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="number" step="1" min="1" value="<?php echo $number; ?>" size="3" /></p>
		
		<p><input class="checkbox" type="checkbox" <?php checked( $show_thumbnail ); ?> id="<?php echo $this->get_field_id( 'show_thumbnail' ); ?>" name="<?php echo $this->get_field_name( 'show_thumbnail' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_thumbnail' ); ?>"><?php _e( 'Display post thumbnail?' ,'homeradar-add-ons'); ?></label></p>

		
		<p><input class="checkbox" type="checkbox" <?php checked( $show_btn ); ?> id="<?php echo $this->get_field_id( 'show_btn' ); ?>" name="<?php echo $this->get_field_name( 'show_btn' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_btn' ); ?>"><?php _e( 'Show view all button?','homeradar-add-ons'); ?></label></p>

<?php
	}
}
