<?php
/* add_ons_php */


get_header(  );
?>
<div id="ltop_sec"></div>
<?php
/* Start the Loop */
while ( have_posts() ) : the_post();

	$hide_address = $disable_address_url = $hide_phone = $hide_email = $hide_web = $hide_whatsapp = $hide_skype = $hide_offnum = $hide_faxnum = '';
	$latitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'latitude', true );
	$longitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'longitude', true );
	$email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'email', true );
	$phone = get_post_meta( get_the_ID(), ESB_META_PREFIX.'phone', true );
	$office_number = get_post_meta( get_the_ID(), ESB_META_PREFIX.'office_number', true );
	$fax_number = get_post_meta( get_the_ID(), ESB_META_PREFIX.'fax_number', true );
	$skype = get_post_meta( get_the_ID(), ESB_META_PREFIX.'skype', true );
	$whatsapp = get_post_meta( get_the_ID(), ESB_META_PREFIX.'whatsapp_number', true );
	
	$address = get_post_meta( get_the_ID(), ESB_META_PREFIX.'address', true );
	$website = get_post_meta( get_the_ID(), ESB_META_PREFIX.'website', true );

	$address_url = 'javascript:void(0);';
	if( $disable_address_url != 'yes' && $longitude != '' && $latitude != '' ) $address_url = 'https://www.google.com/maps/search/?api=1&query='.esc_attr($latitude).','.esc_attr($longitude);

	?>

	<!-- breadcrumbs-->
    <div class="breadcrumbs-wrapper inline-breadcrumbs fw-breadcrumbs sp-brd fl-wrap">
        <div class="container">
            <div class="inline-breadcrumbs-wrap flex-items-center jtf-space-between flw-wrap">
                <?php if( function_exists('homeradar_get_template_part') ) homeradar_get_template_part( 'template-parts/breadcrumbs', '', array( 'is_top'=>false) ); ?>
                <div class="inline-breadcrumbs-right flex-items-center">
                    <?php homeradar_addons_echo_socials_share(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumbs end -->
    <!-- col-list-wrap -->
    <section class="gray-bg small-padding ">
        <div class="container">

        	<div class="card-info smpar fl-wrap">
            	<div class="lhead-more-wrap">
                    <div class="box-widget-menu-btn smact"><i class="far fa-ellipsis-h"></i></div>
                    <div class="show-more-snopt-tooltip bxwt">
                        <?php if( comments_open() ): ?><a class="custom-scroll-link" href="#post-respond"> <i class="fas fa-comment-alt"></i><?php _e( 'Write a review', 'homeradar-add-ons' ); ?></a><?php endif; ?>
                    	<!-- <a href="#"> <i class="fas fa-exclamation-triangle"></i> Report </a> -->
                        
                    </div>
                </div>
                <?php $coverImage = get_post_meta( get_the_ID(), ESB_META_PREFIX.'coverImage', true );  ?>
                <div class="bg-wrap bg-parallax-wrap-gradien">
                    <div class="bg" <?php if(!empty($coverImage['id'])):?>data-bg="<?php echo wp_get_attachment_image_url( $coverImage['id'], 'full' );?>"<?php endif;?>></div>
                </div>
                <?php if(has_post_thumbnail()): ?>
                <div class="card-info-media">
                    <?php the_post_thumbnail( 'thumbnail' ); ?>
                </div>
                <?php endif; ?>
                <div class="card-info-content">
                    <div class="agent_card-title fl-wrap">
                        <h4><?php the_title(); ?></h4>
                        <div class="geodir-category-location fl-wrap flex-items-center">
                            <?php if( $hide_address != 'yes' && $address != '' ): ?><a class="agency-address" href="<?php echo $address_url; ?>"><?php echo esc_html( $address ); ?></a><?php endif; ?>
                            
                            <?php 
                            $rating = get_post_meta( get_the_ID(), ESB_META_PREFIX.'rating_average', true ); 
                            if( !empty($rating) ) :
                                $rating_base = (int)homeradar_addons_get_option('rating_base'); 
                                if(empty($rating_base)) $rating_base = 5;
                            ?>
                            <div class="listing-rating card-popup-rainingvis ml-20" data-rating="<?php echo $rating; ?>" data-stars="<?php echo $rating_base; ?>"><span class="re_stars-title review-text"><?php echo homeradar_addons_rating_text($rating); ?></span></div>
                            <?php 
                            endif; ?>
                        </div>
                    </div>
                    <div class="list-single-stats">
                        <ul class="no-list-style">
                            <li><span class="viewed-counter"><i class="fas fa-eye"></i><?php echo sprintf(__( 'Viewed - %d', 'homeradar-add-ons' ), homeradar_addons_get_post_views(get_the_ID()) ); ?></span></li>
                            <?php $comments = get_comments_number(); ?>
                            <li><span class="bookmark-counter"><i class="fas fa-comment-alt"></i><?php echo sprintf(_nx( 'Review - %d', 'Reviews - %d', $comments, 'Comment count', 'homeradar-add-ons' ), $comments ); ?></span></li>
                            <?php 
                            $post_args = array(
                                'post_type'         => 'listing',
                                'posts_per_page'    => -1,
                                'post_status'       => 'publish',
                                // 'meta_query' => array(
                                //     array(
                                //         'key'     => ESB_META_PREFIX.'lagent',
                                //         'value'   => get_the_ID(),
                                //     ),
                                // ),
                            );
                            $lpostsCount = count(get_posts( $post_args ));
                            ?>
                            <li><span class="bookmark-counter"><i class="fas fa-sitemap"></i><?php echo sprintf(_nx( 'Listing - %d', 'Listings - %d', $lpostsCount, 'Listing count', 'homeradar-add-ons' ), $lpostsCount ); ?></span></li>

                        </ul>
                    </div>
                    <?php 
                    if( get_post_meta( get_the_ID(), ESB_META_PREFIX.'verified', true ) == 'yes' ): ?>
                        <div class="card-verified tolt" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-user-check"></i></div>
                    <?php else:  ?>
                        <div class="card-verified cv_not tolt" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Not Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-minus-octagon"></i></div>
                    <?php endif; ?>
                </div>
            </div>
                    
            <div class="row">
                <div class="col-md-8">
                    
                    <!-- list-single-main-item -->
                    <div class="lsingle-block-box lsingle-block-bdrs-bottom">
                        <div class="lsingle-block-title">
                            <h3><?php _e( 'About This Agency', 'homeradar-add-ons' ); ?></h3>
                        </div>
                        <div class="lsingle-block-content">
                            <?php the_content(); ?>
                            <?php 
                            $taxs = get_the_terms(get_the_ID(), 'agency_city');
                            if ( $taxs && ! is_wp_error( $taxs ) ){ ?>
                            <div class="list-single-tags fl-wrap tags-stylwrap dis-flex mt-20">
                                <span class="tags-title"><?php _e( 'Service Areas:', 'homeradar-add-ons' ); ?></span>
                                <div class="tag-items-wrap dis-flex-wrap">
                                <?php
                                $agentsPage = get_permalink( esb_addons_get_wpml_option('agencies_page') );
                                foreach( $taxs as $key => $tax){
                                    echo sprintf( '<a href="%1$s" class="agency-city">%2$s</a> ',
                                        add_query_arg( 'city', $tax->slug, $agentsPage ),
                                        // homeradar_addons_get_term_link( $tax->term_id, 'agency_city' ),
                                        esc_html( $tax->name )
                                    );
                                } ?>
                                </div>
                            </div>
                            <?php
                            } ?>
                        </div>
                    </div>
                    <!-- list-single-main-item end -->  
                    <?php 
                    $tabOne = uniqid('listing'); 
                    $tabTwo = uniqid('reviews');
                    $tabThree = uniqid('agents');
                    ?> 
                    <!-- content-tabs-wrap -->
                    <div class="content-tabs-wrap tabs-act fl-wrap tabs-wrapper  agency-content-tabs">
                        <div class="content-tabs fl-wrap">
                            <ul class="tabs-menu fl-wrap no-list-style dis-flex-wrap">
                                <li class="current"><a href="#<?php echo $tabOne; ?>"><?php _ex( 'Listing', 'Single Agency', 'homeradar-add-ons' ); ?></a></li>
                                <li><a href="#<?php echo $tabThree; ?>"><?php _ex( 'Agents', 'Single Agency', 'homeradar-add-ons' ); ?></a></li>
                                <li><a href="#<?php echo $tabTwo; ?>"><?php _ex( 'Reviews', 'Single Agency', 'homeradar-add-ons' ); ?></a></li>
                            </ul>
                        </div>
                        <!--tabs -->                       
                        <div class="tabs-container">
                            <!--tab -->
                            <div class="tab">
                                <div id="<?php echo $tabOne; ?>" class="tab-content first-tab agency-listings-tab">

                                	<div class="listings-grid-wrapper">
                                        <!-- list-main-wrap-->
                                        <div class="list-main-wrap fl-wrap card-listing listings-full-map">
                                            
                                            <?php 
                                            if (is_front_page()) {
                                                $paged = (get_query_var('page')) ? get_query_var('page') : 1;
                                            } else {
                                                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                                            }
                                            $post_args = array(
                                                'post_type'         => 'listing',
                                                'paged'             => $paged,
                                                'posts_per_page'    => homeradar_addons_get_option('listings_count'),
                                                'orderby'           => homeradar_addons_get_option('listings_orderby'),
                                                'order'             => homeradar_addons_get_option('listings_order'),
                                                'post_status'       => 'publish',
                                            );
                                            homeradar_addons_get_template_part('templates/loop','custom', array('post_args'=>$post_args, 'ajax_pagination'=>false, 'card_layout'=>'list', 'add_mapdata'=>false)); 
                                            ?>
                                            
                                        </div><!-- list-main-wrap end-->
                                    </div>
                                    						
                                </div>
                            </div>
                            <!--tab  end-->
                            <!--tab -->
                            <div class="tab">
                                <div id="<?php echo $tabThree; ?>" class="tab-content agency-agents-tab">
                                    <div class="agents-grid-wrapper mt-20">
                                    	<?php 
                                    	$post_args = array(
							                'post_type' 		=> 'lagent',
							                'paged' 			=> 1,
							                'posts_per_page'	=> -1,
							                'orderby'			=> 'date',
							                'order'				=> 'DESC',
							                'post_status' 		=> 'publish',
							                'meta_key'     		=> ESB_META_PREFIX.'agency',
    										'meta_value'   		=> get_the_ID(),
							            );
							            $posts_query = new \WP_Query($post_args);
            							if($posts_query->have_posts()): ?>
            								<div class="cthiso-medium-pad cthiso-flex cthiso-two-cols">
            								<?php 
            								while($posts_query->have_posts()): $posts_query->the_post(); ?>
            									<div class="cthiso-item">
            										<?php homeradar_addons_get_template_part( 'template-parts/agent', false ); ?>
            									</div>
            								<?php
            								endwhile; ?>
            								</div>
            								<?php
            							endif; // check has posts
            							wp_reset_postdata();
							            ?>
                                    </div>	
                                </div>
                            </div>
                            <!--tab end-->
                            <!--tab -->
                            <div class="tab">
                                <div id="<?php echo $tabTwo; ?>" class="tab-content post-comments-tab">
                                    <?php echo do_shortcode( '[cth_lreviews]' ); ?>
                                </div>
                            </div>
                            <!--tab end-->							
                        </div>
                        <!--tabs end-->  
                    </div>
                    <!-- content-tabs-wrap end -->
                </div>
                <!-- col-md 8 end -->
                <!--  sidebar-->
                <div class="col-md-4">
                    <!--box-widget-->
                    <div class="box-widget fl-wrap">
                        <div class="box-widget-title fl-wrap"><?php _ex( 'Agency Contacts', 'Single Agency', 'homeradar-add-ons' ); ?></div>
                        <div class="box-widget-content fl-wrap">
                            <div class="contats-list clm fl-wrap">
                                <ul class="no-list-style">
                                    
			                        <?php 
			                        if( $phone != '' && $hide_phone != 'yes' ): ?>
			                        <li class="aucontact-phone"><span><i class="fal fa-phone"></i> <?php _e( 'Phone :', 'homeradar-add-ons' );?></span> <a href="tel:<?php echo esc_attr( $phone );?>"  rel="nofollow"><?php echo esc_html($phone);?></a></li>
			                        <?php endif;?>
			                        <?php 
			                        if( $office_number != '' && $hide_offnum != 'yes' ): ?>
			                        <li class="aucontact-office-number"><span><i class="fal fa-phone-office"></i> <?php _e( 'Office Number :', 'homeradar-add-ons' );?></span> <a href="tel:<?php echo esc_attr( $office_number );?>"  rel="nofollow"><?php echo esc_html($office_number);?></a></li>
			                        <?php endif;?>
			                        <?php 
			                        if( $fax_number != '' && $hide_faxnum != 'yes' ): ?>
			                        <li class="aucontact-fax"><span><i class="fal fa-fax"></i> <?php _e( 'Fax Number :', 'homeradar-add-ons' );?></span> <a href="fax:<?php echo esc_attr( $fax_number );?>"  rel="nofollow"><?php echo esc_html($fax_number);?></a></li>
			                        <?php endif;?>

			                        <?php 
			                        if($email != '' && $hide_email != 'yes' ): ?>
			                        <li class="aucontact-email"><span><i class="fal fa-envelope"></i> <?php _e( 'Mail :', 'homeradar-add-ons' );?></span> <a href="mailto:<?php echo esc_attr( $email ) ;?>"  rel="nofollow"><?php echo  esc_html($email);?></a></li>
			                        <?php endif;?>
			                        <?php
			                        if( $hide_address != 'yes' && $address != ''): 
			                            
			                        ?>
			                        <li class="aucontact-address"><span><i class="fal fa-map-marker"></i> <?php _e( 'Address :', 'homeradar-add-ons' );?></span> <a href="<?php echo $address_url;?>" target="_blank"  rel="nofollow"><?php echo esc_html($address);?></a></li>
			                        <?php endif;?>
			                        <?php 
			                        if($website != '' && $hide_web != 'yes' ): ?>
			                        <li class="aucontact-web"><span><i class="fal fa-browser"></i> <?php _e( 'Website :', 'homeradar-add-ons' );?></span> <a href="<?php echo esc_url($website) ;?>" target="_blank"  rel="nofollow"><?php echo  $website;?></a></li>
			                        <?php endif;?>
			                        <?php 
			                        if($whatsapp != '' && $hide_whatsapp != 'yes' ): ?>
			                        <li class="aucontact-whatsapp"><span><i class="fab fa-whatsapp"></i> <?php _e( 'Whatsapp: ', 'homeradar-add-ons' );?></span> <a href="<?php echo 'https://wa.me/'.$whatsapp; ?>" target="_blank"  rel="nofollow"><?php echo esc_html($whatsapp);?></a></li>
			                        <?php endif;?>
			                        <?php 
			                        if($skype != '' && $hide_skype != 'yes' ): ?>
			                        <li class="aucontact-whatsapp"><span><i class="fab fa-skype"></i> <?php _e( 'Skype: ', 'homeradar-add-ons' );?></span> <a href="<?php echo 'skype:'.$skype.'?call'; ?>" target="_blank"  rel="nofollow"><?php echo esc_html($skype);?></a></li>
			                        <?php endif;?>
                                </ul>
                            </div>
                            <div class="profile-widget-footer fl-wrap flex-items-center jtf-space-between">
                                <div class="card-info-content_social">
                                    <ul class="no-list-style">
                                    	<?php 
                                        $socials = homeradar_addons_get_socials_list();
                                        foreach ($socials as $val => $lbl) {
                                            $url = get_post_meta( get_the_ID(), ESB_META_PREFIX.$val, true );
                                            if( !empty($url) ): ?>
                                                <li><a href="<?php echo esc_url( $url ); ?>" target="_blank"><i class="fab fa-<?php echo esc_attr($val) ?>"></i></a></li>
                                            <?php
                                            endif;
                                        } 
                                        ?>
                                    </ul>
                                </div>
                                <a href="#sec-contact" class="custom-scroll-link tolt csls" data-microtip-position="left" data-tooltip="Write Message"><i class="fal fa-paper-plane"></i></a>
                            </div>
                        </div>
                    </div>
                    <!--box-widget end --> 
                    <?php 
                    $latitude = '40.7427837';
                    $longitude = '-73.11445617675781';
                    ?>
                    <!--box-widget-->
                    <div class="box-widget fl-wrap">
                        <div class="box-widget-title fl-wrap"><?php _ex( 'Agency Location', 'Single Agency', 'homeradar-add-ons' ); ?></div>
                        <div class="map-widget fl-wrap">
                            <div class="map-container mapC_vis">
                            	<div id="<?php echo uniqid('singleMap'); ?>" 
				                    class="singleMap singleMap-<?php echo esc_attr( homeradar_addons_get_option('map_provider') );?> agency-smap" 
				                    data-lat="<?php echo esc_attr( $latitude );?>" 
				                    data-lng="<?php echo esc_attr( $longitude );?>" 
				                    data-loc="<?php echo esc_attr( $address );?>" 
				                    data-zoom="<?php echo homeradar_addons_get_option('gmap_single_zoom');?>"  
				                    data-marker="<?php echo esc_url( homeradar_addons_get_attachment_thumb_link( homeradar_addons_get_listing_marker( get_the_ID() ) ) ); ?>"></div>


                

                                <!-- <div id="singleMap" data-latitude="40.7427837" data-longitude="-73.11445617675781" data-mapTitle="Our Location" data-infotitle="Mavers RealEstate Agency" data-infotext="70 Bright St New York, USA"></div>
                                <div class="scrollContorl"></div> -->
                            </div>
                        </div>
                    </div>
                    <!--box-widget end --> 	
                    <?php 
                    if(is_active_sidebar('agent-sidebar')){
                        dynamic_sidebar('agent-sidebar');
                    }
                    ?>							
                    
                    <?php 
                    $current_user = wp_get_current_user();
                    $loggedName = '';
                    $loggedEmail = '';
                    $loggedPhone = '';
                    if( is_user_logged_in() ){
                        $loggedName = $current_user->display_name;
                        $loggedEmail = get_user_meta($current_user->ID,  ESB_META_PREFIX.'email', true );
                        if( empty($loggedEmail) ) $loggedEmail = $current_user->user_email;
                        $loggedPhone = get_user_meta($current_user->ID,  ESB_META_PREFIX.'phone', true );
                    }
                    ?>  								
                    <!--box-widget-->
                    <div class="box-widget fl-wrap">
                        <div class="box-widget-fixed-init fl-wrap" id="sec-contact">
                            <div class="box-widget-title"><?php _ex( 'Get In Touch', 'Single Agency', 'homeradar-add-ons' ); ?></div>
                            <div class="box-widget-content fl-wrap">
                                <div class="custom-form">
                                    <form name="contact-agency-form" class="cthajax-form" data-action="contact_agency">
                                        <div class="contact-inner">
                                            <div class="mb-20 hasIcon">
                                                <label><?php _e( 'Your name*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-user"></i></span></label>
                                                <input name="name" type="text" onClick="this.select()" value="<?php echo esc_attr( $loggedName ); ?>" required="required">
                                            </div>
                                            <div class="mb-20 hasIcon">
                                                <label><?php _e( 'Your mail*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-envelope"></i></span></label>
                                                <input name="email" type="email" onClick="this.select()" value="<?php echo esc_attr( $loggedEmail ); ?>" required="required">   
                                            </div>    
                                            <div class="hasIcon mb-20">
                                                <label><?php esc_html_e( 'Phone*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-phone"></i></span></label>
                                                <input name="phone" type="tel" value="<?php echo esc_attr( $loggedPhone ); ?>" required="required">
                                            </div> 
                                            <div class="mb-20 hasIcon">
                                                <textarea name="message" cols="40" rows="3" placeholder="<?php esc_attr_e( 'Your Message:', 'homeradar-add-ons' ); ?>" style="height: 150px"></textarea>
                                            </div>
                                            <div class="cthajax-error mb-20"></div>
                                            <button type="submit" class="cthajax-submit btn float-btn color-bg fw-btn"><?php _e( 'Send', 'homeradar-add-ons' ); ?></button>
                                        </div>
                                            
                                        <input type="hidden" name="pid" value="<?php the_ID(); ?>">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--box-widget end -->               									
                </div>
                <!--   sidebar end-->								
            </div>
        </div>
        <div class="limit-box"></div>
        <div class="clearfix"></div>
    </section>

	<?php
	homeradar_addons_set_post_views(get_the_ID());
endwhile;
// end the loop
?>
<?php
get_footer(  );