<?php
/* add_ons_php */

get_header(  ); 
$css_classes = array(
    'listings-grid-wrap clearfix',
    homeradar_addons_get_option('columns_grid').'-cols',
    'template-column-map-filter'
);
if( homeradar_addons_get_option('show_cats_nav', 'yes') !== 'yes' ) $css_classes['hide-cats-nav'];
$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

?>
<div class="<?php echo esc_attr( $css_class );?>">

    <!-- categoties-column -->
    <div class="categoties-column">
        <?php homeradar_addons_get_template_part( 'template-parts/filter/categories', '', array('tooltip_pos'=> 'right') ); ?>
        <div class="progress-indicator">
            <svg xmlns="http://www.w3.org/2000/svg"
                viewBox="-1 -1 34 34">
                <circle cx="16" cy="16" r="15.9155"
                    class="progress-bar__background" />
                <circle cx="16" cy="16" r="15.9155"
                    class="progress-bar__progress 
                    js-progress-bar" />
            </svg>
        </div>
    </div>
    <!-- categoties-column end -->


    <!-- Map -->
    <div class="map-container column-map left-position-map has-top_search hid-mob-map listings-has-map<?php if(homeradar_addons_get_option('map_provider') == 'mapbox' && 1 ==2 ) echo ' fix-map';?>">
        <?php homeradar_addons_get_template_part('template-parts/filter/map'); ?>
    </div>
    <!-- Map end --> 

    <!-- top-search-content -->
    <div class="top-search-content top-search-wrap listsearch-options">
        <div class="top-search-dec color-bg"><i class="far fa-sliders-h"></i></div>
        <!-- <div class="top-search-content-title">Search:</div> -->
        <div class="close_sb-filter"><i class="fal fa-times"></i></div>
        <div class="more-opt_btn mor-opt-btn_act"><?php _ex( 'Advanced search', 'Filter', 'homeradar-add-ons' ); ?><span><i class="fas fa-caret-down"></i></span></div>
        <?php homeradar_addons_get_template_part( 'templates/filter_form' ); ?>
    </div>
    <!-- top-search-content end --> 

    <!-- col-list-wrap -->
    <div class="col-list-wrap gray-bg ">
        <div class="col-list-wrap_opt fl-wrap">
            <div class="show-hidden-filter col-list-wrap_opt_btn color-bg"><?php _ex( 'Show Filters', 'Filter', 'homeradar-add-ons' ); ?></div>
            <div class="show-hidden-map col-list-wrap_opt_btn color-bg"><?php _ex( 'Show Map', 'Filter', 'homeradar-add-ons' ); ?></div>
        </div>

        <?php homeradar_addons_get_template_part( 'template-parts/filter/head' ); ?>                
        <!-- list-main-wrap-->
        <div class="list-main-wrap fl-wrap card-listing">
            
            <div class="container"> 
                <div class="row">
                    
                    <div class="col-md-12">
                        <?php 
                        if( is_singular('page') ) // custom template for page
                            homeradar_addons_get_template_part('templates/loop','custom'); 
                        else
                            homeradar_addons_get_template_part('templates/loop'); 
                        ?>
                    </div><!-- end col-md-12 -->

                </div><!-- end row -->
            </div><!-- end container -->
            
        </div><!-- list-main-wrap end-->
                            
        <div class="small-footer fl-wrap flex-items-center jtf-space-between">
            <div class="copyright small-ftcopyright"></div>
            <a class="custom-to-top color-bg custom-scroll-link" href="#main-theme"><i class="fas fa-caret-up"></i></a>
        </div>
    </div>
    <!-- col-list-wrap end -->
</div>
<!--template wrap end -->
<div class="limit-box"></div>
<div class="clearfix"></div>
<?php

get_footer(  );