<?php
/* add_ons_php */

get_header(  ); 
$css_classes = array(
    'agents-list-wrap clearfix',
    // homeradar_addons_get_option('columns_grid').'-cols',
    // 'template-no-map'
);

$css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

get_template_part( 'template-parts/post', 'head' ); 
?>
<div class="<?php echo esc_attr( $css_class );?>">
  
    <?php // if( function_exists('homeradar_get_template_part') ) homeradar_get_template_part( 'template-parts/breadcrumbs', '', array( 'is_top'=>true) ); ?>

    <!-- breadcrumbs-->
    <div class="breadcrumbs-wrapper inline-breadcrumbs fw-breadcrumbs sp-brd fl-wrap">
        <div class="container">
            <div class="inline-breadcrumbs-wrap flex-items-center jtf-space-between flw-wrap">
                <?php if( function_exists('homeradar_get_template_part') ) homeradar_get_template_part( 'template-parts/breadcrumbs', '', array( 'is_top'=>false) ); ?>
                <div class="inline-breadcrumbs-right flex-items-center">
                    <?php // homeradar_addons_get_template_part( 'template-parts/filter/categories', '', array('exclass' => 'inline-categories') ); ?>
                    <?php homeradar_addons_echo_socials_share(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumbs end -->

    <?php 

    $keyword = isset($_GET['keyword']) ?  esc_html($_GET['keyword']) : '';
    $city = isset($_GET['city']) ?  esc_html($_GET['city']) : '';
    $category = isset($_GET['category']) ?  esc_html($_GET['category']) : '';
    $meta_queries = array();
    $rfrom = 1;
    $rto = 5;
    if( isset($_GET['rating']) && !empty($_GET['rating'] ) ){
        if(strpos($_GET['rating'], ";") !== false){
            $range = explode(";", $_GET['rating']);
            $range = array_map(function($val){
                return intval($val);
            }, $range);
            if(count($range) == 2){

                $rfrom = $range[0];
                $rto = $range[1];

                $meta_queries[] = array(
                    'key'     => ESB_META_PREFIX.'rating_average',
                    'value'   => $range,
                    'type'    => 'NUMERIC',
                    'compare' => 'BETWEEN',
                );
            }
        }
            
    }

    if(is_front_page()) {
        $paged = (get_query_var('page')) ? get_query_var('page') : 1;
    } else {
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    } 


    $post_args = array(
        'post_type'         => 'lagent',
        'paged'             => $paged,
        // 'posts_per_page'=> $settings['posts_per_page'],
        // 'orderby'=> $settings['order_by'],
        // 'order'=> $settings['order'],

        'post_status'       => 'publish'
    );
    if( !empty($keyword) ) $post_args['s'] = $keyword;
    $taxQuery = array();
    if( !empty($category) ) $taxQuery[] = array(
        'taxonomy'      => 'agent_cat',
        'field'         => 'slug',
        'terms'         => $category,
    );
    if( !empty($city) ) $taxQuery[] = array(
        'taxonomy'      => 'agent_city',
        'field'         => 'slug',
        'terms'         => $city,
    );
    if( !empty($taxQuery) ) $post_args['tax_query'] = $taxQuery;
    if(!empty($meta_queries)){
        if(count($meta_queries)> 1) $meta_queries['relation'] = 'AND';
        $post_args['meta_query'] = $meta_queries;
    } 
    // The Query
    $posts_query = new WP_Query( $post_args ); ?>
    
     <!-- col-list-wrap -->
    <section class="gray-bg small-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <?php 
                    if($posts_query->have_posts()) : ?>
                    <div class="cthiso-flex cthiso-medium-pad cthiso-two-cols mb-20 agents-list">
                    <?php
                        while($posts_query->have_posts()) : $posts_query->the_post(); 
                            
                        ?>
                        <div class="cthiso-item agent-list-item">
                            <?php homeradar_addons_get_template_part( 'template-parts/agent', false ); ?>
                        </div>
                        <!-- dashboard-list end--> 
                    <?php 
                        endwhile; 
                        ?>
                    </div>
                    <?php
                        echo homeradar_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
                    
                        /* Restore original Post Data 
                         * NB: Because we are using new WP_Query we aren't stomping on the 
                         * original $wp_query and it does not need to be reset with 
                         * wp_reset_query(). We just need to set the post data back up with
                         * wp_reset_postdata().
                         */
                        wp_reset_postdata();
                    endif;
                    ?> 
                </div>
                <!-- col-md 8 end -->
                <!--  sidebar-->
                <div class="col-md-4">
                    <!-- Search agents -->
                    <div class="list-searh-input-wrap-title fl-wrap"><i class="far fa-sliders-h"></i><span><?php _e( 'Search Agent', 'homeradar-add-ons' ); ?></span></div>
                    <div class="box-widget-content fl-wrap search-sb" id="filters-column">
                        <form action="<?php echo get_permalink( esb_addons_get_wpml_option( 'agents_page' ) ); ?>" method="get">
                            <!-- listsearch-input-item -->
                            <div class="listsearch-input-item mb-15">
                                <label><?php _e( 'Keywords', 'homeradar-add-ons' ); ?></label>
                                <input type="text" onClick="this.select()" placeholder="<?php esc_attr_e( 'Name , agent...', 'homeradar-add-ons' ); ?>" name="keyword" value="<?php echo $keyword; ?>"/>                                        
                            </div>
                            <!-- listsearch-input-item end-->
                            <?php 
                            $taxes = homeradar_addons_filter_cats('', 3, true, 'agent_city'); ?>
                            <!-- listsearch-input-item -->
                            <div class="listsearch-input-item mb-15">
                                <label><?php _e( 'Cities', 'homeradar-add-ons' ); ?></label>
                                <select data-placeholder="<?php esc_attr_e( 'All Cities', 'homeradar-add-ons' ); ?>" class="chosen-select on-radius no-search-select" name="city">
                                    <option value=""><?php _e( 'All Cities', 'homeradar-add-ons' ); ?></option>
                                    <?php 
                                    foreach ($taxes as $tax) {
                                        echo '<option value="'.$tax['slug'].'" '.selected( $city, $tax['slug'],false).'>'.str_repeat('-', $tax['level']) .$tax['name'].'</option>';
                                    } ?>
                                </select>
                                <div class="clearfix"></div>
                            </div>
                            <!-- listsearch-input-item end-->                                           
                            <!-- listsearch-input-item -->
                            <div class="listsearch-input-item mb-15">
                                <div class="price-rage-wrap fl-wrap rating-range-wrap">
                                    <span class="pr_title"><?php _e( 'Rating:', 'homeradar-add-ons' ); ?></span>
                                    <div class="price-rage-item">
                                        <input class="price-slider" data-type="double" data-from="<?php echo $rfrom; ?>" data-to="<?php echo $rto; ?>" data-step="1" data-min="1" data-max="5" data-prefix="*">
                                        <input type="hidden" name="rating" class="price_range_hidden" value="<?php echo $rfrom.';'.$rto; ?>">
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                            <!-- listsearch-input-item end-->
                            <div class="msotw_footer flex-items-center">
                                <button type="submit" class="btn small-btn float-btn color-bg"><?php _e( 'Search Agents', 'homeradar-add-ons' ); ?></button>
                                <a class="reset-form" href="<?php echo get_permalink( esb_addons_get_wpml_option( 'agents_page' ) ); ?>"> <i class="far fa-sync-alt"></i><?php _e( 'Reset Filters', 'homeradar-add-ons' ); ?></a>
                            </div>

                        </form>
                    </div>
                    <?php 
                    if(is_active_sidebar('agents-list-sidebar')){
                        dynamic_sidebar('agents-list-sidebar');
                    }
                    ?>  
                                                                     
                </div>
                <!--   sidebar end-->                               
            </div>
        </div>
        
    </section>

    
</div>
<!--template wrap end -->
<div class="limit-box"></div>
<div class="clearfix"></div>
<?php

get_footer(  );