<?php
/* add_ons_php */
if( !isset($ajax_pagination) ){
    $ajax_pagination = true;
}
if(!isset($card_layout)) $card_layout = homeradar_addons_get_option('listings_grid_layout');
if(!isset($add_mapdata)) $add_mapdata = true;
if(!isset($post_args)) $post_args = array(
    'post_type' => 'listing',
    'paged' => 1,
    'posts_per_page'=> homeradar_addons_get_option('listings_count'),
    'orderby'=> homeradar_addons_get_option('listings_orderby'),
    'order'=> homeradar_addons_get_option('listings_order'),
    'post_status' => 'publish'
);
$past_events_query = array();
if( homeradar_addons_get_option('hide_past_events') == 'yes' && ( !isset($_GET['past_events']) || $_GET['past_events'] != 'show' ) ){

    $past_events_query =   array(
                            'relation'      => 'OR',
                            array(
                                'key'       => ESB_META_PREFIX.'eventdate_end',
                                'value'     => 'none',
                                'compare'   => '=',
                            ),
                            array(
                                'key'       => ESB_META_PREFIX.'eventdate_end',
                                'value'     => current_time('Y-m-d', 1),
                                'compare'   => '>=',
                                'type'      => 'DATE',
                            ),
                        );
}
if( !empty($past_events_query) ){
    if( !empty($post_args['meta_query']) && is_array($post_args['meta_query']) ){
        $post_args['meta_query'][] = $past_events_query;
    }else{
        $post_args['meta_query'] = array($past_events_query);
    }
}
$post_args = apply_filters( 'homeradar_addons_custom_loop_args', $post_args );
?>
<div class="listing-term-desc"></div>
<div class="listing-item-container init-grid-items" id="lisconfw">
    <div id="listing-items" class="listing-items listing-items-wrapper">
    <?php
    $action_args = array(
        'listings' => array()
    );
    // https://codex.wordpress.org/Function_Reference/do_action_ref_array
    do_action_ref_array( 'homeradar_addons_listing_loop_before', array(&$action_args) );
    $posts_query = new \WP_Query($post_args);
    if($posts_query->have_posts()) :
        /* Start the Loop */
        while($posts_query->have_posts()) : $posts_query->the_post(); 
            homeradar_addons_get_template_part('template-parts/listing', '', array('card_layout'=>$card_layout, 'add_mapdata'=>$add_mapdata));
            // $action_args['listings'][] = get_the_ID();
        endwhile;

    elseif(empty($action_args['listings'])):

        homeradar_addons_get_template_part('template-parts/search-no');

    endif;
        ?>
    </div>
    <div class="listings-pagination-wrap">
        <?php
        if($ajax_pagination) 
            homeradar_addons_ajax_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
        else
            homeradar_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
        ?>
    </div>
    <?php $found_posts = $posts_query->found_posts + count($action_args['listings']); ?>
    <div class="lresults-data" style="display:none;"><?php echo intval($found_posts); ?></div>
</div><!-- end listing-item-container -->
<?php wp_reset_postdata(); ?>
