<?php
/* add_ons_php */
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 */
$bgimg = homeradar_addons_get_option('coming_soon_bg');
$cs_decor = homeradar_addons_get_option('cs_decor');

?><!DOCTYPE html>
<html class="no-js no-svg" itemscope>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <title><?php echo wp_get_document_title() ?></title>
    <link rel="stylesheet"  href="https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500;600;700;800;900&display=swap" type="text/css" media="all">
    <link rel="stylesheet" href="<?php echo ESB_DIR_URL.'assets/vendors/fontawesome-pro/css/all.min.css'; ?>" type="text/css" media="all">
    <link rel="stylesheet" href="<?php echo ESB_DIR_URL.'assets/css/maintenance.css'; ?>" type="text/css" media="all">
    <?php // wp_head(); ?>
</head>

<body>
    <div id="main-theme" class="is-hide-loader">

        <div class="wrapper">
                <!--  logo  -->
                <div class="logo-holder">
                <?php 
                $logo = homeradar_addons_get_option('coming_soon_logo');
                if( !empty($logo['id']) ){
                    echo '<a class="custom-logo-link logo-text" href="'.esc_url( home_url('/' ) ).'">'.wp_get_attachment_image( $logo['id'], 'full' ).'</a>'; 
                }elseif( has_custom_logo() ){
                    the_custom_logo(); 
                }else echo '<a class="custom-logo-link logo-text" href="'.esc_url( home_url('/' ) ).'"><h2>'.get_bloginfo( 'name' ).'</h2></a>'; 
                ?>
                </div>
                <!-- logo end  -->
                <div class="cs-content-wrapper">
                    <?php echo do_shortcode( homeradar_addons_get_option('coming_soon_msg') ); ?>
                </div>
                <div class="pwh_bg bg" <?php if( !empty($cs_decor)): ?>
            data-bg="<?php echo esc_url( homeradar_addons_get_attachment_thumb_link($cs_decor['id'], 'bg-image') ); ?>"
            <?php endif; ?>>
                    <div class="mrb_pin"></div>
                    <div class="mrb_pin mrb_pin2"></div>
                </div>
            </div>
            <div class="cs-media">
                <div class="bg-wrap">
                    <div class="bg par-elem" data-bg="<?php echo esc_url( homeradar_addons_get_attachment_thumb_link($bgimg['id'], 'bg-image') ); ?>"></div>

                    <!-- <div class="slideshow-container" >
                        
                        <div class="slideshow-item">
                            <div class="bg"  data-bg="images/bg/4.jpg"></div>
                        </div>
                        
                        <div class="slideshow-item">
                            <div class="bg"  data-bg="images/bg/3.jpg"></div>
                        </div>
                        
                        <div class="slideshow-item">
                            <div class="bg"  data-bg="images/bg/5.jpg"></div>
                        </div>
                        
                    </div> -->
                    <div class="overlay"></div>
                </div>
                <!-- <div class="slider-progress-bar">
                    <span>
                        <svg class="circ" width="30" height="30">
                            <circle class="circ2" cx="15" cy="15" r="13" stroke="rgba(255,255,255,0.4)" stroke-width="1" fill="none"/>
                            <circle class="circ1" cx="15" cy="15" r="13" stroke="#fff" stroke-width="2" fill="none"/>
                        </svg>
                    </span>
                </div> -->

                
                
                

                <?php 
                $cmsDate = homeradar_addons_get_option('coming_soon_date');
                $cmsTime = homeradar_addons_get_option('coming_soon_time');
                if( $cmsDate != ''){ 
                    $date = date_i18n( 'Y-m-d', strtotime($cmsDate) );
                    if( !empty($cmsTime) ){
                        $date .= 'T'.$cmsTime;
                    }
                ?>
                <!-- cs-media-container -->
                <div class="cs-media-container counter-widget fl-wrap">


                    <!-- countdown -->
                    <div class="countdown countdown-widget" data-countdate="<?php echo esc_attr( $date ); ?>" data-tz="<?php echo esc_attr( homeradar_addons_get_option('coming_soon_tz') ); ?>">
                        <div class="cs-countdown-item">
                            <span class="days rot">00</span>
                            <p><?php esc_html_e( 'days', 'homeradar-add-ons' ); ?></p>
                        </div>
                        <div class="cs-countdown-item">
                            <span class="hours rot">00</span>
                            <p><?php esc_html_e( 'hours', 'homeradar-add-ons' ); ?></p>
                        </div>
                        <div class="cs-countdown-item">
                            <span class="minutes rot2">00</span>
                            <p><?php esc_html_e( 'minutes', 'homeradar-add-ons' ); ?></p>
                        </div>
                        <div class="cs-countdown-item no-dec">
                            <span class="seconds rot2">00</span>
                            <p><?php esc_html_e( 'seconds', 'homeradar-add-ons' ); ?></p>
                        </div>
                    </div>
                    <!-- countdown end --> 
                </div>
                <!--cs-media-container end -->  
                <?php } ?>

                <?php echo do_shortcode( homeradar_addons_get_option('coming_soon_msg_after') ); ?>

                
                <div class="cf_btn"><?php _e( 'Get In Touch', 'homeradar-add-ons' ); ?></div>
            </div>


    </div>
    <!-- Main end -->
    <!--contact-form-wrap -->   
    <div class="contact-form-wrap">
        <div class="contact-form-container">
            <div class="contact-form-main fl-wrap">
                <div class="contact-form-header">
                    <h4><?php _e( 'Get In touch', 'homeradar-add-ons' ); ?></h4>
                    <span class="close-contact-form"><i class="fal fa-times"></i></span>
                </div>
                <div class="contact-form-ajax custom-form">
                    <?php // echo do_shortcode( '[contact-form-7 id="1582" title="HomeRadar Contact form"]' );?>
                    <form name="soon-contact-form" class="cthajax-form" data-action="contact_soon">
                        <div class="contact-inner">
                            <div class="mb-20 hasIcon">
                                <label><?php _e( 'Your name*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-user"></i></span></label>
                                <input name="name" type="text" onClick="this.select()" value="" required="required">
                            </div>
                            <div class="mb-20 hasIcon">
                                <label><?php _e( 'Your mail*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-envelope"></i></span></label>
                                <input name="email" type="email" onClick="this.select()" value="" required="required">   
                            </div>    
                            <div class="hasIcon mb-20">
                                <label><?php esc_html_e( 'Phone*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-phone"></i></span></label>
                                <input name="phone" type="tel" value="" required="required">
                            </div> 
                            <div class="mb-20 hasIcon">
                                <textarea name="message" cols="40" rows="3" placeholder="<?php esc_attr_e( 'Your Message:', 'homeradar-add-ons' ); ?>" style="height: 150px"></textarea>
                            </div>
                            <div class="cthajax-error mb-20"></div>
                            <button type="submit" class="cthajax-submit btn float-btn color-bg fw-btn"><?php _e( 'Send', 'homeradar-add-ons' ); ?></button>
                        </div>
                            
                        <input type="hidden" name="action" value="contact_soon">
                        <?php wp_nonce_field( 'homeradar-add-ons', '_wpnonce', true, true ); ?>
                    </form> 
                </div>                 
            </div>
        </div>
        <div class="contact-form-overlay"></div>
    </div>
    <!--contact-form-wrap end-->  

    <script type='text/javascript' src='<?php echo ESB_DIR_URL.'assets/js/jquery.min.js'; ?>'></script>
    <script type='text/javascript'>
    /* <![CDATA[ */
    var _homeradar_add_ons = {"pl_w":"Please wait...","url": "<?php echo esc_url(admin_url( 'admin-ajax.php' ) ); ?>","disable_bubble":"<?php _ex( 'no', 'Disable bubbles on coming soon page: yes or no', 'homeradar-add-ons' ) ?>"};
    /* ]]> */
    </script>
    <script type='text/javascript' src='<?php echo ESB_DIR_URL.'assets/js/maintenance.min.js'; ?>'></script>
    <script>
        var images = document.querySelectorAll("img");

        images.forEach(function(img) {
            if( img.hasAttribute("data-src") ){ 
                img.setAttribute( 'src', img.getAttribute('data-src') );
            }
        });
    </script>
    <?php // wp_footer(); ?>
</body>
</html>
