<?php
/* add_ons_php */

get_header(  );

global $laumember;
$current_user_id = get_current_user_id();
$current_user = wp_get_current_user();

$phone = get_user_meta( $laumember->ID, '_cth_phone', true );
$address = get_user_meta( $laumember->ID, '_cth_address', true );
$email = get_user_meta( $laumember->ID, '_cth_email', true );
$company = get_user_meta( $laumember->ID,  ESB_META_PREFIX.'company', true );
$office_number = get_user_meta( $laumember->ID,  ESB_META_PREFIX.'office_number', true );
$fax_number = get_user_meta( $laumember->ID,  ESB_META_PREFIX.'fax_number', true );
$longitude = get_user_meta( $laumember->ID,  ESB_META_PREFIX.'longitude', true );
$latitude = get_user_meta( $laumember->ID,  ESB_META_PREFIX.'latitude', true );
$whatsapp = get_user_meta( $laumember->ID,  ESB_META_PREFIX.'whatsapp', true );
$skype = get_user_meta( $laumember->ID,  ESB_META_PREFIX.'skype', true );
$website = $laumember->user_url;

$cover_bg = get_user_meta($laumember->ID,  ESB_META_PREFIX.'cover_bg', true ); 
$cover_id = '';
if(is_array($cover_bg) && count($cover_bg)){
    $cover_id = reset($cover_bg);
}

// $following = Esb_Class_Dashboard::filter_users( (array)get_user_meta( $laumember->ID, ESB_META_PREFIX.'following', true ) ) ;
// $follower = Esb_Class_Dashboard::filter_users( (array)get_user_meta( $laumember->ID, ESB_META_PREFIX.'follower', true ) ) ;
// // var_dump($following);
// // var_dump($follower);

$loggedName = '';
$loggedEmail = '';
$loggedPhone = '';
if( is_user_logged_in() ){
    $loggedName = $current_user->display_name;
    $loggedEmail = get_user_meta($current_user->ID,  ESB_META_PREFIX.'email', true );
    if( empty($loggedEmail) ) $loggedEmail = $current_user->user_email;
    $loggedPhone = get_user_meta($current_user->ID,  ESB_META_PREFIX.'phone', true );
}
$hide_address = $disable_address_url = $hide_phone = $hide_email = $hide_web = $hide_whatsapp = $hide_skype = $hide_offnum = $hide_faxnum = '';
$sb_w = 4;
$has_nosidebar = homeradar_addons_get_option('author_hide_about') == 'yes' && homeradar_addons_get_option('author_hide_contacts') == 'yes' && homeradar_addons_get_option('author_hide_form') == 'yes' && !is_active_sidebar('author-sidebar');
if( $has_nosidebar ){
    $sb_w = 0;
}
?>
<div id="ltop_sec"></div>
<!-- breadcrumbs-->
<div class="breadcrumbs-wrapper inline-breadcrumbs fw-breadcrumbs sp-brd fl-wrap">
    <div class="container">
        <div class="inline-breadcrumbs-wrap flex-items-center jtf-space-between flw-wrap">
            <?php if( function_exists('homeradar_get_template_part') ) homeradar_get_template_part( 'template-parts/breadcrumbs', '', array( 'is_top'=>false) ); ?>
            <div class="inline-breadcrumbs-right flex-items-center">
                <?php homeradar_addons_echo_socials_share(); ?>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumbs end -->
<!-- col-list-wrap -->
<section class="gray-bg small-padding ">
    <div class="container">
        <div class="row">
            <div class="col-md-<?php echo esc_attr(12 - $sb_w);?>">
                <div class="card-info smpar fl-wrap">

                    <div class="bg-wrap bg-parallax-wrap-gradien">
                        <div class="bg" <?php if( !empty($cover_id) ):?>data-bg="<?php echo wp_get_attachment_image_url( $cover_id, 'full' );?>"<?php endif;?>></div>
                    </div>
                    <div class="card-info-media">
                        <?php
                            echo get_avatar($laumember->user_email, '150', 'https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $laumember->display_name );
                        ?>
                    </div>
                    <div class="card-info-content">
                        <div class="agent_card-title fl-wrap">
                            <h4><?php echo $laumember->display_name; ?></h4>
                            <div class="geodir-category-location fl-wrap flex-items-center">
                                <?php if( !empty($au_company) ): ?><h5 class="agent-agency agent-job-comp"><a href="javascript:void(0);"><?php echo $au_company; ?></a></h5><?php endif; ?>
                                
                            </div>
                        </div>
                        <div class="list-single-stats">
                            <ul class="no-list-style">
                                
                                <?php 
                                $lcount = count_user_posts( $laumember->ID , "listing" , true ); ?>
                                <li><span class="bookmark-counter"><i class="fas fa-sitemap"></i><?php echo sprintf(_nx( 'Listing - %d', 'Listings - %d', $lcount, 'Property count', 'homeradar-add-ons' ), $lcount ); ?></span></li>
                            </ul>
                        </div>
                        <?php 
                        if( get_user_meta( $laumember->ID, ESB_META_PREFIX.'verified', true ) == 'yes' ): ?>
                            <div class="card-verified tolt" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-user-check"></i></div>
                        <?php else:  ?>
                            <div class="card-verified cv_not tolt" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Not Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-minus-octagon"></i></div>
                        <?php endif; ?>
                    </div>
                </div>
                <!-- list-single-main-item -->
                <div class="lsingle-block-box lsingle-block-bdrs-bottom">
                    <div class="lsingle-block-title">
                        <h3><?php _e( 'About This Author', 'homeradar-add-ons' ); ?></h3>
                    </div>
                    <div class="lsingle-block-content">
                        <?php echo wpautop( get_the_author_meta('description',$laumember->ID), false ); ?>
                        
                    </div>
                </div>
                <!-- list-single-main-item end --> 
                <div class="author-listings-wrap mt-30">
                    <div class="list-main-wrap-title">
                        <h2 id="lsearch-results-title"><?php echo sprintf(__( 'Properites by  : <span>%s</span>', 'homeradar-add-ons' ), $laumember->display_name); ?></h2>
                    </div>
                    <div class="listings-grid-wrapper">
                        <!-- list-main-wrap-->
                        <div class="list-main-wrap fl-wrap card-listing listings-full-map">
                            
                            <?php 
                            if(is_front_page()) {
                                $paged = (get_query_var('page')) ? get_query_var('page') : 1;
                            } else {
                                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                            }
                            $post_args = array(
                                'post_type' => 'listing',
                                'author' => $laumember->ID,
                                'paged' => $paged,
                                'posts_per_page'=> homeradar_addons_get_option('listings_count'),
                                // 'posts_per_page'=> $settings['posts_per_page'],
                                // 'orderby'=> $settings['order_by'],
                                // 'order'=> $settings['order'],
                                'post_status' => 'publish'
                            );
                            homeradar_addons_get_template_part('templates/loop','custom', array('post_args'=>$post_args, 'ajax_pagination'=>false, 'card_layout'=>'list', 'add_mapdata'=>false)); 
                            ?>
                            
                        </div><!-- list-main-wrap end-->
                    </div>  
                </div> 
                
            </div>
            <!-- col-md 8 end -->
            <!--  sidebar-->
            <?php 
            if( false === $has_nosidebar ): ?>
            <div class="col-md-<?php echo esc_attr( $sb_w ); ?> author-single-sidebar">
                <?php 
                if( homeradar_addons_get_option('author_hide_contacts') != 'yes' ): ?>          
                <!--box-widget-->
                <div class="box-widget box-widget-box fl-wrap">
                    <div class="box-widget-title fl-wrap box-widget-title-color color-bg no-top-margin"><?php _ex( 'Author Contacts', 'Single Author', 'homeradar-add-ons' ); ?></div>
                    <div class="box-widget-content fl-wrap">
                        <div class="contats-list clm fl-wrap">
                            <ul class="no-list-style">
                                
                                <?php 
                                if( $phone != '' && $hide_phone != 'yes' ): ?>
                                <li class="aucontact-phone"><span><i class="fal fa-phone"></i> <?php _e( 'Phone :', 'homeradar-add-ons' );?></span> <a href="tel:<?php echo esc_attr( $phone );?>"  rel="nofollow"><?php echo esc_html($phone);?></a></li>
                                <?php endif;?>
                                <?php 
                                if( $office_number != '' && $hide_offnum != 'yes' ): ?>
                                <li class="aucontact-office-number"><span><i class="fal fa-phone-office"></i> <?php _e( 'Office Number :', 'homeradar-add-ons' );?></span> <a href="tel:<?php echo esc_attr( $office_number );?>"  rel="nofollow"><?php echo esc_html($office_number);?></a></li>
                                <?php endif;?>
                                <?php 
                                if( $fax_number != '' && $hide_faxnum != 'yes' ): ?>
                                <li class="aucontact-fax"><span><i class="fal fa-fax"></i> <?php _e( 'Fax Number :', 'homeradar-add-ons' );?></span> <a href="fax:<?php echo esc_attr( $fax_number );?>"  rel="nofollow"><?php echo esc_html($fax_number);?></a></li>
                                <?php endif;?>

                                <?php 
                                if($email != '' && $hide_email != 'yes' ): ?>
                                <li class="aucontact-email"><span><i class="fal fa-envelope"></i> <?php _e( 'Mail :', 'homeradar-add-ons' );?></span> <a href="mailto:<?php echo esc_attr( $email ) ;?>"  rel="nofollow"><?php echo  esc_html($email);?></a></li>
                                <?php endif;?>
                                <?php
                                if( $hide_address != 'yes' && $address != ''): 
                                    $address_url = 'javascript:void(0);';
                                    if( $disable_address_url != 'yes' && $longitude != '' && $latitude != '' ) $address_url = 'https://www.google.com/maps/search/?api=1&query='.esc_attr($latitude).','.esc_attr($longitude);
                                ?>
                                <li class="aucontact-address"><span><i class="fal fa-map-marker"></i> <?php _e( 'Address :', 'homeradar-add-ons' );?></span> <a href="<?php echo $address_url;?>" target="_blank"  rel="nofollow"><?php echo esc_html($address);?></a></li>
                                <?php endif;?>
                                <?php 
                                if($website != '' && $hide_web != 'yes' ): ?>
                                <li class="aucontact-web"><span><i class="fal fa-browser"></i> <?php _e( 'Website :', 'homeradar-add-ons' );?></span> <a href="<?php echo esc_url($website) ;?>" target="_blank"  rel="nofollow"><?php echo  $website;?></a></li>
                                <?php endif;?>
                                <?php 
                                if($whatsapp != '' && $hide_whatsapp != 'yes' ): ?>
                                <li class="aucontact-whatsapp"><span><i class="fab fa-whatsapp"></i> <?php _e( 'Whatsapp: ', 'homeradar-add-ons' );?></span> <a href="<?php echo 'https://wa.me/'.$whatsapp; ?>" target="_blank"  rel="nofollow"><?php echo esc_html($whatsapp);?></a></li>
                                <?php endif;?>
                                <?php 
                                if($skype != '' && $hide_skype != 'yes' ): ?>
                                <li class="aucontact-whatsapp"><span><i class="fab fa-skype"></i> <?php _e( 'Skype: ', 'homeradar-add-ons' );?></span> <a href="<?php echo 'skype:'.$skype.'?call'; ?>" target="_blank"  rel="nofollow"><?php echo esc_html($skype);?></a></li>
                                <?php endif;?>
                            </ul>
                        </div>
                        <div class="profile-widget-footer fl-wrap flex-items-center jtf-space-between">
                            <?php 
                            $au_socials = get_user_meta( $laumember->ID, '_cth_socials', true );
                            // echo'<pre>';var_dump($au_socials);
                            if(is_array($au_socials) && count($au_socials)) : ?>
                            <div class="card-info-content_social">
                                <ul class="no-list-style">
                                    <?php 
                                    foreach ($au_socials as $social) {
                                        echo '<li><a href="'.esc_url( $social['url'] ).'" target="_blank" ><i class="fab fa-'.esc_attr( $social['name'] ).'"></i></a></li>';
                                    }
                                    ?>
                                </ul>
                            </div>
                            <?php 
                            endif;?>

                            
                            <a href="#sec-contact" class="custom-scroll-link tolt csls" data-microtip-position="left" data-tooltip="Write Message"><i class="fal fa-paper-plane"></i></a>
                        </div>
                    </div>
                </div>
                <!--box-widget end --> 
                <?php
                    endif;
                ?> 
                <?php 
                if(is_active_sidebar('author-sidebar')){
                    dynamic_sidebar('author-sidebar');
                } ?>  
                <?php 
                if( homeradar_addons_get_option('author_hide_form') != 'yes' ):
                ?>                                  
                <!--box-widget-->
                <div class="box-widget box-widget-box fl-wrap mt-20 get-in-touch-widget">
                    <div class="box-widget-fixed-init fl-wrap" id="sec-contact">
                        <div class="box-widget-title fl-wrap box-widget-title-color color-bg no-top-margin"><?php _ex( 'Get In Touch', 'Single Author', 'homeradar-add-ons' ); ?></div>
                        <div class="box-widget-content fl-wrap">
                            <div class="custom-form">
                                <form class="author-message-form custom-form" action="#" method="post">
                                    <?php do_action( 'homeradar_author_contact_form_before', $laumember->ID ); ?>
                                    <div class="mb-20 hasIcon">
                                        <label><?php _e( 'Your name*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-user"></i></span></label>
                                        <input name="lmsg_name" type="text" onClick="this.select()" value="<?php echo esc_attr( $loggedName ); ?>" required="required">
                                    </div>
                                    <div class="mb-20 hasIcon">
                                        <label><?php _e( 'Your mail*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-envelope"></i></span></label>
                                        <input name="lmsg_email" type="email" onClick="this.select()" value="<?php echo esc_attr( $loggedEmail ); ?>" required="required">   
                                    </div>    
                                    <div class="hasIcon mb-20">
                                        <label><?php esc_html_e( 'Phone*', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-phone"></i></span></label>
                                        <input name="lmsg_phone" type="tel" value="<?php echo esc_attr( $loggedPhone ); ?>" required="required">
                                    </div> 
                                    <div class="mb-20 hasIcon">
                                        <textarea name="lmsg_message" cols="40" rows="3" placeholder="<?php esc_attr_e( 'Your Message:', 'homeradar-add-ons' ); ?>" style="height: 150px"></textarea>
                                    </div>
                                    
                                    <?php do_action( 'homeradar_author_contact_form_after', $laumember->ID ); ?>
                                    <div class="author-message-error"></div>
                                    <button class="btn float-btn color-bg fw-btn author-msg-submit" type="submit"><?php _e( 'Send Message <i class="fal fa-paper-plane"></i>', 'homeradar-add-ons' ); ?></button>
                                    <input type="hidden" name="authid" value="<?php echo $laumember->ID; ?>">
                                </form>




                            </div>
                        </div>
                    </div>
                </div>
                <!--box-widget end -->   
                <?php
                    endif;
                ?>                                               
            </div>
            <!--   sidebar end-->  
            <?php endif; ?>                             
        </div>
    </div>
    <div class="limit-box"></div>
    <div class="clearfix"></div>
</section>

<?php

get_footer(  );