<?php
/* add_ons_php */
?>
<!--secondary-nav -->
<div class="secondary-nav">
    <ul class="no-list-style">
        <?php
        if(is_user_logged_in()) : ?>
            <li><a href="<?php echo homeradar_addons_add_listing_url();?>" class="tolt" data-microtip-position="left"  data-tooltip="<?php esc_attr_e( 'Sell Property', 'homeradar-add-ons' ); ?>"><i class="fal fa-truck-couch"></i> </a></li>
        <?php else : 
            $logBtnAttrs = homeradar_addons_get_login_button_attrs( 'addlist', 'current' );
            ?>
            <li><a href="<?php echo esc_url( $logBtnAttrs['url'] );?>" class="tolt <?php echo esc_attr( $logBtnAttrs['class'] );?>" data-message="<?php echo esc_attr_x( 'You must be logged in to add listings.','Header', 'homeradar-add-ons' ); ?>" data-microtip-position="left"  data-tooltip="<?php esc_attr_e( 'Sell Property', 'homeradar-add-ons' ); ?>"><i class="fal fa-truck-couch"></i> </a></li>
        <?php 
        endif;
        ?>

        <li><a href="<?php echo get_post_type_archive_link('listing'); ?>" class="tolt" data-microtip-position="left"  data-tooltip="<?php esc_attr_e( 'Buy Property', 'homeradar-add-ons' ); ?>"> <i class="fal fa-shopping-bag"></i></a></li>
        <li><a href="<?php echo get_permalink( esb_addons_get_wpml_option('compare_page') ); ?>" class="tolt" data-microtip-position="left"  data-tooltip="<?php esc_attr_e( 'Your Compare', 'homeradar-add-ons' ); ?>"><i class="fal fa-exchange"></i></a></li>
    </ul>
    <div class="progress-indicator">
        <svg xmlns="http://www.w3.org/2000/svg"
            viewBox="-1 -1 34 34">
            <circle cx="16" cy="16" r="15.9155"
                class="progress-bar__background" />
            <circle cx="16" cy="16" r="15.9155"
                class="progress-bar__progress 
                js-progress-bar" />
        </svg>
    </div>
</div>
<!--secondary-nav end -->

