<?php
/* add_ons_php */
$beds = get_post_meta( get_the_ID(), ESB_META_PREFIX.'bedrooms', true );
$baths = get_post_meta( get_the_ID(), ESB_META_PREFIX.'bathrooms', true );
$house_size = get_post_meta( get_the_ID(), ESB_META_PREFIX.'house_size', true );
$price = get_post_meta( get_the_ID(), '_price', true );
$garage = get_post_meta( get_the_ID(), ESB_META_PREFIX.'garage', true );
$kitchens = get_post_meta( get_the_ID(), ESB_META_PREFIX.'kitchens', true );
$livingrooms = get_post_meta( get_the_ID(), ESB_META_PREFIX.'livingrooms', true );
$building_age = get_post_meta( get_the_ID(), ESB_META_PREFIX.'building_age', true );
$floors = get_post_meta( get_the_ID(), ESB_META_PREFIX.'floors', true );
?>
<!-- slick-slide-item -->
<div class="slick-slide-item">
    <div class="compare-column">
        <div class="compare-link fl-wrap">
            <div class="compare-link-meia fl-wrap">
                <div class="bg par-elem" data-bg="<?php echo wp_get_attachment_image_url( get_post_thumbnail_id(), 'thumbnail', false ); ?>"></div>
                <div class="remove-compare color-bg" data-id="<?php echo get_the_ID(); ?>"><i class="fal fa-times"></i></div>
            </div>
            <h4><a href="<?php the_permalink(  ); ?>"><?php the_title(); ?></a></h4>
        </div>
        <div class="compare-content">
            <ul class="no-list-style">
                <li class="compare-price"><?php echo homeradar_addons_get_price_string($price); ?></li>
                <li class="compare-beds"><?php echo $beds; ?></li>
                <li class="compare-baths"><?php echo $baths; ?></li>
                <li class="compare-garage"><?php echo $garage; ?></li>
                <li class="compare-area"><?php echo homeradar_echo_area_size($house_size); ?></li>
                <li class="compare-kitchens"><?php echo $kitchens; ?></li>
                <li class="compare-livingrooms"><?php echo $livingrooms; ?></li>
                <li class="compare-building-age"><?php echo $building_age; ?></li>
                <li class="compare-floors"><?php echo $floors; ?></li>
            </ul>
        </div>
    </div>
</div>
<!-- slick-slide-item end-->

