<?php
/* add_ons_php */
$address = get_post_meta( get_the_ID(), ESB_META_PREFIX.'address', true );
$latitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'latitude', true );
$longitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'longitude', true );
?>
<li class="wishlist-item dis-flex">
    <div class="widget-posts-img">
        <a href="<?php the_permalink(  ); ?>"><?php the_post_thumbnail( 'homeradar-recent' ); ?></a>  
    </div>
    <div class="widget-posts-descr">
        <h4><a href="<?php the_permalink(  ); ?>"><?php the_title(); ?></a></h4>
        <?php
        if($address != ''): ?>
        <div class="geodir-category-location fl-wrap"><a href="https://www.google.com/maps/search/?api=1&query=<?php echo $latitude.','.$longitude;?>" target="_blank"><i class="fas fa-map-marker-alt"></i><?php echo $address;?></a></div>
        <?php endif;?>

        <?php 
        $price = get_post_meta( get_the_ID(), '_price', true );
        if( !empty($price) ){ ?>
            <div class="widget-posts-descr-price"><span><?php _ex( 'Price: ', 'Bookmark', 'homeradar-add-ons' ); ?></span><?php echo homeradar_addons_get_price_string($price); ?></div>
        <?php } ?>
        
        <div class="clear-wishlist delete-compare-btn" data-id="<?php the_ID(); ?>"><i class="fal fa-trash-alt"></i></div>
    </div>
</li>

